/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.QueryUtil;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final File cacheRoot;
    private final boolean isSource;
    private volatile URL dirty;
    private Set<String> rootPkgCache;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());
    private static final String REFERENCES = "refs";

    private PersistentClassIndex(URL root, File cacheRoot, boolean source) throws IOException, IllegalArgumentException {
        assert (root != null);
        this.root = root;
        this.cacheRoot = cacheRoot;
        this.index = IndexManager.createIndex((File)PersistentClassIndex.getReferencesCacheFolder(cacheRoot), (Analyzer)DocumentUtil.createAnalyzer());
        this.isSource = source;
    }

    @Override
    public BinaryAnalyser getBinaryAnalyser() {
        return new BinaryAnalyser(new PIWriter(), this.cacheRoot);
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(new PIWriter());
    }

    @Override
    public boolean isSource() {
        return this.isSource;
    }

    @Override
    public boolean isEmpty() {
        try {
            return (Boolean)IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<Boolean>(){

                public Boolean run() throws IOException, InterruptedException {
                    return !PersistentClassIndex.this.index.exists();
                }
            });
        }
        catch (InterruptedException ie) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public boolean isValid() {
        try {
            return this.index.isValid(true);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] rootFos;
        if (this.isSource) {
            FileObject[] fileObjectArray;
            FileObject rootFo = URLMapper.findFileObject((URL)this.root);
            if (rootFo == null) {
                fileObjectArray = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = rootFo;
            }
            rootFos = fileObjectArray;
        } else {
            rootFos = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return rootFos;
    }

    @Override
    public String getSourceName(String binaryName) throws IOException, InterruptedException {
        try {
            Query q = DocumentUtil.binaryNameQuery(binaryName);
            HashSet names = new HashSet();
            this.index.query(names, DocumentUtil.sourceNameConvertor(), DocumentUtil.sourceNameFieldSelector(), (AtomicBoolean)cancel.get(), new Query[]{q});
            return names.isEmpty() ? null : (String)names.iterator().next();
        }
        catch (IOException e) {
            return this.handleException(null, e);
        }
    }

    public static ClassIndexImpl create(URL root, File cacheRoot, boolean indexNow) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(root, cacheRoot, indexNow);
    }

    @Override
    public <T> void search(final String binaryName, final Set<ClassIndexImpl.UsageType> usageType, final Convertor<? super Document, T> convertor, final Set<? super T> result) throws InterruptedException, IOException {
        this.updateDirty();
        try {
            if (BinaryAnalyser.OBJECT.equals(binaryName)) {
                this.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, convertor, result);
                return;
            }
            IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                public Void run() throws IOException, InterruptedException {
                    PersistentClassIndex.this.usages(binaryName, usageType, convertor, result);
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe);
        }
    }

    @Override
    public <T> void getDeclaredTypes(final String simpleName, final ClassIndex.NameKind kind, final Convertor<? super Document, T> convertor, final Set<? super T> result) throws InterruptedException, IOException {
        this.updateDirty();
        try {
            IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                public Void run() throws IOException, InterruptedException {
                    Query query = Queries.createQuery((String)"simpleName", (String)"ciName", (String)simpleName, (Queries.QueryKind)DocumentUtil.translateQueryKind(kind));
                    PersistentClassIndex.this.index.query((Collection)result, convertor, DocumentUtil.declaredTypesFieldSelector(), ClassIndexImpl.cancel.get(), new Query[]{query});
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe);
        }
    }

    @Override
    public <T> void getDeclaredElements(final String ident, final ClassIndex.NameKind kind, final Convertor<? super Document, T> convertor, final Map<T, Set<String>> result) throws InterruptedException, IOException {
        this.updateDirty();
        try {
            IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                public Void run() throws IOException, InterruptedException {
                    Query query = Queries.createTermCollectingQuery((String)"fids", (String)"cifids", (String)ident, (Queries.QueryKind)DocumentUtil.translateQueryKind(kind));
                    PersistentClassIndex.this.index.queryDocTerms(result, convertor, (Convertor)new Convertor<Term, String>(){

                        public String convert(Term p) {
                            return p.text();
                        }
                    }, DocumentUtil.declaredTypesFieldSelector(), ClassIndexImpl.cancel.get(), new Query[]{query});
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe);
        }
    }

    @Override
    public void getPackageNames(final String prefix, final boolean directOnly, final Set<String> result) throws InterruptedException, IOException {
        try {
            IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException, InterruptedException {
                    Collection collectInto;
                    boolean cacheOp = directOnly && prefix.length() == 0;
                    HashSet myPkgs = null;
                    if (cacheOp) {
                        PersistentClassIndex persistentClassIndex = PersistentClassIndex.this;
                        synchronized (persistentClassIndex) {
                            if (PersistentClassIndex.this.rootPkgCache != null) {
                                result.addAll(PersistentClassIndex.this.rootPkgCache);
                                return null;
                            }
                        }
                        myPkgs = new HashSet();
                        collectInto = new TeeCollection(myPkgs, result);
                    } else {
                        collectInto = result;
                    }
                    Pair<StoppableConvertor<Term, String>, Term> filter = QueryUtil.createPackageFilter(prefix, directOnly);
                    PersistentClassIndex.this.index.queryTerms(collectInto, (Term)filter.second, (StoppableConvertor)filter.first, ClassIndexImpl.cancel.get());
                    if (cacheOp) {
                        PersistentClassIndex persistentClassIndex = PersistentClassIndex.this;
                        synchronized (persistentClassIndex) {
                            if (PersistentClassIndex.this.rootPkgCache == null) {
                                assert (myPkgs != null);
                                PersistentClassIndex.this.rootPkgCache = myPkgs;
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            this.handleException(null, ioe);
        }
    }

    @Override
    public void setDirty(URL url) {
        this.dirty = url;
    }

    public String toString() {
        return "PersistentClassIndex[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    private static File getReferencesCacheFolder(File cacheRoot) throws IOException {
        File refRoot = new File(cacheRoot, REFERENCES);
        if (!refRoot.exists()) {
            refRoot.mkdir();
        }
        return refRoot;
    }

    private void updateDirty() {
        URL url = this.dirty;
        if (url != null) {
            JavaSource js;
            FileObject file = url != null ? URLMapper.findFileObject((URL)url) : null;
            JavaSource javaSource = js = file != null ? JavaSource.forFileObject(file) : null;
            if (js != null) {
                long startTime = System.currentTimeMillis();
                ClassPath scp = js.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                if (scp != null && scp.contains(file)) {
                    try {
                        js.runUserActionTask(new Task<CompilationController>(){

                            @Override
                            public void run(final CompilationController controller) {
                                try {
                                    IndexManager.writeAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                                        public Void run() throws IOException {
                                            if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo(JavaSource.Phase.RESOLVED) < 0) {
                                                return null;
                                            }
                                            try {
                                                SourceAnalyser sa = PersistentClassIndex.this.getSourceAnalyser();
                                                sa.analyseUnitAndStore(controller.getCompilationUnit(), JavaSourceAccessor.getINSTANCE().getJavacTask(controller), ClasspathInfoAccessor.getINSTANCE().getFileManager(controller.getClasspathInfo()));
                                            }
                                            catch (IllegalArgumentException ia) {
                                                ClassPath scp = controller.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                                                throw new IllegalArgumentException(String.format("Provided source path: %s root: %s cache root: %", scp == null ? "<null>" : scp.toString(), PersistentClassIndex.this.root.toExternalForm(), PersistentClassIndex.this.cacheRoot.toURI().toURL()), ia);
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (Index.IndexClosedException e) {
                                    LOGGER.info("Ignoring store into closed index");
                                }
                                catch (IOException ioe) {
                                    Exceptions.printStackTrace((Throwable)ioe);
                                }
                                catch (InterruptedException e) {
                                    Exceptions.printStackTrace((Throwable)e);
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                } else {
                    LOGGER.log(Level.INFO, "Not updating cache for file {0}, does not belong to classpath {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)file), scp});
                }
                this.dirty = null;
                long endTime = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "PersistentClassIndex.updateDirty took: {0} ms", endTime - startTime);
            }
        }
    }

    private <T> void usages(String binaryName, Set<ClassIndexImpl.UsageType> usageType, Convertor<? super Document, T> convertor, Set<? super T> result) throws InterruptedException, IOException {
        Query usagesQuery = QueryUtil.createUsagesQuery(binaryName, usageType, BooleanClause.Occur.SHOULD);
        this.index.query(result, convertor, DocumentUtil.declaredTypesFieldSelector(), (AtomicBoolean)cancel.get(), new Query[]{usagesQuery});
    }

    private synchronized void resetPkgCache() {
        this.rootPkgCache = null;
    }

    private class TeeCollection<T>
    extends AbstractCollection<T> {
        private Collection<T> primary;
        private Collection<T> secondary;

        TeeCollection(@NonNull Collection<T> primary, Collection<T> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public int size() {
            return this.primary.size();
        }

        @Override
        public boolean add(T e) {
            boolean result = this.primary.add(e);
            this.secondary.add(e);
            return result;
        }
    }

    private class PIWriter
    implements ClassIndexImpl.Writer {
        private PIWriter() {
        }

        @Override
        public void clear() throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            PersistentClassIndex.this.index.clear();
        }

        @Override
        public void deleteEnclosedAndStore(List<Pair<Pair<String, String>, Object[]>> refs, Set<Pair<String, String>> topLevels) throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            PersistentClassIndex.this.index.store(refs, topLevels, DocumentUtil.documentConvertor(), DocumentUtil.queryClassWithEncConvertor(true), false);
        }

        @Override
        public void deleteAndStore(List<Pair<Pair<String, String>, Object[]>> refs, Set<Pair<String, String>> toDelete) throws IOException {
            PersistentClassIndex.this.resetPkgCache();
            PersistentClassIndex.this.index.store(refs, toDelete, DocumentUtil.documentConvertor(), DocumentUtil.queryClassConvertor(), true);
        }
    }
}

