/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.DiffFacility;
import org.netbeans.modules.java.source.save.EstimatorFactory;
import org.netbeans.modules.java.source.save.ListMatcher;
import org.netbeans.modules.java.source.save.Measure;
import org.netbeans.modules.java.source.save.PositionEstimator;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class CasualDiff {
    public static boolean OLD_TREES_VERBATIM = Boolean.parseBoolean(System.getProperty(WorkingCopy.class.getName() + ".keep-old-trees", "true"));
    protected final Collection<Diff> diffs;
    protected CommentHandler comments;
    protected JCTree.JCCompilationUnit oldTopLevel;
    protected final DiffContext diffContext;
    private TokenSequence<JavaTokenId> tokenSequence;
    private String origText;
    private VeryPretty printer;
    private Context context;
    private static final Logger LOG = Logger.getLogger(CasualDiff.class.getName());
    private Map<Integer, String> diffInfo = new HashMap<Integer, String>();
    private final Map<Tree, ?> tree2Tag;
    private final Map<Object, int[]> tag2Span;
    private final Set<Tree> oldTrees;
    private boolean parameterPrint = false;
    private boolean enumConstantPrint = false;
    private Name origClassName = null;
    boolean anonClass = false;
    private static final EnumSet<Tree.Kind> compAssign = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    private static final EnumSet<Tree.Kind> binaries = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR});
    private static final EnumSet<Tree.Kind> unaries = EnumSet.of(Tree.Kind.POSTFIX_INCREMENT, new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});

    protected CasualDiff(Context context, DiffContext diffContext, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        this.diffs = new LinkedHashSet<Diff>();
        this.comments = CommentHandlerService.instance(context);
        this.diffContext = diffContext;
        this.tokenSequence = diffContext.tokenSequence;
        this.origText = diffContext.origText;
        this.context = context;
        this.tree2Tag = tree2Tag;
        this.tag2Span = tag2Span;
        this.printer = new VeryPretty(diffContext, diffContext.style, tree2Tag, tag2Span, this.origText);
        this.printer.oldTrees = oldTrees;
        this.oldTrees = oldTrees;
    }

    private Collection<Diff> getDiffs() {
        return this.diffs;
    }

    public static Collection<Diff> diff(Context context, DiffContext diffContext, TreePath oldTreePath, JCTree newTree, Map<Integer, String> userInfo, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        int lineStart;
        CasualDiff td = new CasualDiff(context, diffContext, tree2Tag, tag2Span, oldTrees);
        JCTree oldTree = (JCTree)oldTreePath.getLeaf();
        td.oldTopLevel = (JCTree.JCCompilationUnit)(oldTree.getKind() == Tree.Kind.COMPILATION_UNIT ? oldTree : diffContext.origUnit);
        for (Tree t : oldTreePath) {
            if (t == oldTree || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind()) && t.getKind() != Tree.Kind.BLOCK) continue;
            td.printer.indent();
        }
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)oldTree.getKind()) && oldTreePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            td.anonClass = true;
        }
        int[] bounds = td.getBounds(oldTree);
        boolean isCUT = oldTree.getKind() == Tree.Kind.COMPILATION_UNIT;
        int start = isCUT ? 0 : bounds[0];
        String origText = td.origText;
        int end = isCUT ? origText.length() : bounds[1];
        for (lineStart = start; lineStart > 0 && origText.charAt(lineStart - 1) != '\n'; --lineStart) {
        }
        td.printer.setInitialOffset(lineStart);
        Tree current = oldTree;
        for (Tree t : oldTreePath) {
            if (t.getKind() == Tree.Kind.METHOD) {
                MethodTree mt = (MethodTree)t;
                for (VariableTree variableTree : mt.getParameters()) {
                    if (variableTree != current) continue;
                    td.parameterPrint = true;
                }
                break;
            }
            if (t.getKind() == Tree.Kind.VARIABLE) {
                JCTree.JCVariableDecl vt = (JCTree.JCVariableDecl)t;
                if ((vt.mods.flags & 0x4000L) != 0L && vt.init == current) {
                    td.enumConstantPrint = true;
                }
            }
            current = t;
        }
        if (oldTree.getKind() == Tree.Kind.METHOD || !td.parameterPrint && oldTree.getKind() == Tree.Kind.VARIABLE) {
            td.tokenSequence.move(start);
            if (td.tokenSequence.movePrevious() && td.tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                String text = ((Object)td.tokenSequence.token().text()).toString();
                int index = text.lastIndexOf(10);
                start = td.tokenSequence.offset();
                if (index > -1) {
                    start += index + 1;
                }
            }
        }
        td.printer.print(origText.substring(lineStart, start));
        td.diffTree(oldTree, newTree, (JCTree)(oldTreePath.getParentPath() != null ? oldTreePath.getParentPath().getLeaf() : null), new int[]{start, bounds[1]});
        String resultSrc = td.printer.toString().substring(start - lineStart);
        String originalText = isCUT ? origText : origText.substring(start, end);
        new DiffFacility(td.diffs).makeListMatch(originalText, resultSrc, start);
        userInfo.putAll(td.diffInfo);
        return td.getDiffs();
    }

    public static Collection<Diff> diff(Context context, DiffContext diffContext, java.util.List<? extends ImportTree> original, java.util.List<? extends ImportTree> nue, Map<Integer, String> userInfo, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, Set<Tree> oldTrees) {
        CasualDiff td = new CasualDiff(context, diffContext, tree2Tag, tag2Span, oldTrees);
        td.oldTopLevel = diffContext.origUnit;
        int start = td.oldTopLevel.getPackageName() != null ? td.endPos((JCTree)((Object)td.oldTopLevel.getPackageName())) : 0;
        LinkedList<JCTree.JCImport> originalJC = new LinkedList<JCTree.JCImport>();
        LinkedList<JCTree.JCImport> nueJC = new LinkedList<JCTree.JCImport>();
        for (ImportTree importTree : original) {
            originalJC.add((JCTree.JCImport)importTree);
        }
        for (ImportTree importTree : nue) {
            nueJC.add((JCTree.JCImport)importTree);
        }
        PositionEstimator est = EstimatorFactory.imports(originalJC, nueJC, td.diffContext);
        int n = td.diffList(originalJC, nueJC, start, est, Measure.DEFAULT, td.printer);
        String resultSrc = td.printer.toString();
        String originalText = td.diffContext.origText.substring(start, n);
        new DiffFacility(td.diffs).makeListMatch(originalText, resultSrc, start);
        userInfo.putAll(td.diffInfo);
        return td.getDiffs();
    }

    public int endPos(JCTree t) {
        return TreeInfo.getEndPos((JCTree)t, (Map)((Object)this.oldTopLevel.endPositions));
    }

    private int endPos(List<? extends JCTree> trees) {
        int result = -1;
        if (trees.nonEmpty()) {
            result = this.endPos((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                result = this.endPos((JCTree)l.head);
                l = l.tail;
            }
        }
        return result;
    }

    private int endPos(java.util.List<? extends JCTree> trees) {
        if (trees.isEmpty()) {
            return -1;
        }
        return this.endPos(trees.get(trees.size() - 1));
    }

    protected void diffTopLevel(JCTree.JCCompilationUnit oldT, JCTree.JCCompilationUnit newT) {
        int packageKeywordStart = 0;
        if (oldT.pid != null) {
            this.tokenSequence.move(oldT.pid.getStartPosition());
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            packageKeywordStart = this.tokenSequence.offset();
        }
        int localPointer = oldT.packageAnnotations.isEmpty() && !newT.packageAnnotations.isEmpty() ? packageKeywordStart : 0;
        this.oldTopLevel = oldT;
        localPointer = this.diffAnnotationsLists(oldT.packageAnnotations, newT.packageAnnotations, localPointer, 0);
        localPointer = this.diffPackageStatement(oldT, newT, packageKeywordStart, localPointer);
        PositionEstimator est = EstimatorFactory.imports(oldT.getImports(), newT.getImports(), this.diffContext);
        localPointer = this.diffList(oldT.getImports(), newT.getImports(), localPointer, est, Measure.DEFAULT, this.printer);
        est = EstimatorFactory.toplevel(oldT.getTypeDecls(), newT.getTypeDecls(), this.diffContext);
        localPointer = this.diffList(oldT.getTypeDecls(), newT.getTypeDecls(), localPointer, est, Measure.MEMBER, this.printer);
        this.printer.print(this.origText.substring(localPointer));
    }

    private ChangeKind getChangeKind(Tree oldT, Tree newT) {
        if (oldT == newT) {
            return ChangeKind.NOCHANGE;
        }
        if (oldT != null && newT != null) {
            return ChangeKind.MODIFY;
        }
        if (oldT != null) {
            return ChangeKind.DELETE;
        }
        return ChangeKind.INSERT;
    }

    private int diffPackageStatement(JCTree.JCCompilationUnit oldT, JCTree.JCCompilationUnit newT, int packageKeywordStart, int localPointer) {
        ChangeKind change = this.getChangeKind(oldT.pid, newT.pid);
        switch (change) {
            case NOCHANGE: {
                break;
            }
            case INSERT: {
                this.printer.printPackage(newT.pid);
                break;
            }
            case DELETE: {
                this.copyTo(localPointer, packageKeywordStart);
                this.tokenSequence.move(this.endPos(oldT.pid));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                localPointer = this.tokenSequence.offset() + 1;
                break;
            }
            case MODIFY: {
                this.copyTo(localPointer, CasualDiff.getOldPos(oldT.pid));
                localPointer = this.endPos(oldT.pid);
                this.printer.print(newT.pid);
                this.diffInfo.put(CasualDiff.getOldPos(oldT.pid), NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdatePackageStatement"));
            }
        }
        return localPointer;
    }

    protected int diffImport(JCTree.JCImport oldT, JCTree.JCImport newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] qualBounds = this.getBounds((JCTree)oldT.getQualifiedIdentifier());
        if (oldT.staticImport == newT.staticImport) {
            this.copyTo(localPointer, qualBounds[0]);
        } else if (oldT.staticImport) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.STATIC);
            this.copyTo(localPointer, this.tokenSequence.offset());
        } else {
            this.copyTo(localPointer, qualBounds[0]);
            this.printer.print("static ");
        }
        localPointer = this.diffTree((JCTree)oldT.getQualifiedIdentifier(), (JCTree)newT.getQualifiedIdentifier(), qualBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffClassDef(JCTree.JCClassDecl oldT, JCTree.JCClassDecl newT, int[] bounds) {
        int localPointer = bounds[0];
        Name origOuterClassName = this.origClassName;
        int insertHint = localPointer;
        if (!this.anonClass) {
            PositionEstimator estimator;
            JavaTokenId[] javaTokenIdArray;
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
            this.tokenSequence.moveNext();
            int afterKindHint = this.tokenSequence.offset();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            insertHint = this.tokenSequence.offset();
            localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            if (this.kindChanged(oldT.mods.flags, newT.mods.flags)) {
                int pos = oldT.pos;
                if ((oldT.mods.flags & 0x2000L) != 0L) {
                    this.tokenSequence.move(pos);
                    this.tokenSequence.moveNext();
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    pos = this.tokenSequence.offset();
                }
                if ((newT.mods.flags & 0x2000L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("@interface");
                } else if ((newT.mods.flags & 0x4000L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("enum");
                } else if ((newT.mods.flags & 0x200L) != 0L) {
                    this.copyTo(localPointer, pos);
                    this.printer.print("interface");
                } else {
                    this.copyTo(localPointer, pos);
                    this.printer.print("class");
                }
                localPointer = afterKindHint;
            }
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, insertHint);
                this.printer.print(newT.name);
                this.diffInfo.put(insertHint, NbBundle.getMessage(CasualDiff.class, (String)"TXT_ChangeClassName"));
                localPointer = insertHint += oldT.name.length();
                this.origClassName = oldT.name;
            } else {
                int n = localPointer;
                localPointer = insertHint += oldT.name.length();
                this.copyTo(n, localPointer);
            }
            if (oldT.typarams.nonEmpty() && newT.typarams.nonEmpty()) {
                int n = localPointer;
                localPointer = ((JCTree.JCTypeParameter)oldT.typarams.head).pos;
                this.copyTo(n, localPointer);
            }
            boolean parens = oldT.typarams.isEmpty() && newT.typarams.nonEmpty();
            List<JCTree.JCTypeParameter> list = oldT.typarams;
            List<JCTree.JCTypeParameter> list2 = newT.typarams;
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, localPointer, Measure.ARGUMENT);
            if (oldT.typarams.nonEmpty()) {
                insertHint = this.endPos(oldT.typarams.last());
                this.tokenSequence.move(insertHint);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                insertHint = this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            switch (this.getChangeKind(oldT.extending, newT.extending)) {
                case NOCHANGE: {
                    insertHint = oldT.extending != null ? this.endPos(oldT.extending) : insertHint;
                    int n = localPointer;
                    localPointer = insertHint;
                    this.copyTo(n, localPointer);
                    break;
                }
                case MODIFY: {
                    this.copyTo(localPointer, CasualDiff.getOldPos(oldT.extending));
                    localPointer = this.diffTree(oldT.extending, newT.extending, this.getBounds(oldT.extending));
                    break;
                }
                case INSERT: {
                    this.copyTo(localPointer, insertHint);
                    this.printer.print(" extends ");
                    this.printer.print(newT.extending);
                    localPointer = insertHint;
                    break;
                }
                case DELETE: {
                    this.copyTo(localPointer, insertHint);
                    localPointer = this.endPos(oldT.extending);
                }
            }
            if (oldT.implementing.isEmpty()) {
                if (oldT.extending != null) {
                    insertHint = this.endPos(oldT.extending);
                }
            } else {
                insertHint = oldT.implementing.iterator().next().getStartPosition();
            }
            long flags = oldT.sym != null ? oldT.sym.flags() : oldT.mods.flags;
            PositionEstimator positionEstimator = estimator = (flags & 0x200L) == 0L ? EstimatorFactory.implementz(oldT.getImplementsClause(), newT.getImplementsClause(), this.diffContext) : EstimatorFactory.extendz(oldT.getImplementsClause(), newT.getImplementsClause(), this.diffContext);
            if (!newT.implementing.isEmpty()) {
                this.copyTo(localPointer, insertHint);
            }
            localPointer = this.diffList2(oldT.implementing, newT.implementing, insertHint, estimator);
            insertHint = this.endPos(oldT) - 1;
            insertHint = this.filterHidden(oldT.defs).isEmpty() ? this.endPos(oldT) - 1 : this.filterHidden(oldT.defs).get(0).getStartPosition() - 1;
            this.tokenSequence.move(insertHint);
            this.tokenSequence.moveNext();
            insertHint = PositionEstimator.moveBackToToken(this.tokenSequence, insertHint, JavaTokenId.LBRACE) + 1;
        } else {
            insertHint = PositionEstimator.moveFwdToToken(this.tokenSequence, CasualDiff.getOldPos(oldT), JavaTokenId.LBRACE);
            this.tokenSequence.moveNext();
            insertHint = this.tokenSequence.offset();
        }
        int old = this.printer.indent();
        Name origName = this.printer.enclClassName;
        this.printer.enclClassName = newT.getSimpleName();
        PositionEstimator est = EstimatorFactory.members(this.filterHidden(oldT.defs), this.filterHidden(newT.defs), this.diffContext);
        if (localPointer < insertHint) {
            this.copyTo(localPointer, insertHint);
        }
        localPointer = this.diffList(this.filterHidden(oldT.defs), this.filterHidden(newT.defs), insertHint, est, Measure.REAL_MEMBER, this.printer);
        this.printer.enclClassName = origName;
        this.origClassName = origOuterClassName;
        this.printer.undent(old);
        if (localPointer != -1 && localPointer < this.origText.length()) {
            if (this.origText.charAt(localPointer) == '}') {
                this.printer.toLeftMargin();
            }
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    private boolean hasModifiers(JCTree.JCModifiers mods) {
        return mods != null && (!mods.getFlags().isEmpty() || !((List)mods.getAnnotations()).isEmpty());
    }

    protected int diffMethodDef(JCTree.JCMethodDecl oldT, JCTree.JCMethodDecl newT, int[] bounds) {
        int pos;
        int localPointer = bounds[0];
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                int n = localPointer = oldT.restype != null ? CasualDiff.getOldPos(oldT.restype) : oldT.pos;
            }
        }
        int n = oldT.typarams.isEmpty() ? (oldT.restype != null ? CasualDiff.getOldPos(oldT.restype) : oldT.pos) : (pos = CasualDiff.getOldPos((JCTree)oldT.typarams.head));
        if (!this.listsMatch(oldT.typarams, newT.typarams)) {
            JavaTokenId[] javaTokenIdArray;
            if (newT.typarams.nonEmpty()) {
                this.copyTo(localPointer, pos);
            } else if (this.hasModifiers(oldT.mods)) {
                this.copyTo(localPointer, this.endPos(oldT.mods));
            }
            boolean parens = oldT.typarams.isEmpty() || newT.typarams.isEmpty();
            List<JCTree.JCTypeParameter> list = oldT.typarams;
            List<JCTree.JCTypeParameter> list2 = newT.typarams;
            if (parens) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, pos, Measure.ARGUMENT);
            if (parens && oldT.typarams.isEmpty()) {
                this.printer.print(" ");
            }
        }
        if (oldT.restype != null) {
            int[] restypeBounds = this.getBounds(oldT.restype);
            this.copyTo(localPointer, restypeBounds[0]);
            int n2 = localPointer = this.diffTree(oldT.restype, newT.restype, restypeBounds);
            localPointer = restypeBounds[1];
            this.copyTo(n2, localPointer);
        }
        int posHint = oldT.typarams.isEmpty() ? (oldT.restype != null ? oldT.restype.getStartPosition() : oldT.getStartPosition()) : oldT.typarams.iterator().next().getStartPosition();
        if (!oldT.sym.isConstructor() || this.origClassName != null) {
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, oldT.pos);
                if (oldT.sym.isConstructor() && this.origClassName != null) {
                    this.printer.print(newT.name);
                    localPointer = oldT.pos + this.origClassName.length();
                } else {
                    this.printer.print(newT.name);
                    this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameMethod") + " " + oldT.name);
                    localPointer = oldT.pos + oldT.name.length();
                }
            } else {
                int n3 = localPointer;
                localPointer = oldT.pos + oldT.name.length();
                this.copyTo(n3, localPointer);
            }
        }
        if (oldT.params.isEmpty()) {
            int startOffset = oldT.restype != null ? oldT.restype.getStartPosition() : oldT.getStartPosition();
            PositionEstimator.moveFwdToToken(this.tokenSequence, startOffset, JavaTokenId.RPAREN);
            posHint = this.tokenSequence.offset();
        } else {
            posHint = oldT.params.iterator().next().getStartPosition();
        }
        if (!this.listsMatch(oldT.params, newT.params)) {
            this.copyTo(localPointer, posHint);
            int old = this.printer.setPrec(0);
            this.parameterPrint = true;
            Name oldEnclClassName = this.printer.enclClassName;
            this.printer.enclClassName = null;
            localPointer = this.diffParameterList(oldT.params, newT.params, null, posHint, Measure.MEMBER);
            this.printer.enclClassName = oldEnclClassName;
            this.parameterPrint = false;
            this.printer.setPrec(old);
        }
        PositionEstimator.moveFwdToToken(this.tokenSequence, oldT.params.isEmpty() ? posHint : this.endPos(oldT.params.last()), JavaTokenId.RPAREN);
        this.tokenSequence.moveNext();
        posHint = this.tokenSequence.offset();
        if (localPointer < posHint) {
            int n4 = localPointer;
            localPointer = posHint;
            this.copyTo(n4, localPointer);
        }
        if (oldT.thrown.isEmpty()) {
            if (oldT.body != null) {
                this.tokenSequence.move(oldT.body.pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                posHint = this.tokenSequence.offset();
            } else if (oldT.defaultValue != null) {
                this.tokenSequence.move(CasualDiff.getOldPos(oldT.defaultValue));
                while (this.tokenSequence.movePrevious() && this.tokenSequence.token().id() != JavaTokenId.DEFAULT) {
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                posHint = this.tokenSequence.offset();
            } else {
                posHint = this.endPos(oldT) - 1;
            }
        } else {
            posHint = oldT.thrown.iterator().next().getStartPosition();
        }
        if (!newT.thrown.isEmpty()) {
            int n5 = localPointer;
            localPointer = posHint;
            this.copyTo(n5, localPointer);
        }
        PositionEstimator est = EstimatorFactory.throwz(oldT.getThrows(), newT.getThrows(), this.diffContext);
        localPointer = this.diffList2(oldT.thrown, newT.thrown, posHint, est);
        if (oldT.defaultValue != newT.defaultValue) {
            if (oldT.defaultValue == null) {
                this.printer.print(" default ");
                this.printer.print(newT.defaultValue);
            } else if (newT.defaultValue == null) {
                localPointer = this.endPos(oldT.defaultValue);
            } else {
                int[] restypeBounds = this.getBounds(oldT.defaultValue);
                this.copyTo(localPointer, restypeBounds[0]);
                int n6 = localPointer = this.diffTree(oldT.defaultValue, newT.defaultValue, restypeBounds);
                localPointer = restypeBounds[1];
                this.copyTo(n6, localPointer);
            }
        }
        if (newT.body == null && oldT.body != null) {
            localPointer = this.endPos(oldT.body);
            this.printer.print(";");
        } else if (oldT.body != null && newT.body != null) {
            int[] bodyBounds = this.getBounds(oldT.body);
            this.copyTo(localPointer, bodyBounds[0]);
            localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffVarDef(JCTree.JCVariableDecl oldT, JCTree.JCVariableDecl newT, int pos) {
        int localPointer = oldT.pos;
        this.copyTo(pos, localPointer);
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable") + " " + oldT.name);
            localPointer = oldT.pos + oldT.name.length();
        }
        if (newT.init != null && oldT.init != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.init);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.init, newT.init, new int[]{localPointer, this.endPos(oldT.init)});
        } else {
            if (oldT.init != null && newT.init == null) {
                pos = CasualDiff.getOldPos(oldT.init);
                this.tokenSequence.move(pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int to = this.tokenSequence.offset();
                this.copyTo(localPointer, to);
                localPointer = this.endPos(oldT.init);
            }
            if (oldT.init == null && newT.init != null) {
                int end = this.endPos(oldT);
                this.tokenSequence.move(end);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                this.printer.printVarInit(newT);
            }
        }
        int n = localPointer;
        localPointer = this.endPos(oldT);
        this.copyTo(n, localPointer);
        return localPointer;
    }

    private int diffVarDef(JCTree.JCVariableDecl oldT, JCTree.JCVariableDecl newT, int[] bounds) {
        int localPointer = bounds[0];
        if ((oldT.mods.flags & 0x4000L) != 0L) {
            if (this.nameChanged(oldT.name, newT.name)) {
                this.copyTo(localPointer, oldT.pos);
                this.printer.print(newT.name);
                this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameEnumConstant") + " " + oldT.name);
                localPointer = oldT.pos + oldT.name.length();
            }
            JCTree.JCNewClass oldInit = (JCTree.JCNewClass)oldT.init;
            JCTree.JCNewClass newInit = (JCTree.JCNewClass)newT.init;
            if (oldInit.args.nonEmpty() && newInit.args.nonEmpty()) {
                int n = localPointer;
                localPointer = CasualDiff.getOldPos((JCTree)oldInit.args.head);
                this.copyTo(n, localPointer);
                localPointer = this.diffParameterList(oldInit.args, newInit.args, null, localPointer, Measure.ARGUMENT);
            }
            if (oldInit.def != null && newInit.def != null) {
                this.anonClass = true;
                int[] defBounds = new int[]{localPointer, this.endPos(oldInit.def)};
                localPointer = this.diffTree(oldInit.def, newInit.def, defBounds);
                this.anonClass = false;
            }
            this.copyTo(localPointer, bounds[1]);
            return bounds[1];
        }
        if (!this.matchModifiers(oldT.mods, newT.mods)) {
            if (this.hasModifiers(newT.mods)) {
                localPointer = this.diffModifiers(oldT.mods, newT.mods, oldT, localPointer);
            } else if (this.hasModifiers(oldT.mods)) {
                int oldPos = CasualDiff.getOldPos(oldT.mods);
                this.copyTo(localPointer, oldPos);
                localPointer = CasualDiff.getOldPos(oldT.vartype);
            }
        }
        int[] vartypeBounds = this.getBounds(oldT.vartype);
        this.copyTo(localPointer, vartypeBounds[0]);
        localPointer = this.diffTree(oldT.vartype, newT.vartype, vartypeBounds);
        if (this.nameChanged(oldT.name, newT.name)) {
            boolean isOldError;
            boolean bl = isOldError = oldT.name == Names.instance((Context)this.context).error;
            if (!isOldError) {
                this.copyTo(localPointer, oldT.pos);
            } else {
                this.printer.print(" ");
            }
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameVariable") + " " + oldT.name);
            if (!isOldError) {
                localPointer = oldT.pos + oldT.name.length();
            }
        }
        if (newT.init != null && oldT.init != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.init);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.init, newT.init, new int[]{localPointer, this.endPos(oldT.init)});
        } else {
            if (oldT.init != null && newT.init == null) {
                int pos = CasualDiff.getOldPos(oldT.init);
                this.tokenSequence.move(pos);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int to = this.tokenSequence.offset();
                this.copyTo(localPointer, to);
                localPointer = this.endPos(oldT.init);
            }
            if (oldT.init == null && newT.init != null) {
                int end = this.endPos(oldT);
                this.tokenSequence.move(end);
                this.tokenSequence.moveNext();
                if (!JavaTokenId.COMMA.equals((Object)this.tokenSequence.token().id()) && !JavaTokenId.SEMICOLON.equals((Object)this.tokenSequence.token().id())) {
                    this.tokenSequence.movePrevious();
                }
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                this.tokenSequence.moveNext();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                this.printer.printVarInit(newT);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBlock(JCTree.JCBlock oldT, JCTree.JCBlock newT, int[] blockBounds) {
        int localPointer = blockBounds[0];
        if (oldT.flags != newT.flags) {
            int sp = CasualDiff.getOldPos(oldT);
            int n = localPointer;
            localPointer = sp;
            this.copyTo(n, localPointer);
            if ((oldT.flags & 8L) == 0L && (newT.flags & 8L) != 0L) {
                this.printer.print("static");
                if (this.diffContext.style.spaceBeforeStaticInitLeftBrace()) {
                    this.printer.print(" ");
                }
            } else if ((oldT.flags & 8L) != 0L && (newT.flags & 8L) == 0L) {
                this.tokenSequence.move(sp);
                if (this.tokenSequence.moveNext() && this.tokenSequence.token().id() == JavaTokenId.STATIC) {
                    localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    if (this.tokenSequence.moveNext() && this.tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                        localPointer = this.tokenSequence.offset() + this.tokenSequence.token().length();
                    }
                }
            }
        } else {
            int n = localPointer;
            localPointer = oldT.pos + 1;
            this.copyTo(n, localPointer);
        }
        if (oldT.stats.head != null && ((JCTree.JCStatement)oldT.stats.head).pos == oldT.pos) {
            oldT.stats = oldT.stats.tail;
        }
        if (newT.stats.head != null && ((JCTree.JCStatement)newT.stats.head).pos == oldT.pos) {
            newT.stats = newT.stats.tail;
        }
        PositionEstimator est = EstimatorFactory.statements(this.filterHidden(oldT.stats), this.filterHidden(newT.stats), this.diffContext);
        int old = this.printer.indent();
        Name oldEnclosing = this.printer.enclClassName;
        this.printer.enclClassName = null;
        java.util.List<JCTree> oldstats = this.filterHidden(oldT.stats);
        localPointer = this.diffList(oldstats, this.filterHidden(newT.stats), localPointer, est, Measure.MEMBER, this.printer);
        this.printer.enclClassName = oldEnclosing;
        if (localPointer < this.endPos(oldT)) {
            int n = localPointer;
            localPointer = this.endPos(oldT);
            this.copyTo(n, localPointer);
        }
        this.printer.undent(old);
        return localPointer;
    }

    private int adjustLocalPointer(int localPointer, CommentSet cs, CommentSet.RelativePosition position) {
        if (cs == null) {
            return localPointer;
        }
        java.util.List<Comment> cl = cs.getComments(position);
        if (!cl.isEmpty()) {
            for (Comment comment : cl) {
                localPointer = Math.max(comment.endPos(), localPointer);
            }
        }
        return localPointer;
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case JAVADOC_COMMENT: {
                return true;
            }
        }
        return false;
    }

    protected int diffDoLoop(JCTree.JCDoWhileLoop oldT, JCTree.JCDoWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        int[] condBounds = this.getBounds(oldT.cond);
        if (oldT.body.getKind() != Tree.Kind.BLOCK && newT.body.getKind() == Tree.Kind.BLOCK) {
            PositionEstimator.moveBackToToken(this.tokenSequence, condBounds[0], JavaTokenId.WHILE);
            localPointer = this.tokenSequence.offset();
        } else {
            this.copyTo(localPointer, condBounds[0]);
            localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWhileLoop(JCTree.JCWhileLoop oldT, JCTree.JCWhileLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condPos = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condPos[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condPos);
        int[] bodyPos = new int[]{localPointer, this.endPos(oldT.body)};
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyPos, oldT.getKind());
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffForLoop(JCTree.JCForLoop oldT, JCTree.JCForLoop newT, int[] bounds) {
        int localPointer;
        if (oldT.init.nonEmpty()) {
            localPointer = CasualDiff.getOldPos((JCTree)oldT.init.head);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, bounds[0], JavaTokenId.SEMICOLON);
            localPointer = this.tokenSequence.offset();
        }
        this.copyTo(bounds[0], localPointer);
        if (!this.listsMatch(oldT.init, newT.init)) {
            boolean newVariable;
            boolean oldVariable = CasualDiff.containsVariable(oldT.init);
            if (oldVariable ^ (newVariable = CasualDiff.containsVariable(newT.init))) {
                int oldPrec = this.printer.setPrec(0);
                localPointer = this.diffParameterList(oldT.init, newT.init, null, localPointer, Measure.ARGUMENT);
                this.printer.setPrec(oldPrec);
            } else if (oldVariable) {
                java.util.List oldInit = NbCollections.checkedListByCopy(oldT.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree old = new FieldGroupTree(oldInit);
                java.util.List newInit = NbCollections.checkedListByCopy(newT.init, JCTree.JCVariableDecl.class, (boolean)false);
                FieldGroupTree nue = new FieldGroupTree(newInit);
                int[] initBounds = this.getBounds((JCTree)oldT.init.head);
                JCTree last = oldT.init.get(oldT.init.size() - 1);
                long endPos = this.diffContext.trees.getSourcePositions().getEndPosition(this.oldTopLevel, last);
                initBounds[1] = (int)endPos;
                localPointer = this.diffTree(old, nue, initBounds);
            } else {
                localPointer = this.diffParameterList(oldT.init, newT.init, null, localPointer, Measure.ARGUMENT);
            }
        }
        if (oldT.cond != null) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT.cond);
            this.copyTo(n, localPointer);
            localPointer = this.diffTree(oldT.cond, newT.cond, this.getBounds(oldT.cond));
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        if (oldT.step.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.step.head);
            this.copyTo(n, localPointer);
        } else {
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.step, newT.step, null, localPointer, Measure.ARGUMENT);
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private static boolean containsVariable(java.util.List<JCTree.JCStatement> statements) {
        for (JCTree.JCStatement s : statements) {
            if (s.getKind() != Tree.Kind.VARIABLE) continue;
            return true;
        }
        return false;
    }

    protected int diffForeachLoop(JCTree.JCEnhancedForLoop oldT, JCTree.JCEnhancedForLoop newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] varBounds = this.getBounds(oldT.var);
        this.copyTo(localPointer, varBounds[0]);
        localPointer = this.diffTree(oldT.var, newT.var, varBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        int[] bodyBounds = new int[]{localPointer, this.endPos(oldT.body)};
        localPointer = this.diffTree((JCTree)oldT.body, (JCTree)newT.body, bodyBounds, oldT.getKind());
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffLabelled(JCTree.JCLabeledStatement oldT, JCTree.JCLabeledStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        if (this.nameChanged(oldT.label, newT.label)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print(newT.label);
            localPointer += oldT.label.length();
        }
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSwitch(JCTree.JCSwitch oldT, JCTree.JCSwitch newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] selectorBounds = this.getBounds(oldT.selector);
        this.copyTo(localPointer, selectorBounds[0]);
        localPointer = this.diffTree(oldT.selector, newT.selector, selectorBounds);
        this.tokenSequence.move(selectorBounds[1]);
        while (this.tokenSequence.moveNext() && JavaTokenId.LBRACE != this.tokenSequence.token().id()) {
        }
        this.tokenSequence.moveNext();
        int n = localPointer;
        localPointer = this.tokenSequence.offset();
        this.copyTo(n, localPointer);
        PositionEstimator est = EstimatorFactory.cases(oldT.getCases(), newT.getCases(), this.diffContext);
        localPointer = this.diffList(oldT.cases, newT.cases, localPointer, est, Measure.MEMBER, this.printer);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffCase(JCTree.JCCase oldT, JCTree.JCCase newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.pat != null) {
            int[] patBounds = this.getBounds(oldT.pat);
            this.copyTo(localPointer, patBounds[0]);
            localPointer = this.diffTree(oldT.pat, newT.pat, patBounds);
            this.tokenSequence.move(patBounds[1]);
            while (this.tokenSequence.moveNext() && JavaTokenId.COLON != this.tokenSequence.token().id()) {
            }
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        if (oldT.pat == null && newT.pat != null) {
            this.printer.print(newT);
            this.printer.newline();
            return bounds[1];
        }
        PositionEstimator est = EstimatorFactory.statements(oldT.getStatements(), newT.getStatements(), this.diffContext);
        localPointer = this.diffList(oldT.stats, newT.stats, localPointer, est, Measure.MEMBER, this.printer);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSynchronized(JCTree.JCSynchronized oldT, JCTree.JCSynchronized newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lockBounds = this.getBounds(oldT.lock);
        this.copyTo(localPointer, lockBounds[0]);
        localPointer = this.diffTree(oldT.lock, newT.lock, lockBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTry(JCTree.JCTry oldT, JCTree.JCTry newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] bodyPos = this.getBounds(oldT.body);
        if (!this.listsMatch(oldT.resources, newT.resources)) {
            if (oldT.resources.nonEmpty() && newT.resources.isEmpty()) {
                this.tokenSequence.move(CasualDiff.getOldPos((JCTree)oldT.resources.head));
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                assert (this.tokenSequence.token().id() == JavaTokenId.LPAREN);
                this.copyTo(localPointer, this.tokenSequence.offset());
                localPointer = bodyPos[0];
            } else {
                JavaTokenId[] javaTokenIdArray;
                int pos;
                pos = oldT.resources.isEmpty() ? (pos = bodyPos[0]) : CasualDiff.getOldPos((JCTree)oldT.resources.head);
                this.copyTo(localPointer, pos);
                boolean parens = oldT.resources.isEmpty() || newT.resources.isEmpty();
                int oldPrec = this.printer.setPrec(0);
                if (newT.resources.nonEmpty()) {
                    List<JCTree> l = newT.resources;
                    Tree t = (Tree)l.head;
                    while (t != null) {
                        this.printer.oldTrees.remove(t);
                        l = l.tail;
                        t = (Tree)l.head;
                    }
                }
                List<JCTree> list = oldT.resources;
                List<JCTree> list2 = newT.resources;
                if (parens) {
                    JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                    javaTokenIdArray2[0] = JavaTokenId.LPAREN;
                    javaTokenIdArray = javaTokenIdArray2;
                    javaTokenIdArray2[1] = JavaTokenId.RPAREN;
                } else {
                    javaTokenIdArray = null;
                }
                localPointer = this.diffParameterList(list, list2, javaTokenIdArray, pos, Measure.ARGUMENT, false, ";");
                this.printer.setPrec(oldPrec);
                if (parens && oldT.resources.isEmpty()) {
                    this.printer.print(" ");
                }
            }
        }
        this.copyTo(localPointer, bodyPos[0]);
        int n = localPointer = this.diffTree(oldT.body, newT.body, bodyPos);
        localPointer = bodyPos[1];
        this.copyTo(n, localPointer);
        PositionEstimator est = EstimatorFactory.catches(oldT.getCatches(), newT.getCatches(), this.diffContext);
        localPointer = this.diffList(oldT.catchers, newT.catchers, localPointer, est, Measure.DEFAULT, this.printer);
        if (oldT.finalizer != null) {
            int[] finalBounds = this.getBounds(oldT.finalizer);
            if (newT.finalizer != null) {
                this.copyTo(localPointer, finalBounds[0]);
                localPointer = this.diffTree(oldT.finalizer, newT.finalizer, finalBounds);
            } else {
                int endetHier = oldT.catchers.isEmpty() ? this.endPos(oldT.body) : this.endPos(oldT.catchers);
                this.copyTo(localPointer, endetHier);
                localPointer = finalBounds[1];
            }
            this.copyTo(localPointer, bounds[1]);
        } else if (newT.finalizer != null) {
            int catchEnd = oldT.catchers.isEmpty() ? bounds[1] : this.endPos((JCTree)oldT.catchers.reverse().head);
            int n2 = localPointer;
            localPointer = catchEnd;
            this.copyTo(n2, localPointer);
            this.printer.printFinallyBlock(newT.finalizer);
            this.copyTo(localPointer, bounds[1]);
        } else {
            this.copyTo(localPointer, bounds[1]);
        }
        return bounds[1];
    }

    protected int diffCatch(JCTree.JCCatch oldT, JCTree.JCCatch newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] paramBounds = this.getBounds(oldT.param);
        this.copyTo(localPointer, paramBounds[0]);
        localPointer = this.diffTree(oldT.param, newT.param, paramBounds);
        int[] bodyBounds = this.getBounds(oldT.body);
        this.copyTo(localPointer, bodyBounds[0]);
        localPointer = this.diffTree(oldT.body, newT.body, bodyBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffConditional(JCTree.JCConditional oldT, JCTree.JCConditional newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        int[] trueBounds = this.getBounds(oldT.truepart);
        this.copyTo(localPointer, trueBounds[0]);
        localPointer = this.diffTree(oldT.truepart, newT.truepart, trueBounds);
        int[] falseBounds = this.getBounds(oldT.falsepart);
        this.copyTo(localPointer, falseBounds[0]);
        localPointer = this.diffTree(oldT.falsepart, newT.falsepart, falseBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIf(JCTree.JCIf oldT, JCTree.JCIf newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        int[] partBounds = new int[]{localPointer, this.endPos(oldT.thenpart)};
        localPointer = this.diffTree((JCTree)oldT.thenpart, (JCTree)newT.thenpart, partBounds, oldT.getKind());
        if (oldT.elsepart == null && newT.elsepart != null) {
            this.printer.printElse(newT, newT.thenpart.getKind() == Tree.Kind.BLOCK);
        } else {
            if (oldT.elsepart != null && newT.elsepart == null) {
                this.copyTo(localPointer, partBounds[1]);
                this.copyTo(this.getBounds(oldT.elsepart)[1], bounds[1]);
                return bounds[1];
            }
            if (oldT.elsepart != null) {
                partBounds = new int[]{localPointer, this.endPos(oldT.elsepart)};
                localPointer = this.diffTree((JCTree)oldT.elsepart, (JCTree)newT.elsepart, partBounds, oldT.getKind());
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffExec(JCTree.JCExpressionStatement oldT, JCTree.JCExpressionStatement newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffBreak(JCTree.JCBreak oldT, JCTree.JCBreak newT, int[] bounds) {
        Name oldTLabel = oldT.label;
        Name newTlabel = newT.label;
        return this.printBreakContinueTree(bounds, oldTLabel, newTlabel, oldT);
    }

    protected int diffContinue(JCTree.JCContinue oldT, JCTree.JCContinue newT, int[] bounds) {
        Name oldTLabel = oldT.label;
        Name newTlabel = newT.label;
        return this.printBreakContinueTree(bounds, oldTLabel, newTlabel, oldT);
    }

    protected int diffReturn(JCTree.JCReturn oldT, JCTree.JCReturn newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.expr != newT.expr) {
            if (oldT.expr == null) {
                this.tokenSequence.move(this.endPos(oldT));
                this.tokenSequence.movePrevious();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                if (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                    this.tokenSequence.movePrevious();
                }
                if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                    this.printer.print(" ");
                }
                this.printer.print(newT.expr);
            } else if (newT.expr == null) {
                int n = localPointer;
                localPointer = CasualDiff.getOldPos(oldT) + "return".length();
                this.copyTo(n, localPointer);
                localPointer = this.endPos(oldT.expr);
            } else {
                int[] exprBounds = this.getBounds(oldT.expr);
                this.copyTo(bounds[0], exprBounds[0]);
                localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffThrow(JCTree.JCThrow oldT, JCTree.JCThrow newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssert(JCTree.JCAssert oldT, JCTree.JCAssert newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] condBounds = this.getBounds(oldT.cond);
        this.copyTo(localPointer, condBounds[0]);
        localPointer = this.diffTree(oldT.cond, newT.cond, condBounds);
        if (oldT.detail != newT.detail) {
            if (oldT.detail == null) {
                this.copyTo(localPointer, condBounds[1]);
                localPointer = condBounds[1];
                this.printer.print(" : ");
                this.printer.print(newT.detail);
            } else {
                int[] detailBounds = this.getBounds(oldT.detail);
                if (newT.detail == null) {
                    this.copyTo(localPointer, condBounds[1]);
                    localPointer = detailBounds[1];
                } else {
                    this.copyTo(localPointer, detailBounds[0]);
                    localPointer = this.diffTree(oldT.detail, newT.detail, detailBounds);
                }
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffApply(JCTree.JCMethodInvocation oldT, JCTree.JCMethodInvocation newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] methBounds = this.getBounds(oldT.meth);
        if (oldT.typeargs.nonEmpty() && newT.typeargs.nonEmpty() && Tree.Kind.MEMBER_SELECT == oldT.meth.getKind()) {
            localPointer = this.diffSelect((JCTree.JCFieldAccess)oldT.meth, (JCTree.JCFieldAccess)newT.meth, methBounds, oldT.typeargs, newT.typeargs);
        } else {
            localPointer = this.diffParameterList(oldT.typeargs, newT.typeargs, null, localPointer, Measure.ARGUMENT);
            localPointer = this.diffTree(oldT.meth, newT.meth, methBounds);
        }
        if (!this.listsMatch(oldT.args, newT.args)) {
            if (oldT.args.nonEmpty()) {
                int n = localPointer;
                localPointer = this.getCommentCorrectedOldPos((JCTree)oldT.args.head);
                this.copyTo(n, localPointer);
            } else {
                int n = localPointer;
                localPointer = methBounds[1];
                this.copyTo(n, localPointer);
                this.tokenSequence.move(localPointer);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                this.tokenSequence.moveNext();
                int n2 = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n2, localPointer);
            }
            localPointer = this.diffParameterList(oldT.args, newT.args, null, localPointer, Measure.ARGUMENT);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewClass(JCTree.JCNewClass oldT, JCTree.JCNewClass newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.encl != null) {
            int[] enclBounds = this.getBounds(oldT.encl);
            localPointer = this.diffTree(oldT.encl, newT.encl, enclBounds);
        }
        this.diffParameterList(oldT.typeargs, newT.typeargs, null, localPointer, Measure.ARGUMENT);
        if (!this.enumConstantPrint) {
            int[] clazzBounds = this.getBounds(oldT.clazz);
            this.copyTo(localPointer, clazzBounds[0]);
            localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        }
        if (oldT.args.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.args.head);
            this.copyTo(n, localPointer);
        } else if (!this.enumConstantPrint) {
            PositionEstimator.moveFwdToToken(this.tokenSequence, oldT.pos, JavaTokenId.LPAREN);
            this.tokenSequence.moveNext();
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.args, newT.args, null, localPointer, Measure.ARGUMENT);
        if (oldT.def != newT.def) {
            if (oldT.def != null && newT.def != null) {
                this.copyTo(localPointer, CasualDiff.getOldPos(oldT.def));
                this.anonClass = true;
                localPointer = this.diffTree(oldT.def, newT.def, this.getBounds(oldT.def));
                this.anonClass = false;
            } else if (newT.def == null) {
                if (this.endPos(oldT.args) > localPointer) {
                    this.copyTo(localPointer, this.endPos(oldT.args));
                }
                this.printer.print(")");
                localPointer = this.endPos(oldT.def);
            } else {
                int n = localPointer;
                localPointer = this.endPos(oldT);
                this.copyTo(n, localPointer);
                this.printer.printNewClassBody(newT);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffNewArray(JCTree.JCNewArray oldT, JCTree.JCNewArray newT, int[] bounds) {
        int localPointer = bounds[0];
        if (newT.elemtype != null) {
            if (oldT.elemtype != null) {
                int[] elemtypeBounds = this.getBounds(oldT.elemtype);
                this.copyTo(localPointer, elemtypeBounds[0]);
                localPointer = this.diffTree(oldT.elemtype, newT.elemtype, elemtypeBounds);
            }
            if (!this.listsMatch(oldT.dims, newT.dims) && !newT.dims.isEmpty()) {
                List<JCTree.JCExpression> l1 = oldT.dims;
                List<JCTree.JCExpression> l2 = newT.dims;
                while (l1.nonEmpty()) {
                    int[] span = this.getBounds((JCTree)l1.head);
                    this.copyTo(localPointer, span[0]);
                    localPointer = this.diffTree((JCTree)l1.head, (JCTree)l2.head, span);
                    l1 = l1.tail;
                    l2 = l2.tail;
                }
            }
        } else if (oldT.elemtype != null) {
            this.copyTo(localPointer, CasualDiff.getOldPos(oldT));
            if (oldT.elems != null) {
                localPointer = oldT.dims != null && !oldT.dims.isEmpty() ? this.endPos(oldT.dims) : this.endPos(oldT.elemtype);
                PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.LBRACE);
                localPointer = this.tokenSequence.offset();
            } else {
                localPointer = this.endPos(oldT);
            }
        }
        if (oldT.elems != null) {
            if (oldT.elems.head != null) {
                this.copyTo(localPointer, CasualDiff.getOldPos((JCTree)oldT.elems.head));
                localPointer = this.diffParameterList(oldT.elems, newT.elems, null, CasualDiff.getOldPos((JCTree)oldT.elems.head), Measure.ARGUMENT);
            } else if (newT.elems != null && !newT.elems.isEmpty()) {
                PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.LBRACE);
                this.tokenSequence.moveNext();
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                localPointer = this.diffParameterList(oldT.elems, newT.elems, null, localPointer, Measure.ARGUMENT);
            }
        } else if (newT.elems != null && !newT.elems.isEmpty()) {
            if (newT.elemtype != null) {
                this.printer.print("[]");
            }
            this.printer.print("{");
            localPointer = this.diffParameterList(Collections.emptyList(), newT.elems, null, localPointer, Measure.ARGUMENT);
            this.printer.print("}");
            PositionEstimator.moveFwdToToken(this.tokenSequence, localPointer, JavaTokenId.SEMICOLON);
            this.tokenSequence.moveNext();
            localPointer = bounds[1];
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffParens(JCTree.JCParens oldT, JCTree.JCParens newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT.expr));
        localPointer = this.diffTree(oldT.expr, newT.expr, this.getBounds(oldT.expr));
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssign(JCTree.JCAssign oldT, JCTree.JCAssign newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        int[] rhsBounds = this.getBounds(oldT.rhs);
        if (oldT.lhs.getKind() == Tree.Kind.IDENTIFIER && newT.lhs.getKind() == Tree.Kind.IDENTIFIER && !((JCTree.JCIdent)oldT.lhs).name.equals(((JCTree.JCIdent)newT.lhs).name)) {
            this.tokenSequence.move(rhsBounds[0]);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            if (this.tokenSequence.token().id() != JavaTokenId.EQ) {
                if (this.diffContext.style.spaceAroundAssignOps()) {
                    this.printer.print(" = ");
                } else {
                    this.printer.print("=");
                }
            }
        }
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAssignop(JCTree.JCAssignOp oldT, JCTree.JCAssignOp newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        if (oldT.getTag() != newT.getTag()) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.getAssignementOperator(newT));
            localPointer = oldT.pos + this.getAssignementOperator(oldT).length();
        }
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    String getAssignementOperator(Tree t) {
        switch (t.getKind()) {
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case DIVIDE_ASSIGNMENT: {
                return "/=";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
        }
        throw new IllegalArgumentException("Illegal kind " + (Object)((Object)t.getKind()));
    }

    protected int diffUnary(JCTree.JCUnary oldT, JCTree.JCUnary newT, int[] bounds) {
        boolean newOpOnLeft;
        int[] argBounds = this.getBounds(oldT.arg);
        boolean bl = newOpOnLeft = newT.getKind() != Tree.Kind.POSTFIX_DECREMENT && newT.getKind() != Tree.Kind.POSTFIX_INCREMENT;
        if (newOpOnLeft) {
            if (oldT.getTag() != newT.getTag()) {
                this.printer.print(this.operatorName(newT.getTag()));
            } else {
                this.copyTo(bounds[0], argBounds[0]);
            }
        }
        int localPointer = this.diffTree(oldT.arg, newT.arg, argBounds);
        this.copyTo(localPointer, argBounds[1]);
        if (!newOpOnLeft) {
            if (oldT.getTag() != newT.getTag()) {
                this.printer.print(this.operatorName(newT.getTag()));
            } else {
                this.copyTo(argBounds[1], bounds[1]);
            }
        }
        return bounds[1];
    }

    protected int diffBinary(JCTree.JCBinary oldT, JCTree.JCBinary newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] lhsBounds = this.getBounds(oldT.lhs);
        this.copyTo(localPointer, lhsBounds[0]);
        localPointer = this.diffTree(oldT.lhs, newT.lhs, lhsBounds);
        if (oldT.getTag() != newT.getTag()) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(this.operatorName(newT.getTag()));
            localPointer = oldT.pos + this.operatorName(oldT.getTag()).toString().length();
        }
        int[] rhsBounds = this.getBounds(oldT.rhs);
        this.copyTo(localPointer, rhsBounds[0]);
        localPointer = this.diffTree(oldT.rhs, newT.rhs, rhsBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private String operatorName(int tag) {
        return new Pretty(null, false).operatorName(tag);
    }

    protected int diffTypeCast(JCTree.JCTypeCast oldT, JCTree.JCTypeCast newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeTest(JCTree.JCInstanceOf oldT, JCTree.JCInstanceOf newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] exprBounds = this.getBounds(oldT.expr);
        this.copyTo(localPointer, exprBounds[0]);
        localPointer = this.diffTree(oldT.expr, newT.expr, exprBounds);
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffIndexed(JCTree.JCArrayAccess oldT, JCTree.JCArrayAccess newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] indexedBounds = this.getBounds(oldT.indexed);
        this.copyTo(localPointer, indexedBounds[0]);
        localPointer = this.diffTree(oldT.indexed, newT.indexed, indexedBounds);
        int[] indexBounds = this.getBounds(oldT.index);
        this.copyTo(localPointer, indexBounds[0]);
        localPointer = this.diffTree(oldT.index, newT.index, indexBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess oldT, JCTree.JCFieldAccess newT, int[] bounds, List<JCTree.JCExpression> oldTypePar, List<JCTree.JCExpression> newTypePar) {
        int localPointer = bounds[0];
        int[] selectedBounds = this.getBounds(oldT.selected);
        this.copyTo(localPointer, selectedBounds[0]);
        localPointer = this.diffTree(oldT.selected, newT.selected, selectedBounds);
        if (oldTypePar != null && newTypePar != null) {
            int[] parBounds = this.getBounds((JCTree)oldTypePar.head);
            this.copyTo(localPointer, parBounds[0]);
            localPointer = this.diffParameterList(oldTypePar, newTypePar, null, parBounds[0], Measure.ARGUMENT);
            parBounds[1] = this.endPos(oldTypePar);
            this.tokenSequence.move(parBounds[1]);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
            int n = localPointer;
            localPointer = this.tokenSequence.offset();
            this.copyTo(n, localPointer);
        } else {
            this.tokenSequence.move(selectedBounds[1]);
            if (oldT.name != Names.instance((Context)this.context).error) {
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
            }
        }
        if (this.nameChanged(oldT.name, newT.name)) {
            this.printer.print(newT.name);
            this.diffInfo.put(localPointer, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo") + " " + oldT.name);
            localPointer += oldT.name.length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffSelect(JCTree.JCFieldAccess oldT, JCTree.JCFieldAccess newT, int[] bounds) {
        return this.diffSelect(oldT, newT, bounds, null, null);
    }

    protected int diffIdent(JCTree.JCIdent oldT, JCTree.JCIdent newT, int[] bounds) {
        if (this.nameChanged(oldT.name, newT.name)) {
            this.copyTo(bounds[0], oldT.pos);
            this.printer.print(newT.name);
            this.diffInfo.put(oldT.pos, NbBundle.getMessage(CasualDiff.class, (String)"TXT_UpdateReferenceTo") + " " + oldT.name);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffLiteral(JCTree.JCLiteral oldT, JCTree.JCLiteral newT, int[] bounds) {
        if (oldT.typetag != newT.typetag || oldT.value != null && !oldT.value.equals(newT.value)) {
            int localPointer = bounds[0];
            int[] literalBounds = this.getBounds(oldT);
            this.copyTo(localPointer, literalBounds[0]);
            this.printer.print(newT);
            this.copyTo(literalBounds[1], bounds[1]);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeIdent(JCTree.JCPrimitiveTypeTree oldT, JCTree.JCPrimitiveTypeTree newT, int[] bounds) {
        if (oldT.typetag != newT.typetag) {
            this.printer.print(newT);
        } else {
            this.copyTo(bounds[0], bounds[1]);
        }
        return bounds[1];
    }

    protected int diffTypeArray(JCTree.JCArrayTypeTree oldT, JCTree.JCArrayTypeTree newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] elemtypeBounds = this.getBounds(oldT.elemtype);
        localPointer = this.diffTree(oldT.elemtype, newT.elemtype, elemtypeBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeApply(JCTree.JCTypeApply oldT, JCTree.JCTypeApply newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] clazzBounds = this.getBounds(oldT.clazz);
        this.copyTo(localPointer, clazzBounds[0]);
        localPointer = this.diffTree(oldT.clazz, newT.clazz, clazzBounds);
        if (!this.listsMatch(oldT.arguments, newT.arguments)) {
            JavaTokenId[] javaTokenIdArray;
            int pos = oldT.arguments.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.arguments.head) : this.endPos(oldT.clazz);
            this.copyTo(localPointer, pos);
            boolean printBrace = false;
            List<JCTree.JCExpression> list = oldT.arguments;
            List<JCTree.JCExpression> list2 = newT.arguments;
            if (printBrace) {
                JavaTokenId[] javaTokenIdArray2 = new JavaTokenId[2];
                javaTokenIdArray2[0] = JavaTokenId.LT;
                javaTokenIdArray = javaTokenIdArray2;
                javaTokenIdArray2[1] = JavaTokenId.GT;
            } else {
                javaTokenIdArray = null;
            }
            localPointer = this.diffParameterList(list, list2, javaTokenIdArray, pos, Measure.ARGUMENT);
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeParameter(JCTree.JCTypeParameter oldT, JCTree.JCTypeParameter newT, int[] bounds) {
        int localPointer = bounds[0];
        this.copyTo(localPointer, CasualDiff.getOldPos(oldT));
        if (this.nameChanged(oldT.name, newT.name)) {
            this.printer.print(newT.name);
            localPointer += oldT.name.length();
        }
        if (!this.listsMatch(oldT.bounds, newT.bounds)) {
            int pos;
            PositionEstimator est = EstimatorFactory.implementz(oldT.getBounds(), newT.getBounds(), this.diffContext);
            int n = pos = oldT.bounds.nonEmpty() ? CasualDiff.getOldPos((JCTree)oldT.bounds.head) : -1;
            if (pos > -1) {
                this.copyTo(localPointer, pos);
                localPointer = this.diffList2(oldT.bounds, newT.bounds, pos, est);
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffWildcard(JCTree.JCWildcard oldT, JCTree.JCWildcard newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.kind.toString());
            localPointer = oldT.pos + oldT.kind.toString().length();
        }
        JCTree oldBound = oldT.kind.kind != BoundKind.UNBOUND ? oldT.inner : null;
        JCTree newBound = newT.kind.kind != BoundKind.UNBOUND ? newT.inner : null;
        int[] innerBounds = this.getBounds(oldBound);
        this.copyTo(localPointer, innerBounds[0]);
        localPointer = this.diffTree(oldBound, newBound, innerBounds);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffTypeBoundKind(JCTree.TypeBoundKind oldT, JCTree.TypeBoundKind newT, int[] bounds) {
        int localPointer = bounds[0];
        if (oldT.kind != newT.kind) {
            this.copyTo(localPointer, oldT.pos);
            this.printer.print(newT.kind.toString());
            localPointer = oldT.pos + oldT.kind.toString().length();
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffAnnotation(JCTree.JCAnnotation oldT, JCTree.JCAnnotation newT, int[] bounds) {
        int localPointer = bounds[0];
        int[] annotationBounds = this.getBounds(oldT.annotationType);
        this.copyTo(localPointer, annotationBounds[0]);
        localPointer = this.diffTree(oldT.annotationType, newT.annotationType, annotationBounds);
        JavaTokenId[] parens = null;
        if (oldT.args.nonEmpty()) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos((JCTree)oldT.args.head);
            this.copyTo(n, localPointer);
        } else {
            int endPos = this.endPos(oldT);
            this.tokenSequence.move(endPos);
            this.tokenSequence.movePrevious();
            if (JavaTokenId.RPAREN != this.tokenSequence.token().id()) {
                parens = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN};
            } else {
                --endPos;
            }
            int n = localPointer;
            localPointer = endPos;
            this.copyTo(n, localPointer);
        }
        localPointer = this.diffParameterList(oldT.args, newT.args, parens, localPointer, Measure.ARGUMENT);
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    protected int diffModifiers(JCTree.JCModifiers oldT, JCTree.JCModifiers newT, JCTree parent, int localPointer) {
        if (oldT == newT) {
            return localPointer;
        }
        int startPos = oldT.pos != -1 ? CasualDiff.getOldPos(oldT) : CasualDiff.getOldPos(parent);
        int firstAnnotationPos = !((List)oldT.getAnnotations()).isEmpty() ? CasualDiff.getOldPos((JCTree)((List)oldT.getAnnotations()).head) : -1;
        int endOffset = this.endPos(oldT);
        if (startPos < firstAnnotationPos && oldT.flags != newT.flags) {
            this.copyTo(localPointer, startPos);
            this.printer.printFlags(newT.flags & 0xFFFFFFFFFFFFFDFFL, oldT.getFlags().isEmpty());
            this.tokenSequence.move(firstAnnotationPos);
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            localPointer = this.tokenSequence.offset();
        }
        localPointer = this.diffAnnotationsLists((List<JCTree.JCAnnotation>)oldT.getAnnotations(), (List<JCTree.JCAnnotation>)newT.getAnnotations(), startPos, localPointer);
        if ((oldT.flags & 0x2000L) != 0L) {
            this.tokenSequence.move(endOffset);
            this.tokenSequence.movePrevious();
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            endOffset = this.tokenSequence.offset();
        }
        if (oldT.flags != newT.flags && startPos >= firstAnnotationPos) {
            if (localPointer == startPos) {
                if ((newT.flags & 0xFFFFFFFFFFFFFDFFL) != 0L) {
                    this.printer.printFlags(newT.flags & 0xFFFFFFFFFFFFFDFFL, oldT.getFlags().isEmpty());
                    localPointer = endOffset > 0 ? endOffset : localPointer;
                } else if (endOffset > 0) {
                    this.tokenSequence.move(endOffset);
                    while (this.tokenSequence.moveNext() && JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                    }
                    localPointer = this.tokenSequence.offset();
                }
            } else {
                this.tokenSequence.move(localPointer);
                PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                int n = localPointer;
                localPointer = this.tokenSequence.offset();
                this.copyTo(n, localPointer);
                localPointer = this.tokenSequence.offset();
                if (!oldT.getFlags().isEmpty()) {
                    localPointer = endOffset;
                }
                this.printer.printFlags(newT.flags, oldT.getFlags().isEmpty());
            }
        } else if (endOffset > localPointer) {
            int n = localPointer;
            localPointer = endOffset;
            this.copyTo(n, localPointer);
        }
        return localPointer;
    }

    private int diffAnnotationsLists(List<JCTree.JCAnnotation> oldAnnotations, List<JCTree.JCAnnotation> newAnnotations, int startPos, int localPointer) {
        int annotationsEnd;
        int n = annotationsEnd = oldAnnotations.nonEmpty() ? this.endPos(oldAnnotations) : localPointer;
        if (this.listsMatch(oldAnnotations, newAnnotations)) {
            int n2 = localPointer;
            localPointer = annotationsEnd != localPointer ? annotationsEnd : startPos;
            this.copyTo(n2, localPointer);
        } else {
            this.tokenSequence.move(startPos);
            if (this.tokenSequence.movePrevious() && JavaTokenId.WHITESPACE == this.tokenSequence.token().id()) {
                String text = ((Object)this.tokenSequence.token().text()).toString();
                int index = text.lastIndexOf(10);
                startPos = this.tokenSequence.offset();
                if (index > -1) {
                    startPos += index + 1;
                }
                if (startPos < localPointer) {
                    startPos = localPointer;
                }
            }
            this.copyTo(localPointer, startPos);
            PositionEstimator est = EstimatorFactory.annotations(oldAnnotations, newAnnotations, this.diffContext, this.parameterPrint);
            localPointer = this.diffList(oldAnnotations, newAnnotations, startPos, est, Measure.DEFAULT, this.printer);
        }
        return localPointer;
    }

    protected void diffLetExpr(JCTree.LetExpr oldT, JCTree.LetExpr newT) {
    }

    protected void diffErroneous(JCTree.JCErroneous oldT, JCTree.JCErroneous newT, int[] bounds) {
        JCTree oldTident = (JCTree)((List)oldT.getErrorTrees()).get(0);
        JCTree newTident = (JCTree)((List)newT.getErrorTrees()).get(0);
        if (oldTident.getKind() == Tree.Kind.IDENTIFIER && newTident.getKind() == Tree.Kind.IDENTIFIER) {
            this.diffIdent((JCTree.JCIdent)oldTident, (JCTree.JCIdent)newTident, bounds);
        }
    }

    protected int diffFieldGroup(FieldGroupTree oldT, FieldGroupTree newT, int[] bounds) {
        if (!this.listsMatch(oldT.getVariables(), newT.getVariables())) {
            this.copyTo(bounds[0], oldT.getStartPosition());
            if (oldT.isEnum()) {
                int pos = this.diffParameterList(oldT.getVariables(), newT.getVariables(), null, oldT.getStartPosition(), Measure.ARGUMENT, true, ",");
                this.copyTo(pos, bounds[1]);
                return bounds[1];
            }
            int pos = this.diffVarGroup(oldT.getVariables(), newT.getVariables(), null, oldT.getStartPosition(), Measure.GROUP_VAR_MEASURE);
            this.copyTo(pos, bounds[1]);
            return bounds[1];
        }
        this.tokenSequence.move(oldT.endPos());
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    protected boolean listContains(java.util.List<? extends JCTree> list, JCTree tree) {
        for (JCTree jCTree : list) {
            if (!this.treesMatch(jCTree, tree)) continue;
            return true;
        }
        return false;
    }

    protected boolean treesMatch(JCTree t1, JCTree t2) {
        return this.treesMatch(t1, t2, true);
    }

    public boolean treesMatch(JCTree t1, JCTree t2, boolean deepMatch) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.getTag() != t2.getTag()) {
            return false;
        }
        if (!deepMatch) {
            return true;
        }
        switch (t1.getTag()) {
            case 1: {
                return ((JCTree.JCCompilationUnit)t1).sourcefile.equals(((JCTree.JCCompilationUnit)t2).sourcefile);
            }
            case 2: {
                return this.matchImport((JCTree.JCImport)t1, (JCTree.JCImport)t2);
            }
            case 3: {
                return ((JCTree.JCClassDecl)t1).sym == ((JCTree.JCClassDecl)t2).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)t1).sym == ((JCTree.JCMethodDecl)t2).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)t1).sym == ((JCTree.JCVariableDecl)t2).sym;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.matchBlock((JCTree.JCBlock)t1, (JCTree.JCBlock)t2);
            }
            case 8: {
                return this.matchDoLoop((JCTree.JCDoWhileLoop)t1, (JCTree.JCDoWhileLoop)t2);
            }
            case 9: {
                return this.matchWhileLoop((JCTree.JCWhileLoop)t1, (JCTree.JCWhileLoop)t2);
            }
            case 10: {
                return this.matchForLoop((JCTree.JCForLoop)t1, (JCTree.JCForLoop)t2);
            }
            case 11: {
                return this.matchForeachLoop((JCTree.JCEnhancedForLoop)t1, (JCTree.JCEnhancedForLoop)t2);
            }
            case 12: {
                return this.matchLabelled((JCTree.JCLabeledStatement)t1, (JCTree.JCLabeledStatement)t2);
            }
            case 13: {
                return this.matchSwitch((JCTree.JCSwitch)t1, (JCTree.JCSwitch)t2);
            }
            case 14: {
                return this.matchCase((JCTree.JCCase)t1, (JCTree.JCCase)t2);
            }
            case 15: {
                return this.matchSynchronized((JCTree.JCSynchronized)t1, (JCTree.JCSynchronized)t2);
            }
            case 16: {
                return this.matchTry((JCTree.JCTry)t1, (JCTree.JCTry)t2);
            }
            case 17: {
                return this.matchCatch((JCTree.JCCatch)t1, (JCTree.JCCatch)t2);
            }
            case 18: {
                return this.matchConditional((JCTree.JCConditional)t1, (JCTree.JCConditional)t2);
            }
            case 19: {
                return this.matchIf((JCTree.JCIf)t1, (JCTree.JCIf)t2);
            }
            case 20: {
                return this.treesMatch(((JCTree.JCExpressionStatement)t1).expr, ((JCTree.JCExpressionStatement)t2).expr);
            }
            case 21: {
                return this.matchBreak((JCTree.JCBreak)t1, (JCTree.JCBreak)t2);
            }
            case 22: {
                return this.matchContinue((JCTree.JCContinue)t1, (JCTree.JCContinue)t2);
            }
            case 23: {
                return this.treesMatch(((JCTree.JCReturn)t1).expr, ((JCTree.JCReturn)t2).expr);
            }
            case 24: {
                return this.treesMatch(((JCTree.JCThrow)t1).expr, ((JCTree.JCThrow)t2).expr);
            }
            case 25: {
                return this.matchAssert((JCTree.JCAssert)t1, (JCTree.JCAssert)t2);
            }
            case 26: {
                return this.matchApply((JCTree.JCMethodInvocation)t1, (JCTree.JCMethodInvocation)t2);
            }
            case 27: {
                if (((JCTree.JCNewClass)t2).def != null) {
                    ((JCTree.JCNewClass)t2).def.sym = null;
                }
                return this.matchNewClass((JCTree.JCNewClass)t1, (JCTree.JCNewClass)t2);
            }
            case 28: {
                return this.matchNewArray((JCTree.JCNewArray)t1, (JCTree.JCNewArray)t2);
            }
            case 29: {
                return this.treesMatch(((JCTree.JCParens)t1).expr, ((JCTree.JCParens)t2).expr);
            }
            case 30: {
                return this.matchAssign((JCTree.JCAssign)t1, (JCTree.JCAssign)t2);
            }
            case 31: {
                return this.matchTypeCast((JCTree.JCTypeCast)t1, (JCTree.JCTypeCast)t2);
            }
            case 32: {
                return this.matchTypeTest((JCTree.JCInstanceOf)t1, (JCTree.JCInstanceOf)t2);
            }
            case 33: {
                return this.matchIndexed((JCTree.JCArrayAccess)t1, (JCTree.JCArrayAccess)t2);
            }
            case 34: {
                return this.matchSelect((JCTree.JCFieldAccess)t1, (JCTree.JCFieldAccess)t2);
            }
            case 35: {
                return ((JCTree.JCIdent)t1).getName().contentEquals(((JCTree.JCIdent)t2).getName());
            }
            case 36: {
                return this.matchLiteral((JCTree.JCLiteral)t1, (JCTree.JCLiteral)t2);
            }
            case 37: {
                return ((JCTree.JCPrimitiveTypeTree)t1).typetag == ((JCTree.JCPrimitiveTypeTree)t2).typetag;
            }
            case 38: {
                return this.treesMatch(((JCTree.JCArrayTypeTree)t1).elemtype, ((JCTree.JCArrayTypeTree)t2).elemtype);
            }
            case 39: {
                return this.matchTypeApply((JCTree.JCTypeApply)t1, (JCTree.JCTypeApply)t2);
            }
            case 40: {
                return this.matchTypeParameter((JCTree.JCTypeParameter)t1, (JCTree.JCTypeParameter)t2);
            }
            case 41: {
                return this.matchWildcard((JCTree.JCWildcard)t1, (JCTree.JCWildcard)t2);
            }
            case 42: {
                return ((JCTree.TypeBoundKind)t1).kind == ((JCTree.TypeBoundKind)t2).kind;
            }
            case 43: {
                return this.matchAnnotation((JCTree.JCAnnotation)t1, (JCTree.JCAnnotation)t2);
            }
            case 91: {
                return this.matchLetExpr((JCTree.LetExpr)t1, (JCTree.LetExpr)t2);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return this.matchUnary((JCTree.JCUnary)t1, (JCTree.JCUnary)t2);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return this.matchBinary((JCTree.JCBinary)t1, (JCTree.JCBinary)t2);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return this.matchAssignop((JCTree.JCAssignOp)t1, (JCTree.JCAssignOp)t2);
            }
        }
        String msg = t1.getKind().toString() + " " + t1.getClass().getName();
        throw new AssertionError((Object)msg);
    }

    private boolean kindChanged(long oldFlags, long newFlags) {
        return (oldFlags & 0x6200L) != (newFlags & 0x6200L);
    }

    protected boolean nameChanged(Name oldName, Name newName) {
        byte[] arr2;
        if (oldName == newName) {
            return false;
        }
        if (oldName == null || newName == null) {
            return true;
        }
        byte[] arr1 = oldName.toUtf();
        int len = arr1.length;
        if (len != (arr2 = newName.toUtf()).length) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return true;
        }
        return false;
    }

    protected int diffList2(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int initialPos, PositionEstimator estimator) {
        if (oldList == newList) {
            return initialPos;
        }
        assert (oldList != null && newList != null);
        int lastOldPos = initialPos;
        ListMatcher<? extends JCTree> matcher = ListMatcher.instance(oldList, newList);
        if (!matcher.match()) {
            return initialPos;
        }
        Iterator<? extends JCTree> oldIter = oldList.iterator();
        ListMatcher.ResultItem<? extends JCTree>[] result = matcher.getTransformedResult();
        ListMatcher.Separator s = matcher.separatorInstance();
        s.compute();
        int[][] matrix = estimator.getMatrix();
        int testPos = initialPos;
        int i = 0;
        boolean firstNewItem = true;
        block6: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<? extends JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    if (!firstNewItem) {
                        this.copyTo(lastOldPos, CasualDiff.getOldPos(oldT));
                    }
                    if (this.treesMatch(oldT, (JCTree)item.element, false)) {
                        lastOldPos = this.diffTree(oldT, (JCTree)item.element, this.getBounds(oldT));
                    } else {
                        this.printer.print((JCTree)item.element);
                        lastOldPos = Math.max(testPos, this.endPos(oldT));
                    }
                    firstNewItem = false;
                    continue block6;
                }
                case INSERT: {
                    String tail;
                    String prec = s.head(j) ? estimator.head() : (s.prev(j) ? estimator.sep() : null);
                    String string = tail = s.next(j) ? estimator.sep() : null;
                    if (estimator.getIndentString() != null && !estimator.getIndentString().equals(" ")) {
                        prec = prec + estimator.getIndentString();
                    }
                    this.copyTo(lastOldPos, testPos);
                    this.printer.print(prec);
                    this.printer.print((JCTree)item.element);
                    this.printer.print(tail);
                    firstNewItem = false;
                    continue block6;
                }
                case DELETE: {
                    int delta = 0;
                    if (i == 0 && matrix[i + 1][2] != -1 && matrix[i + 1][2] == matrix[i + 1][3]) {
                        ++delta;
                    }
                    int startOffset = this.toOff(s.head(j) || s.prev(j) ? matrix[i][1] : matrix[i][2 + delta]);
                    int endOffset = this.toOff(s.tail(j) || s.next(j) ? matrix[i + 1][2] : matrix[i][4]);
                    assert (startOffset != -1 && endOffset != -1) : "Invalid offset!";
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    lastOldPos = i == 0 && !newList.isEmpty() ? endOffset : this.endPos((JCTree)item.element);
                    JCTree oldT = oldIter.next();
                    ++i;
                    continue block6;
                }
                case NOCHANGE: {
                    this.tokenSequence.moveIndex(matrix[i][4]);
                    if (this.tokenSequence.moveNext()) {
                        testPos = this.tokenSequence.offset();
                        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
                            testPos += JavaTokenId.COMMA.fixedText().length();
                        }
                    }
                    JCTree oldT = oldIter.next();
                    ++i;
                    int n = lastOldPos;
                    lastOldPos = this.endPos(oldT);
                    this.copyTo(n, lastOldPos);
                    firstNewItem = false;
                }
            }
        }
        return lastOldPos;
    }

    private int printBreakContinueTree(int[] bounds, Name oldTLabel, Name newTlabel, JCTree.JCStatement oldT) {
        String stmt;
        int localPointer = bounds[0];
        String string = stmt = oldT.getKind() == Tree.Kind.BREAK ? "break" : "continue";
        if (this.nameChanged(oldTLabel, newTlabel)) {
            int n = localPointer;
            localPointer = CasualDiff.getOldPos(oldT);
            this.copyTo(n, localPointer);
            this.printer.print(stmt);
            localPointer += stmt.length();
            if (oldTLabel != null && oldTLabel.length() > 0) {
                ++localPointer;
            }
            if (newTlabel != null && newTlabel.length() > 0) {
                this.printer.print(" ");
                this.printer.print(newTlabel);
            }
            if (oldTLabel != null) {
                localPointer += oldTLabel.length();
            }
        }
        this.copyTo(localPointer, bounds[1]);
        return bounds[1];
    }

    private int toOff(int tokenIndex) {
        if (tokenIndex == -1) {
            return -1;
        }
        this.tokenSequence.moveIndex(tokenIndex);
        this.tokenSequence.moveNext();
        return this.tokenSequence.offset();
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure) {
        return this.diffParameterList(oldList, newList, makeAround, pos, measure, false, ",");
    }

    private int diffParameterList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure, boolean isEnum, String separator) {
        boolean printParens;
        assert (oldList != null && newList != null);
        if (oldList == newList || ((Object)oldList).equals(newList)) {
            return pos;
        }
        boolean bl = printParens = makeAround != null && makeAround.length != 0;
        if (newList.isEmpty()) {
            int endPos = this.endPos(oldList);
            if (printParens) {
                this.tokenSequence.move(endPos);
                PositionEstimator.moveFwdToToken(this.tokenSequence, endPos, makeAround[1]);
                this.tokenSequence.moveNext();
                endPos = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    this.printer.print(" ");
                }
            }
            return endPos;
        }
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return pos;
        }
        ListMatcher.ResultItem[] result = matcher.getResult();
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[0].fixedText());
        }
        int oldIndex = 0;
        boolean wasLeadingDelete = false;
        boolean wasComma = false;
        for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    JCTree tree = oldList.get(oldIndex++);
                    int[] bounds = this.getBounds(tree);
                    this.tokenSequence.move(bounds[0]);
                    if (oldIndex != 1) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    this.copyTo(start, bounds[0], this.printer);
                    this.diffTree(tree, (JCTree)item.element, bounds);
                    this.tokenSequence.move(bounds[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    if (!this.commaNeeded(result, item) && isEnum && this.tokenSequence.token().id() == JavaTokenId.RBRACKET) {
                        this.printer.print(";");
                    }
                    pos = this.tokenSequence.offset();
                    this.copyTo(bounds[1], pos, this.printer);
                    wasLeadingDelete = false;
                    break;
                }
                case INSERT: {
                    if (wasComma && this.diffContext.style.spaceAfterComma()) {
                        this.printer.print(" ");
                    }
                    this.printer.print((JCTree)item.element);
                    wasLeadingDelete = false;
                    break;
                }
                case DELETE: {
                    wasLeadingDelete |= oldIndex++ == 0;
                    this.tokenSequence.move(this.getBounds((JCTree)item.element)[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    pos = this.tokenSequence.offset();
                    break;
                }
                case NOCHANGE: {
                    if (oldIndex++ == 0 && wasComma && this.diffContext.style.spaceAfterComma()) {
                        this.printer.print(" ");
                    }
                    int[] bounds = this.getCommentCorrectedBounds((JCTree)item.element);
                    this.tokenSequence.move(bounds[0]);
                    if (oldIndex != 1 && !wasLeadingDelete) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    this.tokenSequence.move(bounds[1]);
                    PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
                    int end = bounds[1];
                    if (isEnum && (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON || this.tokenSequence.token().id() == JavaTokenId.COMMA)) {
                        end = this.tokenSequence.offset();
                    }
                    pos = end;
                    this.copyTo(start, pos, this.printer);
                    wasLeadingDelete = false;
                    break;
                }
            }
            if (this.commaNeeded(result, item)) {
                this.printer.print(separator);
                wasComma = true;
                continue;
            }
            if (item.operation == ListMatcher.Operation.DELETE) continue;
            wasComma = false;
        }
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[1].fixedText());
        }
        if (oldList.isEmpty()) {
            return pos;
        }
        int endPos2 = this.endPos(oldList);
        this.tokenSequence.move(endPos2);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (isEnum && (this.tokenSequence.token().id() == JavaTokenId.SEMICOLON || this.tokenSequence.token().id() == JavaTokenId.COMMA)) {
            return this.tokenSequence.offset();
        }
        return pos;
    }

    private int diffVarGroup(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, JavaTokenId[] makeAround, int pos, Comparator<JCTree> measure) {
        boolean printParens;
        assert (oldList != null && newList != null);
        if (oldList == newList || ((Object)oldList).equals(newList)) {
            return pos;
        }
        boolean bl = printParens = makeAround != null && makeAround.length != 0;
        if (newList.isEmpty()) {
            int endPos = this.endPos(oldList);
            if (printParens) {
                this.tokenSequence.move(endPos);
                PositionEstimator.moveFwdToToken(this.tokenSequence, endPos, makeAround[1]);
                this.tokenSequence.moveNext();
                endPos = this.tokenSequence.offset();
                if (!PositionEstimator.nonRelevant.contains(this.tokenSequence.token())) {
                    this.printer.print(" ");
                }
            }
            return endPos;
        }
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return pos;
        }
        ListMatcher.ResultItem[] result = matcher.getResult();
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[0].fixedText());
        }
        int oldIndex = 0;
        boolean skipWhitespaces = false;
        for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    JCTree tree = oldList.get(oldIndex++);
                    int[] bounds = this.getBounds(tree);
                    if (oldIndex != 1) {
                        bounds[0] = tree.pos;
                    }
                    this.tokenSequence.move(bounds[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        bounds[1] = this.tokenSequence.offset();
                    }
                    this.tokenSequence.move(bounds[0]);
                    if (oldIndex != 1 && !skipWhitespaces) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    this.copyTo(start, bounds[0], this.printer);
                    int localPointer = oldIndex != 1 ? this.diffVarDef((JCTree.JCVariableDecl)tree, (JCTree.JCVariableDecl)item.element, bounds[0]) : this.diffVarDef((JCTree.JCVariableDecl)tree, (JCTree.JCVariableDecl)item.element, bounds);
                    pos = bounds[1];
                    this.copyTo(localPointer, pos, this.printer);
                    skipWhitespaces = false;
                    break;
                }
                case INSERT: {
                    JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)item.element;
                    if (oldIndex == 0) {
                        int oldPrec = this.printer.setPrec(0);
                        this.printer.visitVarDef(decl);
                        this.printer.setPrec(oldPrec);
                    } else {
                        if (this.diffContext.style.spaceAfterComma()) {
                            this.printer.print(" ");
                        }
                        this.printer.print(decl.name);
                        this.printer.printVarInit(decl);
                    }
                    skipWhitespaces = false;
                    break;
                }
                case NOCHANGE: {
                    ++oldIndex;
                    int[] bounds = this.getBounds((JCTree)item.element);
                    if (j != 0) {
                        bounds[0] = ((JCTree)item.element).pos;
                    }
                    this.tokenSequence.move(bounds[0]);
                    if (j != 0 && !skipWhitespaces) {
                        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
                    }
                    this.tokenSequence.moveNext();
                    int start = this.tokenSequence.offset();
                    int end = bounds[1];
                    this.tokenSequence.move(end);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        end = this.tokenSequence.offset();
                    }
                    pos = end;
                    this.copyTo(start, pos, this.printer);
                    skipWhitespaces = false;
                    break;
                }
                case DELETE: {
                    skipWhitespaces = false;
                    if (j == 0) {
                        JCTree.JCVariableDecl oldEl = (JCTree.JCVariableDecl)oldList.get(0);
                        JCTree.JCVariableDecl newEl = (JCTree.JCVariableDecl)newList.get(0);
                        int[] bounds = this.getBounds(oldEl.getModifiers());
                        this.copyTo(pos, bounds[0]);
                        pos = this.diffTree(oldEl.getModifiers(), newEl.getModifiers(), bounds);
                        bounds = this.getBounds(oldEl.getType());
                        int n = pos;
                        pos = bounds[0];
                        this.copyTo(n, pos);
                        pos = this.diffTree(oldEl.getType(), newEl.getType(), bounds);
                        this.copyTo(pos, ((JCTree)item.element).pos);
                        skipWhitespaces = true;
                    }
                    int[] bounds = this.getBounds((JCTree)item.element);
                    this.tokenSequence.move(bounds[1]);
                    this.tokenSequence.movePrevious();
                    if (this.tokenSequence.token().id() == JavaTokenId.COMMA || this.tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                        bounds[1] = this.tokenSequence.offset();
                    }
                    pos = bounds[1];
                    break;
                }
            }
            if (!this.commaNeeded(result, item)) continue;
            this.printer.print(",");
        }
        if (printParens && oldList.isEmpty()) {
            this.printer.print(makeAround[1].fixedText());
        }
        return pos;
    }

    private boolean commaNeeded(ListMatcher.ResultItem[] arr, ListMatcher.ResultItem item) {
        if (item.operation == ListMatcher.Operation.DELETE) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < arr.length; ++i) {
            if (item == arr[i]) {
                result = true;
                continue;
            }
            if (!result || arr[i].operation == ListMatcher.Operation.DELETE) continue;
            return true;
        }
        return false;
    }

    private java.util.List<JCTree> filterHidden(java.util.List<? extends JCTree> list) {
        LinkedList<JCTree> result = new LinkedList<JCTree>();
        ArrayList<JCTree.JCVariableDecl> fieldGroup = new ArrayList<JCTree.JCVariableDecl>();
        ArrayList<JCTree.JCVariableDecl> enumConstants = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree jCTree : list) {
            if (Tree.Kind.VARIABLE == jCTree.getKind()) {
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)jCTree;
                if ((var.mods.flags & 0x4000L) != 0L) {
                    enumConstants.add(var);
                    continue;
                }
                if (!fieldGroup.isEmpty()) {
                    int oldPos = CasualDiff.getOldPos((JCTree)fieldGroup.get(0));
                    if (oldPos != -1 && oldPos != -2 && oldPos == CasualDiff.getOldPos(var) && ((JCTree.JCVariableDecl)fieldGroup.get(0)).getModifiers() == var.getModifiers()) {
                        fieldGroup.add(var);
                        continue;
                    }
                    if (fieldGroup.size() > 1) {
                        result.add(new FieldGroupTree(fieldGroup));
                    } else {
                        result.add((JCTree)fieldGroup.get(0));
                    }
                    fieldGroup = new ArrayList();
                    fieldGroup.add(var);
                    continue;
                }
                fieldGroup.add(var);
                continue;
            }
            if (!fieldGroup.isEmpty()) {
                if (fieldGroup.size() > 1) {
                    result.add(new FieldGroupTree(fieldGroup));
                } else {
                    result.add((JCTree)fieldGroup.get(0));
                }
                fieldGroup = new ArrayList();
            }
            if (Tree.Kind.METHOD == jCTree.getKind()) {
                if (jCTree.pos == -1 || (((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L) {
                    continue;
                }
            } else if (Tree.Kind.BLOCK == jCTree.getKind()) {
                JCTree.JCBlock block = (JCTree.JCBlock)jCTree;
                if (block.stats.isEmpty() && block.pos == -1 && block.flags == 0L) continue;
            }
            result.add(jCTree);
        }
        if (!fieldGroup.isEmpty()) {
            if (fieldGroup.size() > 1) {
                result.add(new FieldGroupTree(fieldGroup));
            } else {
                result.add((JCTree)fieldGroup.get(0));
            }
        }
        if (!enumConstants.isEmpty()) {
            result.addFirst(new FieldGroupTree(enumConstants, !result.isEmpty()));
        }
        return result;
    }

    private int diffList(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList, int localPointer, PositionEstimator estimator, Comparator<JCTree> measure, VeryPretty printer) {
        if (oldList == newList || ((Object)oldList).equals(newList)) {
            return localPointer;
        }
        assert (oldList != null && newList != null);
        ListMatcher<JCTree> matcher = ListMatcher.instance(oldList, newList, measure);
        if (!matcher.match()) {
            return localPointer;
        }
        JCTree lastdel = null;
        ListMatcher.ResultItem<JCTree>[] result = matcher.getResult();
        if (oldList.isEmpty() && !newList.isEmpty()) {
            StringBuilder aHead = new StringBuilder();
            StringBuilder aTail = new StringBuilder();
            int pos = estimator.prepare(localPointer, aHead, aTail);
            this.copyTo(localPointer, pos, printer);
            if (newList.get(0).getKind() == Tree.Kind.IMPORT) {
                printer.printImportsBlock(newList, true);
            } else {
                printer.print(aHead.toString());
                for (JCTree jCTree : newList) {
                    if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                        printer.newline();
                    }
                    printer.print(jCTree);
                    if (LineInsertionType.AFTER != estimator.lineInsertType()) continue;
                    printer.newline();
                }
                printer.print(aTail.toString());
            }
            return pos;
        }
        if (newList.isEmpty() && !oldList.isEmpty()) {
            int[] removalBounds = estimator.sectionRemovalBounds(null);
            this.copyTo(localPointer, removalBounds[0]);
            return removalBounds[1];
        }
        int i = 0;
        int insertPos = estimator.getInsertPos(0);
        if (insertPos > localPointer) {
            int n = localPointer;
            localPointer = estimator.getInsertPos(0);
            this.copyTo(n, localPointer, printer);
        } else {
            insertPos = localPointer;
        }
        block7: for (int j = 0; j < result.length; ++j) {
            ListMatcher.ResultItem<JCTree> item = result[j];
            switch (item.operation) {
                case MODIFY: {
                    int[] nArray = estimator.getPositions(i);
                    nArray[0] = Math.min(nArray[0], this.getCommentCorrectedOldPos(oldList.get(i)));
                    this.copyTo(localPointer, nArray[0], printer);
                    localPointer = this.diffTree(oldList.get(i), (JCTree)item.element, nArray);
                    ++i;
                    continue block7;
                }
                case INSERT: {
                    int n = estimator.getInsertPos(i);
                    if (n > localPointer) {
                        this.tokenSequence.move(n);
                        PositionEstimator.moveToDifferentThan(this.tokenSequence, PositionEstimator.Direction.BACKWARD, EnumSet.of(JavaTokenId.WHITESPACE));
                        this.tokenSequence.moveNext();
                        int n2 = this.tokenSequence.offset();
                        if (n2 > localPointer) {
                            int n3 = localPointer;
                            localPointer = n2;
                            this.copyTo(n3, localPointer);
                        }
                    }
                    int oldPos = ((JCTree)item.element).getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos((JCTree)item.element) : ((JCTree)item.element).pos;
                    boolean found = false;
                    if (oldPos > 0) {
                        for (JCTree jCTree : oldList) {
                            int oldNodePos = jCTree.getKind() != Tree.Kind.VARIABLE ? CasualDiff.getOldPos(jCTree) : jCTree.pos;
                            if (oldPos != oldNodePos) continue;
                            found = true;
                            VeryPretty oldPrinter = this.printer;
                            int old = oldPrinter.indent();
                            this.printer = new VeryPretty(this.diffContext, this.diffContext.style, this.tree2Tag, this.tag2Span, this.origText, oldPrinter.toString().length() + oldPrinter.getInitialOffset());
                            this.printer.reset(old);
                            this.printer.oldTrees = this.oldTrees;
                            int index = oldList.indexOf(jCTree);
                            int[] poss = estimator.getPositions(index);
                            int end = this.diffTree(jCTree, (JCTree)item.element, poss);
                            this.copyTo(end, poss[1]);
                            printer.print(this.printer.toString());
                            this.printer = oldPrinter;
                            this.printer.undent(old);
                            break;
                        }
                    }
                    if (found) continue block7;
                    if (lastdel != null && this.treesMatch((JCTree)item.element, lastdel, false)) {
                        VeryPretty oldPrinter = this.printer;
                        int n4 = oldPrinter.indent();
                        this.printer = new VeryPretty(this.diffContext, this.diffContext.style, this.tree2Tag, this.tag2Span, this.origText, oldPrinter.toString().length() + oldPrinter.getInitialOffset());
                        this.printer.reset(n4);
                        this.printer.oldTrees = this.oldTrees;
                        int index = oldList.indexOf(lastdel);
                        int[] poss = estimator.getPositions(index);
                        localPointer = this.diffTree(lastdel, (JCTree)item.element, poss);
                        printer.print(this.printer.toString());
                        this.printer = oldPrinter;
                        this.printer.undent(n4);
                        lastdel = null;
                        continue block7;
                    }
                    if (LineInsertionType.BEFORE == estimator.lineInsertType()) {
                        printer.newline();
                    }
                    printer.print((JCTree)item.element);
                    if (LineInsertionType.AFTER != estimator.lineInsertType()) continue block7;
                    printer.newline();
                    continue block7;
                }
                case DELETE: {
                    int[] nArray = estimator.getPositions(i);
                    if (localPointer < nArray[0]) {
                        this.copyTo(localPointer, nArray[0], printer);
                    }
                    lastdel = oldList.get(i);
                    ++i;
                    CommentSet ch = this.comments.getComments(lastdel);
                    localPointer = Math.max(nArray[1], Math.max(CasualDiff.commentEnd(ch, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(ch, CommentSet.RelativePosition.TRAILING)));
                    continue block7;
                }
                case NOCHANGE: {
                    int[] nArray = estimator.getPositions(i);
                    if (nArray[0] > localPointer && i != 0) {
                        this.copyTo(localPointer, nArray[0], printer);
                    }
                    if (nArray[0] >= localPointer) {
                        localPointer = nArray[0];
                        if (nArray.length > 3 && nArray[3] != -1 && j + 1 < result.length) {
                            int n = localPointer;
                            localPointer = nArray[3];
                            this.copyTo(n, localPointer, printer);
                            printer.print(estimator.append(i));
                        }
                    }
                    int n = localPointer;
                    localPointer = nArray[1];
                    this.copyTo(n, localPointer, printer);
                    lastdel = null;
                    ++i;
                    continue block7;
                }
            }
        }
        return localPointer;
    }

    protected int diffPrecedingComments(JCTree oldT, JCTree newT, int localPointer) {
        java.util.List<Comment> newPrecedingComments;
        CommentSet cs = this.comments.getComments(newT);
        CommentSet old = this.comments.getComments(oldT);
        java.util.List<Comment> oldPrecedingComments = old.getComments(CommentSet.RelativePosition.PRECEDING);
        if (this.sameComments(oldPrecedingComments, newPrecedingComments = cs.getComments(CommentSet.RelativePosition.PRECEDING))) {
            return localPointer;
        }
        return this.diffCommentLists(oldT, newT, oldPrecedingComments, newPrecedingComments, false, localPointer);
    }

    protected int diffTrailingComments(JCTree oldT, JCTree newT, int localPointer) {
        CommentSet cs = this.comments.getComments(newT);
        CommentSet old = this.comments.getComments(oldT);
        java.util.List<Comment> oldInlineComments = old.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> newInlineComments = cs.getComments(CommentSet.RelativePosition.INLINE);
        java.util.List<Comment> oldTrailingComments = old.getComments(CommentSet.RelativePosition.TRAILING);
        java.util.List<Comment> newTrailingComments = cs.getComments(CommentSet.RelativePosition.TRAILING);
        if (this.sameComments(oldInlineComments, newInlineComments) && this.sameComments(oldTrailingComments, newTrailingComments)) {
            return localPointer;
        }
        localPointer = this.diffCommentLists(oldT, newT, oldInlineComments, newInlineComments, false, localPointer);
        boolean containedEmbeddedNewLine = false;
        boolean containsEmbeddedNewLine = false;
        for (Comment oldComment : oldInlineComments) {
            if (oldComment.style() != Comment.Style.LINE) continue;
            containedEmbeddedNewLine = true;
        }
        for (Comment nueComment : newInlineComments) {
            if (nueComment.style() != Comment.Style.LINE) continue;
            containsEmbeddedNewLine = true;
        }
        if (containedEmbeddedNewLine && !containsEmbeddedNewLine) {
            this.printer.print("\n");
        }
        return this.diffCommentLists(oldT, newT, oldTrailingComments, newTrailingComments, true, localPointer);
    }

    private boolean sameComments(java.util.List<Comment> oldList, java.util.List<Comment> newList) {
        Iterator<Comment> oldIter = oldList.iterator();
        Iterator<Comment> newIter = newList.iterator();
        Comment oldC = this.safeNext(oldIter);
        Comment newC = this.safeNext(newIter);
        while (oldC != null && newC != null) {
            if (!this.commentsMatch(oldC, newC)) {
                return false;
            }
            oldC = this.safeNext(oldIter);
            newC = this.safeNext(newIter);
        }
        return !(oldC == null ^ newC == null);
    }

    private int diffCommentLists(JCTree oldT, JCTree newT, java.util.List<Comment> oldList, java.util.List<Comment> newList, boolean trailing, int localPointer) {
        int cStart;
        int lastPos = CasualDiff.getOldPos(oldT);
        Iterator<Comment> oldIter = oldList.iterator();
        Iterator<Comment> newIter = newList.iterator();
        Comment oldC = this.safeNext(oldIter);
        Comment newC = this.safeNext(newIter);
        boolean first = true;
        while (oldC != null && newC != null) {
            lastPos = oldC.pos();
            cStart = this.commentStartCorrect(oldC);
            if (first && trailing && localPointer < cStart) {
                this.copyTo(localPointer, cStart);
            }
            first = false;
            int nextTarget = Math.max(localPointer, oldC.endPos());
            if (this.commentsMatch(oldC, newC)) {
                if (nextTarget > localPointer) {
                    this.copyTo(localPointer, nextTarget);
                }
                oldC = this.safeNext(oldIter);
                newC = this.safeNext(newIter);
            } else if (!this.listContains(newList, oldC)) {
                if (!this.listContains(oldList, newC)) {
                    int n = localPointer;
                    localPointer = oldC.pos();
                    this.copyTo(n, localPointer);
                    this.printer.printComment(newC, !trailing, false, true);
                    oldC = this.safeNext(oldIter);
                    newC = this.safeNext(newIter);
                } else {
                    oldC = this.safeNext(oldIter);
                }
            } else {
                this.printer.print(newC.getText());
                newC = this.safeNext(newIter);
            }
            localPointer = nextTarget;
        }
        while (oldC != null) {
            cStart = this.commentStartCorrect(oldC);
            if (first && trailing && localPointer < cStart) {
                this.copyTo(localPointer, cStart);
            }
            first = false;
            localPointer = Math.max(localPointer, oldC.endPos());
            oldC = this.safeNext(oldIter);
        }
        while (newC != null) {
            if (Comment.Style.WHITESPACE != newC.style()) {
                this.printer.printComment(newC, !trailing, false);
                lastPos += newC.endPos() - newC.pos();
            }
            newC = this.safeNext(oldIter);
        }
        return localPointer;
    }

    private Comment safeNext(Iterator<Comment> iter) {
        return iter.hasNext() ? iter.next() : null;
    }

    private boolean commentsMatch(Comment oldC, Comment newC) {
        if (oldC == null && newC == null) {
            return true;
        }
        if (oldC == null || newC == null) {
            return false;
        }
        return oldC.equals(newC);
    }

    private boolean listContains(java.util.List<Comment> list, Comment comment) {
        for (Comment c : list) {
            if (!c.equals(comment)) continue;
            return true;
        }
        return false;
    }

    private int commentStartCorrect(Comment c) {
        this.tokenSequence.move(c.pos());
        boolean wasPrevious = false;
        while (this.tokenSequence.movePrevious()) {
            if (this.tokenSequence.token().id() != JavaTokenId.WHITESPACE) {
                return this.tokenSequence.offset() + this.tokenSequence.token().length();
            }
            int lastNewLine = ((Object)this.tokenSequence.token().text()).toString().lastIndexOf(10);
            if (lastNewLine != -1) {
                return this.tokenSequence.offset() + lastNewLine + 1;
            }
            wasPrevious = true;
        }
        if (wasPrevious) {
            return this.tokenSequence.offset();
        }
        return c.pos();
    }

    public static int commentStart(CommentSet comments, CommentSet.RelativePosition pos) {
        java.util.List<Comment> list = comments.getComments(pos);
        if (list.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return list.get(0).pos();
    }

    public static int commentEnd(CommentSet comments, CommentSet.RelativePosition pos) {
        java.util.List<Comment> list = comments.getComments(pos);
        if (list.isEmpty()) {
            return -1;
        }
        return list.get(list.size() - 1).endPos();
    }

    private static JCTree leftMostTree(JCTree tree) {
        switch (tree.getTag()) {
            case 26: {
                return CasualDiff.leftMostTree(((JCTree.JCMethodInvocation)tree).meth);
            }
            case 30: {
                return CasualDiff.leftMostTree(((JCTree.JCAssign)tree).lhs);
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return CasualDiff.leftMostTree(((JCTree.JCAssignOp)tree).lhs);
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return CasualDiff.leftMostTree(((JCTree.JCBinary)tree).lhs);
            }
            case 3: {
                JCTree.JCClassDecl node = (JCTree.JCClassDecl)tree;
                if (node.mods.pos == -1) break;
                return node.mods;
            }
            case 18: {
                return CasualDiff.leftMostTree(((JCTree.JCConditional)tree).cond);
            }
            case 20: {
                return CasualDiff.leftMostTree(((JCTree.JCExpressionStatement)tree).expr);
            }
            case 33: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayAccess)tree).indexed);
            }
            case 4: {
                JCTree.JCMethodDecl node = (JCTree.JCMethodDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods;
                }
                if (node.restype != null) {
                    return CasualDiff.leftMostTree(node.restype);
                }
                return node;
            }
            case 34: {
                return CasualDiff.leftMostTree(((JCTree.JCFieldAccess)tree).selected);
            }
            case 39: {
                return CasualDiff.leftMostTree(((JCTree.JCTypeApply)tree).clazz);
            }
            case 38: {
                return CasualDiff.leftMostTree(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case 32: {
                return CasualDiff.leftMostTree(((JCTree.JCInstanceOf)tree).expr);
            }
            case 52: 
            case 53: {
                return CasualDiff.leftMostTree(((JCTree.JCUnary)tree).arg);
            }
            case 5: {
                JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods;
                }
                return CasualDiff.leftMostTree(node.vartype);
            }
            case 1: {
                JCTree.JCCompilationUnit node = (JCTree.JCCompilationUnit)tree;
                assert (node.defs.size() > 0);
                return node.pid != null ? node.pid : (JCTree)node.defs.head;
            }
        }
        return tree;
    }

    private static int getOldPos(JCTree oldT) {
        return TreeInfo.getStartPos(oldT);
    }

    protected int diffTree(JCTree oldT, JCTree newT, int[] elementBounds) {
        return this.diffTree(oldT, newT, null, elementBounds);
    }

    protected int diffTree(JCTree oldT, JCTree newT, JCTree parent, int[] elementBounds) {
        int result;
        Object t = this.tree2Tag.get(newT);
        if (t != null) {
            int start = this.printer.toString().length();
            result = this.diffTreeImpl(oldT, newT, parent, elementBounds);
            int end = this.printer.toString().length();
            this.tag2Span.put(t, new int[]{start + this.printer.getInitialOffset(), end + this.printer.getInitialOffset()});
        } else {
            result = this.diffTreeImpl(oldT, newT, parent, elementBounds);
        }
        return result;
    }

    protected int diffTreeImpl(JCTree oldT, JCTree newT, JCTree parent, int[] elementBounds) {
        if (oldT == null && newT != null) {
            throw new IllegalArgumentException("Null is not allowed in parameters.");
        }
        if (oldT == newT) {
            return elementBounds[0];
        }
        if (newT == null) {
            this.tokenSequence.move(elementBounds[1]);
            if (!this.tokenSequence.moveNext()) {
                return elementBounds[1];
            }
            while (this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && this.tokenSequence.moveNext()) {
            }
            return this.tokenSequence.offset();
        }
        if (this.printer.handlePossibleOldTrees(Collections.singletonList(newT), false)) {
            return this.getCommentCorrectedEndPos(oldT);
        }
        elementBounds[0] = this.diffPrecedingComments(oldT, newT, elementBounds[0]);
        int retVal = -1;
        if (!(oldT.getTag() == newT.getTag() || compAssign.contains((Object)oldT.getKind()) && compAssign.contains((Object)newT.getKind()) || binaries.contains((Object)oldT.getKind()) && binaries.contains((Object)newT.getKind()) || unaries.contains((Object)oldT.getKind()) && unaries.contains((Object)newT.getKind()))) {
            int[] oldBounds = this.getBounds(oldT);
            if (oldBounds[0] > elementBounds[0]) {
                this.copyTo(elementBounds[0], oldBounds[0]);
            }
            this.printer.print(newT);
            return oldBounds[1];
        }
        int commentsStart = Math.min(CasualDiff.commentStart(this.comments.getComments(oldT), CommentSet.RelativePosition.INLINE), CasualDiff.commentStart(this.comments.getComments(oldT), CommentSet.RelativePosition.TRAILING));
        if (commentsStart < elementBounds[1]) {
            int lastIndex;
            this.tokenSequence.move(commentsStart);
            elementBounds[1] = this.tokenSequence.movePrevious() && this.tokenSequence.token().id() == JavaTokenId.WHITESPACE && (lastIndex = ((Object)this.tokenSequence.token().text()).toString().lastIndexOf(10)) > -1 ? this.tokenSequence.offset() + lastIndex + 1 : commentsStart;
        }
        switch (oldT.getTag()) {
            case 1: {
                this.diffTopLevel((JCTree.JCCompilationUnit)oldT, (JCTree.JCCompilationUnit)newT);
                break;
            }
            case 2: {
                retVal = this.diffImport((JCTree.JCImport)oldT, (JCTree.JCImport)newT, elementBounds);
                break;
            }
            case 3: {
                retVal = this.diffClassDef((JCTree.JCClassDecl)oldT, (JCTree.JCClassDecl)newT, elementBounds);
                break;
            }
            case 4: {
                retVal = this.diffMethodDef((JCTree.JCMethodDecl)oldT, (JCTree.JCMethodDecl)newT, elementBounds);
                break;
            }
            case 5: {
                retVal = this.diffVarDef((JCTree.JCVariableDecl)oldT, (JCTree.JCVariableDecl)newT, elementBounds);
                break;
            }
            case 6: {
                this.copyTo(elementBounds[0], elementBounds[1]);
                retVal = elementBounds[1];
                break;
            }
            case 7: {
                retVal = this.diffBlock((JCTree.JCBlock)oldT, (JCTree.JCBlock)newT, elementBounds);
                break;
            }
            case 8: {
                retVal = this.diffDoLoop((JCTree.JCDoWhileLoop)oldT, (JCTree.JCDoWhileLoop)newT, elementBounds);
                break;
            }
            case 9: {
                retVal = this.diffWhileLoop((JCTree.JCWhileLoop)oldT, (JCTree.JCWhileLoop)newT, elementBounds);
                break;
            }
            case 10: {
                retVal = this.diffForLoop((JCTree.JCForLoop)oldT, (JCTree.JCForLoop)newT, elementBounds);
                break;
            }
            case 11: {
                retVal = this.diffForeachLoop((JCTree.JCEnhancedForLoop)oldT, (JCTree.JCEnhancedForLoop)newT, elementBounds);
                break;
            }
            case 12: {
                retVal = this.diffLabelled((JCTree.JCLabeledStatement)oldT, (JCTree.JCLabeledStatement)newT, elementBounds);
                break;
            }
            case 13: {
                retVal = this.diffSwitch((JCTree.JCSwitch)oldT, (JCTree.JCSwitch)newT, elementBounds);
                break;
            }
            case 14: {
                retVal = this.diffCase((JCTree.JCCase)oldT, (JCTree.JCCase)newT, elementBounds);
                break;
            }
            case 15: {
                retVal = this.diffSynchronized((JCTree.JCSynchronized)oldT, (JCTree.JCSynchronized)newT, elementBounds);
                break;
            }
            case 16: {
                retVal = this.diffTry((JCTree.JCTry)oldT, (JCTree.JCTry)newT, elementBounds);
                break;
            }
            case 17: {
                retVal = this.diffCatch((JCTree.JCCatch)oldT, (JCTree.JCCatch)newT, elementBounds);
                break;
            }
            case 18: {
                retVal = this.diffConditional((JCTree.JCConditional)oldT, (JCTree.JCConditional)newT, elementBounds);
                break;
            }
            case 19: {
                retVal = this.diffIf((JCTree.JCIf)oldT, (JCTree.JCIf)newT, elementBounds);
                break;
            }
            case 20: {
                retVal = this.diffExec((JCTree.JCExpressionStatement)oldT, (JCTree.JCExpressionStatement)newT, elementBounds);
                break;
            }
            case 21: {
                retVal = this.diffBreak((JCTree.JCBreak)oldT, (JCTree.JCBreak)newT, elementBounds);
                break;
            }
            case 22: {
                retVal = this.diffContinue((JCTree.JCContinue)oldT, (JCTree.JCContinue)newT, elementBounds);
                break;
            }
            case 23: {
                retVal = this.diffReturn((JCTree.JCReturn)oldT, (JCTree.JCReturn)newT, elementBounds);
                break;
            }
            case 24: {
                retVal = this.diffThrow((JCTree.JCThrow)oldT, (JCTree.JCThrow)newT, elementBounds);
                break;
            }
            case 25: {
                retVal = this.diffAssert((JCTree.JCAssert)oldT, (JCTree.JCAssert)newT, elementBounds);
                break;
            }
            case 26: {
                retVal = this.diffApply((JCTree.JCMethodInvocation)oldT, (JCTree.JCMethodInvocation)newT, elementBounds);
                break;
            }
            case 27: {
                retVal = this.diffNewClass((JCTree.JCNewClass)oldT, (JCTree.JCNewClass)newT, elementBounds);
                break;
            }
            case 28: {
                retVal = this.diffNewArray((JCTree.JCNewArray)oldT, (JCTree.JCNewArray)newT, elementBounds);
                break;
            }
            case 29: {
                retVal = this.diffParens((JCTree.JCParens)oldT, (JCTree.JCParens)newT, elementBounds);
                break;
            }
            case 30: {
                retVal = this.diffAssign((JCTree.JCAssign)oldT, (JCTree.JCAssign)newT, elementBounds);
                break;
            }
            case 31: {
                retVal = this.diffTypeCast((JCTree.JCTypeCast)oldT, (JCTree.JCTypeCast)newT, elementBounds);
                break;
            }
            case 32: {
                retVal = this.diffTypeTest((JCTree.JCInstanceOf)oldT, (JCTree.JCInstanceOf)newT, elementBounds);
                break;
            }
            case 33: {
                retVal = this.diffIndexed((JCTree.JCArrayAccess)oldT, (JCTree.JCArrayAccess)newT, elementBounds);
                break;
            }
            case 34: {
                retVal = this.diffSelect((JCTree.JCFieldAccess)oldT, (JCTree.JCFieldAccess)newT, elementBounds);
                break;
            }
            case 35: {
                retVal = this.diffIdent((JCTree.JCIdent)oldT, (JCTree.JCIdent)newT, elementBounds);
                break;
            }
            case 36: {
                retVal = this.diffLiteral((JCTree.JCLiteral)oldT, (JCTree.JCLiteral)newT, elementBounds);
                break;
            }
            case 37: {
                retVal = this.diffTypeIdent((JCTree.JCPrimitiveTypeTree)oldT, (JCTree.JCPrimitiveTypeTree)newT, elementBounds);
                break;
            }
            case 38: {
                retVal = this.diffTypeArray((JCTree.JCArrayTypeTree)oldT, (JCTree.JCArrayTypeTree)newT, elementBounds);
                break;
            }
            case 39: {
                retVal = this.diffTypeApply((JCTree.JCTypeApply)oldT, (JCTree.JCTypeApply)newT, elementBounds);
                break;
            }
            case 40: {
                retVal = this.diffTypeParameter((JCTree.JCTypeParameter)oldT, (JCTree.JCTypeParameter)newT, elementBounds);
                break;
            }
            case 41: {
                retVal = this.diffWildcard((JCTree.JCWildcard)oldT, (JCTree.JCWildcard)newT, elementBounds);
                break;
            }
            case 42: {
                retVal = this.diffTypeBoundKind((JCTree.TypeBoundKind)oldT, (JCTree.TypeBoundKind)newT, elementBounds);
                break;
            }
            case 43: {
                retVal = this.diffAnnotation((JCTree.JCAnnotation)oldT, (JCTree.JCAnnotation)newT, elementBounds);
                break;
            }
            case 91: {
                this.diffLetExpr((JCTree.LetExpr)oldT, (JCTree.LetExpr)newT);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                retVal = this.diffUnary((JCTree.JCUnary)oldT, (JCTree.JCUnary)newT, elementBounds);
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                retVal = this.diffBinary((JCTree.JCBinary)oldT, (JCTree.JCBinary)newT, elementBounds);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                retVal = this.diffAssignop((JCTree.JCAssignOp)oldT, (JCTree.JCAssignOp)newT, elementBounds);
                break;
            }
            case 45: {
                this.diffErroneous((JCTree.JCErroneous)oldT, (JCTree.JCErroneous)newT, elementBounds);
                break;
            }
            case 44: {
                retVal = this.diffModifiers((JCTree.JCModifiers)oldT, (JCTree.JCModifiers)newT, parent, elementBounds[0]);
                this.copyTo(retVal, elementBounds[1]);
                break;
            }
            default: {
                if (oldT.getKind() == Tree.Kind.OTHER) {
                    if (!(oldT instanceof FieldGroupTree)) break;
                    return this.diffFieldGroup((FieldGroupTree)oldT, (FieldGroupTree)newT, elementBounds);
                }
                String msg = "Diff not implemented: " + oldT.getKind().toString() + " " + oldT.getClass().getName();
                throw new AssertionError((Object)msg);
            }
        }
        return this.diffTrailingComments(oldT, newT, retVal);
    }

    protected boolean listsMatch(java.util.List<? extends JCTree> oldList, java.util.List<? extends JCTree> newList) {
        if (oldList == newList) {
            return true;
        }
        int n = oldList.size();
        if (newList.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.treesMatch(oldList.get(i), newList.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchImport(JCTree.JCImport t1, JCTree.JCImport t2) {
        return t1.staticImport == t2.staticImport && this.treesMatch(t1.qualid, t2.qualid);
    }

    private boolean matchBlock(JCTree.JCBlock t1, JCTree.JCBlock t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchDoLoop(JCTree.JCDoWhileLoop t1, JCTree.JCDoWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchWhileLoop(JCTree.JCWhileLoop t1, JCTree.JCWhileLoop t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForLoop(JCTree.JCForLoop t1, JCTree.JCForLoop t2) {
        return this.listsMatch(t1.init, t2.init) && this.treesMatch(t1.cond, t2.cond) && this.listsMatch(t1.step, t2.step) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchForeachLoop(JCTree.JCEnhancedForLoop t1, JCTree.JCEnhancedForLoop t2) {
        return this.treesMatch(t1.var, t2.var) && this.treesMatch(t1.expr, t2.expr) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchLabelled(JCTree.JCLabeledStatement t1, JCTree.JCLabeledStatement t2) {
        return t1.label == t2.label && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchSwitch(JCTree.JCSwitch t1, JCTree.JCSwitch t2) {
        return this.treesMatch(t1.selector, t2.selector) && this.listsMatch(t1.cases, t2.cases);
    }

    private boolean matchCase(JCTree.JCCase t1, JCTree.JCCase t2) {
        return this.treesMatch(t1.pat, t2.pat) && this.listsMatch(t1.stats, t2.stats);
    }

    private boolean matchSynchronized(JCTree.JCSynchronized t1, JCTree.JCSynchronized t2) {
        return this.treesMatch(t1.lock, t2.lock) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchTry(JCTree.JCTry t1, JCTree.JCTry t2) {
        return this.treesMatch(t1.finalizer, t2.finalizer) && this.listsMatch(t1.catchers, t2.catchers) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchCatch(JCTree.JCCatch t1, JCTree.JCCatch t2) {
        return this.treesMatch(t1.param, t2.param) && this.treesMatch(t1.body, t2.body);
    }

    private boolean matchConditional(JCTree.JCConditional t1, JCTree.JCConditional t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.truepart, t2.truepart) && this.treesMatch(t1.falsepart, t2.falsepart);
    }

    private boolean matchIf(JCTree.JCIf t1, JCTree.JCIf t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.thenpart, t2.thenpart) && this.treesMatch(t1.elsepart, t2.elsepart);
    }

    private boolean matchBreak(JCTree.JCBreak t1, JCTree.JCBreak t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchContinue(JCTree.JCContinue t1, JCTree.JCContinue t2) {
        return t1.label == t2.label && this.treesMatch(t1.target, t2.target);
    }

    private boolean matchAssert(JCTree.JCAssert t1, JCTree.JCAssert t2) {
        return this.treesMatch(t1.cond, t2.cond) && this.treesMatch(t1.detail, t2.detail);
    }

    private boolean matchApply(JCTree.JCMethodInvocation t1, JCTree.JCMethodInvocation t2) {
        return t1.varargsElement == t2.varargsElement && this.listsMatch(t1.typeargs, t2.typeargs) && this.treesMatch(t1.meth, t2.meth) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchNewClass(JCTree.JCNewClass t1, JCTree.JCNewClass t2) {
        return t1.constructor == t2.constructor && this.treesMatch(t1.getIdentifier(), t2.getIdentifier()) && this.listsMatch(t1.typeargs, t2.typeargs) && this.listsMatch(t1.args, t2.args) && t1.varargsElement == t2.varargsElement && this.treesMatch(t1.def, t2.def);
    }

    private boolean matchNewArray(JCTree.JCNewArray t1, JCTree.JCNewArray t2) {
        return this.treesMatch(t1.elemtype, t2.elemtype) && this.listsMatch(t1.dims, t2.dims) && this.listsMatch(t1.elems, t2.elems);
    }

    private boolean matchAssign(JCTree.JCAssign t1, JCTree.JCAssign t2) {
        return this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchAssignop(JCTree.JCAssignOp t1, JCTree.JCAssignOp t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchUnary(JCTree.JCUnary t1, JCTree.JCUnary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.arg, t2.arg);
    }

    private boolean matchBinary(JCTree.JCBinary t1, JCTree.JCBinary t2) {
        return t1.operator == t2.operator && this.treesMatch(t1.lhs, t2.lhs) && this.treesMatch(t1.rhs, t2.rhs);
    }

    private boolean matchTypeCast(JCTree.JCTypeCast t1, JCTree.JCTypeCast t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchTypeTest(JCTree.JCInstanceOf t1, JCTree.JCInstanceOf t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean matchIndexed(JCTree.JCArrayAccess t1, JCTree.JCArrayAccess t2) {
        return this.treesMatch(t1.indexed, t2.indexed) && this.treesMatch(t1.index, t2.index);
    }

    private boolean matchSelect(JCTree.JCFieldAccess t1, JCTree.JCFieldAccess t2) {
        return this.treesMatch(t1.selected, t2.selected) && t1.sym == t2.sym;
    }

    private boolean matchLiteral(JCTree.JCLiteral t1, JCTree.JCLiteral t2) {
        return t1.typetag == t2.typetag && (t1.value == t2.value || t1.value != null && t1.value.equals(t2.value));
    }

    private boolean matchTypeApply(JCTree.JCTypeApply t1, JCTree.JCTypeApply t2) {
        return this.treesMatch(t1.clazz, t2.clazz) && this.listsMatch(t1.arguments, t2.arguments);
    }

    private boolean matchTypeParameter(JCTree.JCTypeParameter t1, JCTree.JCTypeParameter t2) {
        return t1.name == t2.name && this.listsMatch(t1.bounds, t2.bounds);
    }

    private boolean matchWildcard(JCTree.JCWildcard t1, JCTree.JCWildcard t2) {
        return t1.kind == t2.kind && this.treesMatch(t1.inner, t2.inner);
    }

    private boolean matchAnnotation(JCTree.JCAnnotation t1, JCTree.JCAnnotation t2) {
        return this.treesMatch(t1.annotationType, t2.annotationType) && this.listsMatch(t1.args, t2.args);
    }

    private boolean matchModifiers(JCTree.JCModifiers t1, JCTree.JCModifiers t2) {
        return t1.flags == t2.flags && this.listsMatch(t1.annotations, t2.annotations);
    }

    private boolean matchLetExpr(JCTree.LetExpr t1, JCTree.LetExpr t2) {
        return this.listsMatch(t1.defs, t2.defs) && this.treesMatch(t1.expr, t2.expr);
    }

    private boolean isCommaSeparated(JCTree.JCVariableDecl oldT) {
        if (CasualDiff.getOldPos(oldT) <= 0 || oldT.pos <= 0) {
            return false;
        }
        this.tokenSequence.move(oldT.pos);
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        if (JavaTokenId.COMMA == this.tokenSequence.token().id()) {
            return true;
        }
        if (oldT.getInitializer() != null && (oldT.mods.flags & 0x4000L) == 0L) {
            this.tokenSequence.move(this.endPos(oldT.getInitializer()));
        } else {
            this.tokenSequence.move(oldT.pos);
            this.tokenSequence.moveNext();
        }
        PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.FORWARD);
        if (this.tokenSequence.token() == null) {
            return false;
        }
        return JavaTokenId.COMMA == this.tokenSequence.token().id();
    }

    private int getCommentCorrectedOldPos(JCTree tree) {
        CommentSet ch = this.comments.getComments(tree);
        return Math.min(CasualDiff.getOldPos(tree), CasualDiff.commentStart(ch, CommentSet.RelativePosition.PRECEDING));
    }

    private int getCommentCorrectedEndPos(JCTree tree) {
        CommentSet ch = this.comments.getComments(tree);
        return Math.max(this.endPos(tree), Math.max(CasualDiff.commentEnd(ch, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(ch, CommentSet.RelativePosition.TRAILING)));
    }

    private int[] getCommentCorrectedBounds(JCTree tree) {
        return new int[]{this.getCommentCorrectedOldPos(tree), this.getCommentCorrectedEndPos(tree)};
    }

    private int[] getBounds(JCTree tree) {
        return new int[]{CasualDiff.getOldPos(tree), this.endPos(tree)};
    }

    private void copyTo(int from, int to) {
        this.copyTo(from, to, this.printer);
    }

    public void copyTo(int from, int to, VeryPretty loc) {
        if (from == to) {
            return;
        }
        if (from > to || from < 0 || to < 0) {
            LOG.log(Level.INFO, "-----\n" + this.origText + "-----\n");
            LOG.log(Level.INFO, "Illegal values: from = " + from + "; to = " + to + "." + "Please, attach your messages.log to new issue!");
            if (to >= 0) {
                this.printer.eatChars(from - to);
            }
            return;
        }
        if (to > this.origText.length()) {
            LOG.severe("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + to + " is greater then its size (" + this.origText.length() + ").");
        }
        loc.print(this.origText.substring(from, to));
    }

    private int diffTree(JCTree oldT, JCTree newT, int[] elementBounds, Tree.Kind parentKind) {
        if (oldT.getKind() != newT.getKind() && newT.getKind() == Tree.Kind.BLOCK) {
            this.tokenSequence.move(CasualDiff.getOldPos(oldT));
            PositionEstimator.moveToSrcRelevant(this.tokenSequence, PositionEstimator.Direction.BACKWARD);
            this.tokenSequence.moveNext();
            this.copyTo(elementBounds[0], this.tokenSequence.offset());
            this.printer.printBlock(oldT, newT, parentKind);
            return this.endPos(oldT);
        }
        elementBounds[0] = this.getBounds(oldT)[0];
        this.copyTo(elementBounds[0], elementBounds[0]);
        return this.diffTree(oldT, newT, elementBounds);
    }

    public static class Diff {
        public DiffTypes type;
        int pos;
        int endOffset;
        protected JCTree oldTree;
        protected JCTree newTree;
        protected Comment oldComment;
        protected Comment newComment;
        private String text;
        boolean trailing;

        public static Diff insert(int pos, String text) {
            return new Diff(DiffTypes.INSERT, pos, -1, text);
        }

        public static Diff delete(int startOffset, int endOffset) {
            return new Diff(DiffTypes.DELETE, startOffset, endOffset, null);
        }

        Diff(DiffTypes type, int pos, int endOffset, String text) {
            this.type = type;
            this.pos = pos;
            this.endOffset = endOffset;
            this.text = text;
        }

        Diff(DiffTypes type, int pos, JCTree oldTree, JCTree newTree, Comment oldComment, Comment newComment, boolean trailing) {
            this(type, pos, -1, null);
            assert (pos >= 0) : "invalid source offset";
            this.oldTree = oldTree;
            this.newTree = newTree;
            this.oldComment = oldComment;
            this.newComment = newComment;
            this.trailing = trailing;
        }

        public JCTree getOld() {
            return this.oldTree;
        }

        public JCTree getNew() {
            return this.newTree;
        }

        public int getPos() {
            return this.pos;
        }

        public int getEnd() {
            return this.endOffset;
        }

        public String getText() {
            return this.text;
        }

        public Comment getOldComment() {
            return this.oldComment;
        }

        public Comment getNewComment() {
            return this.newComment;
        }

        public boolean isTrailingComment() {
            return this.trailing;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Diff)) {
                return false;
            }
            Diff d2 = (Diff)obj;
            return this.type != d2.type && this.pos != d2.pos && this.oldTree != d2.oldTree && this.newTree != d2.newTree && this.oldComment != d2.oldComment && this.newComment != d2.newComment && this.trailing != d2.trailing;
        }

        public int hashCode() {
            return this.type.hashCode() + this.pos + (this.oldTree != null ? this.oldTree.hashCode() : 0) + (this.newTree != null ? this.newTree.hashCode() : 0) + (this.oldComment != null ? this.oldComment.hashCode() : 0) + (this.newComment != null ? this.newComment.hashCode() : 0) + Boolean.valueOf(this.trailing).hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("tree (");
            sb.append(this.type.toString());
            sb.append(") pos=");
            sb.append(this.pos);
            if (this.trailing) {
                sb.append(" trailing comment");
            }
            sb.append("\n");
            if (this.type == DiffTypes.DELETE || this.type == DiffTypes.INSERT || this.type == DiffTypes.MODIFY) {
                this.addDiffString(sb, this.oldTree, this.newTree);
            } else {
                this.addDiffString(sb, this.oldComment, this.newComment);
            }
            return sb.toString();
        }

        private void addDiffString(StringBuffer sb, Object o1, Object o2) {
            if (o1 != null) {
                sb.append("< ");
                sb.append(o1.toString());
                sb.append(o2 != null ? "\n---\n> " : "\n");
            } else {
                sb.append("> ");
            }
            if (o2 != null) {
                sb.append(o2.toString());
                sb.append('\n');
            }
        }
    }

    public static enum LineInsertionType {
        BEFORE,
        AFTER,
        NONE;

    }

    public static enum DiffTypes {
        MODIFY("modify"),
        INSERT("insert"),
        DELETE("delete");

        public final String name;

        private DiffTypes(String name) {
            this.name = name;
        }
    }

    private static enum ChangeKind {
        INSERT,
        DELETE,
        MODIFY,
        NOCHANGE;

    }
}

