/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.hints;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.infrastructure.JavaHintsPositionRefresher;
import org.netbeans.modules.java.hints.jackpot.impl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public class HintsTask
implements CancellableTask<CompilationInfo> {
    public static final String KEY_HINTS = HintsInvoker.class.getName() + "-hints";
    public static final String KEY_SUGGESTIONS = HintsInvoker.class.getName() + "-suggestions";
    private static final Logger TIMER = Logger.getLogger("TIMER");
    private static final Logger TIMER_EDITOR = Logger.getLogger("TIMER.editor");
    private static final Logger TIMER_CARET = Logger.getLogger("TIMER.caret");
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final boolean caretAware;

    public HintsTask(boolean caretAware) {
        this.caretAware = caretAware;
    }

    public void run(CompilationInfo info) {
        this.cancel.set(false);
        if (Utilities.disableErrors((FileObject)info.getFileObject()).contains(Severity.VERIFIER)) {
            return;
        }
        Document doc = info.getSnapshot().getSource().getDocument(false);
        long version = doc != null ? DocumentUtilities.getDocumentVersion((Document)doc) : 0L;
        long startTime = System.currentTimeMillis();
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
        HintsInvoker inv = this.caretAware ? new HintsInvoker(info, caret, this.cancel) : new HintsInvoker(info, this.cancel);
        List<ErrorDescription> result = inv.computeHints(info);
        if (this.cancel.get()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)(this.caretAware ? KEY_SUGGESTIONS : KEY_HINTS), result);
        if (this.caretAware) {
            JavaHintsPositionRefresher.suggestionsUpdated(doc, version, caret);
        } else {
            JavaHintsPositionRefresher.hintsUpdated(doc, version);
        }
        long endTime = System.currentTimeMillis();
        TIMER.log(Level.FINE, "Jackpot 3.0 Hints Task" + (this.caretAware ? " - Caret Aware" : ""), new Object[]{info.getFileObject(), endTime - startTime});
        Logger l = this.caretAware ? TIMER_CARET : TIMER_EDITOR;
        for (Map.Entry<String, Long> e : inv.getTimeLog().entrySet()) {
            l.log(Level.FINE, e.getKey(), new Object[]{info.getFileObject(), e.getValue()});
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public static final class CaretFactoryImpl
    extends CaretAwareJavaSourceTaskFactory
    implements ChangeListener {
        public CaretFactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
            HintsSettings.addChangeListener(WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new HintsTask(true);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (FileObject file : this.getFileObjects()) {
                this.reschedule(file);
            }
        }
    }

    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory
    implements ChangeListener {
        public FactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
            HintsSettings.addChangeListener(WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new HintsTask(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (FileObject file : this.getFileObjects()) {
                this.reschedule(file);
            }
        }
    }
}

