/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.java.hints.jackpot.impl.JackpotTrees;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class Utilities {
    private static long inc;

    private Utilities() {
    }

    public static <E> Iterable<E> checkedIterableByFilter(final Iterable raw, final Class<E> type, final boolean strict) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return NbCollections.checkedIteratorByFilter(raw.iterator(), (Class)type, (boolean)strict);
            }
        };
    }

    public static ExpressionTree prepareAssignment(TreeMaker make, String name, ExpressionTree value) {
        return make.Assignment((ExpressionTree)make.Identifier((CharSequence)name), value);
    }

    public static ExpressionTree findValue(AnnotationTree m, String name) {
        for (ExpressionTree expressionTree : m.getArguments()) {
            AssignmentTree at;
            String varName;
            if (expressionTree.getKind() == Tree.Kind.ASSIGNMENT && (varName = ((IdentifierTree)(at = (AssignmentTree)expressionTree).getVariable()).getName().toString()).equals(name)) {
                return at.getExpression();
            }
            if (!(expressionTree instanceof LiteralTree) || !"value".equals(name)) continue;
            return expressionTree;
        }
        return null;
    }

    public static List<AnnotationTree> findArrayValue(AnnotationTree at, String name) {
        ExpressionTree fixesArray = Utilities.findValue(at, name);
        LinkedList<AnnotationTree> fixes = new LinkedList<AnnotationTree>();
        if (fixesArray != null && fixesArray.getKind() == Tree.Kind.NEW_ARRAY) {
            NewArrayTree trees = (NewArrayTree)fixesArray;
            for (ExpressionTree expressionTree : trees.getInitializers()) {
                if (expressionTree.getKind() != Tree.Kind.ANNOTATION) continue;
                fixes.add((AnnotationTree)expressionTree);
            }
        }
        if (fixesArray != null && fixesArray.getKind() == Tree.Kind.ANNOTATION) {
            fixes.add((AnnotationTree)fixesArray);
        }
        return fixes;
    }

    public static boolean isPureMemberSelect(Tree mst, boolean allowVariables) {
        switch (mst.getKind()) {
            case IDENTIFIER: {
                return allowVariables || ((IdentifierTree)mst).getName().charAt(0) != '$';
            }
            case MEMBER_SELECT: {
                return Utilities.isPureMemberSelect(((MemberSelectTree)mst).getExpression(), allowVariables);
            }
        }
        return false;
    }

    public static Tree parseAndAttribute(CompilationInfo info, String pattern, Scope scope) {
        return Utilities.parseAndAttribute(info, JavaSourceAccessor.getINSTANCE().getJavacTask(info), pattern, scope);
    }

    public static Tree parseAndAttribute(JavacTaskImpl jti, String pattern) {
        return Utilities.parseAndAttribute(null, jti, pattern, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tree parseAndAttribute(CompilationInfo info, JavacTaskImpl jti, String pattern, Scope scope) {
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        Tree patternTree = !Utilities.isStatement(pattern) ? Utilities.parseExpression(c, pattern, true, new SourcePositions[1]) : null;
        boolean expression = true;
        boolean classMember = false;
        if (patternTree == null || Utilities.isErrorTree(patternTree)) {
            Log log = Log.instance(c);
            DiagnosticListener old = log.getDiagnosticListener();
            DiagnosticCollector dc = new DiagnosticCollector();
            log.setDiagnosticListener(dc);
            try {
                Tree currentPatternTree = Utilities.parseStatement(c, "{" + pattern + "}", new SourcePositions[1]);
                assert (currentPatternTree.getKind() == Tree.Kind.BLOCK) : currentPatternTree.getKind();
                List<? extends StatementTree> statements = ((BlockTree)currentPatternTree).getStatements();
                if (statements.size() == 1) {
                    currentPatternTree = statements.get(0);
                } else {
                    LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
                    newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$1$")));
                    newStatements.addAll(statements);
                    newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$2$")));
                    currentPatternTree = make.Block(newStatements, false);
                }
                currentPatternTree = Utilities.fixTree(c, currentPatternTree);
                boolean hasErrors = false;
                for (Diagnostic d : dc.getDiagnostics()) {
                    if (d.getKind() != Diagnostic.Kind.ERROR || "compiler.err.not.stmt".contentEquals(d.getCode())) continue;
                    hasErrors = true;
                }
                if (hasErrors || Utilities.containsError(currentPatternTree)) {
                    Tree classPatternTree = Utilities.parseExpression(c, "new Object() {" + pattern + "}", false, new SourcePositions[1]);
                    if (!Utilities.containsError(classPatternTree = Utilities.fixTree(c, classPatternTree))) {
                        patternTree = classPatternTree;
                        classMember = true;
                    } else {
                        patternTree = currentPatternTree;
                    }
                } else {
                    patternTree = currentPatternTree;
                }
                expression = false;
            }
            finally {
                log.setDiagnosticListener(old);
            }
        } else {
            patternTree = Utilities.fixTree(c, patternTree);
        }
        int syntheticOffset = 0;
        if (scope != null) {
            assert (info != null);
            TypeMirror type = info.getTreeUtilities().attributeTree(patternTree, scope);
            if (Utilities.isError(type) && expression && Utilities.isPureMemberSelect(patternTree, false) && info.getElements().getTypeElement(pattern) != null) {
                ExpressionTree var = info.getTreeUtilities().parseExpression(pattern + ".class;", new SourcePositions[1]);
                type = info.getTreeUtilities().attributeTree((Tree)var, scope);
                ExpressionTree typeTree = ((MemberSelectTree)var).getExpression();
                if (!Utilities.isError(info.getTrees().getElement(new TreePath(new TreePath(info.getCompilationUnit()), typeTree)))) {
                    patternTree = typeTree;
                }
            }
            syntheticOffset = 1;
        }
        if (classMember) {
            List<? extends Tree> members = ((NewClassTree)patternTree).getClassBody().getMembers();
            if (members.size() > 1 + syntheticOffset) {
                ModifiersTree mt = make.Modifiers(EnumSet.noneOf(Modifier.class));
                LinkedList<? extends Tree> newMembers = new LinkedList<Tree>();
                newMembers.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$$1$")));
                newMembers.addAll(members.subList(syntheticOffset, members.size()));
                patternTree = make.Class(mt, (CharSequence)"$", Collections.emptyList(), null, Collections.emptyList(), newMembers);
            } else {
                patternTree = members.get(0 + syntheticOffset);
            }
        }
        return patternTree;
    }

    private static boolean isError(Element el) {
        return el == null || el.getKind() == ElementKind.CLASS && Utilities.isError(((TypeElement)el).asType());
    }

    private static boolean isError(TypeMirror type) {
        return type == null || type.getKind() == TypeKind.ERROR;
    }

    private static boolean isStatement(String pattern) {
        return pattern.trim().endsWith(";");
    }

    private static boolean isErrorTree(Tree t) {
        return t.getKind() == Tree.Kind.ERRONEOUS || t.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)t).getName().contentEquals("<error>");
    }

    private static boolean containsError(Tree t) {
        return new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean scan(Tree node, Void p) {
                if (node != null && Utilities.isErrorTree(node)) {
                    return true;
                }
                return super.scan(node, p) == Boolean.TRUE;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        }.scan(t, (Void)null);
    }

    private static Tree fixTree(Context c, Tree patternTree) {
        FixTree fixTree = new FixTree();
        fixTree.attach(c, new NoImports(c), null);
        return fixTree.translate(patternTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JCTree.JCStatement parseStatement(Context context, CharSequence stmt, SourcePositions[] pos) {
        if (stmt == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        JavaCompiler compiler = JavaCompiler.instance(context);
        JavaFileObject prev = compiler.log.useSource(new DummyJFO());
        try {
            CharBuffer buf = CharBuffer.wrap((stmt + "\u0000").toCharArray(), 0, stmt.length());
            ParserFactory factory = ParserFactory.instance(context);
            ScannerFactory scannerFactory = ScannerFactory.instance(context);
            Names names = Names.instance(context);
            JackpotJavacParser parser = new JackpotJavacParser(context, factory, scannerFactory.newScanner(buf, false), false, false, CancelService.instance((Context)context), names);
            if (parser instanceof JavacParser) {
                JCTree.JCStatement jCStatement = parser.parseStatement();
                return jCStatement;
            }
            JCTree.JCStatement jCStatement = null;
            return jCStatement;
        }
        finally {
            compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JCTree.JCExpression parseExpression(Context context, CharSequence expr, boolean onlyFullInput, SourcePositions[] pos) {
        if (expr == null || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        JavaCompiler compiler = JavaCompiler.instance(context);
        JavaFileObject prev = compiler.log.useSource(new DummyJFO());
        try {
            CharBuffer buf = CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            ParserFactory factory = ParserFactory.instance(context);
            ScannerFactory scannerFactory = ScannerFactory.instance(context);
            Names names = Names.instance(context);
            Scanner scanner = scannerFactory.newScanner(buf, false);
            JackpotJavacParser parser = new JackpotJavacParser(context, factory, scanner, false, false, CancelService.instance((Context)context), names);
            if (parser instanceof JavacParser) {
                JCTree.JCExpression result = parser.parseExpression();
                if (!onlyFullInput || scanner.token() == Token.EOF) {
                    JCTree.JCExpression jCExpression = result;
                    return jCExpression;
                }
            }
            JCTree.JCExpression jCExpression = null;
            return jCExpression;
        }
        finally {
            compiler.log.useSource(prev);
        }
    }

    @CheckForNull
    public static CharSequence getWildcardTreeName(@NonNull Tree t) {
        IdentifierTree identTree;
        String name;
        if (t.getKind() == Tree.Kind.EXPRESSION_STATEMENT && ((ExpressionStatementTree)t).getExpression().getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree identTree2 = (IdentifierTree)((ExpressionStatementTree)t).getExpression();
            return identTree2.getName().toString();
        }
        if (t.getKind() == Tree.Kind.IDENTIFIER && (name = (identTree = (IdentifierTree)t).getName().toString()).startsWith("$")) {
            return name;
        }
        return null;
    }

    public static boolean isMultistatementWildcard(@NonNull CharSequence name) {
        return name.charAt(name.length() - 1) == '$';
    }

    public static boolean isMultistatementWildcardTree(Tree tree) {
        CharSequence name = Utilities.getWildcardTreeName(tree);
        return name != null && Utilities.isMultistatementWildcard(name);
    }

    public static Scope constructScope(CompilationInfo info, Map<String, TypeMirror> constraints) {
        return Utilities.constructScope(info, constraints, Collections.emptyList());
    }

    public static Scope constructScope(CompilationInfo info, Map<String, TypeMirror> constraints, Iterable<? extends String> auxiliaryImports) {
        return ((SPI)Lookup.getDefault().lookup(SPI.class)).constructScope(info, constraints, auxiliaryImports);
    }

    public static String toHumanReadableTime(double d) {
        StringBuilder result = new StringBuilder();
        long inSeconds = (long)(d / 1000.0);
        int seconds = (int)(inSeconds % 60L);
        long inMinutes = inSeconds / 60L;
        int minutes = (int)(inMinutes % 60L);
        long inHours = inMinutes / 60L;
        if (inHours > 0L) {
            result.append(inHours);
            result.append("h");
        }
        if (minutes > 0) {
            result.append(minutes);
            result.append("m");
        }
        result.append(seconds);
        result.append("s");
        return result.toString();
    }

    public static ClasspathInfo createUniversalCPInfo() {
        JavaPlatform select = JavaPlatform.getDefault();
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (p.getSpecification().getVersion().compareTo((Object)select.getSpecification().getVersion()) <= 0) continue;
            select = p;
        }
        return ClasspathInfo.create((ClassPath)select.getBootstrapLibraries(), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
    }

    public static void waitScanFinished() throws InterruptedException {
        SourceUtils.waitScanFinished();
    }

    @NonNull
    public static Set<? extends String> findSuppressedWarnings(@NonNull CompilationInfo info, @NonNull TreePath path) {
        HashSet<String> keys = new HashSet<String>();
        while (path != null) {
            Tree leaf = path.getLeaf();
            switch (leaf.getKind()) {
                case METHOD: {
                    Utilities.handleSuppressWarnings(info, path, ((MethodTree)leaf).getModifiers(), keys);
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    Utilities.handleSuppressWarnings(info, path, ((ClassTree)leaf).getModifiers(), keys);
                    break;
                }
                case VARIABLE: {
                    Utilities.handleSuppressWarnings(info, path, ((VariableTree)leaf).getModifiers(), keys);
                }
            }
            path = path.getParentPath();
        }
        return Collections.unmodifiableSet(keys);
    }

    private static void handleSuppressWarnings(CompilationInfo info, TreePath path, ModifiersTree modifiers, final Set<String> keys) {
        Element el = info.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            javax.lang.model.element.Name fqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals("java.lang.SuppressWarnings")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                if (!e.getKey().getSimpleName().contentEquals("value")) continue;
                e.getValue().accept(new AnnotationValueVisitor<Void, Void>(){

                    @Override
                    public Void visit(AnnotationValue av, Void p) {
                        av.accept(this, p);
                        return null;
                    }

                    @Override
                    public Void visit(AnnotationValue av) {
                        av.accept(this, null);
                        return null;
                    }

                    @Override
                    public Void visitBoolean(boolean b, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitByte(byte b, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitChar(char c, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitDouble(double d, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitFloat(float f, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitInt(int i, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitLong(long i, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitShort(short s, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitString(String s, Void p) {
                        keys.add(s);
                        return null;
                    }

                    @Override
                    public Void visitType(TypeMirror t, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitEnumConstant(VariableElement c, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitAnnotation(AnnotationMirror a, Void p) {
                        return null;
                    }

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
                        for (AnnotationValue annotationValue : vals) {
                            annotationValue.accept(this, p);
                        }
                        return null;
                    }

                    @Override
                    public Void visitUnknown(AnnotationValue av, Void p) {
                        return null;
                    }
                }, null);
            }
        }
    }

    public static Tree generalizePattern(CompilationInfo info, TreePath original) {
        return Utilities.generalizePattern(JavaSourceAccessor.getINSTANCE().getJavacTask(info), original);
    }

    public static Tree generalizePattern(JavaCompiler.CompilationTask task, TreePath original) {
        JavacTaskImpl jti = (JavacTaskImpl)task;
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        Trees javacTrees = Trees.instance(task);
        GeneralizePattern gp = new GeneralizePattern(javacTrees, make);
        gp.scan(original, null);
        GeneralizePatternITT itt = new GeneralizePatternITT(gp.tree2Variable);
        itt.attach(c, new NoImports(c), null);
        return itt.translate(original.getLeaf());
    }

    public static Tree generalizePattern(CompilationInfo info, TreePath original, int firstStatement, int lastStatement) {
        JavacTaskImpl jti = JavaSourceAccessor.getINSTANCE().getJavacTask(info);
        Context c = jti.getContext();
        TreeFactory make = TreeFactory.instance((Context)c);
        Tree translated = Utilities.generalizePattern(jti, original);
        assert (translated.getKind() == Tree.Kind.BLOCK);
        LinkedList<? extends StatementTree> newStatements = new LinkedList<StatementTree>();
        BlockTree block = (BlockTree)translated;
        if (firstStatement != lastStatement) {
            newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$s0$")));
            newStatements.addAll(block.getStatements().subList(firstStatement, lastStatement + 1));
            newStatements.add(make.ExpressionStatement((ExpressionTree)make.Identifier((CharSequence)"$s1$")));
            translated = make.Block(newStatements, block.isStatic());
        } else {
            translated = block.getStatements().get(firstStatement);
        }
        return translated;
    }

    public static long patternValue(Tree pattern) {
        class VisitorImpl
        extends TreeScanner<Void, Void> {
            private int value;

            VisitorImpl() {
            }

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null) {
                    ++this.value;
                }
                return (Void)super.scan(node, p);
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                if (node.getName().toString().startsWith("$")) {
                    --this.value;
                }
                return (Void)super.visitIdentifier(node, p);
            }
        }
        VisitorImpl vi = new VisitorImpl();
        vi.scan(pattern, null);
        return vi.value;
    }

    public static boolean containsMultistatementTrees(List<? extends Tree> statements) {
        for (Tree tree : statements) {
            if (!Utilities.isMultistatementWildcardTree(tree)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends Tree> filterHidden(TreePath basePath, Iterable<? extends Tree> members) {
        LinkedList<Tree> result = new LinkedList<Tree>();
        for (Tree tree : members) {
            if (Utilities.isSynthetic(basePath != null ? basePath.getCompilationUnit() : null, tree)) continue;
            result.add(tree);
        }
        return result;
    }

    private static boolean isSynthetic(CompilationUnitTree cut, Tree leaf) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
        }
        if (cut != null && leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            return (Integer)((JCTree.JCCompilationUnit)cut).endPositions.get(tree) == -1;
        }
        return false;
    }

    private static final class DummyJFO
    extends SimpleJavaFileObject {
        private DummyJFO() {
            super(URI.create("dummy.java"), JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return "";
        }
    }

    private static final class PushbackLexer
    implements Lexer {
        private final Lexer delegate;
        private final List<Token> buffer;
        private Token currentBufferToken;

        public PushbackLexer(Lexer delegate) {
            this.delegate = delegate;
            this.buffer = new LinkedList<Token>();
        }

        public void add(Token token) {
            this.buffer.add(token);
        }

        public void token(Token token) {
            this.delegate.token(token);
        }

        public Token token() {
            if (this.currentBufferToken != null) {
                return this.currentBufferToken;
            }
            return this.delegate.token();
        }

        public String stringVal() {
            return this.delegate.stringVal();
        }

        public void resetDeprecatedFlag() {
            this.delegate.resetDeprecatedFlag();
        }

        public int radix() {
            return this.delegate.radix();
        }

        public int prevEndPos() {
            return this.delegate.prevEndPos();
        }

        public int pos() {
            return this.delegate.pos();
        }

        @Override
        public void nextToken() {
            if (!this.buffer.isEmpty()) {
                this.currentBufferToken = this.buffer.remove(0);
            } else {
                this.delegate.nextToken();
            }
        }

        public Name name() {
            return this.delegate.name();
        }

        public char[] getRawCharacters(int beginIndex, int endIndex) {
            return this.delegate.getRawCharacters(beginIndex, endIndex);
        }

        public char[] getRawCharacters() {
            return this.delegate.getRawCharacters();
        }

        @Override
        public Position.LineMap getLineMap() {
            return this.delegate.getLineMap();
        }

        @Override
        public void errPos(int pos) {
            this.delegate.errPos(pos);
        }

        @Override
        public int errPos() {
            return this.delegate.errPos();
        }

        public int endPos() {
            return this.delegate.endPos();
        }

        public String docComment() {
            return this.delegate.docComment();
        }

        public boolean deprecatedFlag() {
            return this.delegate.deprecatedFlag();
        }
    }

    private static class JackpotJavacParser
    extends EndPosParser {
        private final Context ctx;

        public JackpotJavacParser(Context ctx, ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, CancelService cancelService, Names names) {
            super(fac, (Lexer)new PushbackLexer(S), keepDocComments, keepLineMap, cancelService);
            this.ctx = ctx;
            this.newAnonScope(names.empty, -1);
        }

        protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
            String ident;
            if (this.S.token() == Token.IDENTIFIER && Utilities.isMultistatementWildcard(ident = this.S.stringVal())) {
                Name name = this.S.name();
                this.S.nextToken();
                return new JackpotTrees.ModifiersWildcard(name, this.F.Ident(name));
            }
            return super.modifiersOpt(partial);
        }

        protected JCTree.JCCatch catchClause() {
            if (this.S.token() == Token.CATCH) {
                this.S.nextToken();
                Token peeked = this.S.token();
                String ident = this.S.stringVal();
                if (peeked == Token.IDENTIFIER && Utilities.isMultistatementWildcard(ident)) {
                    this.accept(Token.CATCH);
                    Name name = this.S.name();
                    this.accept(Token.IDENTIFIER);
                    return new JackpotTrees.CatchWildcard(this.ctx, name, this.F.Ident(name));
                }
                ((PushbackLexer)this.S).add(Token.CATCH);
                ((PushbackLexer)this.S).add(null);
                this.S.nextToken();
            }
            return super.catchClause();
        }

        protected JCTree resource() {
            char[] maybeSemicolon;
            if (this.S.token() == Token.IDENTIFIER && this.S.stringVal().startsWith("$") && ((maybeSemicolon = this.S.getRawCharacters(this.S.endPos(), this.S.endPos() + 1))[0] == ';' || maybeSemicolon[0] == ')')) {
                int pos = this.S.pos();
                Name name = this.S.name();
                this.S.nextToken();
                return this.F.at(pos).Ident(name);
            }
            return super.resource();
        }
    }

    private static final class NoImports
    extends ImportAnalysis2 {
        private List<? extends ImportTree> imports;

        public NoImports(Context env) {
            super(env);
        }

        public void classEntered(ClassTree clazz) {
        }

        public void classLeft() {
        }

        public ExpressionTree resolveImport(MemberSelectTree orig, Element element) {
            return orig;
        }

        public void setCompilationUnit(CompilationUnitTree cut) {
        }

        public void setImports(List<? extends ImportTree> importsToAdd) {
            this.imports = importsToAdd;
        }

        public List<? extends ImportTree> getImports() {
            return this.imports;
        }

        public void setPackage(ExpressionTree packageNameTree) {
        }
    }

    private static final class GeneralizePatternITT
    extends ImmutableTreeTranslator {
        private final Map<Tree, Tree> tree2Variable;

        public GeneralizePatternITT(Map<Tree, Tree> tree2Variable) {
            this.tree2Variable = tree2Variable;
        }

        public Tree translate(Tree tree) {
            Tree var = this.tree2Variable.remove(tree);
            if (var != null) {
                return super.translate(var);
            }
            return super.translate(tree);
        }
    }

    private static final class GeneralizePattern
    extends TreePathScanner<Void, Void> {
        public final Map<Tree, Tree> tree2Variable = new HashMap<Tree, Tree>();
        private final Map<Element, String> element2Variable = new HashMap<Element, String>();
        private final Trees javacTrees;
        private final TreeFactory make;
        private int currentVariableIndex = 0;

        public GeneralizePattern(Trees javacTrees, TreeFactory make) {
            this.javacTrees = javacTrees;
            this.make = make;
        }

        @NonNull
        private String getVariable(@NonNull Element el) {
            String var = this.element2Variable.get(el);
            if (var == null) {
                var = "$" + this.currentVariableIndex++;
                this.element2Variable.put(el, var);
            }
            return var;
        }

        private boolean shouldBeGeneralized(@NonNull Element el) {
            if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return true;
            }
            switch (el.getKind()) {
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: 
                case PARAMETER: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            Element e = this.javacTrees.getElement(this.getCurrentPath());
            if (e != null && this.shouldBeGeneralized(e)) {
                this.tree2Variable.put(node, this.make.Identifier((CharSequence)this.getVariable(e)));
            }
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            Element e = this.javacTrees.getElement(this.getCurrentPath());
            if (e != null && this.shouldBeGeneralized(e)) {
                VariableTree nue = this.make.Variable(node.getModifiers(), (CharSequence)this.getVariable(e), node.getType(), node.getInitializer());
                this.tree2Variable.put(node, nue);
            }
            return (Void)super.visitVariable(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, Void p) {
            List<? extends ExpressionTree> arguments = node.getArguments();
            if (!arguments.isEmpty() && arguments.get(0).getKind() == Tree.Kind.OTHER) {
                this.tree2Variable.put(node, this.make.Identifier((CharSequence)("$" + this.currentVariableIndex++)));
                return null;
            }
            return (Void)super.visitNewClass(node, p);
        }
    }

    private static final class ScannerImpl
    extends TreePathScanner<Scope, CompilationInfo> {
        private ScannerImpl() {
        }

        @Override
        public Scope visitBlock(BlockTree node, CompilationInfo p) {
            return p.getTrees().getScope(this.getCurrentPath());
        }

        @Override
        public Scope visitMethod(MethodTree node, CompilationInfo p) {
            if (node.getReturnType() == null) {
                return null;
            }
            return (Scope)super.visitMethod(node, p);
        }

        @Override
        public Scope reduce(Scope r1, Scope r2) {
            return r1 != null ? r1 : r2;
        }
    }

    public static final class SPIImpl
    implements SPI {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Scope constructScope(CompilationInfo info, Map<String, TypeMirror> constraints, Iterable<? extends String> auxiliaryImports) {
            StringBuilder clazz = new StringBuilder();
            clazz.append("package $;");
            for (String string : auxiliaryImports) {
                clazz.append(string);
            }
            long count = inc++;
            clazz.append("public class $" + count + "{");
            for (Map.Entry<String, TypeMirror> e : constraints.entrySet()) {
                if (e.getValue() == null) continue;
                clazz.append("private ");
                clazz.append(((Object)e.getValue()).toString());
                clazz.append(" ");
                clazz.append(e.getKey());
                clazz.append(";\n");
            }
            clazz.append("private void test() {\n");
            clazz.append("}\n");
            clazz.append("}\n");
            JavacTaskImpl jti = JavaSourceAccessor.getINSTANCE().getJavacTask(info);
            Context context = jti.getContext();
            JavaCompiler jc = JavaCompiler.instance(context);
            Log.instance((Context)context).nerrors = 0;
            InferableJavaFileObject jfo = FileObjects.memoryFileObject((CharSequence)"$", (CharSequence)"$", (URI)new File("/tmp/t" + count + ".java").toURI(), (long)System.currentTimeMillis(), (CharSequence)clazz.toString());
            boolean oldSkipAPs = jc.skipAnnotationProcessing;
            try {
                jc.skipAnnotationProcessing = true;
                Iterable parsed = jti.parse(new JavaFileObject[]{jfo});
                CompilationUnitTree cut = (CompilationUnitTree)parsed.iterator().next();
                jti.analyze(jti.enter(parsed));
                Scope scope = (Scope)new ScannerImpl().scan(cut, info);
                return scope;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Scope scope = null;
                return scope;
            }
            finally {
                jc.skipAnnotationProcessing = oldSkipAPs;
            }
        }
    }

    public static interface SPI {
        public Scope constructScope(CompilationInfo var1, Map<String, TypeMirror> var2, Iterable<? extends String> var3);
    }

    private static final class FixTree
    extends ImmutableTreeTranslator {
        private FixTree() {
        }

        public Tree translate(Tree tree) {
            IdentifierTree idTree;
            String id;
            ErroneousTree err;
            ExpressionStatementTree et;
            if (tree != null && tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (et = (ExpressionStatementTree)tree).getExpression().getKind() == Tree.Kind.ERRONEOUS && (err = (ErroneousTree)et.getExpression()).getErrorTrees().size() == 1 && err.getErrorTrees().get(0).getKind() == Tree.Kind.IDENTIFIER && (id = (idTree = (IdentifierTree)err.getErrorTrees().get(0)).getName().toString()).length() > 0 && id.charAt(0) == '$') {
                return this.make.ExpressionStatement((ExpressionTree)idTree);
            }
            return super.translate(tree);
        }
    }
}

