/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SystemOut {
    public static ErrorDescription checkSystemOut(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        CompilationInfo compilationInfo = ctx.getInfo();
        return ErrorDescriptionFactory.forName(ctx, treePath, NbBundle.getMessage(SystemOut.class, (String)"MSG_SystemOut"), new FixImpl(NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_SystemOut_fix"), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo)));
    }

    private static final class FixImpl
    implements Fix {
        private final String text;
        private final TreePathHandle treePathHandle;

        public FixImpl(String text, TreePathHandle loggerFieldHandle) {
            this.text = text;
            this.treePathHandle = loggerFieldHandle;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath statementPath = FixImpl.this.treePathHandle.resolve((CompilationInfo)wc);
                    if (statementPath == null) {
                        return;
                    }
                    TreePath blockPath = statementPath.getParentPath();
                    while (!(blockPath.getLeaf() instanceof BlockTree)) {
                        statementPath = blockPath;
                        if ((blockPath = blockPath.getParentPath()) != null) continue;
                        return;
                    }
                    BlockTree blockTree = (BlockTree)blockPath.getLeaf();
                    List<? extends StatementTree> statements = blockTree.getStatements();
                    ArrayList<StatementTree> newStatements = new ArrayList<StatementTree>();
                    for (StatementTree statementTree : statements) {
                        if (statementTree == statementPath.getLeaf()) continue;
                        newStatements.add(statementTree);
                    }
                    BlockTree newBlockTree = wc.getTreeMaker().Block(newStatements, blockTree.isStatic());
                    wc.rewrite((Tree)blockTree, (Tree)newBlockTree);
                }
            }).commit();
            return null;
        }
    }
}

