/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.AssignmentToItself;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AnnotationAsSuperInterface
extends AbstractHint {
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private Set<Tree.Kind> KINDS = Collections.singleton(Tree.Kind.ANNOTATION_TYPE);

    public AnnotationAsSuperInterface() {
        super(true, true, AbstractHint.HintSeverity.WARNING, "AnnotationAsSuperInterface");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        Tree node = treePath.getLeaf();
        if (node.getKind() != Tree.Kind.ANNOTATION_TYPE) {
            return null;
        }
        ClassTree tree = (ClassTree)node;
        Element e = info.getTrees().getElement(treePath);
        if (e == null || !(e instanceof TypeElement)) {
            return null;
        }
        ArrayList<ErrorDescription> eds = new ArrayList<ErrorDescription>();
        TypeElement te = (TypeElement)e;
        List<? extends TypeMirror> interfaces = te.getInterfaces();
        Types types = info.getTypes();
        for (TypeMirror typeMirror : interfaces) {
            Element si = types.asElement(typeMirror);
            if (si == null || si.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            Tree annoTree = this.findTreeForAnnotation(tree, si);
            annoTree = annoTree == null ? tree : annoTree;
            eds.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(AnnotationAsSuperInterface.class, (String)"HNT_AnnotationAsSuperInterface", (Object)si.getSimpleName().toString()), NO_FIXES, (FileObject)info.getFileObject(), (int)((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), annoTree)), (int)((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), annoTree))));
        }
        return eds;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return "AnnotationAsSuperInterface";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"LBL_AnnotationAsSuperInterface");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(AssignmentToItself.class, (String)"DSC_AnnotationAsSuperInterface");
    }

    private Tree findTreeForAnnotation(ClassTree ct, Element annotation) {
        String name = annotation.getSimpleName().toString();
        for (Tree tree : ct.getImplementsClause()) {
            if (!tree.toString().endsWith(name)) continue;
            return tree;
        }
        return null;
    }
}

