/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.display.DeviceTheme;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileObject;

public final class ScreenSupport {
    private static final JButton BUTTON = new JButton();

    private ScreenSupport() {
    }

    public static Font getFont(DesignComponent fontComponent) {
        if (fontComponent == null) {
            return null;
        }
        return ScreenSupport.getFont(ScreenSupport.getDeviceInfo(fontComponent.getDocument()), fontComponent);
    }

    public static Font getFont(DesignDocument document, int kindCode, int faceCode, int styleCode, int sizeCode) {
        ScreenDeviceInfo deviceInfo = ScreenSupport.getDeviceInfo(document);
        if (kindCode == 0) {
            return deviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.DEFAULT);
        }
        if (kindCode == 2) {
            return deviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.STATIC_TEXT);
        }
        if (kindCode == 3) {
            return deviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.INPUT_TEXT);
        }
        DeviceTheme.FontFace face = DeviceTheme.FontFace.SYSTEM;
        if (faceCode == 32) {
            face = DeviceTheme.FontFace.MONOSPACE;
        } else if (faceCode == 64) {
            face = DeviceTheme.FontFace.PROPORTIONAL;
        }
        EnumSet<DeviceTheme.FontStyle> style = EnumSet.of(DeviceTheme.FontStyle.PLAIN);
        if ((styleCode & 1) != 0) {
            style.add(DeviceTheme.FontStyle.BOLD);
        }
        if ((styleCode & 2) != 0) {
            style.add(DeviceTheme.FontStyle.ITALIC);
        }
        if ((styleCode & 4) != 0) {
            style.add(DeviceTheme.FontStyle.UNDERLINED);
        }
        DeviceTheme.FontSize size = DeviceTheme.FontSize.MEDIUM;
        if (sizeCode == 8) {
            size = DeviceTheme.FontSize.SMALL;
        } else if (sizeCode == 16) {
            size = DeviceTheme.FontSize.LARGE;
        }
        return deviceInfo.getDeviceTheme().getFont(face, style, size);
    }

    public static ScreenDeviceInfo getDeviceInfo(final DesignDocument document) {
        final ScreenDeviceInfo[] screenDevice = new ScreenDeviceInfo[1];
        if (document == null) {
            return null;
        }
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent rootComponent = document.getRootComponent();
                ScreenDeviceInfoPresenter presenter = (ScreenDeviceInfoPresenter)rootComponent.getPresenter(ScreenDeviceInfoPresenter.class);
                if (presenter == null) {
                    throw Debug.error((Object[])new Object[]{"No ScreenDevice attached to the root component"});
                }
                screenDevice[0] = presenter.getScreenDeviceInfo();
            }
        });
        return screenDevice[0];
    }

    public static Font getFont(ScreenDeviceInfo deviceInfo, DesignComponent fontComponent) {
        if (fontComponent == null) {
            return deviceInfo.getDeviceTheme().getFont(DeviceTheme.FontType.DEFAULT);
        }
        PropertyValue value = fontComponent.readProperty("fontKind");
        int kindCode = !PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? MidpTypes.getInteger(value) : 0;
        value = fontComponent.readProperty("face");
        int faceCode = !PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? MidpTypes.getInteger(value) : 0;
        value = fontComponent.readProperty("style");
        int styleCode = !PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? MidpTypes.getInteger(value) : 0;
        value = fontComponent.readProperty("bold");
        int sizeCode = !PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) ? MidpTypes.getInteger(value) : 0;
        return ScreenSupport.getFont(fontComponent.getDocument(), kindCode, faceCode, styleCode, sizeCode);
    }

    public static Icon getIconFromImageComponent(DesignComponent imageComponent) {
        if (imageComponent == null) {
            return null;
        }
        PropertyValue value = imageComponent.readProperty("resourcePath");
        String imagePath = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            imagePath = MidpTypes.getString(imageComponent.readProperty("resourcePath"));
        }
        if (imagePath == null) {
            return null;
        }
        DesignDocument document = imageComponent.getDocument();
        Map<FileObject, FileObject> fileMap = MidpProjectSupport.getFileObjectsForRelativeResourcePath(document, imagePath);
        if (fileMap == null || !fileMap.keySet().iterator().hasNext()) {
            return null;
        }
        FileObject imageFileObject = fileMap.keySet().iterator().next();
        if (imageFileObject != null) {
            return ScreenSupport.resolveImageForRoot(imageFileObject, imagePath);
        }
        Debug.warning((Object[])new Object[]{"Resource path property in", imageComponent, "contains incorrect value"});
        return null;
    }

    public static FileObject getFileObjectFromImageComponent(DesignComponent imageComponent) {
        if (imageComponent == null) {
            return null;
        }
        PropertyValue value = imageComponent.readProperty("resourcePath");
        String imagePath = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            imagePath = MidpTypes.getString(imageComponent.readProperty("resourcePath"));
        }
        if (imagePath == null) {
            return null;
        }
        DesignDocument document = imageComponent.getDocument();
        Map<FileObject, FileObject> fileMap = MidpProjectSupport.getFileObjectsForRelativeResourcePath(document, imagePath);
        if (fileMap == null || !fileMap.keySet().iterator().hasNext()) {
            return null;
        }
        FileObject imageFileObject = fileMap.keySet().iterator().next();
        if (imageFileObject != null) {
            return imageFileObject;
        }
        Debug.warning((Object[])new Object[]{"Resource path property in", imageComponent, "contains incorrect value"});
        return null;
    }

    public static int getFontHeight(Graphics g, Font f) {
        assert (g != null && f != null);
        FontMetrics fm = g.getFontMetrics(f);
        return fm.getHeight();
    }

    static void addKeyboardSupport(final ScreenDisplayPresenter presenter) {
        final JComponent panel = presenter.getView();
        panel.setInputMap(0, BUTTON.getInputMap());
        panel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                presenter.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        presenter.getRelatedComponent().getDocument().setSelectedComponents("screen", Collections.singleton(presenter.getRelatedComponent()));
                    }
                });
                InputMap map = panel.getInputMap();
                if (map != BUTTON.getInputMap()) {
                    return;
                }
                map = new InputMap();
                panel.setInputMap(0, map);
                ActionMap actionMap = panel.getActionMap();
                if (actionMap == null) {
                    actionMap = new ActionMap();
                    panel.setActionMap(actionMap);
                }
                for (Action action : ActionsSupport.createActionsArray((DesignComponent)presenter.getRelatedComponent())) {
                    if (action == null || action.getValue("AcceleratorKey") == null) continue;
                    map.put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("AcceleratorKey").toString());
                    actionMap.put(action.getValue("AcceleratorKey").toString(), action);
                }
                if (map.allKeys() == null || map.allKeys().length == 0) {
                    map.setParent(BUTTON.getInputMap());
                }
            }
        });
    }

    private static Icon resolveImageForRoot(FileObject file, String relPath) {
        try {
            BufferedImage img = ImageIO.read(file.getInputStream());
            if (img != null) {
                return new ImageIcon(img);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

