/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.ScreenFileObjectListener;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class ImageItemDisplayPresenter
extends ItemDisplayPresenter {
    private static final String ICON_BROKEN_PATH = "org/netbeans/modules/vmd/midp/resources/screen/broken-image.png";
    private static final Icon ICON_BROKEN = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/screen/broken-image.png", (boolean)false);
    private JLabel label = new JLabel();
    private ScreenFileObjectListener imageFileListener;
    private FileObject imageFileObject;

    public ImageItemDisplayPresenter() {
        this.setContentComponent(this.label);
    }

    @Override
    public void reload(ScreenDeviceInfo deviceInfo) {
        super.reload(deviceInfo);
        PropertyValue value = this.getComponent().readProperty("image");
        DesignComponent imageComponent = null;
        String path = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind()) && (imageComponent = value.getComponent()) != null) {
            path = (String)imageComponent.readProperty("resourcePath").getPrimitiveValue();
        }
        value = this.getComponent().readProperty("altText");
        String alternText = null;
        if (!PropertyValue.Kind.USERCODE.equals((Object)value.getKind())) {
            alternText = MidpTypes.getString(value);
        }
        Icon icon = ScreenSupport.getIconFromImageComponent(imageComponent);
        this.imageFileObject = ScreenSupport.getFileObjectFromImageComponent(imageComponent);
        if (this.imageFileObject != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
            this.imageFileListener = new ScreenFileObjectListener(this.getRelatedComponent(), imageComponent, "resourcePath");
            this.imageFileObject.addFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        if (icon != null) {
            this.label.setText(null);
            this.label.setIcon(icon);
        } else if (icon == null && path != null) {
            this.label.setIcon(ICON_BROKEN);
        } else if (alternText != null) {
            this.label.setText(alternText);
            this.label.setIcon(null);
        }
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ArrayList<ScreenPropertyDescriptor> descriptors = new ArrayList<ScreenPropertyDescriptor>(super.getPropertyDescriptors());
        ResourcePropertyEditor imagePropertyEditor = new ResourcePropertyEditor("image", this.getComponent());
        descriptors.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)imagePropertyEditor));
        return descriptors;
    }

    protected void notifyDetached(DesignComponent component) {
        if (this.imageFileObject != null && this.imageFileListener != null) {
            this.imageFileObject.removeFileChangeListener((FileChangeListener)this.imageFileListener);
        }
        this.imageFileObject = null;
        this.imageFileListener = null;
    }
}

