/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class MidpJavaSupport
implements Runnable,
PropertyChangeListener {
    private static HashMap<String, MidpJavaSupport> instanceMap;
    private static RequestProcessor validationRP;
    private final ConcurrentLinkedQueue<String> validationQueue;
    private final ConcurrentHashMap<String, Boolean> validationCache;
    private final AtomicBoolean isValidationRunning;
    private WeakReference<DesignDocument> document;

    private MidpJavaSupport(DesignDocument document) {
        this.document = new WeakReference<DesignDocument>(document);
        this.validationQueue = new ConcurrentLinkedQueue();
        this.validationCache = new ConcurrentHashMap();
        this.isValidationRunning = new AtomicBoolean();
        this.registerClassPathListener();
    }

    public Boolean checkValidityCached(TypeID typeID) {
        return this.checkValidityCached(MidpTypes.getFQNClassName(typeID));
    }

    public Boolean checkValidityCached(String fqnName) {
        if (this.validationCache.containsKey(fqnName)) {
            return this.validationCache.get(fqnName);
        }
        this.scheduleValidation(fqnName);
        return null;
    }

    private void scheduleValidation(String fqnName) {
        this.validationQueue.add(fqnName);
        if (!this.isValidationRunning.getAndSet(true)) {
            validationRP.post((Runnable)this);
        }
    }

    @Override
    public void run() {
        DesignDocument doc = (DesignDocument)this.document.get();
        if (doc == null) {
            return;
        }
        while (true) {
            if (this.validationQueue.isEmpty()) break;
            String fqnName = (String)this.validationQueue.remove();
            boolean isValid = MidpJavaSupport.checkValidity(doc, fqnName);
            this.validationCache.put(fqnName, isValid);
        }
        this.isValidationRunning.set(false);
    }

    private void registerClassPathListener() {
        DesignDocument doc = (DesignDocument)this.document.get();
        if (doc == null) {
            return;
        }
        final ClasspathInfo info = this.getClasspathInfo(org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)doc));
        if (info == null) {
            Debug.warning((Object[])new Object[]{"Can't get ClasspathInfo for project"});
            return;
        }
        try {
            Task<CompilationController> ct = new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    ClassPath cp = info.getClassPath(ClasspathInfo.PathKind.BOOT);
                    PropertyChangeListener wcl = WeakListeners.propertyChange((PropertyChangeListener)MidpJavaSupport.this, (Object)cp);
                    cp.addPropertyChangeListener(wcl);
                }
            };
            JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runUserActionTask((Task)ct, true);
        }
        catch (IOException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
    }

    private ClasspathInfo getClasspathInfo(Project project) {
        if (project == null) {
            return null;
        }
        SourceGroup group = this.getSourceGroup(project);
        return group != null ? ClasspathInfo.create((FileObject)group.getRootFolder()) : null;
    }

    private SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        return sourceGroups != null && sourceGroups.length > 0 ? sourceGroups[0] : null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateCacheInternally();
    }

    void updateCacheInternally() {
        final DesignDocument doc = (DesignDocument)this.document.get();
        if (doc == null) {
            return;
        }
        this.validationCache.clear();
        String projectID = doc.getDocumentInterface().getProjectID();
        String projectType = doc.getDocumentInterface().getProjectType();
        final ArrayList producers = new ArrayList();
        final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)projectType, (String)projectID);
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                producers.addAll(registry.getComponentProducers());
            }
        });
        ClasspathInfo info = this.getClasspathInfo(org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)doc));
        if (info != null) {
            try {
                JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        for (ComponentProducer componentProducer : producers) {
                            componentProducer.checkValidity(doc, true);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Debug.warning((Object[])new Object[]{ex});
            }
        }
    }

    public static boolean checkValidity(DesignDocument document, TypeID typeID) {
        return MidpJavaSupport.checkValidity(document, MidpTypes.getFQNClassName(typeID));
    }

    public static boolean checkValidity(DesignDocument document, String fqName) {
        DataObjectContext context = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
        if (context == null) {
            return true;
        }
        List sg = org.netbeans.modules.vmd.api.io.ProjectUtils.getSourceGroups((DataObjectContext)context);
        boolean isValid = false;
        CheckingTask ct = new CheckingTask();
        Set collection = Collections.emptySet();
        for (SourceGroup sourceGroup : sg) {
            ct.setFQName(fqName);
            ClasspathInfo cpi = ClasspathInfo.create((FileObject)sourceGroup.getRootFolder());
            try {
                JavaSource.create((ClasspathInfo)cpi, collection).runUserActionTask((Task)ct, true);
            }
            catch (Exception ex) {
                Debug.warning((Object[])new Object[]{"Can't create javasource for", fqName});
            }
            if (isValid = ct.getResult()) continue;
            break;
        }
        return isValid;
    }

    public static synchronized MidpJavaSupport getCache(DesignDocument document) {
        String projectID;
        MidpJavaSupport instance;
        if (instanceMap == null) {
            instanceMap = new HashMap(1);
            validationRP = new RequestProcessor("VMD MIDP ClassPath validation");
        }
        if ((instance = instanceMap.get(projectID = document.getDocumentInterface().getProjectID())) == null) {
            instance = new MidpJavaSupport(document);
            instanceMap.put(projectID, instance);
        }
        return instance;
    }

    private static final class CheckingTask
    implements Task<CompilationController> {
        private boolean result;
        private String fqName;

        private CheckingTask() {
        }

        public void run(CompilationController controller) throws Exception {
            Elements elements = controller.getElements();
            TypeElement te = elements.getTypeElement(this.fqName);
            this.result = te != null;
        }

        public boolean getResult() {
            return this.result;
        }

        public void setFQName(String fqName) {
            this.fqName = fqName;
        }
    }
}

