/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.elements.ChoiceElementCD;

public class ChoiceGroupCode {
    public static final String PARAM_STRING = "elementString";
    public static final String PARAM_IMAGE = "elementImage";
    static final String PARAM_FONT = "elementFont";
    static final String PARAM_SELECTED_ARRAY = "elementSelectedArray";
    static final String PARAM_STRING_ARRAY = "elementStringArray";
    static final String PARAM_IMAGE_ARRAY = "elementImageArray";
    static final String PARAM_CHOICE_TYPE = "choiceType";
    static final String PARAM_FIT_POLICY = "fitPolicy";

    public static Parameter createStringParameter() {
        return new StringParameter();
    }

    public static Parameter createImageParameter() {
        return new ImageParameter();
    }

    public static Parameter createFontParameter() {
        return new FontParameter();
    }

    public static Parameter createSelectArrayParameter() {
        return new SelectedArrayParameter();
    }

    public static Parameter createStringArrayParameter() {
        return new StringArrayParameter();
    }

    public static Parameter createImageArrayParameter() {
        return new ImageArrayParameter();
    }

    public static Parameter createChoiceTypeParameter() {
        return new ChoiceTypeParameter();
    }

    public static Parameter createFitPolicyParameter() {
        return new FitPolicyParameter();
    }

    private static class FitPolicyParameter
    extends MidpParameter {
        protected FitPolicyParameter() {
            super(ChoiceGroupCode.PARAM_FIT_POLICY);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ChoiceGroupCode.PARAM_FIT_POLICY);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value) {
                    case 0: {
                        section.getWriter().write("Choice.TEXT_WRAP_DEFAULT");
                        break;
                    }
                    case 1: {
                        section.getWriter().write("Choice.TEXT_WRAP_ON");
                        break;
                    }
                    case 2: {
                        section.getWriter().write("Choice.TEXT_WRAP_OFF");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static class ChoiceTypeParameter
    extends MidpParameter {
        protected ChoiceTypeParameter() {
            super(ChoiceGroupCode.PARAM_CHOICE_TYPE);
        }

        @Override
        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty(ChoiceGroupCode.PARAM_CHOICE_TYPE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int value = MidpTypes.getInteger(propertyValue);
                switch (value) {
                    case 1: {
                        section.getWriter().write("Choice.EXCLUSIVE");
                        break;
                    }
                    case 2: {
                        section.getWriter().write("Choice.MULTIPLE");
                        break;
                    }
                    case 4: {
                        section.getWriter().write("Choice.POPUP");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                return;
            }
            super.generateParameterCode(component, section, index);
        }
    }

    private static class ImageArrayParameter
    implements Parameter {
        private ImageArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_IMAGE_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new Image[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue choiceElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent choiceElement = choiceElementValue.getComponent();
                PropertyValue image = choiceElement.readProperty("image");
                MidpCodeSupport.generateCodeForPropertyValue(writer, image);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class StringArrayParameter
    implements Parameter {
        private StringArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_STRING_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new String[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue choiceElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent choiceElement = choiceElementValue.getComponent();
                PropertyValue string = choiceElement.readProperty("string");
                MidpCodeSupport.generateCodeForPropertyValue(writer, string);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class SelectedArrayParameter
    implements Parameter {
        private SelectedArrayParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_SELECTED_ARRAY;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List elementsArray = propertyValue.getArray();
            CodeWriter writer = section.getWriter();
            writer.write("new boolean[] { ");
            for (int i = 0; i < elementsArray.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                PropertyValue choiceElementValue = (PropertyValue)elementsArray.get(i);
                DesignComponent choiceElement = choiceElementValue.getComponent();
                PropertyValue string = choiceElement.readProperty("selected");
                MidpCodeSupport.generateCodeForPropertyValue(writer, string);
            }
            writer.write(" }");
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            throw Debug.illegalState((Object[])new Object[0]);
        }
    }

    private static class FontParameter
    implements Parameter {
        private FontParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_FONT;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent choiceElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = choiceElement.readProperty("font");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            List children = DocumentSupport.gatherSubComponentsOfType((DesignComponent)component, (TypeID)ChoiceElementCD.TYPEID);
            if (children == null) {
                return false;
            }
            for (DesignComponent child : children) {
                if (child.isDefaultValue("font")) continue;
                return true;
            }
            return false;
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }

    private static class ImageParameter
    implements Parameter {
        private ImageParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_IMAGE;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent choiceElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = choiceElement.readProperty("image");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }

    private static class StringParameter
    implements Parameter {
        private StringParameter() {
        }

        public String getParameterName() {
            return ChoiceGroupCode.PARAM_STRING;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent component, MultiGuardedSection section, int index) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            DesignComponent listElement = ((PropertyValue)array.get(index)).getComponent();
            PropertyValue string = listElement.readProperty("string");
            MidpCodeSupport.generateCodeForPropertyValue(section.getWriter(), string);
        }

        public boolean isRequiredToBeSet(DesignComponent component) {
            return !component.isDefaultValue("elements");
        }

        public int getCount(DesignComponent component) {
            PropertyValue propertyValue = component.readProperty("elements");
            List array = propertyValue.getArray();
            return array.size();
        }

        public boolean isRequiredToBeSet(DesignComponent component, int index) {
            return true;
        }
    }
}

