/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.awt.Image;
import java.util.HashMap;
import org.netbeans.modules.vmd.api.model.EnumDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpEnumDescriptor;
import org.netbeans.modules.vmd.midp.components.MidpPrimitiveDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public final class MidpTypes {
    public static final TypeID TYPEID_CHAR = new TypeID(TypeID.Kind.PRIMITIVE, "char");
    public static final TypeID TYPEID_BYTE = new TypeID(TypeID.Kind.PRIMITIVE, "byte");
    public static final TypeID TYPEID_SHORT = new TypeID(TypeID.Kind.PRIMITIVE, "short");
    public static final TypeID TYPEID_INT = new TypeID(TypeID.Kind.PRIMITIVE, "int");
    public static final TypeID TYPEID_LONG = new TypeID(TypeID.Kind.PRIMITIVE, "long");
    public static final TypeID TYPEID_FLOAT = new TypeID(TypeID.Kind.PRIMITIVE, "float");
    public static final TypeID TYPEID_DOUBLE = new TypeID(TypeID.Kind.PRIMITIVE, "double");
    public static final TypeID TYPEID_JAVA_LANG_STRING = new TypeID(TypeID.Kind.PRIMITIVE, "java.lang.String");
    public static final TypeID TYPEID_BOOLEAN = new TypeID(TypeID.Kind.PRIMITIVE, "boolean");
    public static final TypeID TYPEID_JAVA_CODE = new TypeID(TypeID.Kind.PRIMITIVE, "#javacode");
    public static final TypeID TYPEID_ALERT_TYPE = new TypeID(TypeID.Kind.ENUM, "javax.microedition.lcdui.AlertType");
    private static final PropertyValue VALUE_TRUE = PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.booleanPD, (TypeID)TYPEID_BOOLEAN, (Object)true);
    private static final PropertyValue VALUE_FALSE = PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.booleanPD, (TypeID)TYPEID_BOOLEAN, (Object)false);
    private static final String PREFIX_LCDUI = "javax.microedition.lcdui.";
    private static final String PREFIX_MIDLET = "javax.microedition.midlet.";
    private static final HashMap<TypeID, Image> iconsRegister = new HashMap();

    public static PropertyValue createBooleanValue(boolean value) {
        return value ? VALUE_TRUE : VALUE_FALSE;
    }

    public static PropertyValue createStringValue(String stringValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.stringPD, (TypeID)TYPEID_JAVA_LANG_STRING, (Object)stringValue);
    }

    public static PropertyValue createIntegerValue(int intValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.intPD, (TypeID)TYPEID_INT, (Object)intValue);
    }

    public static PropertyValue createLongValue(long longValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.longPD, (TypeID)TYPEID_LONG, (Object)longValue);
    }

    public static PropertyValue createFloatValue(float floatValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.floatPD, (TypeID)TYPEID_FLOAT, (Object)Float.valueOf(floatValue));
    }

    public static PropertyValue createDoubleValue(double doubleValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.doublePD, (TypeID)TYPEID_DOUBLE, (Object)doubleValue);
    }

    public static PropertyValue createCharValue(char charValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.charPD, (TypeID)TYPEID_CHAR, (Object)Character.valueOf(charValue));
    }

    public static PropertyValue createByteValue(byte byteValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.bytePD, (TypeID)TYPEID_BYTE, (Object)byteValue);
    }

    public static PropertyValue createShortValue(short shortValue) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.shortPD, (TypeID)TYPEID_SHORT, (Object)shortValue);
    }

    public static PropertyValue createJavaCodeValue(String javaCode) {
        return PropertyValue.createValue((PrimitiveDescriptor)MidpPrimitiveDescriptor.stringPD, (TypeID)TYPEID_JAVA_CODE, (Object)javaCode);
    }

    public static PropertyValue createAlertTypeValue(AlertType alertType) {
        return PropertyValue.createEnumValue((EnumDescriptor)MidpEnumDescriptor.alertTypePD, (TypeID)TYPEID_ALERT_TYPE, (Object)((Object)alertType));
    }

    public static String getString(PropertyValue propertyValue) {
        return (String)propertyValue.getPrimitiveValue();
    }

    public static boolean getBoolean(PropertyValue propertyValue) {
        return (Boolean)propertyValue.getPrimitiveValue();
    }

    public static int getInteger(PropertyValue propertyValue) {
        return (Integer)propertyValue.getPrimitiveValue();
    }

    public static long getLong(PropertyValue propertyValue) {
        return (Long)propertyValue.getPrimitiveValue();
    }

    public static float getFloat(PropertyValue propertyValue) {
        return ((Float)propertyValue.getPrimitiveValue()).floatValue();
    }

    public static double getDouble(PropertyValue propertyValue) {
        return (Double)propertyValue.getPrimitiveValue();
    }

    public static char getChar(PropertyValue propertyValue) {
        return ((Character)propertyValue.getPrimitiveValue()).charValue();
    }

    public static byte getByte(PropertyValue propertyValue) {
        return (Byte)propertyValue.getPrimitiveValue();
    }

    public static short getShort(PropertyValue propertyValue) {
        return (Short)propertyValue.getPrimitiveValue();
    }

    public static String getJavaCode(PropertyValue propertyValue) {
        return (String)propertyValue.getPrimitiveValue();
    }

    public static AlertType getAlertType(PropertyValue propertyValue) {
        return (AlertType)((Object)propertyValue.getPrimitiveValue());
    }

    public static boolean isValidFQNClassName(String string) {
        if (string == null) {
            return false;
        }
        for (String part : string.split("\\.", -2)) {
            if (Utilities.isJavaIdentifier((String)part)) continue;
            return false;
        }
        return true;
    }

    public static String getFQNClassName(TypeID type) {
        assert (TypeID.Kind.COMPONENT.equals((Object)type.getKind()));
        return type.getString();
    }

    public static String getOptimalizedFQNClassName(TypeID type) {
        String className = type.getString();
        if (className.startsWith(PREFIX_LCDUI)) {
            return className.substring(PREFIX_LCDUI.length());
        }
        if (className.startsWith(PREFIX_MIDLET)) {
            return className.substring(PREFIX_MIDLET.length());
        }
        return className;
    }

    public static String getSimpleClassName(TypeID type) {
        assert (TypeID.Kind.COMPONENT.equals((Object)type.getKind()));
        String string = type.getString();
        int i = string.lastIndexOf(46);
        return i >= 0 ? string.substring(i + 1) : string;
    }

    public static void registerIconResource(TypeID typeID, String iconResource) {
        if (iconResource == null) {
            return;
        }
        iconsRegister.put(typeID, ImageUtilities.loadImage((String)iconResource));
    }

    public static void registerIcon(TypeID typeID, Image icon) {
        iconsRegister.put(typeID, icon);
    }

    public static Image getRegisteredIcon(TypeID typeID) {
        return iconsRegister.get(typeID);
    }

    public static enum AlertType {
        ALARM,
        CONFIRMATION,
        ERROR,
        INFO,
        WARNING;

    }
}

