/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.DiffTopComponent;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Diff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        boolean bNotManaged;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        String contextName = Utils.getContextDisplayName((VCSContext)context);
        File[] files = context.getRootFiles().toArray(new File[context.getRootFiles().size()]);
        boolean bl = bNotManaged = !HgUtils.isFromHgRepository(context) || files == null || files.length == 0;
        if (bNotManaged) {
            OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE"));
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        DiffAction.diff(context, 0, contextName);
    }

    public static void diff(VCSContext ctx, int type, String contextName) {
        MultiDiffPanel panel = new MultiDiffPanel(ctx, type, contextName);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
        tc.open();
        tc.requestActive();
    }

    public static void diff(File file, HgLogMessage.HgRevision rev1, HgLogMessage.HgRevision rev2) {
        MultiDiffPanel panel = new MultiDiffPanel(file, rev1, rev2, false);
        DiffTopComponent tc = new DiffTopComponent(panel);
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }
}

