/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgSearchHistorySupport;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private ConcurrentLinkedQueue<File> filesToRefresh = new ConcurrentLinkedQueue();
    private RequestProcessor.Task refreshTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRefresh", 1, true);
    private final HgFolderEventsHandler hgFolderEventsHandler;
    private static final boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.mercurial.autoRefreshDisabled", "false"));
    private static final File userDir = new File(System.getProperty("netbeans.user"));

    public MercurialInterceptor() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask());
        this.hgFolderEventsHandler = new HgFolderEventsHandler();
    }

    public boolean beforeDelete(File file) {
        Mercurial.LOG.fine("beforeDelete " + file);
        if (file == null) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        return !HgUtils.isIgnored(file, false);
    }

    public void doDelete(File file) throws IOException {
        Mercurial.LOG.fine("doDelete " + file);
        if (file == null) {
            return;
        }
        Mercurial hg = Mercurial.getInstance();
        File root = hg.getRepositoryRoot(file);
        try {
            file.delete();
            HgCommand.doRemove(root, file, null);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.FINE, "doDelete(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
        }
    }

    public void afterDelete(File file) {
        Mercurial.LOG.fine("afterDelete " + file);
        if (file == null) {
            return;
        }
        if (HgUtils.isIgnored(file, false)) {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINE, "skipping afterDelete(): File: {0} is ignored", new Object[]{file.getAbsolutePath()});
            }
            return;
        }
        this.reScheduleRefresh(800, file);
    }

    public boolean beforeMove(File from, File to) {
        Mercurial.LOG.fine("beforeMove " + from + "->" + to);
        if (this.isUnderIgnoredUserDir(from)) {
            return false;
        }
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Mercurial hg = Mercurial.getInstance();
        if (hg.isManaged(from)) {
            return hg.isManaged(to);
        }
        return super.beforeMove(from, to);
    }

    public void doMove(File from, File to) throws IOException {
        Mercurial.LOG.fine("doMove " + from + "->" + to);
        if (from == null || to == null || to.exists()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mercurial.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
        }
        this.hgMoveImplementation(from, to);
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        long retval = -1L;
        if (".hg".equals(dir.getName())) {
            Mercurial.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getAbsolutePath());
            children.clear();
            retval = this.hgFolderEventsHandler.handleHgFolderEvent(dir);
        }
        return retval;
    }

    public boolean isMutable(File file) {
        return HgUtils.isPartOfMercurialMetadata(file) || super.isMutable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hgMoveImplementation(File srcFile, File dstFile) throws IOException {
        Mercurial hg = Mercurial.getInstance();
        File root = hg.getRepositoryRoot(srcFile);
        File dstRoot = hg.getRepositoryRoot(dstFile);
        if (root == null) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{srcFile, dstFile});
        boolean result = srcFile.renameTo(dstFile);
        if (!result) {
            Mercurial.LOG.log(Level.INFO, "Cannot rename file {0} to {1}", new Object[]{srcFile, dstFile});
        }
        OutputLogger logger = OutputLogger.getLogger(root.getAbsolutePath());
        try {
            if (root.equals(dstRoot)) {
                HgCommand.doRenameAfter(root, srcFile, dstFile, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{srcFile.getAbsolutePath(), dstFile.getAbsolutePath()});
        }
        finally {
            logger.closeLog();
        }
    }

    public void afterMove(File from, File to) {
        Mercurial.LOG.fine("afterMove " + from + "->" + to);
        if (from == null || to == null || !to.exists()) {
            return;
        }
        File parent = from.getParentFile();
        if (parent != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, from);
        }
        if ((parent = to.getParentFile()) != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to);
        }
    }

    public boolean beforeCopy(File from, File to) {
        Mercurial.LOG.fine("beforeCopy " + from + "->" + to);
        if (this.isUnderIgnoredUserDir(to)) {
            return false;
        }
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Mercurial hg = Mercurial.getInstance();
        return hg.isManaged(from) && hg.isManaged(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(File from, File to) throws IOException {
        Mercurial.LOG.fine("doCopy " + from + "->" + to);
        if (from == null || to == null || to.exists()) {
            return;
        }
        Mercurial hg = Mercurial.getInstance();
        File root = hg.getRepositoryRoot(from);
        File dstRoot = hg.getRepositoryRoot(to);
        if (from.isDirectory()) {
            FileUtils.copyDirFiles((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        if (root == null) {
            return;
        }
        OutputLogger logger = OutputLogger.getLogger(root.getAbsolutePath());
        try {
            if (root.equals(dstRoot)) {
                HgCommand.doCopy(root, from, to, true, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to copy: File: {0} {1}", new Object[]{from.getAbsolutePath(), to.getAbsolutePath()});
        }
        finally {
            logger.closeLog();
        }
    }

    public void afterCopy(File from, File to) {
        Mercurial.LOG.fine("afterCopy " + from + "->" + to);
        if (to == null) {
            return;
        }
        File parent = to.getParentFile();
        if (parent != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to);
        }
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        Mercurial.LOG.fine("beforeCreate " + file + " " + isDirectory);
        if (this.isUnderIgnoredUserDir(file)) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            File root = Mercurial.getInstance().getRepositoryRoot(file);
            FileInformation info = null;
            try {
                Map<File, FileInformation> statusMap = HgCommand.getStatus(root, Arrays.asList(file));
                info = statusMap != null ? statusMap.get(file) : null;
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): getStatus failed for file: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
            }
            if (info != null && info.getStatus() == 256) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
                if (root == null) {
                    return false;
                }
                OutputLogger logger = Mercurial.getInstance().getLogger(root.getAbsolutePath());
                try {
                    ArrayList<File> revertFiles = new ArrayList<File>();
                    revertFiles.add(file);
                    HgCommand.doRevert(root, revertFiles, null, false, logger);
                }
                catch (HgException ex) {
                    Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
                }
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
                logger.closeLog();
                file.delete();
            }
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
        Mercurial.LOG.fine("doCreate " + file + " " + isDirectory);
        super.doCreate(file, isDirectory);
    }

    public void afterCreate(File file) {
        Mercurial.LOG.fine("afterCreate " + file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public void afterChange(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "afterChange(): {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file);
        }
    }

    public Object getAttribute(final File file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                    cache.refresh(file);
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new HgSearchHistorySupport(file);
        }
        return super.getAttribute(file, attrName);
    }

    private String getRemoteRepository(File file) {
        return HgUtils.getRemoteRepository(file);
    }

    private void reScheduleRefresh(int delayMillis, File fileToRefresh) {
        Mercurial.STATUS_LOG.fine("reScheduleRefresh: adding " + fileToRefresh.getAbsolutePath());
        if (!HgUtils.isPartOfMercurialMetadata(fileToRefresh)) {
            this.filesToRefresh.add(fileToRefresh);
        }
        this.refreshTask.schedule(delayMillis);
    }

    private void reScheduleRefresh(int delayMillis, Set<File> filesToRefresh) {
        Mercurial.STATUS_LOG.fine("reScheduleRefresh: adding " + filesToRefresh);
        this.filesToRefresh.addAll(filesToRefresh);
        this.refreshTask.schedule(delayMillis);
    }

    void pingRepositoryRootFor(File file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.hgFolderEventsHandler.initializeFor(file);
    }

    void refreshHgFolderTimestamp(File repository) {
        assert (repository != null);
        if (repository == null) {
            return;
        }
        File hgFolder = HgUtils.getHgFolderForRoot(repository);
        this.hgFolderEventsHandler.refreshHgFolderTimestamp(hgFolder, hgFolder.lastModified());
    }

    Set<File> getSeenRoots(File repositoryRoot) {
        return this.hgFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    private boolean isUnderIgnoredUserDir(File file) {
        return Utils.isAncestorOrEqual((File)userDir, (File)file) && HgUtils.isIgnored(file, false);
    }

    private class HgFolderEventsHandler {
        private final HashMap<File, Long> hgFolders = new HashMap(5);
        private final HashMap<File, FileChangeListener> hgFolderRLs = new HashMap(5);
        private final HashMap<File, Set<File>> seenRoots = new HashMap(5);
        private final HashSet<File> filesToInitialize = new HashSet();
        private RequestProcessor rp = new RequestProcessor("MercurialInterceptorEventsHandlerRP", 1);
        private RequestProcessor.Task initializingTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                HgFolderEventsHandler.this.initializeFiles();
            }
        });
        private RequestProcessor.Task refreshOpenFilesTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                Set openFiles = Utils.getOpenFiles();
                for (File file : openFiles) {
                    Mercurial.getInstance().notifyFileChanged(file);
                }
            }
        });

        private HgFolderEventsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshHgFolderTimestamp(File hgFolder, long timestamp) {
            boolean exists = timestamp > 0L || hgFolder.exists();
            HashMap<File, Long> hashMap = this.hgFolders;
            synchronized (hashMap) {
                Long ts;
                if (exists && (ts = this.hgFolders.get(hgFolder)) != null && ts >= timestamp) {
                    return;
                }
            }
            hashMap = this.hgFolders;
            synchronized (hashMap) {
                this.hgFolders.remove(hgFolder);
                FileChangeListener list = this.hgFolderRLs.remove(hgFolder);
                if (exists) {
                    this.hgFolders.put(hgFolder, timestamp);
                    if (list == null) {
                        list = new FileChangeAdapter();
                        FileUtil.addRecursiveListener((FileChangeListener)list, (File)hgFolder);
                    }
                    this.hgFolderRLs.put(hgFolder, list);
                } else {
                    if (list != null) {
                        FileUtil.removeRecursiveListener((FileChangeListener)list, (File)hgFolder);
                    }
                    Mercurial.STATUS_LOG.fine("refreshHgFolderTimestamp: " + hgFolder.getAbsolutePath() + " no longer exists");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long handleHgFolderEvent(File hgFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("mercurial.handleDirstateEvents", "true"))) {
                hgFolder = FileUtil.normalizeFile((File)hgFolder);
                Mercurial.STATUS_LOG.finer("handleHgFolderEvent: special FS event handling for " + hgFolder.getAbsolutePath());
                lastModified = hgFolder.lastModified();
                Long lastCachedModified = null;
                HashMap<File, Long> hashMap = this.hgFolders;
                synchronized (hashMap) {
                    lastCachedModified = this.hgFolders.get(hgFolder);
                    if (lastCachedModified == null || lastCachedModified < lastModified || lastModified == 0L) {
                        this.refreshHgFolderTimestamp(hgFolder, lastModified);
                        lastCachedModified = null;
                    }
                }
                if (lastCachedModified == null) {
                    File repository = hgFolder.getParentFile();
                    Mercurial.STATUS_LOG.fine("handleDirstateEvent: planning repository scan for " + repository.getAbsolutePath());
                    MercurialInterceptor.this.reScheduleRefresh(3000, this.getSeenRoots(repository));
                    this.refreshOpenFilesTask.schedule(3000);
                }
            }
            return lastModified;
        }

        public void initializeFor(File file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRoots(File repositoryRoot) {
            Set<File> seenRootsForRepository;
            HashSet<File> retval = new HashSet<File>();
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File addSeenRoot(File repositoryRoot, File rootToAdd) {
            Set<File> seenRootsForRepository;
            File addedRoot = null;
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    rootToAdd = FileUtil.normalizeFile((File)rootToAdd);
                    addedRoot = HgUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd);
                }
            }
            return addedRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRootsForRepository(File repositoryRoot) {
            HashMap<File, Set<File>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<File> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<File>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(File file) {
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getFileToInitialize() {
            File nextFile = null;
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<File> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            File file = null;
            while ((file = this.getFileToInitialize()) != null) {
                File repositoryRoot = Mercurial.getInstance().getRepositoryRoot(file);
                if (repositoryRoot == null) continue;
                File hgFolder = FileUtil.normalizeFile((File)HgUtils.getHgFolderForRoot(repositoryRoot));
                File newlyAddedRoot = this.addSeenRoot(repositoryRoot, file);
                if (newlyAddedRoot == null) continue;
                HashMap<File, Long> hashMap = this.hgFolders;
                synchronized (hashMap) {
                    Mercurial.STATUS_LOG.fine("pingRepositoryRootFor: planning a scan for " + repositoryRoot.getAbsolutePath() + " - " + file.getAbsolutePath());
                    MercurialInterceptor.this.reScheduleRefresh(4000, newlyAddedRoot);
                    if (!this.hgFolders.containsKey(hgFolder) && hgFolder.isDirectory()) {
                        this.hgFolders.put(hgFolder, null);
                        this.refreshHgFolderTimestamp(hgFolder, hgFolder.lastModified());
                    }
                }
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            File file;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(MercurialInterceptor.this.refreshTask, Mercurial.STATUS_LOG, "MercurialInterceptor.refreshTask")) {
                return;
            }
            HashSet<File> files = new HashSet<File>(MercurialInterceptor.this.filesToRefresh.size());
            while ((file = (File)MercurialInterceptor.this.filesToRefresh.poll()) != null) {
                files.add(file);
            }
            MercurialInterceptor.this.cache.refreshAllRoots(files);
        }
    }
}

