/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.actions.AbstractInjectableAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class InspectInjectablesAtCaretAction
extends AbstractInjectableAction {
    private static final long serialVersionUID = -8870045479163815171L;
    private static final String INSPECT_INJACTABLES_AT_CARET = "inspect-injactables-at-caret";
    private static final String INSPECT_INJACTABLES_AT_CARET_POPUP = "inspect-injactables-at-caret-popup";

    public InspectInjectablesAtCaretAction() {
        super(NbBundle.getMessage(InspectInjectablesAtCaretAction.class, (String)INSPECT_INJACTABLES_AT_CARET));
    }

    @Override
    protected String getActionCommand() {
        return INSPECT_INJACTABLES_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return INSPECT_INJACTABLES_AT_CARET_POPUP;
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] variable, JTextComponent component, FileObject fileObject) {
        VariableElement var = WebBeansActionHelper.findVariable(model, variable);
        if (var == null) {
            return;
        }
        try {
            if (!model.isInjectionPoint(var)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotInjectionPoint"), 700);
                return;
            }
        }
        catch (InjectionPointDefinitionError e) {
            StatusDisplayer.getDefault().setStatusText(e.getMessage(), 700);
        }
        Result result = model.getInjectable(var, null);
        if (result == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_InjectableNotFound"), 700);
            return;
        }
        if (result instanceof Result.Error) {
            StatusDisplayer.getDefault().setStatusText(((Result.Error)result).getMessage(), 700);
        }
        if (result.getKind() == Result.ResultKind.DEFINITION_ERROR) {
            return;
        }
        CompilationController controller = model.getCompilationController();
        final InjectablesModel uiModel = new InjectablesModel(result, controller, metaModel);
        final String name = var.getSimpleName().toString();
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showInjectablesDialog(metaModel, model, variable, uiModel, name);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showInjectablesDialog((MetadataModel<WebBeansModel>)metaModel, null, variable, uiModel, name);
                }
            });
        }
    }
}

