/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class DefaultBindingTypeFilter<T extends Element>
extends Filter<T> {
    private WebBeansModelImplementation myImpl;

    DefaultBindingTypeFilter() {
    }

    static <T extends Element> DefaultBindingTypeFilter<T> get(Class<T> clazz) {
        DefaultBindingTypeFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new DefaultBindingTypeFilter<T>();
        }
        if (clazz.equals(TypeElement.class)) {
            return new DefaultBindingTypeFilter<T>();
        }
        return null;
    }

    void init(WebBeansModelImplementation impl) {
        this.myImpl = impl;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            Element specialized;
            Element element = (Element)iterator.next();
            List<? extends AnnotationMirror> allAnnotationMirrors = this.getImplementation().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
            HashSet<String> qualifierNames = new HashSet<String>();
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                TypeElement annotationElement = (TypeElement)annotationType.asElement();
                String annotationName = annotationElement.getQualifiedName().toString();
                if ("javax.enterprise.inject.Any".equals(annotationName) || "javax.inject.Named".equals(annotationName) || !this.isQualifier(annotationElement)) continue;
                qualifierNames.add(annotationName);
            }
            if (qualifierNames.contains("javax.enterprise.inject.Default") || element instanceof TypeElement && AnnotationObjectProvider.checkSuper((TypeElement)element, "javax.enterprise.inject.Default", this.getImplementation().getHelper()) != null || element instanceof ExecutableElement && (specialized = MemberCheckerFilter.getSpecialized(element, this.getImplementation(), "javax.enterprise.inject.Default")) != null || qualifierNames.size() == 0) continue;
            iterator.remove();
        }
    }

    private boolean isQualifier(TypeElement annotationElement) {
        return AnnotationObjectProvider.isQualifier(annotationElement, this.getImplementation().getHelper());
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }
}

