/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.groovy.support.customizer.GroovyCustomizerPanel;
import org.netbeans.modules.groovy.support.spi.GroovyFeature;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class GroovyProjectExtender
implements GroovyFeature {
    private static final String EXTENSIBLE_TARGET_NAME = "-pre-pre-compile";
    private static final String GROOVY_EXTENSION_ID = "groovy";
    private static final String GROOVY_BUILD_XSL = "org/netbeans/modules/groovy/support/resources/groovy-build.xsl";
    private static final String GROOVY_BUILD_65_XML = "org/netbeans/modules/groovy/support/resources/groovy-build-65.xml";
    private static final String GROOVY_BUILD_SAMPLE_65_XML = "org/netbeans/modules/groovy/support/resources/groovy-build-sample-65.xml";
    private static final String J2SE_PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    private static final String J2SE_EXCLUDE_PROPERTY = "build.classes.excludes";
    private static final String J2SE_DISABLE_COMPILE_ON_SAVE = "compile.on.save.unsupported.groovy";
    private static final String EXCLUSION_PATTERN = "**/*.groovy";
    private final Project project;
    private GroovyCustomizerPanel panel;

    public GroovyProjectExtender(Project project) {
        this.project = project;
    }

    public GroovyCustomizerPanel createPanel() {
        this.panel = new GroovyCustomizerPanel(this);
        return this.panel;
    }

    public GroovyCustomizerPanel getPanel() {
        return this.panel;
    }

    public boolean enableGroovy() {
        boolean result = this.addClasspath() && this.addExcludes() && this.addBuildScript() && this.addDisableCompileOnSaveProperty();
        return result;
    }

    public boolean disableGroovy() {
        boolean result = this.removeClasspath() && this.removeExcludes() && this.removeBuildScript() && this.removeDisableCompileOnSaveProperty();
        return result;
    }

    public void refreshBuildScript(boolean checkProjectXml) {
        if (this.isGroovyEnabled()) {
            GeneratedFilesHelper helper = new GeneratedFilesHelper(this.project.getProjectDirectory());
            URL stylesheet = this.getClass().getClassLoader().getResource(GROOVY_BUILD_XSL);
            try {
                FileObject buildScript;
                int flags = helper.getBuildScriptState("nbproject/groovy-build.xml", stylesheet);
                if ((4 & flags) != 0 && (8 & flags) != 0 && (0x10 & flags) != 0 && (GroovyProjectExtender.hasBuildScriptFrom65(this.project, GROOVY_BUILD_65_XML) || GroovyProjectExtender.hasBuildScriptFrom65(this.project, GROOVY_BUILD_SAMPLE_65_XML)) && (buildScript = this.project.getProjectDirectory().getFileObject("nbproject/groovy-build.xml")) != null) {
                    buildScript.delete();
                    helper.generateBuildScriptFromStylesheet("nbproject/groovy-build.xml", stylesheet);
                    return;
                }
                helper.refreshBuildScript("nbproject/groovy-build.xml", stylesheet, checkProjectXml);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public boolean isGroovyEnabled() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        return extender != null && extender.getExtension(GROOVY_EXTENSION_ID) != null;
    }

    private boolean addClasspath() {
        Library groovyAllLib = LibraryManager.getDefault().getLibrary("groovy-all");
        if (groovyAllLib != null) {
            try {
                SourceGroup[] sourceGroups;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{groovyAllLib}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private boolean removeClasspath() {
        Library groovyAllLib = LibraryManager.getDefault().getLibrary("groovy-all");
        if (groovyAllLib != null) {
            try {
                SourceGroup[] sourceGroups;
                Sources sources = ProjectUtils.getSources((Project)this.project);
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                    ProjectClassPathModifier.removeLibraries((Library[])new Library[]{groovyAllLib}, (FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (UnsupportedOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private boolean addExcludes() {
        try {
            EditableProperties props = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            String exclude = props.getProperty(J2SE_EXCLUDE_PROPERTY);
            if (!exclude.contains(EXCLUSION_PATTERN)) {
                props.setProperty(J2SE_EXCLUDE_PROPERTY, exclude + "," + EXCLUSION_PATTERN);
                GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, props);
            }
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private boolean removeExcludes() {
        try {
            EditableProperties props = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            String exclude = props.getProperty(J2SE_EXCLUDE_PROPERTY);
            if (exclude.contains(",**/*.groovy")) {
                exclude = exclude.replace(",**/*.groovy", "");
                props.setProperty(J2SE_EXCLUDE_PROPERTY, exclude);
                GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, props);
            }
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private boolean addBuildScript() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null && extender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = extender.getExtension(GROOVY_EXTENSION_ID);
            if (extension == null) {
                FileObject destDirFO = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    GeneratedFilesHelper helper = new GeneratedFilesHelper(this.project.getProjectDirectory());
                    URL stylesheet = this.getClass().getClassLoader().getResource(GROOVY_BUILD_XSL);
                    helper.generateBuildScriptFromStylesheet("nbproject/groovy-build.xml", stylesheet);
                    FileObject destFileFO = destDirFO.getFileObject("groovy-build", "xml");
                    extension = extender.addExtension(GROOVY_EXTENSION_ID, destFileFO);
                    extension.addDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean removeBuildScript() {
        AntBuildExtender extender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (extender != null && extender.getExtensibleTargets().contains(EXTENSIBLE_TARGET_NAME)) {
            AntBuildExtender.Extension extension = extender.getExtension(GROOVY_EXTENSION_ID);
            if (extension != null) {
                FileObject destDirFO = this.project.getProjectDirectory().getFileObject("nbproject");
                try {
                    FileObject fileToRemove;
                    extension.removeDependency(EXTENSIBLE_TARGET_NAME, "-groovy-init-macrodef-javac");
                    extender.removeExtension(GROOVY_EXTENSION_ID);
                    if (destDirFO != null && (fileToRemove = destDirFO.getFileObject("groovy-build.xml")) != null) {
                        fileToRemove.delete();
                    }
                    ProjectManager.getDefault().saveProject(this.project);
                    return true;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean addDisableCompileOnSaveProperty() {
        try {
            EditableProperties props = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            props.put(J2SE_DISABLE_COMPILE_ON_SAVE, "true");
            GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, props);
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private boolean removeDisableCompileOnSaveProperty() {
        try {
            EditableProperties props = GroovyProjectExtender.getEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH);
            props.remove((Object)J2SE_DISABLE_COMPILE_ON_SAVE);
            GroovyProjectExtender.storeEditableProperties(this.project, J2SE_PROJECT_PROPERTIES_PATH, props);
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private static EditableProperties getEditableProperties(final Project prj, final String propertiesPath) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        InputStream is = null;
                        ep = new EditableProperties();
                        try {
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private static void storeEditableProperties(final Project prj, final String propertiesPath, final EditableProperties ep) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    if (propertiesFo != null) {
                        OutputStream os = null;
                        try {
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasBuildScriptFrom65(Project project, String resource) throws IOException {
        FileObject fo = project.getProjectDirectory().getFileObject("nbproject/groovy-build.xml");
        if (fo == null) {
            return false;
        }
        URL xml65 = GroovyProjectExtender.class.getClassLoader().getResource(resource);
        URLConnection connection = xml65.openConnection();
        connection.setUseCaches(false);
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
        try {
            List lines65 = fo.asLines("UTF-8");
            for (String line65 : lines65) {
                String line = reader.readLine();
                if (line != null && line.equals(line65)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = reader.readLine() == null;
            return bl;
        }
        finally {
            reader.close();
        }
    }
}

