/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

final class NewCndClassPanelGUI
extends CndPanelGUI
implements ActionListener {
    private String sourceExt;
    private String headerExt;
    private final MIMEExtensions sourceExtensions = MIMEExtensions.get((String)"text/x-c++");
    private final MIMEExtensions headerExtensions = MIMEExtensions.get((String)"text/x-h");
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JComboBox cbHeaderExtension;
    private JComboBox cbSourceExtension;
    private JLabel classNameLbl;
    private JTextField classNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JButton headerBrowseButton;
    private JTextField headerFolderTextField;
    private JTextField headerTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    NewCndClassPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel) {
        super(project, folders);
        this.initComponents();
        this.initMnemonics();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.headerBrowseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.classNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.headerFolderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    @Override
    public void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = NewCndClassPanelGUI.getPreselectedGroup(this.folders, preselectedFolder);
        this.locationComboBox.setSelectedItem(preselectedGroup);
        String relPreselectedFolder = NewCndClassPanelGUI.getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder);
        this.folderTextField.setText(relPreselectedFolder);
        this.headerFolderTextField.setText(relPreselectedFolder);
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.sourceExt = this.sourceExtensions.getDefaultExtension();
        this.cbSourceExtension.setSelectedItem(this.sourceExt);
        this.headerExt = this.headerExtensions.getDefaultExtension();
        this.cbHeaderExtension.setSelectedItem(this.headerExt);
        if (template != null) {
            if (documentName == null) {
                FileObject currentFolder;
                String baseName;
                documentName = baseName = NewCndClassPanelGUI.getMessage("NewClassSuggestedName");
                FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder();
                if (currentFolder != null) {
                    documentName = documentName + NewCndClassPanelGUI.generateUniqueSuffix(currentFolder, NewCndClassPanelGUI.getFileName(documentName), this.sourceExt, this.headerExt);
                }
            }
            this.classNameTextField.setText(documentName);
            this.classNameTextField.selectAll();
        }
    }

    @Override
    public SourceGroup getTargetGroup() {
        Object selectedItem = this.locationComboBox.getSelectedItem();
        if (selectedItem == null && (selectedItem = this.locationComboBox.getItemAt(this.locationComboBox.getSelectedIndex())) == null) {
            selectedItem = this.locationComboBox.getItemAt(0);
        }
        return (SourceGroup)selectedItem;
    }

    @Override
    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    @Override
    public String getTargetName() {
        String documentName = this.getSourceFileName();
        if (documentName.length() == 0 || documentName.charAt(documentName.length() - 1) == '.') {
            return null;
        }
        return documentName;
    }

    private String createdFileName(JTextField field) {
        FileObject root = this.getTargetGroup().getRootFolder();
        String folderName = field.getText().trim();
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/");
        return createdFileName.replace('/', File.separatorChar);
    }

    @Override
    protected void updateCreatedFile() {
        String sourceFileName = this.createdFileName(this.folderTextField) + this.getSourceFileName();
        String headerFileName = this.createdFileName(this.headerFolderTextField) + this.getHeaderFileName();
        if (!sourceFileName.equals(this.fileTextField.getText()) || !headerFileName.equals(this.headerTextField.getText())) {
            this.fileTextField.setText(sourceFileName);
            this.headerTextField.setText(headerFileName);
            this.changeSupport.fireChange();
        }
    }

    public String getSourceFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.sourceExt;
    }

    private DefaultComboBoxModel getSourceExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.sourceExtensions.getValues()));
    }

    public String getHeaderFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.headerExt;
    }

    public String getHeaderFolder() {
        String folderName = this.headerFolderTextField.getText().trim();
        if (folderName.length() == 0) {
            return "";
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getHeaderName() {
        String documentName = this.getHeaderFileName();
        if (documentName.length() == 0 || documentName.charAt(documentName.length() - 1) == '.') {
            return null;
        }
        return documentName;
    }

    private DefaultComboBoxModel getHeaderExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.headerExtensions.getValues()));
    }

    private static String getFileName(String className) {
        return className;
    }

    public String getClassName() {
        return this.classNameTextField.getText().trim();
    }

    public String getHeaderExt() {
        return this.headerExt;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel5 = new JLabel();
        this.cbSourceExtension = new JComboBox();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.headerFolderTextField = new JTextField();
        this.headerBrowseButton = new JButton();
        this.jLabel7 = new JLabel();
        this.cbHeaderExtension = new JComboBox();
        this.jLabel6 = new JLabel();
        this.headerTextField = new JTextField();
        this.classNameLbl = new JLabel();
        this.classNameTextField = new JTextField();
        this.jLabel1.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        this.projectTextField.setEditable(false);
        this.projectTextField.setFocusable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        this.bottomPanelContainer.setFocusable(false);
        this.bottomPanelContainer.setMinimumSize(new Dimension(0, 10));
        this.bottomPanelContainer.setPreferredSize(new Dimension(0, 10));
        this.bottomPanelContainer.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_Sorce_File_Section")));
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        this.jLabel5.setLabelFor(this.cbSourceExtension);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Extension_Label"));
        this.cbSourceExtension.setModel(this.getSourceExtensionsModel());
        this.cbSourceExtension.setMinimumSize(new Dimension(100, 25));
        this.cbSourceExtension.setPreferredSize(new Dimension(100, 25));
        this.cbSourceExtension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCndClassPanelGUI.this.cbSourceExtensionActionPerformed(evt);
            }
        });
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        this.fileTextField.setEditable(false);
        this.fileTextField.setFocusable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.folderTextField, -1, 198, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.cbSourceExtension, -2, 94, -2).addComponent(this.fileTextField, GroupLayout.Alignment.TRAILING, -1, 291, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.jLabel2)).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSourceExtension, -2, -1, -2).addComponent(this.jLabel5)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap(17, Short.MAX_VALUE)));
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_folderTextField"));
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_browseButton"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_fileTextField"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_Heder_File_Section")));
        this.jLabel8.setLabelFor(this.headerFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Folder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.headerBrowseButton, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Browse_Button"));
        this.jLabel7.setLabelFor(this.cbHeaderExtension);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Extension_Label"));
        this.cbHeaderExtension.setModel(this.getHeaderExtensionsModel());
        this.cbHeaderExtension.setMinimumSize(new Dimension(100, 25));
        this.cbHeaderExtension.setPreferredSize(new Dimension(100, 25));
        this.cbHeaderExtension.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewCndClassPanelGUI.this.cbHeaderExtensionActionPerformed(evt);
            }
        });
        this.jLabel6.setLabelFor(this.headerTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_HeaderFile_Label"));
        this.headerTextField.setEditable(false);
        this.headerTextField.setFocusable(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.headerTextField, -1, 304, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(28, 28, 28)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel8).addGap(51, 51, 51).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.headerFolderTextField, -1, 206, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerBrowseButton)).addComponent(this.cbHeaderExtension, -2, -1, -2)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.headerBrowseButton).addComponent(this.headerFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.cbHeaderExtension, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.headerTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.classNameLbl.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.classNameLbl, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameLbl).addComponent(this.locationLabel).addComponent(this.jLabel1)).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.locationComboBox, GroupLayout.Alignment.LEADING, 0, 315, Short.MAX_VALUE).addComponent(this.classNameTextField, GroupLayout.Alignment.LEADING, -1, 315, Short.MAX_VALUE).addComponent(this.projectTextField, GroupLayout.Alignment.LEADING, -1, 315, Short.MAX_VALUE))).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.bottomPanelContainer, -1, 410, Short.MAX_VALUE).addComponent(this.targetSeparator, -1, 410, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classNameTextField, -2, -1, -2).addComponent(this.classNameLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectTextField, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, -1, -2).addComponent(this.locationLabel)).addGap(4, 4, 4).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetSeparator, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanelContainer, -1, 33, Short.MAX_VALUE).addContainerGap()));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_projectTextField"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_locationComboBox"));
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_documentNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void cbSourceExtensionActionPerformed(ActionEvent evt) {
        this.sourceExt = (String)this.cbSourceExtension.getSelectedItem();
        this.updateCreatedFile();
    }

    private void cbHeaderExtensionActionPerformed(ActionEvent evt) {
        this.headerExt = (String)this.cbHeaderExtension.getSelectedItem();
        this.updateCreatedFile();
    }

    private void initMnemonics() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            SourceGroup group = this.getTargetGroup();
            FileObject fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.headerBrowseButton == e.getSource()) {
            SourceGroup group = this.getTargetGroup();
            FileObject fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.headerFolderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.headerFolderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFile();
        }
    }
}

