/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HtmlCompletionOptionsPanel
extends JPanel {
    public static final String HTML_AUTOCOMPLETE_QUOTES_AFTER_EQS = "htmlAutocompleteQuotesAfterEQS";
    public static final boolean HTML_AUTOCOMPLETE_QUOTES_AFTER_EQS_DEFAULT = true;
    public static final String HTML_AUTOCOMPLETE_QUOTES = "htmlAutocompleteQuotes";
    public static final boolean HTML_AUTOCOMPLETE_QUOTES_DEFAULT = true;
    public static final String HTML_COMPLETION_END_TAG_ADTER_LT = "htmlCompletionOffersEndTagsAfterLt";
    public static final boolean HTML_COMPLETION_END_TAG_ADTER_LT_DEFAULT = false;
    public static final String HTML_COMPLETION_AUTOPOPUP_WINDOW = "htmlCompletionAutoPopupWindow";
    public static final boolean HTML_COMPLETION_AUTOPOPUP_WINDOW_DEFAULT = true;
    private Preferences preferences;
    private JCheckBox autoPopupCompletionWindow;
    private JCheckBox autocompleteQuotesAfterEQSCheckBox;
    private JCheckBox autocompleteQuotesCheckBox;
    private JCheckBox completionOffersEndTagAfterLt;

    private HtmlCompletionOptionsPanel(Preferences preferences) {
        this.preferences = preferences;
        this.initComponents();
        this.autocompleteQuotesAfterEQSCheckBox.setSelected(preferences.getBoolean(HTML_AUTOCOMPLETE_QUOTES_AFTER_EQS, true));
        this.autocompleteQuotesCheckBox.setSelected(preferences.getBoolean(HTML_AUTOCOMPLETE_QUOTES, true));
        this.completionOffersEndTagAfterLt.setSelected(preferences.getBoolean(HTML_COMPLETION_END_TAG_ADTER_LT, false));
        this.autoPopupCompletionWindow.setSelected(preferences.getBoolean(HTML_COMPLETION_AUTOPOPUP_WINDOW, true));
    }

    private void initComponents() {
        this.autocompleteQuotesAfterEQSCheckBox = new JCheckBox();
        this.autocompleteQuotesCheckBox = new JCheckBox();
        this.completionOffersEndTagAfterLt = new JCheckBox();
        this.autoPopupCompletionWindow = new JCheckBox();
        this.setPreferredSize(new Dimension(550, 400));
        this.autocompleteQuotesAfterEQSCheckBox.setText(NbBundle.getMessage(HtmlCompletionOptionsPanel.class, (String)"HtmlCompletionOptionsPanel.autocompleteQuotesAfterEQSCheckBox.text"));
        this.autocompleteQuotesAfterEQSCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlCompletionOptionsPanel.this.autocompleteQuotesAfterEQSCheckBoxActionPerformed(evt);
            }
        });
        this.autocompleteQuotesCheckBox.setText(NbBundle.getMessage(HtmlCompletionOptionsPanel.class, (String)"HtmlCompletionOptionsPanel.autocompleteQuotesCheckBox.text"));
        this.autocompleteQuotesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlCompletionOptionsPanel.this.autocompleteQuotesCheckBoxActionPerformed(evt);
            }
        });
        this.completionOffersEndTagAfterLt.setText(NbBundle.getMessage(HtmlCompletionOptionsPanel.class, (String)"HtmlCompletionOptionsPanel.completionOffersEndTagAfterLt.text"));
        this.completionOffersEndTagAfterLt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlCompletionOptionsPanel.this.completionOffersEndTagAfterLtActionPerformed(evt);
            }
        });
        this.autoPopupCompletionWindow.setText(NbBundle.getMessage(HtmlCompletionOptionsPanel.class, (String)"HtmlCompletionOptionsPanel.autoPopupCompletionWindow.text"));
        this.autoPopupCompletionWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlCompletionOptionsPanel.this.autoPopupCompletionWindowActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoPopupCompletionWindow).addComponent(this.autocompleteQuotesAfterEQSCheckBox).addComponent(this.autocompleteQuotesCheckBox).addComponent(this.completionOffersEndTagAfterLt)).addContainerGap(18, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.autoPopupCompletionWindow).addGap(2, 2, 2).addComponent(this.autocompleteQuotesAfterEQSCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autocompleteQuotesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completionOffersEndTagAfterLt).addContainerGap(289, Short.MAX_VALUE)));
    }

    private void autocompleteQuotesAfterEQSCheckBoxActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(HTML_AUTOCOMPLETE_QUOTES_AFTER_EQS, this.autocompleteQuotesAfterEQSCheckBox.isSelected());
    }

    private void autocompleteQuotesCheckBoxActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(HTML_AUTOCOMPLETE_QUOTES, this.autocompleteQuotesCheckBox.isSelected());
    }

    private void completionOffersEndTagAfterLtActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(HTML_COMPLETION_END_TAG_ADTER_LT, this.completionOffersEndTagAfterLt.isSelected());
    }

    private void autoPopupCompletionWindowActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(HTML_COMPLETION_AUTOPOPUP_WINDOW, this.autoPopupCompletionWindow.isSelected());
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    private static class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;
        private static final String CUSTOMIZER_NAME = "htmlCodeCompletionPreferencesCustomizer";

        private CodeCompletionPreferencesCustomizer(Preferences p) {
            this.preferences = p;
        }

        public String getId() {
            return CUSTOMIZER_NAME;
        }

        public String getDisplayName() {
            return CUSTOMIZER_NAME;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.java");
        }

        public JComponent getComponent() {
            return new HtmlCompletionOptionsPanel(this.preferences);
        }
    }
}

