/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.installations.BundledInstallation;
import org.openide.util.lookup.Lookups;

public class InstallationManager {
    private static Logger LOGGER = Logger.getLogger(InstallationManager.class.getName());
    private static ArrayList<Installation> INSTALLATIONS = null;
    private static final String INSTALLATION_PROVIDER_PATH = "Databases/MySQL/Installations";

    public static synchronized List<Installation> getInstallations(Collection loadedInstallations) {
        if (INSTALLATIONS == null) {
            BundledInstallation bundled = BundledInstallation.getDefault();
            if (bundled.isInstalled()) {
                ArrayList<Installation> bundledList = new ArrayList<Installation>();
                bundledList.add(bundled);
                return bundledList;
            }
            ArrayList<Installation> stackInstalls = new ArrayList<Installation>();
            ArrayList<Installation> stdInstalls = new ArrayList<Installation>();
            for (Installation installation : loadedInstallations) {
                if (installation.isStackInstall()) {
                    stackInstalls.add(installation);
                    continue;
                }
                stdInstalls.add(installation);
            }
            INSTALLATIONS = new ArrayList();
            INSTALLATIONS.addAll(stackInstalls);
            INSTALLATIONS.addAll(stdInstalls);
        }
        return INSTALLATIONS;
    }

    public static Installation detectInstallation() {
        CopyOnWriteArrayList<Installation> installationCopy = new CopyOnWriteArrayList<Installation>();
        Collection loadedInstallations = Lookups.forPath((String)INSTALLATION_PROVIDER_PATH).lookupAll(Installation.class);
        installationCopy.addAll(InstallationManager.getInstallations(loadedInstallations));
        for (Installation installation : installationCopy) {
            LOGGER.log(Level.FINE, "Looking for MySQL installation " + installation.getStartCommand()[0] + installation.getStartCommand()[1]);
            if (!installation.isInstalled()) continue;
            LOGGER.log(Level.FINE, "Installation is installed");
            return installation;
        }
        return null;
    }
}

