/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbPreferences;

public class JPDABreakpoint
extends Breakpoint {
    static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend;
    private String printText;
    private Collection<JPDABreakpointListener> breakpointListeners = new HashSet<JPDABreakpointListener>();
    private JPDADebugger session;
    private List<DebuggerEngine> engines = new ArrayList<DebuggerEngine>();

    JPDABreakpoint() {
        Preferences preferences = NbPreferences.forModule(((Object)((Object)this)).getClass()).node("debugging");
        int num = preferences.getInt("default.suspend.action", -1);
        if (num == -1) {
            Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
            num = p.getInt("BreakpointSuspend", 1);
        }
        switch (num) {
            case 0: {
                this.suspend = 0;
                break;
            }
            case 1: {
                this.suspend = 1;
                break;
            }
            case 2: {
                this.suspend = 2;
            }
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int s) {
        if (s == this.suspend) {
            return;
        }
        int old = this.suspend;
        this.suspend = s;
        this.firePropertyChange(PROP_SUSPEND, old, s);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean h) {
        if (h == this.hidden) {
            return;
        }
        boolean old = this.hidden;
        this.hidden = h;
        this.firePropertyChange(PROP_HIDDEN, old, h);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        if (printText.equals(this.printText)) {
            return;
        }
        String old = this.printText;
        this.printText = printText;
        this.firePropertyChange(PROP_PRINT_TEXT, old, printText);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    synchronized void setSession(JPDADebugger session) {
        this.session = session;
    }

    synchronized JPDADebugger getSession() {
        return this.session;
    }

    public synchronized void addJPDABreakpointListener(JPDABreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public synchronized void removeJPDABreakpointListener(JPDABreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    void fireJPDABreakpointChange(JPDABreakpointEvent event) {
        Iterator<JPDABreakpointListener> i = new HashSet<JPDABreakpointListener>(this.breakpointListeners).iterator();
        while (i.hasNext()) {
            i.next().breakpointReached(event);
        }
    }

    void enginePropertyChange(PropertyChangeEvent evt) {
        if (DebuggerEngine.class.getName().equals(evt.getPropertyName())) {
            DebuggerEngine oldEngine = (DebuggerEngine)evt.getOldValue();
            DebuggerEngine newEngine = (DebuggerEngine)evt.getNewValue();
            if (oldEngine != null) {
                this.engines.remove(oldEngine);
            }
            if (newEngine != null) {
                this.engines.add(newEngine);
            }
            this.firePropertyChange("groupProperties", null, null);
        }
    }

    DebuggerEngine[] getEngines() {
        if (this.engines.size() == 0) {
            return null;
        }
        return this.engines.toArray(new DebuggerEngine[0]);
    }

    static void fillFilesForClass(String className, List<FileObject> files) {
        int simpleNameIndex = className.lastIndexOf(46);
        int innerClassIndex = className.indexOf(36);
        if (innerClassIndex > 0) {
            className = className.substring(0, innerClassIndex);
        }
        String simpleClassName = className;
        if (simpleNameIndex > 0) {
            simpleClassName = className.substring(simpleNameIndex + 1);
        }
        Collection srcRoots = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
        for (FileObject root : srcRoots) {
            URL rootUrl;
            try {
                rootUrl = root.getURL();
            }
            catch (FileStateInvalidException fsie) {
                continue;
            }
            ClassPath cp = ClassPathSupport.createClassPath((URL[])new URL[]{rootUrl});
            ClasspathInfo ci = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)cp);
            Set names = ci.getClassIndex().getDeclaredTypes(simpleClassName, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle eh : names) {
                if (!className.equals(eh.getQualifiedName())) continue;
                FileObject f = SourceUtils.getFile((ElementHandle)eh, (ClasspathInfo)ci);
                files.add(f);
            }
        }
    }
}

