/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryException;
import org.netbeans.modules.db.sql.history.SQLHistoryModel;
import org.netbeans.modules.db.sql.history.SQLHistoryModelImpl;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SQLHistoryPanel
extends JPanel {
    public static final String SAVE_STATEMENTS_CLEARED = "";
    public static final int SAVE_STATEMENTS_MAX_LIMIT = 10000;
    public static final int TABLE_DATA_WIDTH_SQL = 125;
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPanel.class.getName());
    private static final FileObject USERDIR = FileUtil.getConfigRoot();
    private static final FileObject historyRoot = USERDIR.getFileObject("Databases/SQLHISTORY");
    private static Object[][] data;
    private Set<String> currentConnections = new HashSet<String>();
    private SQLHistoryView view;
    private JEditorPane editorPane;
    private Map<String, String> urlAliasMap = new HashMap<String, String>();
    private Map<String, String> aliasUrlMap = new HashMap<String, String>();
    private static RequestProcessor RP;
    private final RequestProcessor.Task initTask;
    private JComboBox connectionUrlComboBox;
    private JLabel inputWarningLabel;
    private JButton insertSQLButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField searchTextField;
    private JTable sqlHistoryTable;
    private JButton sqlLimitButton;
    private JLabel sqlLimitLabel;
    private JTextField sqlLimitTextField;

    public SQLHistoryPanel(JEditorPane editorPane) {
        this.editorPane = editorPane;
        this.view = new SQLHistoryView(new SQLHistoryModel(){

            @Override
            public void initialize() {
            }

            @Override
            public void setFilter(String filter) {
            }

            @Override
            public String getFilter() {
                return SQLHistoryPanel.SAVE_STATEMENTS_CLEARED;
            }

            @Override
            public List<SQLHistory> getSQLHistoryList() throws SQLHistoryException {
                return Collections.emptyList();
            }

            @Override
            public void setSQLHistoryList(List<SQLHistory> sqlHistoryList) {
            }
        });
        this.initSQLHistoryTableData();
        this.initComponents();
        this.setupSQLSaveLimit();
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                SQLHistoryPanel.this.lazyInit();
            }
        });
    }

    public void lazyInit() {
        this.view = new SQLHistoryView(new SQLHistoryModelImpl());
        for (DatabaseConnection existingConnection : ConnectionManager.getDefault().getConnections()) {
            this.urlAliasMap.put(existingConnection.getDatabaseURL(), existingConnection.getDisplayName());
            this.aliasUrlMap.put(existingConnection.getDisplayName(), existingConnection.getDatabaseURL());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLHistoryPanel.this.setWaitingState(false);
                SQLHistoryPanel.this.initSQLHistoryTableData();
                SQLHistoryPanel.this.initComponentData();
                SQLHistoryPanel.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window w = this.findWindowParent();
        if (w != null) {
            w.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    SQLHistoryPanel.this.setWaitingState(!SQLHistoryPanel.this.initTask.isFinished());
                }
            });
        }
    }

    private void setWaitingState(boolean waitingState) {
        boolean enabled = !waitingState;
        Container parent = this.getParent();
        JRootPane rootPane = this.getRootPane();
        if (parent != null) {
            parent.setEnabled(enabled);
        }
        if (rootPane != null) {
            if (enabled) {
                rootPane.setCursor(null);
            } else {
                rootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    private Window findWindowParent() {
        Container c = this;
        while (c != null) {
            if (!((c = c.getParent()) instanceof Window)) continue;
            return (Window)c;
        }
        return null;
    }

    private void setupSQLSaveLimit() {
        String savedLimit = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
        if (null != savedLimit && !savedLimit.equals(SAVE_STATEMENTS_CLEARED)) {
            this.sqlLimitTextField.setText(savedLimit);
        } else {
            this.sqlLimitTextField.setText("100");
            savedLimit = "100";
            NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", "100");
        }
    }

    private void initComponentData() {
        this.searchTextField.getDocument().addDocumentListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.sqlHistoryTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SQLTableTitle"));
        this.sqlHistoryTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DateTableTitle"));
        JTableHeader header = this.sqlHistoryTable.getTableHeader();
        header.addMouseListener(new ColumnListener());
        this.sqlHistoryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e)) {
                    SQLHistoryPanel.this.insertSQL();
                    e.consume();
                }
            }
        });
        this.connectionUrlComboBox.addActionListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.view.updateConnectionUrl();
    }

    private void initSQLHistoryTableData() {
        if (this.initTask == null || !this.initTask.isFinished()) {
            data = new Object[1][2];
            SQLHistoryPanel.data[0][0] = NbBundle.getMessage(SQLHistoryPanel.class, (String)"SQLHistoryPanel_PleaseWait");
            return;
        }
        List<String> sqlList = this.view.getSQLList(null);
        List<String> dateList = this.view.getDateList(null);
        data = new Object[sqlList.size()][2];
        int row = 0;
        for (String sql : sqlList) {
            int length = sql.trim().length();
            int maxLength = length > 125 ? 125 : length;
            SQLHistoryPanel.data[row][0] = sql.trim().substring(0, maxLength).replaceAll("\n", " ");
            ++row;
        }
        row = 0;
        for (String date : dateList) {
            SQLHistoryPanel.data[row][1] = date;
            ++row;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.connectionUrlComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.searchTextField = new JTextField();
        this.insertSQLButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sqlHistoryTable = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(SQLHistoryPanel.this.view.getSQLHistoryTooltipValue(rowIndex, vColIndex));
                }
                return c;
            }
        };
        this.sqlLimitLabel = new JLabel();
        this.sqlLimitTextField = new JTextField();
        this.sqlLimitButton = new JButton();
        this.inputWarningLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Connection"));
        this.connectionUrlComboBox.setRenderer(new ConnectionUrlRenderer());
        this.jLabel2.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Match"));
        this.searchTextField.setMinimumSize(new Dimension(20, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.insertSQLButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Insert"));
        this.insertSQLButton.setEnabled(false);
        this.insertSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.insertSQLButtonActionPerformed(evt);
            }
        });
        this.sqlHistoryTable.setModel(new HistoryTableModel());
        this.sqlHistoryTable.setGridColor(Color.lightGray);
        this.jScrollPane1.setViewportView(this.sqlHistoryTable);
        this.sqlHistoryTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_History"));
        this.sqlHistoryTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_History"));
        this.sqlLimitLabel.setLabelFor(this.sqlLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.sqlLimitLabel, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SqlLimit"));
        this.sqlLimitTextField.setText("100");
        this.sqlLimitTextField.setMinimumSize(new Dimension(18, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.sqlLimitButton, (String)NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ApplyButton"));
        this.sqlLimitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLHistoryPanel.this.sqlLimitButtonActionPerformed(evt);
            }
        });
        this.inputWarningLabel.setForeground(Color.red);
        this.inputWarningLabel.setFocusable(false);
        this.inputWarningLabel.setRequestFocusEnabled(false);
        this.inputWarningLabel.setVerifyInputWhenFocusTarget(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 655, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connectionUrlComboBox, 0, 306, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchTextField, -2, 147, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.insertSQLButton).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.inputWarningLabel, -1, 228, Short.MAX_VALUE).addGap(493, 493, 493)).addGroup(layout.createSequentialGroup().addComponent(this.sqlLimitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sqlLimitTextField, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sqlLimitButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.connectionUrlComboBox, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.insertSQLButton).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sqlLimitTextField, -2, -1, -2).addComponent(this.sqlLimitButton).addComponent(this.sqlLimitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputWarningLabel, -2, 26, -2))).addContainerGap()));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ASCN_ConnectionCombo"));
        this.connectionUrlComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_ConnectionCombo"));
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Match"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Match"));
        this.insertSQLButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Insert"));
        this.insertSQLButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Insert"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Save"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Save"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Apply"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Apply"));
    }

    private void insertSQLButtonActionPerformed(ActionEvent evt) {
        this.insertSQL();
    }

    private void sqlLimitButtonActionPerformed(ActionEvent evt) {
        this.verifySQLLimit();
    }

    private void insertSQL() {
        try {
            List<SQLHistory> sqlHistoryList = this.view.getCurrentSQLHistoryList();
            int i = 0;
            String sqlToInsert = SAVE_STATEMENTS_CLEARED;
            InsertSQLUtility insertUtility = new InsertSQLUtility();
            for (SQLHistory sqlHistory : sqlHistoryList) {
                if (this.sqlHistoryTable.isRowSelected(i)) {
                    sqlToInsert = sqlHistory.getSql().trim();
                    JEditorPane pane = (JEditorPane)EditorRegistry.lastFocusedComponent();
                    String mime = pane.getContentType();
                    if (mime.equals("text/x-sql")) {
                        this.editorPane = pane;
                    }
                    insertUtility.insert(sqlToInsert, this.editorPane);
                }
                ++i;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void verifySQLLimit() {
        String enteredLimit = this.sqlLimitTextField.getText();
        int iLimit = 0;
        if (enteredLimit.equals(SAVE_STATEMENTS_CLEARED)) {
            this.updateSaveLimitUponClear(iLimit);
            this.inputWarningLabel.setText(SAVE_STATEMENTS_CLEARED);
        } else {
            this.updateSaveLimitUponReset(enteredLimit);
        }
    }

    private void updateSaveLimitUponClear(int iLimit) {
        iLimit = 10000;
        List<SQLHistory> sqlHistoryList = new ArrayList<SQLHistory>();
        try {
            this.view.setSQLHistoryList(SQLHistoryPersistenceManager.getInstance().updateSQLSaved(iLimit, historyRoot));
            sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve(historyRoot);
            this.view.setCurrentSQLHistoryList(sqlHistoryList);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SQLHistoryException ex) {
            this.handleSQLHistoryException();
        }
        ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(sqlHistoryList);
        NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(iLimit));
        this.sqlLimitTextField.setText("100");
    }

    private void updateSaveLimitUponReset(String enteredLimit) {
        try {
            int iLimit = enteredLimit.trim().length() < 10 ? Integer.parseInt(enteredLimit) : 10001;
            String savedLimit = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
            if (iLimit < 0) {
                this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_TextInputWarningLabel"));
                if (savedLimit != null) {
                    this.sqlLimitTextField.setText(savedLimit);
                } else {
                    this.sqlLimitTextField.setText("100");
                }
            } else if (iLimit > 10000) {
                this.sqlLimitButton.setEnabled(true);
                this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_NumberInputWarningLabel"));
                if (savedLimit != null) {
                    this.sqlLimitTextField.setText(savedLimit);
                } else {
                    this.sqlLimitTextField.setText(SAVE_STATEMENTS_CLEARED);
                    this.sqlLimitTextField.setText("100");
                }
            } else {
                this.inputWarningLabel.setText(SAVE_STATEMENTS_CLEARED);
                if (SQLHistoryPersistenceManager.getInstance().updateSQLSaved(iLimit, historyRoot).size() > 0) {
                    List<SQLHistory> sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve(historyRoot);
                    this.view.setCurrentSQLHistoryList(sqlHistoryList);
                    ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(sqlHistoryList);
                    this.view.updateConnectionUrl();
                    NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(iLimit));
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SQLHistoryException ex) {
            this.handleSQLHistoryException();
        }
        catch (NumberFormatException ne) {
            this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_TextInputWarningLabel"));
            String savedLimit = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
            if (savedLimit != null) {
                this.sqlLimitTextField.setText(savedLimit);
            }
            this.sqlLimitTextField.setText("100");
        }
    }

    private void handleSQLHistoryException() {
        LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ErrorParsingSQLHistory"));
        List<SQLHistory> sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve();
        this.view.setCurrentSQLHistoryList(sqlHistoryList);
        ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(sqlHistoryList);
        this.view.updateConnectionUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Document doc) throws InterruptedException, Exception {
        Renderer r = new Renderer(doc);
        doc.render(r);
        Renderer renderer = r;
        synchronized (renderer) {
            while (!r.done) {
                r.wait();
                if (r.err == null) continue;
                throw new Exception(r.err);
            }
        }
        return r.result;
    }

    private static void adjustColumnPreferredWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            int maxwidth = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
            }
            TableColumn column = columnModel.getColumn(col);
            column.setPreferredWidth(maxwidth);
        }
    }

    private TableCellRenderer createDefaultRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? SQLHistoryPanel.SAVE_STATEMENTS_CLEARED : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return SQLHistoryPanel.this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }

    static /* synthetic */ Object[][] access$1902(Object[][] x0) {
        data = x0;
        return x0;
    }

    static {
        RP = new RequestProcessor(SQLHistoryPanel.class);
    }

    private class SQLComparator
    implements Comparator<SQLHistory> {
        protected int sortCol;
        protected boolean sortAsc;

        public SQLComparator(int sortCol, boolean sortAsc) {
            this.sortCol = sortCol;
            this.sortAsc = sortAsc;
        }

        @Override
        public int compare(SQLHistory sql1, SQLHistory sql2) {
            int result = 0;
            if (!(sql1 instanceof SQLHistory) || !(sql2 instanceof SQLHistory)) {
                return result;
            }
            SQLHistory sqlHistory1 = sql1;
            SQLHistory sqlHistory2 = sql2;
            switch (this.sortCol) {
                case 0: {
                    String s1 = sqlHistory1.getSql().trim().toLowerCase();
                    String s2 = sqlHistory2.getSql().trim().toLowerCase();
                    result = s1.compareTo(s2);
                    break;
                }
                case 1: {
                    Date d1 = sqlHistory1.getDate();
                    Date d2 = sqlHistory2.getDate();
                    result = d1.compareTo(d2);
                }
            }
            if (!this.sortAsc) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SQLComparator) {
                SQLComparator compObj = (SQLComparator)obj;
                return compObj.sortCol == this.sortCol && compObj.sortAsc == this.sortAsc;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + this.sortCol;
            hash = 17 * hash + (this.sortAsc ? 1 : 0);
            return hash;
        }
    }

    private class ColumnListener
    extends MouseAdapter {
        private ColumnListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int colModelIndex;
            HistoryTableModel model = (HistoryTableModel)SQLHistoryPanel.this.sqlHistoryTable.getModel();
            TableColumnModel colModel = SQLHistoryPanel.this.sqlHistoryTable.getColumnModel();
            int modelIndex = colModel.getColumn(colModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (model.sortCol == modelIndex) {
                model.sortAsc = !model.sortAsc;
            } else {
                model.sortCol = modelIndex;
            }
            model.sortData();
            SQLHistoryPanel.this.sqlHistoryTable.tableChanged(new TableModelEvent(model));
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
        }
    }

    private static final class ConnectionUrlRenderer
    extends DefaultListCellRenderer {
        private ConnectionUrlRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            component.setToolTipText((String)value);
            return component;
        }
    }

    private class InsertSQLUtility {
        public void insert(String s, JEditorPane target) throws BadLocationException {
            this.insert(s, target, false);
        }

        public void insert(String s, JEditorPane target, boolean reformat) throws BadLocationException {
            Document doc;
            if (s == null) {
                s = SQLHistoryPanel.SAVE_STATEMENTS_CLEARED;
            }
            if ((doc = target.getDocument()) != null) {
                this.insert(s, target, doc);
            }
        }

        private int insert(String s, JEditorPane target, Document doc) throws BadLocationException {
            int start = -1;
            try {
                Caret caret = target.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                doc.remove(p0, p1 - p0);
                start = caret.getDot();
                doc.insertString(start, s + ";\n", null);
            }
            catch (BadLocationException ble) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InsertAtLocationError") + ble);
            }
            return start;
        }
    }

    private static class Renderer
    implements Runnable {
        Document doc;
        String result;
        Throwable err;
        boolean done;

        Renderer(Document doc) {
            this.doc = doc;
        }

        @Override
        public synchronized void run() {
            try {
                this.result = this.doc.getText(0, this.doc.getLength());
            }
            catch (Throwable e) {
                this.err = e;
                Exceptions.printStackTrace((Throwable)e);
            }
            this.done = true;
            this.notify();
        }
    }

    private final class HistoryTableModel
    extends DefaultTableModel
    implements ActionListener,
    DocumentListener {
        List<String> sqlList;
        List<String> dateList;
        int sortCol = 1;
        boolean sortAsc = false;

        private HistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            if (SQLHistoryPanel.this.sqlHistoryTable.getSelectedRow() == -1) {
                SQLHistoryPanel.this.insertSQLButton.setEnabled(false);
            }
            return data.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            Object value = this.getValueAt(0, c);
            if (value == null) {
                return String.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (SQLHistoryPanel.this.sqlHistoryTable.isRowSelected(row)) {
                SQLHistoryPanel.this.insertSQLButton.setEnabled(true);
            }
            return data[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
        }

        public void adjustColumnPreferredWidths(JTable table) {
            TableColumnModel columnModel = table.getColumnModel();
            for (int col = 0; col < table.getColumnCount(); ++col) {
                int maxwidth = 0;
                for (int row = 0; row < table.getRowCount(); ++row) {
                    TableCellRenderer rend = table.getCellRenderer(row, col);
                    Object value = table.getValueAt(row, col);
                    Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                    maxwidth = Math.max(comp.getPreferredSize().width, maxwidth);
                }
                TableColumn column = columnModel.getColumn(col);
                column.setPreferredWidth(maxwidth);
                column.setHeaderRenderer(SQLHistoryPanel.this.createDefaultRenderer());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.processUpdate();
        }

        public void refreshTable(List<SQLHistory> sqlHistoryList) {
            int maxLength;
            int length;
            String url;
            if (SQLHistoryPanel.this.initTask == null) {
                return;
            }
            if (sqlHistoryList.size() > 0) {
                url = SQLHistoryPanel.this.connectionUrlComboBox.getSelectedItem().toString();
                if (SQLHistoryPanel.this.aliasUrlMap.containsKey(url)) {
                    url = (String)SQLHistoryPanel.this.aliasUrlMap.get(url);
                }
            } else {
                url = NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
            }
            this.sqlList = new ArrayList<String>();
            this.dateList = new ArrayList<String>();
            SQLHistoryPanel.this.connectionUrlComboBox.setToolTipText(url);
            for (SQLHistory sqlHistory : sqlHistoryList) {
                if (!url.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem")) && !url.equals(sqlHistory.getUrl())) continue;
                length = sqlHistory.getSql().trim().length();
                maxLength = length > 125 ? 125 : length;
                this.sqlList.add(sqlHistory.getSql().trim().substring(0, maxLength).replaceAll("\n", " "));
                this.dateList.add(DateFormat.getInstance().format(sqlHistory.getDate()));
            }
            SQLHistoryPanel.access$1902(null);
            SQLHistoryPanel.access$1902(new Object[this.sqlList.size()][2]);
            int row = 0;
            for (String sql : this.sqlList) {
                length = sql.trim().length();
                maxLength = length > 125 ? 125 : length;
                data[row][0] = sql.trim().substring(0, maxLength).replaceAll("\n", " ");
                ++row;
            }
            row = 0;
            for (String date : this.dateList) {
                data[row++][1] = date;
            }
            if (data.length > 0) {
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
            } else {
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
                SQLHistoryPanel.this.insertSQLButton.setEnabled(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.processUpdate();
        }

        private void processUpdate() {
            SQLHistoryPanel.this.view.setCurrentSQLHistoryList(SQLHistoryPanel.this.view.filterSQLHistoryList());
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
            SQLHistoryPanel.this.sqlHistoryTable.clearSelection();
            this.refreshTable(SQLHistoryPanel.this.view.getCurrentSQLHistoryList());
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        public List<SQLHistory> sortData() {
            List filteredSQLHistoryList = SQLHistoryPanel.this.view.filterSQLHistoryList();
            SQLComparator sqlComparator = new SQLComparator(this.sortCol, this.sortAsc);
            Collections.sort(filteredSQLHistoryList, sqlComparator);
            SQLHistoryPanel.this.view.setCurrentSQLHistoryList(filteredSQLHistoryList);
            this.refreshTable(filteredSQLHistoryList);
            return filteredSQLHistoryList;
        }
    }

    private class SQLHistoryView {
        private SQLHistoryModel model;
        List<SQLHistory> sqlHistoryList = new ArrayList<SQLHistory>();
        List<SQLHistory> currentSQLHistoryList = new ArrayList<SQLHistory>();
        public static final String MATCH_EMPTY = "";

        public SQLHistoryView(SQLHistoryModel model) {
            this.model = model;
            this.init();
        }

        private void init() {
            try {
                this.sqlHistoryList = this.model.getSQLHistoryList();
                this.currentSQLHistoryList = this.model.getSQLHistoryList();
            }
            catch (SQLHistoryException ex) {
                LOGGER.log(Level.INFO, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ErrorParsingSQLHistory"), ex);
                this.sqlHistoryList = SQLHistoryPersistenceManager.getInstance().retrieve();
                this.setCurrentSQLHistoryList(this.sqlHistoryList);
            }
        }

        public void setCurrentSQLHistoryList(List<SQLHistory> sqlHistoryList) {
            this.currentSQLHistoryList = sqlHistoryList;
        }

        public List<SQLHistory> getCurrentSQLHistoryList() {
            return this.currentSQLHistoryList;
        }

        public List<SQLHistory> getSQLHistoryList() {
            return this.sqlHistoryList;
        }

        public void setSQLHistoryList(List<SQLHistory> sqlHistoryList) {
            this.sqlHistoryList = sqlHistoryList;
        }

        public String getSQLHistoryTooltipValue(int row, int col) {
            List<SQLHistory> sqlHistoryListForTooltip = SQLHistoryPanel.this.view.getCurrentSQLHistoryList();
            if (sqlHistoryListForTooltip != null && row < sqlHistoryListForTooltip.size()) {
                if (col == 0) {
                    String sqlRow = sqlHistoryListForTooltip.get(row).getSql().trim();
                    while (sqlRow.indexOf("\n") != -1) {
                        sqlRow = this.replace(sqlRow, "\n", "<br>");
                    }
                    return "<html>" + sqlRow + "</html>";
                }
                return DateFormat.getInstance().format(sqlHistoryListForTooltip.get(row).getDate());
            }
            return null;
        }

        public String replace(String target, String from, String to) {
            int start = target.indexOf(from);
            if (start == -1) {
                return target;
            }
            int lf = from.length();
            char[] targetChars = target.toCharArray();
            StringBuilder buffer = new StringBuilder();
            int copyFrom = 0;
            while (start != -1) {
                buffer.append(targetChars, copyFrom, start - copyFrom);
                buffer.append(to);
                copyFrom = start + lf;
                start = target.indexOf(from, copyFrom);
            }
            buffer.append(targetChars, copyFrom, targetChars.length - copyFrom);
            return buffer.toString();
        }

        public List<String> getSQLList(List<SQLHistory> sqlHistoryList) {
            ArrayList<String> sqlList = new ArrayList<String>();
            if (sqlHistoryList == null) {
                sqlHistoryList = this.getSQLHistoryList();
            }
            for (SQLHistory sqlHistory : sqlHistoryList) {
                String sql = sqlHistory.getSql();
                if (sqlList.contains(sql)) continue;
                sqlList.add(sql);
            }
            return sqlList;
        }

        public List<String> getDateList(List<SQLHistory> sqlHistoryList) {
            ArrayList<String> dateList = new ArrayList<String>();
            ArrayList<String> sqlList = new ArrayList<String>();
            if (sqlHistoryList == null) {
                sqlHistoryList = this.getSQLHistoryList();
            }
            for (SQLHistory sqlHistory : sqlHistoryList) {
                String date = DateFormat.getInstance().format(sqlHistory.getDate());
                String sql = sqlHistory.getSql();
                if (sqlList.contains(sql)) continue;
                sqlList.add(sql);
                dateList.add(date);
            }
            return dateList;
        }

        public void updateConnectionUrl() {
            SQLHistoryPanel.this.currentConnections.clear();
            String defaultSelectedItem = NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem");
            SQLHistoryPanel.this.currentConnections.add(defaultSelectedItem);
            for (SQLHistory sqlHistory : this.sqlHistoryList) {
                String url = sqlHistory.getUrl();
                if (SQLHistoryPanel.this.urlAliasMap.containsKey(url)) {
                    SQLHistoryPanel.this.currentConnections.add(SQLHistoryPanel.this.urlAliasMap.get(url));
                    continue;
                }
                SQLHistoryPanel.this.currentConnections.add(url);
            }
            SQLHistoryPanel.this.connectionUrlComboBox.setModel(new DefaultComboBoxModel<Object>(SQLHistoryPanel.this.currentConnections.toArray()));
            SQLHistoryPanel.this.connectionUrlComboBox.setSelectedItem(defaultSelectedItem);
            SQLHistoryPanel.this.connectionUrlComboBox.revalidate();
        }

        private List<SQLHistory> filterSQLHistoryList() {
            ArrayList<SQLHistory> filteredSqlHistoryList = new ArrayList<SQLHistory>();
            String match = SQLHistoryPanel.this.searchTextField.getText();
            String url = (String)SQLHistoryPanel.this.connectionUrlComboBox.getSelectedItem();
            if (SQLHistoryPanel.this.aliasUrlMap.containsKey(url)) {
                url = (String)SQLHistoryPanel.this.aliasUrlMap.get(url);
            }
            for (SQLHistory sqlHistory : this.sqlHistoryList) {
                if (!sqlHistory.getUrl().equals(url) && !url.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem"))) continue;
                if (!match.equals("")) {
                    if (sqlHistory.getSql().toLowerCase().indexOf(match.toLowerCase()) == -1) continue;
                    filteredSqlHistoryList.add(sqlHistory);
                    continue;
                }
                filteredSqlHistoryList.add(sqlHistory);
            }
            this.currentSQLHistoryList = filteredSqlHistoryList;
            return filteredSqlHistoryList;
        }
    }
}

