/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class TestsuiteNodeChildren
extends Children.Keys<Testcase> {
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private final Report report;
    private int filterMask;
    private boolean live = true;

    TestsuiteNodeChildren(Report report, int filterMask) {
        this.report = report;
        this.filterMask = filterMask;
    }

    protected void addNotify() {
        super.addNotify();
        if (this.live) {
            this.setKeys(this.report.getTests());
        }
    }

    protected void removeNotify() {
        super.removeNotify();
        Set emptySet = Collections.emptySet();
        this.setKeys(emptySet);
    }

    protected Node[] createNodes(Testcase testcase) {
        if (testcase.getStatus().isMaskApplied(this.filterMask)) {
            return EMPTY_NODE_ARRAY;
        }
        return new Node[]{testcase.getSession().getNodeFactory().createTestMethodNode(testcase, this.report.getProject())};
    }

    void setFilterMask(int filterMask) {
        int diff = this.filterMask ^ filterMask;
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        if (this.isInitialized()) {
            for (Testcase testcase : this.report.getTests()) {
                if (!testcase.getStatus().isMaskApplied(diff)) continue;
                this.refreshKey(testcase);
            }
        }
    }
}

