/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.CompilerProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.APIAccessor;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;

public final class CompilerSetImpl
extends CompilerSet {
    private final CompilerFlavor flavor;
    private String name;
    private final String displayName;
    private boolean autoGenerated;
    private boolean isDefault;
    private final String directory;
    private final ArrayList<Tool> tools = new ArrayList();
    private CompilerProvider compilerProvider;
    private Map<ToolKind, String> pathSearch;
    private boolean isSunStudioDefault;
    private Charset charset;

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isUrlPointer() {
        if (this.getDirectory() == null || this.getDirectory().length() == 0) {
            return this.flavor.getToolchainDescriptor().getUpdateCenterUrl() != null && this.flavor.getToolchainDescriptor().getModuleID() != null;
        }
        return false;
    }

    void setAsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void unsetDefault() {
        this.isDefault = false;
    }

    public CompilerSetImpl(CompilerFlavor flavor, String directory, String name) {
        this.directory = directory == null ? "" : directory;
        this.compilerProvider = CompilerProvider.getInstance();
        this.name = name != null && !name.isEmpty() ? name : flavor.toString();
        this.displayName = flavor.getToolchainDescriptor().getDisplayName();
        this.flavor = flavor;
        this.autoGenerated = true;
        this.isDefault = false;
    }

    public CompilerSetImpl(int platform) {
        this.directory = "";
        this.name = "None";
        this.flavor = CompilerFlavorImpl.getUnknown(platform);
        this.displayName = NbBundle.getMessage(CompilerSetImpl.class, (String)"LBL_EmptyCompilerSetDisplayName");
        this.compilerProvider = CompilerProvider.getInstance();
        this.autoGenerated = true;
        this.isDefault = false;
    }

    public CompilerSetImpl createCopy() {
        return this.createCopy(this.flavor, this.getDirectory(), this.name, this.isAutoGenerated(), this.charset, true);
    }

    public CompilerSetImpl createCopy(CompilerFlavor flavor, String directory, String name, Boolean autoGenerated, Charset charset, boolean keepToolFlavor) {
        flavor = flavor == null ? this.flavor : flavor;
        directory = directory == null ? this.getDirectory() : directory;
        name = name == null ? this.name : name;
        CompilerSetImpl copy = new CompilerSetImpl(flavor, directory, name);
        autoGenerated = autoGenerated == null ? this.isAutoGenerated() : autoGenerated.booleanValue();
        copy.setAutoGenerated(autoGenerated);
        copy.setEncoding(charset);
        for (Tool tool : this.getTools()) {
            CompilerFlavor toolFlavor = keepToolFlavor ? tool.getFlavor() : flavor;
            copy.addTool(tool.createCopy(toolFlavor));
        }
        return copy;
    }

    protected static CompilerSet createEmptyCompilerSet(int platform) {
        return new CompilerSetImpl(platform);
    }

    @Override
    public CompilerFlavor getCompilerFlavor() {
        return this.flavor;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    Tool addTool(ExecutionEnvironment env, String name, String path, ToolKind kind, CompilerFlavor aFlavor) {
        Tool tool;
        if (this.findTool(kind) != null) {
            return null;
        }
        if (aFlavor == null) {
            aFlavor = this.getCompilerFlavor();
        }
        if (!this.tools.contains(tool = this.compilerProvider.createCompiler(env, aFlavor, kind, name, kind.getDisplayName(), path))) {
            this.tools.add(tool);
        }
        APIAccessor.get().setCompilerSet(tool, this);
        return tool;
    }

    void addTool(Tool tool) {
        this.tools.add(tool);
        APIAccessor.get().setCompilerSet(tool, this);
    }

    Tool addNewTool(ExecutionEnvironment env, String name, String path, ToolKind kind, CompilerFlavor aFlavor) {
        if (aFlavor == null) {
            aFlavor = this.getCompilerFlavor();
        }
        Tool tool = this.compilerProvider.createCompiler(env, aFlavor, kind, name, kind.getDisplayName(), path);
        this.tools.add(tool);
        APIAccessor.get().setCompilerSet(tool, this);
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tool getTool(ToolKind kind) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != kind) continue;
            return tool;
        }
        CndUtils.assertFalse((boolean)true, (String)"Should not be here, cuz we should create empty tools in CompilerSetManager");
        Tool t = this.compilerProvider.createCompiler(ExecutionEnvironmentFactory.getLocal(), this.getCompilerFlavor(), kind, "", kind.getDisplayName(), "");
        APIAccessor.get().setCompilerSet(t, this);
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            this.tools.add(t);
        }
        return t;
    }

    @Override
    public Tool findTool(ToolKind kind) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != kind) continue;
            return tool;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tool> getTools() {
        ArrayList<Tool> arrayList = this.tools;
        synchronized (arrayList) {
            return (List)this.tools.clone();
        }
    }

    void addPathCandidate(ToolKind tool, String path) {
        if (this.pathSearch == null) {
            this.pathSearch = new HashMap<ToolKind, String>();
        }
        this.pathSearch.put(tool, path);
    }

    String getPathCandidate(ToolKind tool) {
        if (this.pathSearch == null) {
            return null;
        }
        return this.pathSearch.get(tool);
    }

    void setSunStudioDefault(boolean isSunStudioDefault) {
        this.isSunStudioDefault = isSunStudioDefault;
    }

    boolean isSunStudioDefault() {
        return this.isSunStudioDefault;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Charset getEncoding() {
        if (this.charset == null) {
            if (this.flavor != null && this.flavor.isSunStudioCompiler()) {
                this.charset = Charset.defaultCharset();
            }
            if (this.charset == null) {
                this.charset = Charset.forName("UTF-8");
                if (this.charset == null) {
                    this.charset = Charset.defaultCharset();
                }
            }
        }
        return this.charset;
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    public static class UnknownToolchainDescriptor
    implements ToolchainManager.ToolchainDescriptor {
        @Override
        public String getFileName() {
            return "";
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public String[] getFamily() {
            return new String[0];
        }

        @Override
        public String[] getPlatforms() {
            return new String[0];
        }

        @Override
        public String getUpdateCenterUrl() {
            return null;
        }

        @Override
        public String getUpdateCenterDisplayName() {
            return null;
        }

        @Override
        public String getUpgradeUrl() {
            return null;
        }

        @Override
        public String getModuleID() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public String getDriveLetterPrefix() {
            return "/";
        }

        @Override
        public List<ToolchainManager.BaseFolder> getBaseFolders() {
            return Collections.emptyList();
        }

        @Override
        public List<ToolchainManager.BaseFolder> getCommandFolders() {
            return Collections.emptyList();
        }

        @Override
        public String getQmakeSpec() {
            return "";
        }

        @Override
        public ToolchainManager.CompilerDescriptor getC() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getCpp() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getFortran() {
            return null;
        }

        @Override
        public ToolchainManager.CompilerDescriptor getAssembler() {
            return null;
        }

        @Override
        public ToolchainManager.ScannerDescriptor getScanner() {
            return null;
        }

        @Override
        public ToolchainManager.LinkerDescriptor getLinker() {
            return new ToolchainManager.LinkerDescriptor(){

                @Override
                public String getLibraryPrefix() {
                    return "";
                }

                @Override
                public String getLibrarySearchFlag() {
                    return "";
                }

                @Override
                public String getDynamicLibrarySearchFlag() {
                    return "";
                }

                @Override
                public String getLibraryFlag() {
                    return "";
                }

                @Override
                public String getPICFlag() {
                    return "";
                }

                @Override
                public String getStaticLibraryFlag() {
                    return "";
                }

                @Override
                public String getDynamicLibraryFlag() {
                    return "";
                }

                @Override
                public String getDynamicLibraryBasicFlag() {
                    return "";
                }

                @Override
                public String getOutputFileFlag() {
                    return "";
                }

                @Override
                public String getStripFlag() {
                    return "";
                }

                @Override
                public String getPreferredCompiler() {
                    return "";
                }
            };
        }

        @Override
        public ToolchainManager.MakeDescriptor getMake() {
            return null;
        }

        @Override
        public Map<String, List<String>> getDefaultLocations() {
            return Collections.emptyMap();
        }

        @Override
        public ToolchainManager.DebuggerDescriptor getDebugger() {
            return null;
        }

        @Override
        public String getMakefileWriter() {
            return null;
        }

        @Override
        public ToolchainManager.QMakeDescriptor getQMake() {
            return null;
        }

        @Override
        public ToolchainManager.CMakeDescriptor getCMake() {
            return null;
        }
    }
}

