/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.SPIAccessor;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;

public final class CompilerSetManagerEvents {
    private static final Map<ExecutionEnvironment, CompilerSetManagerEvents> map;
    private final ExecutionEnvironment executionEnvironment;
    private boolean isCodeModelInfoReady;
    private List<Runnable> tasks = new ArrayList<Runnable>();

    public static synchronized CompilerSetManagerEvents get(ExecutionEnvironment env) {
        CompilerSetManagerEvents instance = map.get(env);
        if (instance == null) {
            instance = new CompilerSetManagerEvents(env);
            map.put(env, instance);
        }
        return instance;
    }

    public void runProjectReadiness(NamedRunnable task) {
        if (this.executionEnvironment.isLocal() || this.isCodeModelInfoReady) {
            task.run();
        } else {
            this.tasks.add((Runnable)task);
            ServerRecord record = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
            if (record.isOffline()) {
                ConnectionNotifier.addTask((ExecutionEnvironment)this.executionEnvironment, (ConnectionNotifier.NamedRunnable)new ConnectionNotifier.NamedRunnable(task.getName()){

                    protected void runImpl() {
                    }
                });
            }
        }
    }

    private CompilerSetManagerEvents(ExecutionEnvironment env) {
        this.executionEnvironment = env;
        this.isCodeModelInfoReady = ((CompilerSetManagerImpl)CompilerSetManager.get(this.executionEnvironment)).isComplete();
    }

    private void runTasks() {
        this.isCodeModelInfoReady = true;
        if (this.tasks != null) {
            for (Runnable task : this.tasks) {
                task.run();
            }
        }
        this.tasks = null;
    }

    static {
        SPIAccessor.register(new SPIAccessorImpl());
        map = new HashMap<ExecutionEnvironment, CompilerSetManagerEvents>();
    }

    private static final class SPIAccessorImpl
    extends SPIAccessor {
        private SPIAccessorImpl() {
        }

        @Override
        public void runTasks(CompilerSetManagerEvents event) {
            event.runTasks();
        }

        @Override
        public CompilerSetManagerEvents createEvent(ExecutionEnvironment env) {
            return new CompilerSetManagerEvents(env);
        }

        @Override
        public void add(ExecutionEnvironment env, CompilerSet cs) {
            ((CompilerSetManagerImpl)CompilerSetManagerImpl.get(env)).add(cs);
        }

        @Override
        public void remove(ExecutionEnvironment env, CompilerSet cs) {
            ((CompilerSetManagerImpl)CompilerSetManagerImpl.get(env)).remove(cs);
        }
    }
}

