/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.servlet.ServletNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ServletsNode
extends ContainerNode {
    private static final String SERVLETS_STRING = NbBundle.getMessage(ServletsNode.class, (String)"ServletsNode_ServletsString");

    public ServletsNode(ContainerNode parent) {
        super(SERVLETS_STRING, (Icon)Utils.PACKAGE_ICON, parent);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    private static class Children
    extends GreedySelectorChildren<ServletsNode> {
        private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();

        public Children() {
            this.scope.add(ClassIndex.SearchScope.SOURCE);
            this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
        }

        protected List<SelectorNode> prepareChildren(ServletsNode parent) {
            HashSet<SelectorNode> servlets = new HashSet<SelectorNode>();
            try {
                Project project = (Project)parent.getLookup().lookup(Project.class);
                ClasspathInfo cpInfo = ProjectUtilities.getClasspathInfo((Project)project);
                Collection<FileObject> dds = WebProjectUtils.getDeploymentDescriptorFileObjects(project, true);
                for (FileObject dd : dds) {
                    this.enumerateServlets(cpInfo, parent, dd, servlets);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return new ArrayList<SelectorNode>(servlets);
        }

        private void enumerateServlets(final ClasspathInfo cpInfo, final ServletsNode parent, FileObject dd, final Collection<SelectorNode> servlets) throws IllegalArgumentException, IOException {
            final WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
            final HashMap<String, String> servlet2class = new HashMap<String, String>();
            for (Servlet servlet : webApp.getServlet()) {
                servlet2class.put(servlet.getServletName(), servlet.getServletClass());
            }
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    for (ServletMapping mapping : webApp.getServletMapping()) {
                        TypeElement type;
                        String clazz = (String)servlet2class.get(mapping.getServletName());
                        TypeElement typeElement = type = clazz != null ? controller.getElements().getTypeElement(clazz) : null;
                        if (type == null) continue;
                        servlets.add(new ServletNode(cpInfo, type, mapping.getServletName(), mapping.getUrlPattern(), parent));
                    }
                }
            }, true);
        }
    }
}

