/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public enum ServerDetails {
    GLASSFISH_SERVER_3(NbBundle.getMessage(ServerDetails.class, (String)"STR_3_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6", new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, new String[]{"lib" + File.separator + "dtds" + File.separator + "glassfish-web-app_3_0-1.dtd"}, 300, "http://download.java.net/glassfish/3.0.1/release/glassfish-3.0.1-ml.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post69v3.txt"),
    GLASSFISH_SERVER_3_1(NbBundle.getMessage(ServerDetails.class, (String)"STR_31_SERVER_NAME", (Object[])new Object[0]), "deployer:gfv3ee6wc", new String[]{"lib" + File.separator + "dtds" + File.separator + "glassfish-web-app_3_0-1.dtd"}, new String[0], 310, "http://download.java.net/glassfish/3.1/release/glassfish-3.1.zip?nbretriever=fallback", "http://serverplugins.netbeans.org/glassfishv3/post69v3-1.txt");

    private String displayName;
    private String uriFragment;
    private String indirectUrl;
    private String directUrl;
    private String[] requiredFiles;
    private String[] excludedFiles;
    private int versionInt;

    public static int getVersionFromInstallDirectory(File glassfishDir) {
        ServerDetails sd = null;
        if (GLASSFISH_SERVER_3_1.isInstalledInDirectory(glassfishDir)) {
            sd = GLASSFISH_SERVER_3_1;
        } else if (GLASSFISH_SERVER_3.isInstalledInDirectory(glassfishDir)) {
            sd = GLASSFISH_SERVER_3;
        }
        return null == sd ? -1 : sd.getVersion();
    }

    public static int getVersionFromDomainXml(File domainXml) throws IllegalStateException {
        if (null == domainXml || !domainXml.isFile() || !domainXml.canRead()) {
            return -1;
        }
        return ServerDetails.hasDefaultConfig(domainXml) ? GLASSFISH_SERVER_3_1.getVersion() : GLASSFISH_SERVER_3.getVersion();
    }

    private static boolean hasDefaultConfig(File domainXml) throws IllegalStateException {
        DomainParser dp = new DomainParser();
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/configs/config", dp));
        TreeParser.readXml(domainXml, paths);
        return dp.hasDefaultConfig();
    }

    private ServerDetails(String displayName, String uriFragment, String[] requiredFiles, String[] excludedFiles, int versionInt, String directUrl, String indirectUrl) {
        this.displayName = displayName;
        this.uriFragment = uriFragment;
        this.indirectUrl = indirectUrl;
        this.directUrl = directUrl;
        this.requiredFiles = requiredFiles;
        this.excludedFiles = excludedFiles;
        this.versionInt = versionInt;
    }

    public String toString() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragment;
    }

    public int getVersion() {
        return this.versionInt;
    }

    public boolean isInstalledInDirectory(File glassfishDir) {
        boolean badFile = false;
        if (glassfishDir != null && glassfishDir.canRead() && glassfishDir.isDirectory()) {
            File descriminatorFile;
            for (String s : this.requiredFiles) {
                descriminatorFile = new File(glassfishDir, s);
                if (descriminatorFile.exists()) continue;
                badFile = true;
            }
            for (String s : this.excludedFiles) {
                descriminatorFile = new File(glassfishDir, s);
                if (!descriminatorFile.exists()) continue;
                badFile = true;
            }
        } else {
            badFile = true;
        }
        return !badFile;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public String getIndirectUrl() {
        return this.indirectUrl;
    }

    static class DomainParser
    extends TreeParser.NodeReader {
        private boolean hasDefaultConfig = false;

        DomainParser() {
        }

        private boolean hasDefaultConfig() {
            return this.hasDefaultConfig;
        }

        @Override
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            if ("default-config".equals(name)) {
                this.hasDefaultConfig = true;
            }
        }
    }
}

