/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.GotoControllerAction;
import org.netbeans.modules.groovy.grailsproject.actions.GotoDomainClassAction;
import org.netbeans.modules.groovy.grailsproject.actions.GotoViewAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class NavigationSupport {
    private static final String GSP_MIME_TYPE = "text/x-gsp";
    private static final Logger LOG = Logger.getLogger(NavigationSupport.class.getName());

    public static boolean isActionEnabled(AbstractAction caller) {
        JTextComponent component = Utilities.getFocusedComponent();
        String fileName = NavigationSupport.getTargetFilename(caller, component);
        return fileName != null && new File(fileName).canRead();
    }

    private static DataObject getDataObjectFromComponent(JTextComponent sourceComponent) {
        if (sourceComponent == null) {
            LOG.log(Level.FINEST, "JTextComponent == null");
            return null;
        }
        Document doc = sourceComponent.getDocument();
        if (doc == null) {
            LOG.log(Level.FINEST, "Document == null");
            return null;
        }
        return NbEditorUtilities.getDataObject((Document)doc);
    }

    private static GrailsProject getOwningProject(FileObject fo) {
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj instanceof GrailsProject) {
            return (GrailsProject)prj;
        }
        return null;
    }

    private static String getTargetFilename(AbstractAction caller, JTextComponent sourceComponent) {
        String targetName;
        LOG.log(Level.FINEST, "openArtifact()");
        DataObject dob = NavigationSupport.getDataObjectFromComponent(sourceComponent);
        if (dob == null) {
            LOG.log(Level.FINEST, "DataObject == null");
            return null;
        }
        String sourceName = dob.getName();
        FileObject fo = dob.getPrimaryFile();
        if (fo == null) {
            LOG.log(Level.FINEST, "FileObject == null");
            return null;
        }
        LOG.log(Level.FINEST, "Source Name : {0}", sourceName);
        GrailsProject prj = NavigationSupport.getOwningProject(fo);
        if (prj == null) {
            LOG.log(Level.FINEST, "Not a grails-project");
            return null;
        }
        String mimetype = fo.getMIMEType();
        if (!mimetype.equals("text/x-groovy") && !mimetype.equals(GSP_MIME_TYPE)) {
            LOG.log(Level.FINEST, "Not a groovy mimetype : {0}", mimetype);
            return null;
        }
        if (mimetype.equals(GSP_MIME_TYPE)) {
            String parentName = fo.getParent().getName();
            targetName = parentName.substring(0, 1).toUpperCase() + parentName.substring(1);
        } else {
            targetName = sourceName;
        }
        ActionType target = NavigationSupport.actionToType(caller);
        String ret = NavigationSupport.getTargetPath(target, prj, targetName);
        FileObject artifactFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(ret)));
        if (fo.equals(artifactFile)) {
            return null;
        }
        return ret;
    }

    public static void openArtifact(AbstractAction caller, JTextComponent sourceComponent) {
        String fileName = NavigationSupport.getTargetFilename(caller, sourceComponent);
        FileObject artifactFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fileName)));
        if (artifactFile != null && artifactFile.isValid()) {
            LOG.log(Level.FINEST, "Open File : {0}", FileUtil.getFileDisplayName((FileObject)artifactFile));
            NbUtilities.open((FileObject)artifactFile, (int)1, (String)"");
        } else {
            LOG.log(Level.FINEST, "File is either null or invalid : {0}", fileName);
        }
    }

    private static String getTargetPath(ActionType type, GrailsProject prj, String filename) {
        String GRAILS_APP_DIR = "grails-app";
        String BASE_DIR = FileUtil.getFileDisplayName((FileObject)prj.getProjectDirectory()) + File.separator + GRAILS_APP_DIR + File.separator;
        if (filename.endsWith("Controller")) {
            filename = filename.replaceAll("Controller$", "");
        }
        switch (type) {
            case CONTROLLER: {
                return BASE_DIR + "controllers" + File.separator + filename + "Controller.groovy";
            }
            case DOMAIN: {
                return BASE_DIR + "domain" + File.separator + filename + ".groovy";
            }
            case VIEW: {
                if (filename.length() > 1) {
                    char first = filename.charAt(0);
                    filename = Character.toLowerCase(first) + filename.substring(1);
                } else {
                    filename = filename.toLowerCase();
                }
                return BASE_DIR + "views" + File.separator + filename + File.separator + "show.gsp";
            }
        }
        return "";
    }

    private static ActionType actionToType(AbstractAction caller) {
        if (caller instanceof GotoDomainClassAction) {
            return ActionType.DOMAIN;
        }
        if (caller instanceof GotoViewAction) {
            return ActionType.VIEW;
        }
        if (caller instanceof GotoControllerAction) {
            return ActionType.CONTROLLER;
        }
        return ActionType.NONE;
    }

    private static enum ActionType {
        DOMAIN,
        VIEW,
        CONTROLLER,
        NONE;

    }
}

