/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.ForeignKeyConstraint;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLExceptions;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

public final class DLightSessionServiceInfoStorage
extends SQLDataStorage
implements ServiceInfoDataStorage {
    private static final String SQL_QUERY_DELIMETER = ";";
    private static final Logger logger = DLightLogger.getLogger(DLightSessionServiceInfoStorage.class);
    static String DLIGHT_SERVICE_INFO_H2_DATABASE_URL;
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    String dbURL;
    public static final DataTableMetadata.Column ID_COLUMN;
    public static final DataTableMetadata.Column SERVICE_INFO_NAME;
    public static final DataTableMetadata.Column SERVICE_INFO_VALUE;
    public static final DataTableMetadata SERVICE_INFO_TABLE;
    private final Map<String, String> serviceInfoMap = new ConcurrentHashMap<String, String>();

    DLightSessionServiceInfoStorage(String storageUniq) {
        super(DLIGHT_SERVICE_INFO_H2_DATABASE_URL + "/" + storageUniq + "/" + storageUniq + ";FILE_LOCK=NO");
        this.dbURL = DLIGHT_SERVICE_INFO_H2_DATABASE_URL + "/" + storageUniq + "/" + storageUniq;
    }

    public String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public String getAutoIncrementExpresion() {
        return "AUTO_INCREMENT";
    }

    public String getPrimaryKeyExpression() {
        return "PRIMARY KEY";
    }

    public String createForeignKeyConstraint(ForeignKeyConstraint fKey) {
        return " FOREIGN KEY (" + fKey.getColumn().getColumnName() + ") REFERENCES " + fKey.getReferenceTable().getName() + "(" + fKey.getReferenceColumn().getColumnName() + ") ";
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        for (DataTableMetadata tdmd : tableMetadatas) {
            if (tdmd == null) continue;
            this.createTable(tdmd);
            this.tables.put(tdmd.getName(), tdmd);
        }
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    protected final Connection doConnect() throws SQLException {
        return DriverManager.getConnection(this.getDbURL(), "admin", "");
    }

    protected void postConnectInit() {
        super.postConnectInit();
        this.loadSchema();
        this.initTables();
    }

    private void initTables() {
        DataTableMetadata[] requiredTables = new DataTableMetadata[]{SERVICE_INFO_TABLE};
        ArrayList<String> existingTables = new ArrayList<String>();
        for (DataTableMetadata table : this.tables.values()) {
            existingTables.add(table.getName().toLowerCase());
        }
        for (DataTableMetadata table : requiredTables) {
            if (existingTables.contains(table.getName().toLowerCase())) continue;
            this.createTable(table);
        }
    }

    public void loadSchema() {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.TABLES", null, "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE LIKE 'TABLE'");
            if (rs == null) {
                return;
            }
            while (rs.next()) {
                String tableName = rs.getString(1);
                this.loadTable(tableName);
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
        }
    }

    private void loadTable(String tableName) {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.COLUMNS", null, "SELECT COLUMN_NAME, TYPE_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE '" + tableName + "'");
            ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
            while (rs.next()) {
                DataTableMetadata.Column c = new DataTableMetadata.Column(rs.getString("COLUMN_NAME"), this.typeToClass(rs.getString("TYPE_NAME")));
                columns.add(c);
            }
            DataTableMetadata result = new DataTableMetadata(tableName, columns, null);
            super.loadTable(result);
            this.tables.put(result.getName(), result);
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
        }
    }

    public boolean hasData(DataTableMetadata data) {
        ArrayList toCheck = new ArrayList(this.tables.values());
        return data.isProvidedBy(toCheck);
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public boolean shutdown() {
        boolean result = super.shutdown();
        String folderToDelete = this.dbURL.substring(this.dbURL.lastIndexOf(":") + 1, this.dbURL.lastIndexOf("/") + 1);
        result = result && Util.deleteLocalDirectory((File)new File(folderToDelete));
        return result;
    }

    public Map<String, String> getInfo() {
        if (this.serviceInfoMap.isEmpty()) {
            String sql = "SELECT * FROM " + SERVICE_INFO_TABLE.getName();
            try {
                PreparedStatement stat = this.getConnection().prepareStatement(sql);
                ResultSet rs = stat.executeQuery();
                while (rs.next()) {
                    this.serviceInfoMap.put(rs.getString(SERVICE_INFO_NAME.getColumnName()), SERVICE_INFO_VALUE.getColumnName());
                }
            }
            catch (SQLException ex) {
                SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
            }
        }
        return this.serviceInfoMap;
    }

    public String getValue(String name) {
        return this.getInfo().get(name);
    }

    public String put(String name, String value) {
        String oldValue = this.serviceInfoMap.put(name, value);
        String sqlString = "";
        sqlString = oldValue == null ? "INSERT INTO " + SERVICE_INFO_TABLE.getName() + "(" + SERVICE_INFO_NAME.getColumnName() + ", " + SERVICE_INFO_VALUE.getColumnName() + ") " + " VALUES (" + "'" + name + "', '" + value + "'" + ")" : " UPDATE " + SERVICE_INFO_TABLE.getName() + " SET value='" + value + "' WHERE " + SERVICE_INFO_NAME.getColumnName() + "='" + name + "'";
        try {
            PreparedStatement stat = this.getConnection().prepareStatement(sqlString);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this, (SQLException)ex);
        }
        return oldValue;
    }

    static {
        String tempDir = null;
        try {
            HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            tempDir = hi.getTempDir();
            if (hi.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                tempDir = WindowsSupport.getInstance().convertToWindowsPath(tempDir);
            }
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (tempDir == null || tempDir.trim().equals("")) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        if (System.getProperty("dlight.storages.host.url") != null) {
            DLIGHT_SERVICE_INFO_H2_DATABASE_URL = System.getProperty("dlight.storages.host.url");
        } else if (PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_HOST != null) {
            String host = PersistentDataStorageFactory.PERSISTENT_DATA_STORAGE_HOST;
            String analytics_serviceinfo_folder = System.getProperty("dlight.storages.host.folder", "/export/home/analytics");
            DLIGHT_SERVICE_INFO_H2_DATABASE_URL = "jdbc:h2:tcp://" + host + analytics_serviceinfo_folder;
        } else {
            DLIGHT_SERVICE_INFO_H2_DATABASE_URL = "jdbc:h2:" + tempDir + "/service_info_h2_db_dlight";
        }
        ID_COLUMN = new DataTableMetadata.Column("id", Integer.class);
        SERVICE_INFO_NAME = new DataTableMetadata.Column("name", String.class);
        SERVICE_INFO_VALUE = new DataTableMetadata.Column("value", String.class);
        SERVICE_INFO_TABLE = new DataTableMetadata("ServiceInfo", Arrays.asList(ID_COLUMN, SERVICE_INFO_NAME, SERVICE_INFO_VALUE), null);
        try {
            Class.forName("org.h2.Driver");
            logger.fine("Driver for H2DB Loaded ");
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

