/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class ServiceModel {
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOT_SERVICE = 1;
    public static final int STATUS_INCORRECT_SERVICE = 2;
    String serviceName;
    String portName;
    String name;
    String endpointInterface;
    String wsdlLocation;
    String targetNamespace;
    int status = 0;
    List<MethodModel> operations;
    private FileObject implementationClass;
    private FileChangeListener fcl;
    private List<ServiceChangeListener> serviceChangeListeners = new ArrayList<ServiceChangeListener>();
    private boolean changeSource = true;

    private ServiceModel(FileObject fileObject) {
        this.implementationClass = fileObject;
        this.populateModel();
    }

    public static ServiceModel getServiceModel(FileObject fileObject) {
        return new ServiceModel(fileObject);
    }

    public FileObject getImplementationClass() {
        return this.implementationClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != null && !this.name.equals(string)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"name", (String)string);
            }
            String string2 = this.name;
            this.name = string == null ? this.implementationClass.getName() : string;
            this.firePropertyChanged("name", string2, string);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        if (this.serviceName != null && !this.serviceName.equals(string)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"serviceName", (String)string);
            }
            String string2 = this.serviceName;
            this.serviceName = string == null ? this.implementationClass.getName() + "Service" : string;
            this.firePropertyChanged("serviceName", string2, this.serviceName);
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        if (this.portName != null && !this.portName.equals(string)) {
            if (this.changeSource) {
                JaxWsUtils.setWebServiceAttrValue((FileObject)this.implementationClass, (String)"portName", (String)string);
            }
            String string2 = this.portName;
            this.portName = string == null ? this.serviceName + "Port" : string;
            this.firePropertyChanged("portName", string2, string);
        }
    }

    public String getEndpointInterface() {
        return this.endpointInterface;
    }

    void setEndpointInterface(String string) {
        if (this.endpointInterface == null) {
            if (string != null) {
                this.endpointInterface = string;
                this.firePropertyChanged("endpointInterface", null, string);
            }
        } else if (!this.endpointInterface.equals(string)) {
            String string2 = this.endpointInterface;
            this.endpointInterface = string;
            this.firePropertyChanged("endpointInterface", string2, string);
        }
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    void setWsdlLocation(String string) {
        if (this.wsdlLocation == null) {
            if (string != null) {
                this.wsdlLocation = string;
                this.firePropertyChanged("wsdlLocation", null, string);
            }
        } else if (!this.wsdlLocation.equals(string)) {
            String string2 = this.wsdlLocation;
            this.wsdlLocation = string;
            this.firePropertyChanged("wsdlLocation", string2, string);
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String string) {
        if (this.targetNamespace == null) {
            if (string != null) {
                this.targetNamespace = string;
                this.firePropertyChanged("targetNamespace", null, string);
            }
        } else if (!this.targetNamespace.equals(string)) {
            String string2 = this.targetNamespace;
            this.targetNamespace = string;
            this.firePropertyChanged("targetNamespace", string2, string);
        }
    }

    public List<MethodModel> getOperations() {
        return this.operations;
    }

    void addOperation(MethodModel methodModel) {
        this.operations.add(methodModel);
        this.fireOperationAdded(methodModel);
    }

    void removeOperation(MethodModel methodModel) {
        this.operations.remove(methodModel);
        this.fireOperationRemoved(methodModel);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        if (this.status != n) {
            int n2 = this.status;
            this.status = n;
            this.firePropertyChanged("status", String.valueOf(n2), String.valueOf(n));
        }
        this.status = n;
    }

    void setOperations(List<MethodModel> list) {
        block9: {
            block8: {
                if (this.operations != null) break block8;
                this.operations = new ArrayList<MethodModel>();
                if (list == null) break block9;
                for (MethodModel methodModel : list) {
                    this.addOperation(methodModel);
                }
                break block9;
            }
            HashMap<String, MethodModel> hashMap = new HashMap<String, MethodModel>();
            HashMap<String, MethodModel> hashMap2 = new HashMap<String, MethodModel>();
            for (MethodModel object2 : this.operations) {
                hashMap.put(object2.getOperationName(), object2);
            }
            if (list != null) {
                for (MethodModel methodModel : list) {
                    hashMap2.put(methodModel.getOperationName(), methodModel);
                }
            }
            HashSet hashSet = new HashSet();
            Set set = hashMap.keySet();
            Set set2 = hashMap2.keySet();
            for (String string : set) {
                if (!set2.contains(string)) continue;
                hashSet.add(string);
            }
            Iterator<Object> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string;
                string = (String)iterator.next();
                MethodModel methodModel = (MethodModel)hashMap.get(string);
                MethodModel methodModel2 = (MethodModel)hashMap2.get(string);
                hashMap.remove(string);
                hashMap2.remove(string);
                if (methodModel.isEqualTo(methodModel2)) continue;
                this.operations.set(this.operations.indexOf(methodModel), methodModel2);
                this.fireOperationChanged(methodModel, methodModel2);
            }
            for (String string : hashMap.keySet()) {
                this.removeOperation((MethodModel)hashMap.get(string));
            }
            for (String string : hashMap2.keySet()) {
                this.addOperation((MethodModel)hashMap2.get(string));
            }
        }
    }

    public synchronized void addServiceChangeListener(ServiceChangeListener serviceChangeListener) {
        if (this.serviceChangeListeners.size() == 0) {
            this.fcl = new AnnotationChangeListener();
            this.implementationClass.addFileChangeListener(this.fcl);
            if (this.getEndpointInterface() != null) {
                String string = this.getEndpointInterface();
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.implementationClass, (String)"classpath/source");
                FileObject fileObject = classPath.findResource(string.replace('.', '/') + ".java");
                if (fileObject != null) {
                    fileObject.addFileChangeListener(this.fcl);
                }
            }
        }
        this.serviceChangeListeners.add(serviceChangeListener);
    }

    public synchronized void removeServiceChangeListener(ServiceChangeListener serviceChangeListener) {
        this.serviceChangeListeners.remove(serviceChangeListener);
        if (this.serviceChangeListeners.size() == 0) {
            this.implementationClass.removeFileChangeListener(this.fcl);
            if (this.getEndpointInterface() != null) {
                String string = this.getEndpointInterface();
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.implementationClass, (String)"classpath/source");
                FileObject fileObject = classPath.findResource(string.replace('.', '/') + ".java");
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this.fcl);
                }
            }
        }
    }

    void firePropertyChanged(String string, String string2, String string3) {
        for (ServiceChangeListener serviceChangeListener : this.serviceChangeListeners) {
            serviceChangeListener.propertyChanged(string, string2, string3);
        }
    }

    void fireOperationAdded(MethodModel methodModel) {
        for (ServiceChangeListener serviceChangeListener : this.serviceChangeListeners) {
            serviceChangeListener.operationAdded(methodModel);
        }
    }

    void fireOperationRemoved(MethodModel methodModel) {
        for (ServiceChangeListener serviceChangeListener : this.serviceChangeListeners) {
            serviceChangeListener.operationRemoved(methodModel);
        }
    }

    void fireOperationChanged(MethodModel methodModel, MethodModel methodModel2) {
        for (ServiceChangeListener serviceChangeListener : this.serviceChangeListeners) {
            serviceChangeListener.operationChanged(methodModel, methodModel2);
        }
    }

    private void populateModel() {
        Utils.populateModel(this.implementationClass, this);
    }

    void mergeModel(ServiceModel serviceModel) {
        if (serviceModel.status == 2 || serviceModel.status == 1) {
            if (this.operations != null && (serviceModel.operations == null || serviceModel.operations.size() == 0)) {
                int n = this.operations.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.removeOperation(this.operations.get(i));
                }
            }
        } else {
            this.changeSource = false;
            this.setStatus(serviceModel.status);
            this.setName(serviceModel.name);
            this.setServiceName(serviceModel.serviceName);
            this.setPortName(serviceModel.portName);
            this.setEndpointInterface(serviceModel.endpointInterface);
            this.setWsdlLocation(serviceModel.wsdlLocation);
            this.setTargetNamespace(serviceModel.targetNamespace);
            this.setOperations(serviceModel.operations);
            this.changeSource = true;
        }
    }

    private class AnnotationChangeListener
    extends FileChangeAdapter {
        private AnnotationChangeListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            ServiceModel serviceModel = new ServiceModel(fileObject);
            ServiceModel.this.mergeModel(serviceModel);
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }
}

