/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGImageComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SVGImageEditorElement
extends PropertyEditorResourceElement
implements Runnable,
CleanUp {
    private static final String EXTENSION = "svg";
    private long componentID;
    private boolean doNotFireEvent;
    private String lastDir;
    private SVGImageComponent imageView;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private PropertyEditorMessageAwareness messageAwareness;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public void clean(DesignComponent component) {
        this.imageView = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.messageAwareness = null;
        this.chooserButton = null;
        this.heightLabel = null;
        this.heightTextField = null;
        this.pathLabel = null;
        this.pathTextComboBox = null;
        this.previewLabel = null;
        this.previewPanel = null;
        this.progressBar = null;
        this.widthLabel = null;
        this.widthTextField = null;
        this.removeAll();
    }

    public SVGImageEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imageView = new SVGImageComponent();
        this.previewPanel.add((Component)this.imageView, "Center");
    }

    public void setPropertyEditorMessageAwareness(PropertyEditorMessageAwareness messageAwareness) {
        this.messageAwareness = messageAwareness;
    }

    public JComponent getJComponent() {
        return this;
    }

    public TypeID getTypeID() {
        return SVGImageCD.TYPEID;
    }

    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = wrapper.getComponentID();
        final String[] _pathText = new String[1];
        final DesignComponent component = wrapper.getComponent();
        if (component != null) {
            if (!component.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + component.getType());
            }
            this.componentID = component.getComponentID();
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertyValue propertyValue = component.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType((PropertyValue)propertyValue)) {
                        _pathText[0] = MidpTypes.getString((PropertyValue)propertyValue);
                    }
                }
            });
        }
        if (wrapper.hasChanges()) {
            Map changes = wrapper.getChanges();
            for (String propertyName : changes.keySet()) {
                PropertyValue propertyValue = (PropertyValue)changes.get(propertyName);
                if (!"resourcePath".equals(propertyName)) continue;
                _pathText[0] = MidpTypes.getString((PropertyValue)propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(_pathText[0]);
    }

    public boolean isPostSetValueSupported(final DesignComponent component) {
        final boolean[] retValue = new boolean[1];
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                retValue[0] = component.getDocument().getDescriptorRegistry().isInHierarchy(SVGMenuCD.TYPEID, component.getType()) && component.readProperty("elements").getArray().size() == 0;
            }
        });
        return retValue[0];
    }

    public void postSetValue(final DesignComponent parentComponent, final DesignComponent childComponent) {
        final FileObject[] svgImageFileObject = new FileObject[1];
        childComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                PropertyValue propertyValue = childComponent.readProperty("resourcePath");
                if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                    Map images = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)parentComponent.getDocument(), (String)MidpTypes.getString((PropertyValue)propertyValue));
                    Iterator iterator = images.keySet().iterator();
                    svgImageFileObject[0] = iterator.hasNext() ? (FileObject)iterator.next() : null;
                }
            }
        });
        this.parseSVGImageItems(svgImageFileObject[0], parentComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSVGImageItems(FileObject imageFO, DesignComponent parentComponent) {
        if (imageFO == null) {
            return;
        }
        SVGComponentImageParser parser = SVGComponentImageParser.getParserByComponent(parentComponent);
        if (parser == null) {
            return;
        }
        InputStream inputStream = null;
        inputStream = imageFO.getInputStream();
        if (inputStream != null) {
            parser.parse(inputStream, parentComponent);
        }
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException ioe) {
            Debug.warning((Object[])new Object[]{ioe});
        }
        return;
        catch (FileNotFoundException ex) {
            try {
                Debug.warning((Object[])new Object[]{ex});
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    Debug.warning((Object[])new Object[]{ioe});
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException ioe) {
                Debug.warning((Object[])new Object[]{ioe});
            }
            return;
        }
    }

    private void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.addImage(text, true);
    }

    private void addImage(String path, boolean selectImage) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(path) == -1) {
            this.comboBoxModel.addElement(path);
            this.sortComboBoxContent();
        }
        if (selectImage) {
            this.pathTextComboBox.setSelectedItem(path);
            if (this.comboBoxModel != null) {
                this.updatePreview();
            }
        }
        this.doNotFireEvent = false;
    }

    private void sortComboBoxContent() {
        int size = this.pathTextComboBox.getItemCount();
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(list, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object object : list) {
            this.pathTextComboBox.addItem(object);
        }
    }

    void setAllEnabled(boolean isEnabled) {
        this.pathLabel.setEnabled(isEnabled);
        this.pathTextComboBox.setEnabled(isEnabled);
        this.previewLabel.setEnabled(isEnabled);
        this.previewPanel.setEnabled(isEnabled);
        this.widthLabel.setEnabled(isEnabled);
        this.widthTextField.setEnabled(isEnabled);
        this.heightLabel.setEnabled(isEnabled);
        this.heightTextField.setEnabled(isEnabled);
        this.chooserButton.setEnabled(isEnabled);
    }

    private void updateModel(DesignDocument document) {
        boolean isEnabled = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map fileMap = MidpProjectSupport.getAllFilesForProjectByExt((DesignDocument)document, Collections.singleton(EXTENSION));
        for (Map.Entry entry : fileMap.entrySet()) {
            this.checkFile((FileObject)entry.getKey(), (String)entry.getValue());
        }
        if (isEnabled) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fo, String relativePath) {
        String path;
        if (EXTENSION.equals(fo.getExt().toLowerCase()) && (path = this.convertFile(fo, relativePath, false)) != null) {
            this.addImage(path, false);
        }
    }

    private void updatePreview() {
        SVGImage svgImage;
        block6: {
            String relativePath = (String)this.pathTextComboBox.getSelectedItem();
            FileObject fo = this.paths.get(relativePath);
            svgImage = null;
            try {
                if (fo != null) {
                    svgImage = Util.createSVGImage((FileObject)fo, (boolean)true);
                }
                if (this.messageAwareness != null) {
                    this.messageAwareness.clearErrorStatus();
                }
            }
            catch (IOException e) {
                Debug.warning((Object[])new Object[]{e});
                if (this.messageAwareness == null) break block6;
                this.messageAwareness.displayWarning(NbBundle.getMessage(SVGImageEditorElement.class, (String)"MSG_SVG_Image_Not_SVG_Tiny"));
            }
        }
        if (svgImage != null) {
            int width = svgImage.getViewportWidth();
            int height = svgImage.getViewportHeight();
            this.widthTextField.setText(String.valueOf(width));
            this.heightTextField.setText(String.valueOf(height));
        } else {
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
        }
        this.imageView.setImage(svgImage);
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private Project getProject() {
        DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        Project project = null;
        if (document != null) {
            project = ProjectUtils.getProject((DesignDocument)document);
        }
        return project;
    }

    private FileObject getSourceFolder() {
        Project project = this.getProject();
        if (project == null) {
            throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
        }
        String projectID = ProjectUtils.getProjectID((Project)project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)projectID).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fo, String relPath, boolean needCopy) {
        String relativePath;
        FileObject sourceFolder = this.getSourceFolder();
        String sourcePath = FileUtil.toFile((FileObject)sourceFolder).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            relativePath = !fo.getPath().startsWith("/", 0) ? "/" + fo.getPath() : fo.getPath();
        } else {
            String fullPath = file.getAbsolutePath();
            if (fullPath.contains(sourcePath)) {
                int i;
                fullPath = fo.getPath();
                relativePath = !fullPath.substring(i = fullPath.indexOf(sourcePath) + sourcePath.length() + 1).startsWith("/") ? "/" + fullPath.substring(i) : fullPath.substring(i);
            } else if (needCopy) {
                File possible = new File(sourcePath + File.separator + fo.getNameExt());
                if (possible.exists()) {
                    return null;
                }
                try {
                    fo = fo.copy(sourceFolder, fo.getName(), fo.getExt());
                }
                catch (IOException ex) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", fullPath, ex});
                }
                relativePath = "/" + fo.getNameExt();
            } else {
                relativePath = relPath;
            }
        }
        this.paths.put(relativePath, fo);
        return relativePath;
    }

    @Override
    public void run() {
        if (this.wrapper == null || this.wrapper.getComponent() == null) {
            return;
        }
        DesignComponent component = this.wrapper.getComponent();
        if (component == null) {
            return;
        }
        DesignDocument document = component.getDocument();
        if (document != null) {
            this.updateModel(document);
        }
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean isShowing) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVGImageEditorElement.this.progressBar.setVisible(isShowing);
            }
        });
    }

    public void removeNotify() {
        this.paths.clear();
        this.wrapper = null;
        super.removeNotify();
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.progressBar = new JProgressBar();
        this.pathLabel.setLabelFor(this.pathTextComboBox);
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.setLayout(new BorderLayout());
        this.widthLabel.setLabelFor(this.widthTextField);
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        this.heightLabel.setLabelFor(this.heightTextField);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.chooserButton, (String)NbBundle.getMessage(SVGImageEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageEditorElement.this.chooserButtonActionPerformed(evt);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageEditorElement.this.pathTextComboBoxActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pathLabel).addContainerGap(272, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewPanel, -1, 36, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.heightLabel).add((Component)this.widthLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.widthTextField, -2, 92, -2).add((Component)this.heightTextField, -2, 92, -2))).add((Component)this.progressBar, -2, 146, -2))).add((Component)this.pathTextComboBox, 0, 246, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooserButton, -2, 79, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pathLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pathTextComboBox, -2, -1, -2).add((Component)this.chooserButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap()).add((Component)this.previewLabel).add((Component)this.previewPanel, -1, 100, Short.MAX_VALUE))));
        this.widthTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Width"));
        this.widthTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Width"));
        this.heightTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Height"));
        this.heightTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Height"));
        this.chooserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_Browse"));
        this.chooserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_Browse"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSN_ImagePath"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageEditorElement.class, (String)"ACSD_ImagePath"));
    }

    private void chooserButtonActionPerformed(ActionEvent evt) {
        Project project = this.getProject();
        JFileChooser chooser = new JFileChooser(this.lastDir != null ? this.lastDir : project.getProjectDirectory().getPath());
        chooser.setFileFilter(new ImageFilter());
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        if (returnVal == 0) {
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)chooser.getSelectedFile()));
            this.lastDir = chooser.getSelectedFile().getParentFile().getPath();
            String relativePath = this.convertFile(fo, null, true);
            if (relativePath != null) {
                this.setText(relativePath);
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String message = NbBundle.getMessage(SVGImageEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
    }

    private void pathTextComboBoxActionPerformed(ActionEvent evt) {
        if (!this.doNotFireEvent) {
            String text = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue((String)(text != null ? text : "")));
            this.updatePreview();
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(SVGImageEditorElement.class, (String)"DISP_SVG_Image_Files");

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = ImageFilter.getExtension(file);
            return SVGImageEditorElement.EXTENSION.equals(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String ext = null;
            String s = file.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

