/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.SelectAppServerPanel;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SelectProjectPanel
extends JPanel {
    private final Project project;
    private final OpenListPanel olp;
    private JLabel listLabel;
    private JPanel listPanel;

    public SelectProjectPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.olp = new OpenListPanel(project);
        this.listPanel.add((Component)this.olp, "Center");
    }

    void attachDD(DialogDescriptor dd) {
        this.olp.attachDD(dd);
    }

    private static Border getNbScrollPaneBorder() {
        Border b = UIManager.getBorder("Nb.ScrollPane.border");
        if (b == null) {
            Color c = UIManager.getColor("controlShadow");
            b = new LineBorder(c != null ? c : Color.GRAY);
        }
        return b;
    }

    Project getSelectedProject() {
        return this.olp.getSelectedProject();
    }

    private void initComponents() {
        this.listLabel = new JLabel();
        this.listPanel = new JPanel();
        this.listLabel.setText(NbBundle.getMessage(SelectProjectPanel.class, (String)"SelectProjectPanel.listLabel.text"));
        this.listPanel.setBorder(SelectProjectPanel.getNbScrollPaneBorder());
        this.listPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.listPanel, -1, 383, Short.MAX_VALUE).add(1, (Component)this.listLabel, -2, 383, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.listLabel).addPreferredGap(0).add((Component)this.listPanel, -1, 248, Short.MAX_VALUE)));
    }

    private static class OpenListPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener,
    Runnable,
    ActionListener {
        private final ListView lv;
        private final ExplorerManager manager;
        private final Project curProject;
        private DialogDescriptor dd;
        private NotificationLineSupport projNls;
        private Project selProj;

        public OpenListPanel(Project curProject) {
            this.curProject = curProject;
            this.lv = new ListView();
            this.lv.setDefaultProcessor((ActionListener)this);
            this.lv.setPopupAllowed(false);
            this.lv.setTraversalAllowed(false);
            this.lv.setSelectionMode(0);
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.lv, "Center");
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Project prj;
            Node[] selNodes = this.manager.getSelectedNodes();
            if (selNodes.length == 1 && (prj = (Project)selNodes[0].getLookup().lookup(Project.class)) != null) {
                this.selProj = prj;
                this.dd.setValid(true);
                this.projNls.clearMessages();
                return;
            }
            this.dd.setValid(false);
            this.projNls.setErrorMessage(NbBundle.getMessage(SelectAppServerPanel.class, (String)"ERR_NoSelection"));
        }

        public Project getSelectedProject() {
            return this.selProj;
        }

        @Override
        public void run() {
            Project[] prjs = OpenProjects.getDefault().getOpenProjects();
            final ArrayList<Node> toRet = new ArrayList<Node>();
            for (Project p : prjs) {
                NbMavenProject mav;
                if (p == this.curProject || (mav = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class)) == null) continue;
                LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
                toRet.add(lvp.createLogicalView());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Children.Array ch = new Children.Array();
                    ch.add(toRet.toArray(new Node[0]));
                    AbstractNode root = new AbstractNode((Children)ch);
                    OpenListPanel.this.getExplorerManager().setRootContext((Node)root);
                    if (ch.getNodesCount() > 0) {
                        Node first = ch.getNodeAt(0);
                        try {
                            OpenListPanel.this.getExplorerManager().setSelectedNodes(new Node[]{first});
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        private void attachDD(DialogDescriptor dd) {
            this.dd = dd;
            this.projNls = dd.createNotificationLineSupport();
        }
    }
}

