/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigGroupPanel;
import org.netbeans.modules.spring.beans.wizards.SpringXMLConfigNamespacesPanel;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class NewSpringXMLConfigWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Project p = Templates.getProject((WizardDescriptor)this.wizard);
            SourceGroup[] groups = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
            ConfigFileManager manager = NewSpringXMLConfigWizardIterator.getConfigFileManager(p);
            List<ConfigFileGroup> configFileGroups = manager != null ? manager.getConfigFileGroups() : null;
            SpringXMLConfigGroupPanel configGroupPanel = configFileGroups != null && !configFileGroups.isEmpty() ? new SpringXMLConfigGroupPanel(configFileGroups) : null;
            WizardDescriptor.Panel targetChooser = Templates.createSimpleTargetChooser((Project)p, (SourceGroup[])groups, (WizardDescriptor.Panel)configGroupPanel);
            this.panels = new WizardDescriptor.Panel[]{targetChooser, new SpringXMLConfigNamespacesPanel()};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject[] createdFile = new FileObject[]{null};
        String version = "";
        boolean addSpringToClassPath = (Boolean)this.wizard.getProperty("addSpringToClassPath");
        if (addSpringToClassPath) {
            Library[] libraries = new Library[]{(Library)this.wizard.getProperty("springLibrary")};
            version = SpringUtilities.getSpringLibraryVersion(libraries[0]);
            this.addLibrariesToClassPath(libraries);
        } else {
            FileObject artifact = NewSpringXMLConfigWizardIterator.getSourceGroupArtifact(Templates.getProject((WizardDescriptor)this.wizard), targetFolder);
            ClassPath cp = ClassPath.getClassPath((FileObject)artifact, (String)"classpath/compile");
            FileObject resource = null;
            if (cp != null) {
                resource = cp.findResource("org.springframework.core.SpringVersion".replace('.', '/') + ".class");
            }
            if (resource != null) {
                FileObject ownerRoot = cp.findOwnerRoot(resource);
                version = this.findSpringVersion(ownerRoot);
            }
        }
        if (version == null || "".equals(version)) {
            version = "2.5";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (version.startsWith("3.0")) {
            version = "3.0";
            params.put("springVersion3", Boolean.TRUE);
        }
        params.put("namespaces", this.getNamespacesList(version));
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        FileObject templateFO = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        createdFile[0] = templateDO.createFromTemplate(dataFolder, targetName, params).getPrimaryFile();
        Set<ConfigFileGroup> selectedGroups = (Set<ConfigFileGroup>)this.wizard.getProperty("configFileGroups");
        this.addFileToConfigFileManager(selectedGroups != null ? selectedGroups : Collections.emptySet(), FileUtil.toFile((FileObject)createdFile[0]));
        return Collections.singleton(createdFile[0]);
    }

    private List<TemplateData> getNamespacesList(String version) {
        String[] incNamespaces;
        ArrayList<TemplateData> namespaces = new ArrayList<TemplateData>();
        for (String ns : incNamespaces = (String[])this.wizard.getProperty("includedNamespaces")) {
            String prefix = ns.substring(0, ns.indexOf("-")).trim();
            String schemaName = ns.substring(ns.indexOf("-") + 1).trim();
            String fileName = schemaName.equals("http://www.springframework.org/schema/webflow-config") ? "spring-" + schemaName.substring(schemaName.lastIndexOf("/") + 1) + "-2.0.xsd" : "spring-" + schemaName.substring(schemaName.lastIndexOf("/") + 1) + "-" + version + ".xsd";
            namespaces.add(new TemplateData(prefix, schemaName, fileName));
        }
        return namespaces;
    }

    private String findSpringVersion(FileObject ownerRoot) {
        try {
            if (ownerRoot != null && ownerRoot.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)ownerRoot.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private void addLibrariesToClassPath(Library[] libraries) throws IOException {
        FileObject artifact = NewSpringXMLConfigWizardIterator.getSourceGroupArtifact(Templates.getProject((WizardDescriptor)this.wizard), Templates.getTargetFolder((WizardDescriptor)this.wizard));
        if (artifact != null) {
            ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)artifact, (String)"classpath/compile");
        }
    }

    private void addFileToConfigFileManager(final Set<ConfigFileGroup> selectedGroups, final File file) throws IOException {
        final ConfigFileManager manager = NewSpringXMLConfigWizardIterator.getConfigFileManager(Templates.getProject((WizardDescriptor)this.wizard));
        try {
            manager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    List<File> origFiles = manager.getConfigFiles();
                    ArrayList<File> newFiles = new ArrayList<File>(origFiles);
                    if (!newFiles.contains(file)) {
                        newFiles.add(file);
                    }
                    List<ConfigFileGroup> origGroups = manager.getConfigFileGroups();
                    List<ConfigFileGroup> newGroups = null;
                    if (selectedGroups.size() > 0) {
                        newGroups = new ArrayList<ConfigFileGroup>(origGroups.size());
                        for (ConfigFileGroup group : origGroups) {
                            if (selectedGroups.contains(group)) {
                                ConfigFileGroup newGroup = NewSpringXMLConfigWizardIterator.this.addFileToConfigGroup(group, file);
                                newGroups.add(newGroup);
                                continue;
                            }
                            newGroups.add(group);
                        }
                    } else {
                        newGroups = origGroups;
                    }
                    manager.putConfigFilesAndGroups(newFiles, newGroups);
                    manager.save();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private ConfigFileGroup addFileToConfigGroup(ConfigFileGroup group, File file) {
        List<File> files = group.getFiles();
        files.add(file);
        return ConfigFileGroup.create(group.getName(), files);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        if (Templates.getTargetFolder((WizardDescriptor)wizard) == null) {
            FileObject location;
            Project project = Templates.getProject((WizardDescriptor)wizard);
            SpringConfigFileLocationProvider provider = project != null ? (SpringConfigFileLocationProvider)project.getLookup().lookup(SpringConfigFileLocationProvider.class) : null;
            FileObject fileObject = location = provider != null ? provider.getLocation() : null;
            if (location != null) {
                Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)location);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    static ConfigFileManager getConfigFileManager(Project p) {
        ProjectSpringScopeProvider scopeProvider = (ProjectSpringScopeProvider)p.getLookup().lookup(ProjectSpringScopeProvider.class);
        return scopeProvider != null ? scopeProvider.getSpringScope().getConfigFileManager() : null;
    }

    static FileObject getSourceGroupArtifact(Project project, FileObject preferredArtifact) {
        SourceGroup[] groups;
        for (SourceGroup group : groups = SourceGroups.getJavaSourceGroups((Project)project)) {
            FileObject root = group.getRootFolder();
            if (!preferredArtifact.equals(root) && (!FileUtil.isParentOf((FileObject)root, (FileObject)preferredArtifact) || !group.contains(preferredArtifact))) continue;
            return preferredArtifact;
        }
        int i$ = 0;
        SourceGroup[] arr$ = groups;
        int len$ = arr$.length;
        if (i$ < len$) {
            SourceGroup group;
            group = arr$[i$];
            return group.getRootFolder();
        }
        return null;
    }

    public static final class TemplateData {
        private String prefix;
        private String namespace;
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public TemplateData(String prefix, String namespace, String fileName) {
            this.prefix = prefix;
            this.namespace = namespace;
            this.fileName = fileName;
        }
    }
}

