/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;

public class PNamespaceCompletor
extends Completor {
    public PNamespaceCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        String typedPrefix = context.getTypedPrefix();
        return context.getCaretOffset() - typedPrefix.length();
    }

    @Override
    protected void compute(final CompletionContext context) throws IOException {
        JavaSource js = JavaUtils.getJavaSource(context.getFileObject());
        if (js == null) {
            return;
        }
        final String typedPrefix = context.getTypedPrefix();
        final String pNamespacePrefix = context.getDocumentContext().getNamespacePrefix("http://www.springframework.org/schema/p");
        final int substitutionOffset = context.getCaretOffset() - typedPrefix.length();
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Property[] props;
                String className = new BeanClassFinder(SpringXMLConfigEditorUtils.getTagAttributes(context.getTag()), context.getFileObject()).findImplementationClass();
                if (className == null) {
                    return;
                }
                TypeElement te = JavaUtils.findClassElementByBinaryName(className, cc);
                if (te == null) {
                    return;
                }
                ElementUtilities eu = cc.getElementUtilities();
                for (Property prop : props = new PropertyFinder(te.asType(), "", eu, MatchType.PREFIX).findProperties()) {
                    if (prop.getSetter() == null) continue;
                    String attribName = pNamespacePrefix + ":" + prop.getName();
                    if (!context.getExistingAttributes().contains(attribName) && attribName.startsWith(typedPrefix)) {
                        SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createPropertyAttribItem(substitutionOffset, attribName, prop);
                        PNamespaceCompletor.this.addCacheItem(item);
                    }
                    attribName = attribName + "-ref";
                    if (context.getExistingAttributes().contains(attribName) || !attribName.startsWith(typedPrefix)) continue;
                    SpringXMLConfigCompletionItem refItem = SpringXMLConfigCompletionItem.createPropertyAttribItem(substitutionOffset, attribName, prop);
                    PNamespaceCompletor.this.addCacheItem(refItem);
                }
            }
        }, true);
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.P_ATTRIBUTE_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }
}

