/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;

public abstract class JavaMethodCompletor
extends Completor {
    public JavaMethodCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        return context.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(final CompletionContext context) throws IOException {
        final String classBinaryName = this.getTypeName(context);
        final Public publicFlag = this.getPublicFlag(context);
        final Static staticFlag = this.getStaticFlag(context);
        final int argCount = this.getArgCount(context);
        if (classBinaryName == null || classBinaryName.equals("")) {
            return;
        }
        JavaSource javaSource = JavaUtils.getJavaSource(context.getFileObject());
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                if (classBinaryName == null) {
                    return;
                }
                TypeElement classElem = JavaUtils.findClassElementByBinaryName(classBinaryName, controller);
                if (classElem == null) {
                    return;
                }
                ElementUtilities eu = controller.getElementUtilities();
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        if (e.getKind() == ElementKind.METHOD) {
                            boolean isPublic;
                            boolean isStatic;
                            TypeElement te = (TypeElement)e.getEnclosingElement();
                            if (te.getQualifiedName().contentEquals("java.lang.Object")) {
                                return false;
                            }
                            if (!e.getSimpleName().toString().startsWith(context.getTypedPrefix())) {
                                return false;
                            }
                            ExecutableElement method = (ExecutableElement)e;
                            if (argCount != -1 && method.getParameters().size() != argCount) {
                                return false;
                            }
                            if (staticFlag != Static.DONT_CARE && ((isStatic = method.getModifiers().contains((Object)Modifier.STATIC)) && staticFlag == Static.NO || !isStatic && staticFlag == Static.YES)) {
                                return false;
                            }
                            return publicFlag == Public.DONT_CARE || (!(isPublic = method.getModifiers().contains((Object)Modifier.PUBLIC)) || publicFlag != Public.NO) && (isPublic || publicFlag != Public.YES);
                        }
                        return false;
                    }
                };
                Iterable<? extends Element> methods = eu.getMembers(classElem.asType(), acceptor);
                methods = JavaMethodCompletor.this.filter(methods);
                for (Element element : methods) {
                    SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createMethodItem(JavaMethodCompletor.this.getAnchorOffset(), (ExecutableElement)element, element.getEnclosingElement() != classElem, controller.getElements().isDeprecated(element));
                    JavaMethodCompletor.this.addCacheItem(item);
                }
            }
        }, false);
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.JAVA_IDENTIFIER_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }

    protected abstract Public getPublicFlag(CompletionContext var1);

    protected abstract Static getStaticFlag(CompletionContext var1);

    protected abstract int getArgCount(CompletionContext var1);

    protected abstract String getTypeName(CompletionContext var1);

    protected Iterable<? extends Element> filter(Iterable<? extends Element> methods) {
        return methods;
    }
}

