/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.JSFUIManager;
import org.netbeans.modules.web.wizards.targetpanel.providers.WebTargetPanelProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class JSFTargetPanelProvider
extends WebTargetPanelProvider<FileType> {
    static final String JSF = "jsf";
    static final String FACELETS_EXT = "xhtml";
    private JSFUIManager myUIManager = new JSFUIManager();

    @Override
    public void init(TargetChooserPanel<FileType> panel) {
        super.init(panel);
    }

    @Override
    public String getExpectedExtension(TargetChooserPanel<FileType> panel) {
        if (this.isFacelets()) {
            return FACELETS_EXT;
        }
        return Templates.getTemplate((WizardDescriptor)panel.getTemplateWizard()).getExt();
    }

    @Override
    public String getResultExtension(TargetChooserPanel<FileType> panel) {
        String ext = Templates.getTemplate((WizardDescriptor)panel.getTemplateWizard()).getExt();
        if (this.getUIManager().isSegment()) {
            ext = ext + "f";
        } else if (this.isFacelets()) {
            ext = FACELETS_EXT;
        }
        return ext;
    }

    @Override
    public String getNewFileName() {
        return super.getNewFileName() + JSF;
    }

    public JSFUIManager getUIManager() {
        return this.myUIManager;
    }

    public String getWizardTitle() {
        return NbBundle.getMessage(JSFTargetPanelProvider.class, (String)"TITLE_JsfFile");
    }

    @Override
    public void storeSettings(TargetChooserPanel<FileType> panel) {
        if (this.isFacelets()) {
            Preferences preferences = ProjectUtils.getPreferences((Project)panel.getProject(), ProjectUtils.class, (boolean)true);
            String key = "jsf.language";
            String value = "Facelets";
            if (!preferences.get(key, "").equals(value)) {
                preferences.put(key, value);
            }
        }
        panel.getTemplateWizard().putProperty(FileType.IS_XML, (Object)false);
        panel.getTemplateWizard().putProperty(FileType.IS_SEGMENT, (Object)this.getUIManager().isSegment());
        panel.getTemplateWizard().putProperty(FileType.IS_FACELETS, (Object)this.getUIManager().isFacelets());
    }

    public boolean isApplicable(FileType id) {
        return id == FileType.JSF;
    }

    @Override
    protected WebModule getWebModule() {
        return this.myUIManager.getWebModule();
    }

    private boolean isFacelets() {
        return this.getUIManager().isFacelets();
    }
}

