/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class DeleteColumnAction
extends AbstractGridAction {
    private String name = NbBundle.getMessage(DeleteColumnAction.class, (String)"DeleteColumnAction_Name");

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return context.getFocusedColumn() != -1 && context.getGridInfo().getColumnCount() > 1;
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        int[] columnBounds;
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        int column = context.getFocusedColumn();
        GridUtils.removePaddingComponents(gridManager);
        gridManager.deleteColumn(column);
        GridUtils.addPaddingComponents(gridManager, originalColumnBounds.length - 2, originalRowBounds.length - 1);
        GridUtils.revalidateGrid(gridManager);
        int[] newColumnBounds = gridInfo.getColumnBounds();
        int[] newRowBounds = gridInfo.getRowBounds();
        if (column == originalColumnBounds.length - 2) {
            columnBounds = newColumnBounds;
        } else {
            columnBounds = new int[newColumnBounds.length + 1];
            System.arraycopy(newColumnBounds, 0, columnBounds, 0, column + 1);
            columnBounds[column + 1] = columnBounds[column];
            System.arraycopy(newColumnBounds, column + 1, columnBounds, column + 2, newColumnBounds.length - column - 1);
        }
        return new GridBoundsChange(originalColumnBounds, originalRowBounds, columnBounds, newRowBounds);
    }
}

