/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.VisualReplicator;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AddAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteColumnContentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteComponentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteRowAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteRowContentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.EncloseInContainerAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.InsertColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.InsertRowAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.SplitColumnAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.SplitRowAction;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.nodes.Node;

public class GridBagManager
implements GridManager {
    private Container container;
    private GridBagInfoProvider info;
    private GridCustomizer customizer;
    private VisualReplicator replicator;
    private Map<Component, RADVisualComponent> componentMap = new IdentityHashMap<Component, RADVisualComponent>();

    public GridBagManager(VisualReplicator replicator) {
        this.replicator = replicator;
        RADVisualContainer metacont = (RADVisualContainer)replicator.getTopMetaComponent();
        Object bean = replicator.getClonedComponent(metacont);
        this.container = metacont.getContainerDelegate(bean);
        if (!(this.container.getLayout() instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        this.info = new GridBagInfoProvider(this.container);
        this.updateComponentMap();
    }

    private void updateComponentMap() {
        this.componentMap.clear();
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        for (RADVisualComponent metacomp : metacont.getSubComponents()) {
            this.componentMap.put((Component)this.replicator.getClonedComponent(metacomp), metacomp);
        }
    }

    private RADVisualComponent getMetaComponent(Component component) {
        RADVisualComponent metacomp = this.componentMap.get(component);
        if (metacomp == null) {
            this.updateComponentMap();
            metacomp = this.componentMap.get(component);
        }
        return metacomp;
    }

    private Node.Property getProperty(Component component, String propertyName) {
        RADVisualComponent metacomp = this.getMetaComponent(component);
        for (Node.Property property : metacomp.getConstraintsProperties()) {
            String name = property.getName();
            if (!name.endsWith(propertyName)) continue;
            return property;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public GridBagInfoProvider getGridInfo() {
        return this.info;
    }

    private void setProperty(Component component, String propertyName, Object value) {
        Node.Property property = this.getProperty(component, propertyName);
        try {
            property.setValue(value);
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.WARNING, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            FormUtils.LOGGER.log(Level.WARNING, itex.getMessage(), itex);
        }
    }

    @Override
    public void setGridX(Component component, int gridX) {
        this.setProperty(component, "gridx", gridX);
    }

    @Override
    public void setGridY(Component component, int gridY) {
        this.setProperty(component, "gridy", gridY);
    }

    @Override
    public void setGridWidth(Component component, int gridWidth) {
        this.setProperty(component, "gridwidth", gridWidth);
    }

    @Override
    public void setGridHeight(Component component, int gridHeight) {
        this.setProperty(component, "gridheight", gridHeight);
    }

    @Override
    public void addComponent(Component component, int gridX, int gridY, int gridWidth, int gridHeight) {
        if (!GridUtils.isPaddingComponent(component)) {
            throw new IllegalArgumentException();
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridX;
        c.gridy = gridY;
        c.gridwidth = gridWidth;
        c.gridheight = gridHeight;
        this.container.add(component, c);
        this.container.doLayout();
    }

    @Override
    public List<GridAction> designerActions(GridAction.Context context) {
        ArrayList<GridAction> actions = new ArrayList<GridAction>();
        if (context == GridAction.Context.COLUMN) {
            AbstractGridAction action = new InsertColumnAction(false);
            actions.add(action);
            action = new InsertColumnAction(true);
            actions.add(action);
            action = new DeleteColumnAction();
            actions.add(action);
            action = new DeleteColumnContentAction();
            actions.add(action);
            action = new SplitColumnAction();
            actions.add(action);
        } else if (context == GridAction.Context.ROW) {
            AbstractGridAction action = new InsertRowAction(false);
            actions.add(action);
            action = new InsertRowAction(true);
            actions.add(action);
            action = new DeleteRowAction();
            actions.add(action);
            action = new DeleteRowContentAction();
            actions.add(action);
            action = new SplitRowAction();
            actions.add(action);
        } else if (context == GridAction.Context.COMPONENT) {
            AbstractGridAction action = new DeleteComponentAction();
            actions.add(action);
            action = new EncloseInContainerAction();
            actions.add(action);
        } else if (context == GridAction.Context.CELL) {
            AddAction action = new AddAction(this.replicator);
            actions.add(action);
        }
        return actions;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void removeComponent(Component component) {
        if (!GridUtils.isPaddingComponent(component)) {
            RADVisualComponent metacomp = this.getMetaComponent(component);
            metacomp.getFormModel().removeComponent(metacomp, true);
        }
        this.container.remove(component);
    }

    @Override
    public void insertColumn(int newColumnIndex) {
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            if (x >= newColumnIndex) {
                this.setGridX(component, ++x);
                continue;
            }
            if (x + width <= newColumnIndex) continue;
            this.setGridWidth(component, ++width);
        }
    }

    @Override
    public void deleteColumn(int columnIndex) {
        for (Component component : this.getContainer().getComponents()) {
            int x = this.info.getGridX(component);
            int width = this.info.getGridWidth(component);
            if (x == columnIndex && width == 1) {
                this.removeComponent(component);
                continue;
            }
            if (x > columnIndex) {
                this.setGridX(component, --x);
                continue;
            }
            if (x + width <= columnIndex) continue;
            this.setGridWidth(component, --width);
        }
    }

    @Override
    public void insertRow(int newRowIndex) {
        for (Component component : this.getContainer().getComponents()) {
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            if (y >= newRowIndex) {
                this.setGridY(component, ++y);
                continue;
            }
            if (y + height <= newRowIndex) continue;
            this.setGridHeight(component, ++height);
        }
    }

    @Override
    public void deleteRow(int rowIndex) {
        for (Component component : this.getContainer().getComponents()) {
            int y = this.info.getGridY(component);
            int height = this.info.getGridHeight(component);
            if (y == rowIndex && height == 1) {
                this.removeComponent(component);
                continue;
            }
            if (y > rowIndex) {
                this.setGridY(component, --y);
                continue;
            }
            if (y + height <= rowIndex) continue;
            this.setGridHeight(component, --height);
        }
    }

    @Override
    public void updateLayout(boolean includingSubcontainers) {
        RADVisualContainer metacont = (RADVisualContainer)this.replicator.getTopMetaComponent();
        if (includingSubcontainers) {
            for (RADVisualComponent metacomp : metacont.getSubComponents()) {
                if (!(metacomp instanceof RADVisualContainer)) continue;
                this.replicator.updateContainerLayout((RADVisualContainer)metacomp);
            }
        }
        this.replicator.updateContainerLayout(metacont);
    }

    @Override
    public GridCustomizer getCustomizer(GridActionPerformer performer) {
        if (this.customizer == null) {
            this.customizer = this.createCustomizer(performer);
        }
        return this.customizer;
    }

    private GridCustomizer createCustomizer(GridActionPerformer performer) {
        return new GridBagCustomizer(this, performer);
    }

    public void setAnchor(Component component, int anchor) {
        this.setProperty(component, "anchor", anchor);
    }

    public void setFill(Component component, int fill) {
        this.setProperty(component, "fill", fill);
    }

    public void setWeightX(Component component, double weight) {
        this.setProperty(component, "weightx", weight);
    }

    public void setWeightY(Component component, double weight) {
        this.setProperty(component, "weighty", weight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container encloseInContainer(Set<Component> components) {
        int i;
        Container clone;
        GridBagLayout layout = (GridBagLayout)this.container.getLayout();
        RADVisualContainer parent = null;
        FormModel formModel = null;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = 0;
        int maxy = 0;
        boolean horizontalFill = false;
        boolean verticalFill = false;
        boolean weightx = false;
        boolean weighty = false;
        for (Component comp : components) {
            double wy;
            RADVisualComponent metaComp = this.componentMap.get(comp);
            parent = metaComp.getParentContainer();
            formModel = metaComp.getFormModel();
            int gridx = this.info.getGridX(comp);
            int gridy = this.info.getGridY(comp);
            int gridwidth = this.info.getGridWidth(comp);
            int gridheight = this.info.getGridHeight(comp);
            minx = Math.min(minx, gridx);
            miny = Math.min(miny, gridy);
            maxx = Math.max(maxx, gridx + gridwidth);
            maxy = Math.max(maxy, gridy + gridheight);
            int fill = this.info.getFill(comp);
            if (fill == 1) {
                horizontalFill = true;
                verticalFill = true;
            } else if (fill == 2) {
                horizontalFill = true;
            } else if (fill == 3) {
                verticalFill = true;
            }
            double wx = this.info.getWeightX(comp);
            if (wx != 0.0) {
                weightx = true;
            }
            if ((wy = this.info.getWeightY(comp)) == 0.0) continue;
            weighty = true;
        }
        double[][] weights = layout.getLayoutWeights();
        MetaComponentCreator creator = formModel.getComponentCreator();
        RADVisualContainer panel = (RADVisualContainer)creator.createComponent(new ClassSource("javax.swing.JPanel", new ClassSource.Entry[0]), (RADComponent)parent, null);
        boolean recording = formModel.isUndoRedoRecording();
        try {
            formModel.setUndoRedoRecording(false);
            creator.createComponent(new ClassSource("java.awt.GridBagLayout", new ClassSource.Entry[0]), (RADComponent)panel, null);
        }
        finally {
            formModel.setUndoRedoRecording(recording);
        }
        for (Component comp : components) {
            RADVisualComponent metaComp = this.componentMap.get(comp);
            creator.moveComponent(metaComp, panel);
        }
        if (minx != 0) {
            for (Component comp : components) {
                int gridx = this.info.getGridX(comp);
                this.setGridX(comp, gridx - minx);
            }
        }
        if (miny != 0) {
            for (Component comp : components) {
                int gridy = this.info.getGridY(comp);
                this.setGridY(comp, gridy - miny);
            }
        }
        if ((clone = (Container)this.replicator.getClonedComponent(panel)) == null) {
            clone = (Container)this.replicator.createClone(panel);
        }
        this.componentMap.put(clone, panel);
        this.setGridX(clone, minx);
        this.setGridY(clone, miny);
        this.setGridWidth(clone, maxx - minx);
        this.setGridHeight(clone, maxy - miny);
        if (horizontalFill && weightx) {
            double totalWeightX = 0.0;
            for (i = minx; i < maxx; ++i) {
                totalWeightX += weights[0][i];
            }
            this.setWeightX(clone, totalWeightX);
        }
        if (verticalFill && weighty) {
            double totalWeightY = 0.0;
            for (i = miny; i < maxy; ++i) {
                totalWeightY += weights[1][i];
            }
            this.setWeightY(clone, totalWeightY);
        }
        int fill = horizontalFill ? (verticalFill ? 1 : 2) : (verticalFill ? 3 : 0);
        this.setFill(clone, fill);
        return clone;
    }
}

