/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridBagManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class GridBagCustomizer
implements GridCustomizer {
    private GridActionPerformer performer;
    private GridBagManager manager;
    private ButtonGroup anchorGroup;
    private JLabel anchorLabel;
    private JPanel anchorPanel;
    private JSeparator anchorSeparator;
    private JToggleButton baselineAnchorButton;
    private JToggleButton bidiAnchorButton;
    private JToggleButton cAnchorButton;
    private JPanel customizer;
    private JToggleButton eAnchorButton;
    private JLabel fillLabel;
    private JPanel fillPanel;
    private JSeparator fillSeparator;
    private JToggleButton hFillButton;
    private JToggleButton nAnchorButton;
    private JToggleButton neAnchorButton;
    private JToggleButton nwAnchorButton;
    private JToggleButton sAnchorButton;
    private JToggleButton seAnchorButton;
    private JToggleButton swAnchorButton;
    private JToggleButton vFillButton;
    private JToggleButton wAnchorButton;

    public GridBagCustomizer(GridBagManager manager, GridActionPerformer performer) {
        this.manager = manager;
        this.performer = performer;
        this.initComponents();
    }

    private void initComponents() {
        this.customizer = new JPanel();
        this.anchorLabel = new JLabel();
        this.anchorSeparator = new JSeparator();
        this.fillLabel = new JLabel();
        this.fillSeparator = new JSeparator();
        this.anchorPanel = new JPanel();
        this.nwAnchorButton = new JToggleButton();
        this.nAnchorButton = new JToggleButton();
        this.neAnchorButton = new JToggleButton();
        this.eAnchorButton = new JToggleButton();
        this.cAnchorButton = new JToggleButton();
        this.wAnchorButton = new JToggleButton();
        this.swAnchorButton = new JToggleButton();
        this.sAnchorButton = new JToggleButton();
        this.seAnchorButton = new JToggleButton();
        this.baselineAnchorButton = new JToggleButton();
        this.bidiAnchorButton = new JToggleButton();
        this.fillPanel = new JPanel();
        this.hFillButton = new JToggleButton();
        this.vFillButton = new JToggleButton();
        this.anchorGroup = new ButtonGroup();
        FormListener formListener = new FormListener();
        this.anchorLabel.setText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.anchorLabel.text"));
        this.fillLabel.setText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.fillLabel.text"));
        this.anchorGroup.add(this.nwAnchorButton);
        this.nwAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_nw.png")));
        this.nwAnchorButton.setEnabled(false);
        this.nwAnchorButton.setFocusPainted(false);
        this.nwAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.nwAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.nAnchorButton);
        this.nAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_n.png")));
        this.nAnchorButton.setEnabled(false);
        this.nAnchorButton.setFocusPainted(false);
        this.nAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.nAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.neAnchorButton);
        this.neAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_ne.png")));
        this.neAnchorButton.setEnabled(false);
        this.neAnchorButton.setFocusPainted(false);
        this.neAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.neAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.eAnchorButton);
        this.eAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_e.png")));
        this.eAnchorButton.setEnabled(false);
        this.eAnchorButton.setFocusPainted(false);
        this.eAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.eAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.cAnchorButton);
        this.cAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_c.png")));
        this.cAnchorButton.setEnabled(false);
        this.cAnchorButton.setFocusPainted(false);
        this.cAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.cAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.wAnchorButton);
        this.wAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_w.png")));
        this.wAnchorButton.setEnabled(false);
        this.wAnchorButton.setFocusPainted(false);
        this.wAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.wAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.swAnchorButton);
        this.swAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_sw.png")));
        this.swAnchorButton.setEnabled(false);
        this.swAnchorButton.setFocusPainted(false);
        this.swAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.swAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.sAnchorButton);
        this.sAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_s.png")));
        this.sAnchorButton.setEnabled(false);
        this.sAnchorButton.setFocusPainted(false);
        this.sAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.sAnchorButton.addActionListener(formListener);
        this.anchorGroup.add(this.seAnchorButton);
        this.seAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/anchor_se.png")));
        this.seAnchorButton.setEnabled(false);
        this.seAnchorButton.setFocusPainted(false);
        this.seAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.seAnchorButton.addActionListener(formListener);
        this.baselineAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/baseline.png")));
        this.baselineAnchorButton.setToolTipText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.anchor.baselineRelated"));
        this.baselineAnchorButton.setEnabled(false);
        this.baselineAnchorButton.setFocusPainted(false);
        this.baselineAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.baselineAnchorButton.addActionListener(formListener);
        this.bidiAnchorButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/bidi.png")));
        this.bidiAnchorButton.setToolTipText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.anchor.bidiAware"));
        this.bidiAnchorButton.setEnabled(false);
        this.bidiAnchorButton.setFocusPainted(false);
        this.bidiAnchorButton.setMargin(new Insets(0, 0, 0, 0));
        this.bidiAnchorButton.addActionListener(formListener);
        GroupLayout anchorPanelLayout = new GroupLayout(this.anchorPanel);
        this.anchorPanel.setLayout(anchorPanelLayout);
        anchorPanelLayout.setHorizontalGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(anchorPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.bidiAnchorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(anchorPanelLayout.createSequentialGroup().addComponent(this.nwAnchorButton).addGap(0, 0, 0).addComponent(this.nAnchorButton).addGap(0, 0, 0).addComponent(this.neAnchorButton)).addGroup(anchorPanelLayout.createSequentialGroup().addComponent(this.wAnchorButton).addGap(0, 0, 0).addComponent(this.cAnchorButton).addGap(0, 0, 0).addComponent(this.eAnchorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.baselineAnchorButton)).addGroup(anchorPanelLayout.createSequentialGroup().addComponent(this.swAnchorButton).addGap(0, 0, 0).addComponent(this.sAnchorButton).addGap(0, 0, 0).addComponent(this.seAnchorButton))).addContainerGap(-1, Short.MAX_VALUE)));
        anchorPanelLayout.setVerticalGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(anchorPanelLayout.createSequentialGroup().addGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nwAnchorButton).addComponent(this.nAnchorButton).addComponent(this.neAnchorButton)).addGap(0, 0, 0).addGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bidiAnchorButton).addComponent(this.baselineAnchorButton).addGroup(anchorPanelLayout.createSequentialGroup().addGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wAnchorButton).addComponent(this.cAnchorButton).addComponent(this.eAnchorButton)).addGap(0, 0, 0).addGroup(anchorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.swAnchorButton).addComponent(this.sAnchorButton).addComponent(this.seAnchorButton))))));
        this.hFillButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/resize_h.png")));
        this.hFillButton.setToolTipText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.fill.horizontal"));
        this.hFillButton.setEnabled(false);
        this.hFillButton.setFocusPainted(false);
        this.hFillButton.setMargin(new Insets(0, 0, 0, 0));
        this.hFillButton.addActionListener(formListener);
        this.vFillButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/layoutsupport/griddesigner/resources/resize_v.png")));
        this.vFillButton.setToolTipText(NbBundle.getMessage(GridBagCustomizer.class, (String)"GridBagCustomizer.fill.vertical"));
        this.vFillButton.setEnabled(false);
        this.vFillButton.setFocusPainted(false);
        this.vFillButton.setMargin(new Insets(0, 0, 0, 0));
        this.vFillButton.addActionListener(formListener);
        GroupLayout fillPanelLayout = new GroupLayout(this.fillPanel);
        this.fillPanel.setLayout(fillPanelLayout);
        fillPanelLayout.setHorizontalGroup(fillPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fillPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.hFillButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vFillButton).addContainerGap(-1, Short.MAX_VALUE)));
        fillPanelLayout.setVerticalGroup(fillPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hFillButton).addComponent(this.vFillButton));
        GroupLayout customizerLayout = new GroupLayout(this.customizer);
        this.customizer.setLayout(customizerLayout);
        customizerLayout.setHorizontalGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customizerLayout.createSequentialGroup().addContainerGap().addGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fillPanel, -1, -1, Short.MAX_VALUE).addComponent(this.anchorPanel, -1, -1, Short.MAX_VALUE).addGroup(customizerLayout.createSequentialGroup().addComponent(this.anchorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorSeparator, -1, 45, Short.MAX_VALUE)).addGroup(customizerLayout.createSequentialGroup().addComponent(this.fillLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fillSeparator, -1, 67, Short.MAX_VALUE))).addContainerGap()));
        customizerLayout.setVerticalGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customizerLayout.createSequentialGroup().addContainerGap().addGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.anchorSeparator, -2, -1, -2).addComponent(this.anchorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customizerLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.fillSeparator, -2, -1, -2).addComponent(this.fillLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fillPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void nwAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void nAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void neAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void wAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void cAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void eAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void swAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void sAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void seAnchorButtonActionPerformed(ActionEvent evt) {
        this.update(this.currentAnchor(), -1);
    }

    private void hFillButtonActionPerformed(ActionEvent evt) {
        this.update(-1, this.currentFill());
    }

    private void vFillButtonActionPerformed(ActionEvent evt) {
        this.update(-1, this.currentFill());
    }

    private void baselineAnchorButtonActionPerformed(ActionEvent evt) {
        if (this.baselineAnchorButton.isSelected()) {
            this.bidiAnchorButton.setSelected(true);
        }
        this.update(this.currentAnchor(), -1);
        this.updateTooltips();
    }

    private void bidiAnchorButtonActionPerformed(ActionEvent evt) {
        if (!this.bidiAnchorButton.isSelected()) {
            this.baselineAnchorButton.setSelected(false);
        }
        this.update(this.currentAnchor(), -1);
        this.updateTooltips();
    }

    private int currentFill() {
        boolean hFill = this.hFillButton.isSelected();
        boolean vFill = this.vFillButton.isSelected();
        int fill = hFill ? (vFill ? 1 : 2) : (vFill ? 3 : 0);
        return fill;
    }

    private int currentAnchor() {
        boolean baseline = this.baselineAnchorButton.isSelected();
        boolean bidi = this.bidiAnchorButton.isSelected();
        int anchor = -1;
        if (this.nwAnchorButton.isSelected()) {
            anchor = baseline ? 1280 : (bidi ? 23 : 18);
        } else if (this.nAnchorButton.isSelected()) {
            anchor = baseline ? 1024 : (bidi ? 19 : 11);
        } else if (this.neAnchorButton.isSelected()) {
            anchor = baseline ? 1536 : (bidi ? 24 : 12);
        } else if (this.wAnchorButton.isSelected()) {
            anchor = baseline ? 512 : (bidi ? 21 : 17);
        } else if (this.cAnchorButton.isSelected()) {
            anchor = baseline ? 256 : 10;
        } else if (this.eAnchorButton.isSelected()) {
            anchor = baseline ? 768 : (bidi ? 22 : 13);
        } else if (this.swAnchorButton.isSelected()) {
            anchor = baseline ? 2048 : (bidi ? 25 : 16);
        } else if (this.sAnchorButton.isSelected()) {
            anchor = baseline ? 1792 : (bidi ? 20 : 15);
        } else if (this.seAnchorButton.isSelected()) {
            anchor = baseline ? 2304 : (bidi ? 26 : 14);
        }
        return anchor;
    }

    @Override
    public void setContext(DesignerContext context) {
        boolean one;
        Set<Component> components = context.getSelectedComponents();
        boolean bl = one = components.size() == 1;
        if (!this.bidiAnchorButton.isEnabled() && one) {
            this.bidiAnchorButton.setSelected(true);
        }
        this.bidiAnchorButton.setEnabled(one);
        this.baselineAnchorButton.setEnabled(one);
        this.nwAnchorButton.setEnabled(one);
        this.nAnchorButton.setEnabled(one);
        this.neAnchorButton.setEnabled(one);
        this.wAnchorButton.setEnabled(one);
        this.cAnchorButton.setEnabled(one);
        this.eAnchorButton.setEnabled(one);
        this.swAnchorButton.setEnabled(one);
        this.sAnchorButton.setEnabled(one);
        this.seAnchorButton.setEnabled(one);
        this.hFillButton.setEnabled(one);
        this.vFillButton.setEnabled(one);
        int anchor = 0;
        int fill = 0;
        if (one) {
            Component selection = components.iterator().next();
            GridBagInfoProvider info = this.manager.getGridInfo();
            anchor = info.getAnchor(selection);
            fill = info.getFill(selection);
        } else {
            this.anchorGroup.clearSelection();
        }
        this.baselineAnchorButton.setSelected(anchor == 1280 || anchor == 1024 || anchor == 1536 || anchor == 512 || anchor == 256 || anchor == 768 || anchor == 2048 || anchor == 1792 || anchor == 2304);
        if (anchor != 10) {
            this.bidiAnchorButton.setSelected(anchor == 23 || anchor == 19 || anchor == 24 || anchor == 21 || anchor == 22 || anchor == 25 || anchor == 20 || anchor == 26 || this.baselineAnchorButton.isSelected());
        }
        this.nwAnchorButton.setSelected(anchor == 18 || anchor == 23 || anchor == 1280);
        this.nAnchorButton.setSelected(anchor == 11 || anchor == 19 || anchor == 1024);
        this.neAnchorButton.setSelected(anchor == 12 || anchor == 24 || anchor == 1536);
        this.wAnchorButton.setSelected(anchor == 17 || anchor == 21 || anchor == 512);
        this.cAnchorButton.setSelected(anchor == 10 || anchor == 256);
        this.eAnchorButton.setSelected(anchor == 13 || anchor == 22 || anchor == 768);
        this.swAnchorButton.setSelected(anchor == 16 || anchor == 25 || anchor == 2048);
        this.sAnchorButton.setSelected(anchor == 15 || anchor == 20 || anchor == 1792);
        this.seAnchorButton.setSelected(anchor == 14 || anchor == 26 || anchor == 2304);
        this.hFillButton.setSelected(fill == 2 || fill == 1);
        this.vFillButton.setSelected(fill == 3 || fill == 1);
        this.updateTooltips();
    }

    @Override
    public Component getComponent() {
        return this.customizer;
    }

    private void update(final int anchor, final int fill) {
        this.performer.performAction(new AbstractGridAction(){

            @Override
            public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
                GridInfoProvider info = gridManager.getGridInfo();
                int columns = info.getColumnCount();
                int rows = info.getRowCount();
                GridUtils.removePaddingComponents(gridManager);
                Component component = context.getSelectedComponents().iterator().next();
                if (anchor != -1) {
                    ((GridBagManager)gridManager).setAnchor(component, anchor);
                }
                if (fill != -1) {
                    ((GridBagManager)gridManager).setFill(component, fill);
                }
                gridManager.updateLayout(false);
                GridUtils.revalidateGrid(gridManager);
                GridUtils.addPaddingComponents(gridManager, columns, rows);
                GridUtils.revalidateGrid(gridManager);
                return null;
            }
        });
    }

    private void updateTooltips() {
        boolean baseline = this.baselineAnchorButton.isSelected();
        boolean bidi = this.bidiAnchorButton.isSelected();
        ResourceBundle bundle = NbBundle.getBundle(GridBagCustomizer.class);
        String key = baseline ? "GridBagCustomizer.anchor.aboveBaselineLeading" : (bidi ? "GridBagCustomizer.anchor.firstLineStart" : "GridBagCustomizer.anchor.northWest");
        this.nwAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.aboveBaseline" : (bidi ? "GridBagCustomizer.anchor.pageStart" : "GridBagCustomizer.anchor.north");
        this.nAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.aboveBaselineTrailing" : (bidi ? "GridBagCustomizer.anchor.firstLineEnd" : "GridBagCustomizer.anchor.northEast");
        this.neAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.baselineLeading" : (bidi ? "GridBagCustomizer.anchor.lineStart" : "GridBagCustomizer.anchor.west");
        this.wAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.baseline" : "GridBagCustomizer.anchor.center";
        this.cAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.baselineTrailing" : (bidi ? "GridBagCustomizer.anchor.lineEnd" : "GridBagCustomizer.anchor.east");
        this.eAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.belowBaselineLeading" : (bidi ? "GridBagCustomizer.anchor.lastLineStart" : "GridBagCustomizer.anchor.southWest");
        this.swAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.belowBaseline" : (bidi ? "GridBagCustomizer.anchor.pageEnd" : "GridBagCustomizer.anchor.south");
        this.sAnchorButton.setToolTipText(bundle.getString(key));
        key = baseline ? "GridBagCustomizer.anchor.belowBaselineTrailing" : (bidi ? "GridBagCustomizer.anchor.lastLineEnd" : "GridBagCustomizer.anchor.southEast");
        this.seAnchorButton.setToolTipText(bundle.getString(key));
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GridBagCustomizer.this.nwAnchorButton) {
                GridBagCustomizer.this.nwAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.nAnchorButton) {
                GridBagCustomizer.this.nAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.neAnchorButton) {
                GridBagCustomizer.this.neAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.eAnchorButton) {
                GridBagCustomizer.this.eAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.cAnchorButton) {
                GridBagCustomizer.this.cAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.wAnchorButton) {
                GridBagCustomizer.this.wAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.swAnchorButton) {
                GridBagCustomizer.this.swAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.sAnchorButton) {
                GridBagCustomizer.this.sAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.seAnchorButton) {
                GridBagCustomizer.this.seAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.baselineAnchorButton) {
                GridBagCustomizer.this.baselineAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.bidiAnchorButton) {
                GridBagCustomizer.this.bidiAnchorButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.hFillButton) {
                GridBagCustomizer.this.hFillButtonActionPerformed(evt);
            } else if (evt.getSource() == GridBagCustomizer.this.vFillButton) {
                GridBagCustomizer.this.vFillButtonActionPerformed(evt);
            }
        }
    }
}

