/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SemanticHighlightingOptionsPanel
extends JPanel
implements ActionListener {
    private boolean isChanged = false;
    private List<Entity> entities = new ArrayList<Entity>();
    JCheckBox cbMacros;
    private JCheckBox cbKeepMarks;
    private JCheckBox cbMarkOccurrences;
    private JPanel jPanel1;

    public SemanticHighlightingOptionsPanel() {
        this.initComponents();
        this.initGeneratedComponents();
        this.initMnemonics();
        this.cbKeepMarks.addActionListener(this);
        this.setName("TAB_SemanticHighlightingTab");
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jPanel1.setOpaque(false);
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        SemanticHighlightingOptions.instance().setEnableMarkOccurrences(this.cbMarkOccurrences.isSelected());
        SemanticHighlightingOptions.instance().setKeepMarks(this.cbKeepMarks.isSelected());
        for (Entity e : this.entities) {
            NamedEntityOptions.instance().setEnabled(e.se, e.cb.isSelected());
        }
        SemanticHighlightingOptions.instance().propertyChange(null);
        this.isChanged = false;
    }

    void update() {
        this.cbMarkOccurrences.setSelected(SemanticHighlightingOptions.instance().getEnableMarkOccurrences());
        this.cbKeepMarks.setSelected(SemanticHighlightingOptions.instance().getKeepMarks());
        for (Entity e : this.entities) {
            e.cb.setSelected(NamedEntityOptions.instance().isEnabled(e.se));
        }
        this.updateValidation();
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isChanged = true;
    }

    private void updateValidation() {
        this.cbKeepMarks.setEnabled(this.cbMarkOccurrences.isSelected());
    }

    private void initMnemonics() {
        this.cbMarkOccurrences.setMnemonic(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_Mnemonic").charAt(0));
        this.cbKeepMarks.setMnemonic(SemanticHighlightingOptionsPanel.getString("KeepMarks_Mnemonic").charAt(0));
        this.cbMarkOccurrences.setToolTipText(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_AD"));
        this.cbKeepMarks.setToolTipText(SemanticHighlightingOptionsPanel.getString("KeepMarks_AD"));
        this.cbMarkOccurrences.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_AD"));
        this.cbKeepMarks.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("KeepMarks_AD"));
    }

    private void addEntity(NamedEntity ne) {
        JCheckBox cb = new JCheckBox();
        String mnemonic = SemanticHighlightingOptionsPanel.getString("Show-" + ne.getName() + "-mnemonic");
        if (mnemonic.length() > 0) {
            cb.setMnemonic(mnemonic.charAt(0));
        }
        cb.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("Show-" + ne.getName() + "-AD"));
        cb.setText(SemanticHighlightingOptionsPanel.getString("Show-" + ne.getName()));
        cb.setToolTipText(SemanticHighlightingOptionsPanel.getString("Show-" + ne.getName() + "-AD"));
        cb.setOpaque(false);
        this.entities.add(new Entity(ne, cb));
    }

    private void initGeneratedComponents() {
        for (SemanticEntity se : SemanticEntitiesProvider.instance().get()) {
            this.addEntity(se);
        }
        for (CsmErrorProvider ee : Lookup.getDefault().lookupResult(CsmErrorProvider.class).allInstances()) {
            this.addEntity((NamedEntity)ee);
        }
        this.addEntity(new NamedEntity(){

            public String getName() {
                return "reparse-on-document-changed";
            }

            public boolean isEnabledByDefault() {
                return true;
            }
        });
        NamedEntity overridesEntity = new NamedEntity(){

            public String getName() {
                return "overrides-annotations";
            }

            public boolean isEnabledByDefault() {
                return true;
            }
        };
        this.addEntity(overridesEntity);
        GroupLayout layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(layout);
        GroupLayout.ParallelGroup pg = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup sg = layout.createSequentialGroup();
        for (Entity e : this.entities) {
            pg.addComponent(e.cb);
            sg.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(e.cb);
        }
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(pg))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sg.addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initComponents() {
        this.cbKeepMarks = new JCheckBox();
        this.cbMarkOccurrences = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.cbKeepMarks.setText(SemanticHighlightingOptionsPanel.getString("KeepMarks"));
        this.cbKeepMarks.setOpaque(false);
        this.cbMarkOccurrences.setText(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences"));
        this.cbMarkOccurrences.setOpaque(false);
        this.cbMarkOccurrences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SemanticHighlightingOptionsPanel.this.cbMarkOccurrencesActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 214, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.cbKeepMarks)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbMarkOccurrences)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbMarkOccurrences).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKeepMarks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)"SemanticHighlightingOptionsPanel_AN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)"SemanticHighlightingOptionsPanel_AD"));
    }

    private void cbMarkOccurrencesActionPerformed(ActionEvent evt) {
        this.updateValidation();
    }

    private static String getString(String key) {
        return NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)key);
    }

    private static class Entity {
        public final NamedEntity se;
        public final JCheckBox cb;

        public Entity(NamedEntity se, JCheckBox cb) {
            this.se = se;
            this.cb = cb;
        }
    }
}

