/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ExtensionList;

public class CsmIncludeCompletionQuery {
    private static final Collection<String> EXCLUDED_DIR_NAMES = Arrays.asList("CVS", ".hg", "nbproject", "SCCS", "SunWS_cache");
    private Map<String, CsmIncludeCompletionItem> results;
    private final CsmFile file;

    public CsmIncludeCompletionQuery(CsmFile file) {
        this.file = file;
    }

    public Collection<CsmIncludeCompletionItem> query(BaseDocument doc, String childSubDir, int substitutionOffset, Boolean usrInclude, boolean showAll) {
        String usrFilePath;
        this.results = new HashMap<String, CsmIncludeCompletionItem>(100);
        CsmFile docFile = this.file;
        if (docFile == null) {
            docFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        }
        Collection<Object> usrPaths = Collections.emptyList();
        Collection<Object> sysPaths = Collections.emptyList();
        File fileChildSubDir = new File(childSubDir);
        if (fileChildSubDir.isAbsolute()) {
            this.addFolderItems("", "", childSubDir, true, usrInclude != null ? usrInclude : false, true, substitutionOffset);
            return this.results.values();
        }
        if (docFile != null) {
            usrFilePath = ((Object)docFile.getAbsolutePath()).toString();
            usrPaths = this.getFileIncludes(docFile, false);
            sysPaths = this.getFileIncludes(docFile, true);
        } else {
            File baseFile = CsmUtilities.getFile((Document)doc);
            if (baseFile == null) {
                return Collections.emptyList();
            }
            usrFilePath = baseFile.getAbsolutePath();
        }
        File usrDir = new File(usrFilePath).getParentFile();
        if (usrInclude == null || usrInclude == Boolean.TRUE) {
            this.addFolderItems(usrDir.getAbsolutePath(), ".", childSubDir, false, false, true, substitutionOffset);
            if (showAll) {
                for (String string : usrPaths) {
                    this.addFolderItems(string, string, childSubDir, false, false, true, substitutionOffset);
                }
                for (String string : sysPaths) {
                    this.addFolderItems(string, string, childSubDir, false, true, false, substitutionOffset);
                }
            }
            if (usrDir.getParentFile() != null) {
                this.addParentFolder(substitutionOffset, childSubDir, false);
            }
        } else {
            for (String string : sysPaths) {
                this.addFolderItems(string, string, childSubDir, false, true, false, substitutionOffset);
            }
            if (showAll) {
                for (String string : usrPaths) {
                    this.addFolderItems(string, string, childSubDir, false, false, true, substitutionOffset);
                }
                this.addFolderItems(usrDir.getAbsolutePath(), ".", childSubDir, false, false, true, substitutionOffset);
                if (usrDir.getParentFile() != null) {
                    this.addParentFolder(substitutionOffset, childSubDir, true);
                }
            }
        }
        return this.results.values();
    }

    private void addFolderItems(String parentFolder, String parentFolderPresentation, String childSubDir, boolean highPriority, boolean system, boolean filtered, int substitutionOffset) {
        File dir = new File(parentFolder, childSubDir);
        if (dir != null && dir.exists()) {
            File[] list;
            File[] fileArray = list = filtered ? dir.listFiles(new HeadersFileFilter()) : dir.listFiles(new DefFileFilter());
            if (list != null) {
                for (File curFile : list) {
                    String relFileName = curFile.getName();
                    CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, relFileName, parentFolderPresentation, childSubDir, system, highPriority, curFile.isDirectory(), true);
                    if (this.results.containsKey(relFileName)) continue;
                    this.results.put(relFileName, item);
                }
            }
        }
    }

    private void addParentFolder(int substitutionOffset, String childSubDir, boolean system) {
        if (!this.results.isEmpty()) {
            CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, "..", ".", childSubDir, system, false, true, false);
            this.results.put("..", item);
        }
    }

    private Collection<String> getFileIncludes(CsmFile file, boolean system) {
        CsmFileInfoQuery query = CsmFileInfoQuery.getDefault();
        return CndFileUtils.toPathList((Collection)(system ? query.getSystemIncludePaths(file) : query.getUserIncludePaths(file)));
    }

    private static boolean isHeaderFileWoExt(File pathname) {
        if (FileUtil.getExtension((String)pathname.getName()).length() == 0) {
            return "text/x-h".equals(MIMESupport.getFileMIMEType((File)pathname));
        }
        return false;
    }

    private static boolean specialFile(File file) {
        String name = file.getName();
        if (name.startsWith(".")) {
            return true;
        }
        if (name.endsWith("~")) {
            return true;
        }
        return file.isDirectory() && EXCLUDED_DIR_NAMES.contains(name);
    }

    private static final class HeadersFileFilter
    implements FileFilter {
        private final ExtensionList exts = new ExtensionList();

        protected HeadersFileFilter() {
            for (String ext : MIMEExtensions.get((String)"text/x-h").getValues()) {
                this.exts.addExtension(ext);
            }
        }

        @Override
        public boolean accept(File pathname) {
            return !CsmIncludeCompletionQuery.specialFile(pathname) && (this.exts.isRegistered(pathname.getName()) || pathname.isDirectory() || CsmIncludeCompletionQuery.isHeaderFileWoExt(pathname));
        }
    }

    private static final class DefFileFilter
    implements FileFilter {
        private DefFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !CsmIncludeCompletionQuery.specialFile(pathname);
        }
    }
}

