/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlHelper
extends BaseHelper {
    protected static Document parseXmlDocument(final FileObject xmlFO) {
        return (Document)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Document>(){

            public Document run() {
                if (xmlFO == null || !xmlFO.isData()) {
                    return null;
                }
                try {
                    return XmlHelper.doParseXmlDocument(xmlFO);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (SAXException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                return null;
            }
        });
    }

    protected static void saveXmlDocument(final Document doc, final FileObject xmlFO) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                try {
                    XmlHelper.doSaveXmlDocument(doc, xmlFO);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSaveXmlDocument(Document doc, FileObject xmlFO) throws IOException {
        FileLock lock = xmlFO.lock();
        try {
            OutputStream out = xmlFO.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
            }
            finally {
                out.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document doParseXmlDocument(FileObject xmlFO) throws FileNotFoundException, IOException, SAXException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = xmlFO.getInputStream();
        try {
            FileUtil.copy((InputStream)in, (OutputStream)baos);
        }
        finally {
            in.close();
        }
        return XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(baos.toByteArray())), (boolean)false, (boolean)false, null, null);
    }
}

