/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.TableColumnSelector;

public class ETableColumnModel
extends DefaultTableColumnModel {
    private static final String NUMBER_OF_COLUMNS = "ColumnsNumber";
    private static final String NUMBER_OF_HIDDEN_COLUMNS = "HiddenColumnsNumber";
    private static final String PROP_HIDDEN_PREFIX = "Hidden";
    protected transient List<TableColumn> sortedColumns = new ArrayList<TableColumn>();
    protected List<TableColumn> hiddenColumns = new ArrayList<TableColumn>();
    private TableColumnSelector.TreeNode columnHierarchyRoot;

    public void readSettings(Properties p, String propertyPrefix, ETable table) {
        this.tableColumns = new Vector();
        this.sortedColumns = new ArrayList<TableColumn>();
        String s = p.getProperty(propertyPrefix + NUMBER_OF_COLUMNS);
        int numColumns = Integer.parseInt(s);
        for (int i = 0; i < numColumns; ++i) {
            ETableColumn setc;
            int j;
            ETableColumn etc = (ETableColumn)table.createColumn(i);
            etc.readSettings(p, i, propertyPrefix);
            this.addColumn(etc);
            if (etc.getComparator() == null) continue;
            for (j = 0; j < this.sortedColumns.size() && (setc = (ETableColumn)this.sortedColumns.get(j)).getSortRank() <= etc.getSortRank(); ++j) {
            }
            this.sortedColumns.add(j, etc);
        }
        this.hiddenColumns = new ArrayList<TableColumn>();
        String sh = p.getProperty(propertyPrefix + NUMBER_OF_HIDDEN_COLUMNS);
        int numHiddenColumns = Integer.parseInt(sh);
        for (int i = 0; i < numHiddenColumns; ++i) {
            ETableColumn etc = new ETableColumn(table);
            etc.readSettings(p, i, propertyPrefix + PROP_HIDDEN_PREFIX);
            this.hiddenColumns.add(etc);
        }
    }

    public void writeSettings(Properties p, String propertyPrefix) {
        int i = 0;
        int numColumns = this.tableColumns.size();
        p.setProperty(propertyPrefix + NUMBER_OF_COLUMNS, Integer.toString(numColumns));
        for (Object obj : this.tableColumns) {
            if (!(obj instanceof ETableColumn)) continue;
            ETableColumn etc = (ETableColumn)obj;
            etc.writeSettings(p, i++, propertyPrefix);
        }
        i = 0;
        int numHiddenColumns = this.hiddenColumns.size();
        p.setProperty(propertyPrefix + NUMBER_OF_HIDDEN_COLUMNS, Integer.toString(numHiddenColumns));
        for (TableColumn obj : this.hiddenColumns) {
            if (!(obj instanceof ETableColumn)) continue;
            ETableColumn etc = (ETableColumn)obj;
            etc.writeSettings(p, i++, propertyPrefix + PROP_HIDDEN_PREFIX);
        }
    }

    public Comparator<ETable.RowMapping> getComparator() {
        if (this.sortedColumns.isEmpty()) {
            return new ETable.OriginalRowComparator();
        }
        return new CompoundComparator();
    }

    public void setColumnSorted(ETableColumn etc, boolean ascending, int newRank) {
        if (!etc.isSortingAllowed()) {
            return;
        }
        boolean wasSorted = this.sortedColumns.contains(etc);
        if (wasSorted) {
            etc.setAscending(ascending);
            etc.setSortRank(newRank);
            this.sortedColumns.remove(etc);
        } else {
            etc.setSorted(newRank, ascending);
        }
        if (newRank > 0) {
            this.sortedColumns.add(newRank - 1, etc);
        }
    }

    void toggleSortedColumn(ETableColumn etc, boolean cleanAll) {
        if (!etc.isSortingAllowed()) {
            return;
        }
        boolean wasSorted = this.sortedColumns.contains(etc);
        if (cleanAll) {
            this.clearSortedColumns(etc);
        }
        if (wasSorted) {
            if (etc.isAscending()) {
                etc.setAscending(false);
            } else {
                this.sortedColumns.remove(etc);
                etc.setSorted(0, false);
            }
            this.updateRanks();
        } else {
            etc.setSorted(this.sortedColumns.size() + 1, true);
            this.sortedColumns.add(etc);
        }
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (this.sortedColumns.remove(column)) {
            int i = 1;
            for (TableColumn sc : this.sortedColumns) {
                if (sc instanceof ETableColumn) {
                    ETableColumn etc = (ETableColumn)sc;
                    etc.setSorted(i, etc.isAscending());
                }
                ++i;
            }
        }
        if (!this.hiddenColumns.remove(column)) {
            super.removeColumn(column);
        }
    }

    public void setColumnHidden(TableColumn column, boolean hidden) {
        if (hidden) {
            if (!this.hiddenColumns.contains(column) && this.tableColumns.contains(column)) {
                this.removeColumn(column);
                this.hiddenColumns.add(column);
            }
        } else if (!this.tableColumns.contains(column) && this.hiddenColumns.contains(column)) {
            this.hiddenColumns.remove(column);
            this.addColumn(column);
        }
    }

    public boolean isColumnHidden(TableColumn tc) {
        return this.hiddenColumns.contains(tc);
    }

    public void clearSortedColumns() {
        for (TableColumn o : this.sortedColumns) {
            if (!(o instanceof ETableColumn)) continue;
            ETableColumn etc = (ETableColumn)o;
            etc.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
    }

    void clearSortedColumns(TableColumn notThisOne) {
        boolean wasSorted = this.sortedColumns.contains(notThisOne);
        for (TableColumn o : this.sortedColumns) {
            if (!(o instanceof ETableColumn) || o == notThisOne) continue;
            ETableColumn etc = (ETableColumn)o;
            etc.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
        if (wasSorted) {
            this.sortedColumns.add(notThisOne);
        }
    }

    private void updateRanks() {
        int i = 1;
        for (TableColumn o : this.sortedColumns) {
            ETableColumn etc;
            if (o instanceof ETableColumn && (etc = (ETableColumn)o).isSorted()) {
                etc.setSortRank(i);
            }
            ++i;
        }
    }

    List<TableColumn> getSortedColumns() {
        return this.sortedColumns;
    }

    public void clean() {
        ArrayList<TableColumn> allColumns = new ArrayList<TableColumn>(this.tableColumns.size() + this.hiddenColumns.size());
        allColumns.addAll(this.tableColumns);
        allColumns.addAll(this.hiddenColumns);
        for (TableColumn tc : allColumns) {
            this.removeColumn(tc);
        }
    }

    public TableColumnSelector.TreeNode getColumnHierarchyRoot() {
        return this.columnHierarchyRoot;
    }

    public void setColumnHierarchyRoot(TableColumnSelector.TreeNode columnHierarchyRoot) {
        this.columnHierarchyRoot = columnHierarchyRoot;
    }

    private class CompoundComparator
    implements Comparator<ETable.RowMapping> {
        private Comparator<ETable.RowMapping> original = new ETable.OriginalRowComparator();

        @Override
        public int compare(ETable.RowMapping o1, ETable.RowMapping o2) {
            for (TableColumn o : ETableColumnModel.this.sortedColumns) {
                int res;
                ETableColumn etc;
                Comparator<ETable.RowMapping> c;
                if (!(o instanceof ETableColumn) || (c = (etc = (ETableColumn)o).getComparator()) == null || (res = c.compare(o1, o2)) == 0) continue;
                return res;
            }
            return this.original.compare(o1, o2);
        }
    }
}

