/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.spi.RestServicesMetadataModelFactory;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public abstract class RestSupport {
    public static final String SWDP_LIBRARY = "restlib";
    public static final String RESTAPI_LIBRARY = "restapi";
    protected static final String GFV3_RESTLIB = "restlib_gfv3ee6";
    protected static final String GFV31_RESTLIB = "restlib_gfv31ee6";
    public static final String PROP_SWDP_CLASSPATH = "libs.swdp.classpath";
    public static final String PROP_RESTBEANS_TEST_DIR = "restbeans.test.dir";
    public static final String PROP_RESTBEANS_TEST_FILE = "restbeans.test.file";
    public static final String PROP_RESTBEANS_TEST_URL = "restbeans.test.url";
    public static final String PROP_BASE_URL_TOKEN = "base.url.token";
    public static final String PROP_APPLICATION_PATH = "rest.application.path";
    public static final String BASE_URL_TOKEN = "___BASE_URL___";
    public static final String RESTBEANS_TEST_DIR = "build/generated-sources/rest-test";
    public static final String COMMAND_TEST_RESTBEANS = "test-restbeans";
    public static final String TEST_RESBEANS = "test-resbeans";
    public static final String TEST_RESBEANS_HTML = "test-resbeans.html";
    public static final String TEST_RESBEANS_JS = "test-resbeans.js";
    public static final String TEST_RESBEANS_CSS = "test-resbeans.css";
    public static final String TEST_RESBEANS_CSS2 = "css_master-all.css";
    public static final String REST_SERVLET_ADAPTOR = "ServletAdaptor";
    public static final String REST_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String REST_SERVLET_ADAPTOR_CLASS_OLD = "com.sun.ws.rest.impl.container.servlet.ServletAdaptor";
    public static final String REST_SPRING_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.spring.container.servlet.SpringServlet";
    public static final String REST_SERVLET_ADAPTOR_MAPPING = "/resources/*";
    public static final String PARAM_WEB_RESOURCE_CLASS = "webresourceclass";
    public static final String WEB_RESOURCE_CLASS = "webresources.WebResources";
    public static final String REST_API_JAR = "jsr311-api.jar";
    public static final String REST_RI_JAR = "jersey";
    public static final String IGNORE_PLATFORM_RESTLIB = "restlib.ignore.platform";
    public static final String JSR311_JAR_PATTERN = "jsr311-api.*\\.jar";
    public static final String JERSEY_API_LOCATION = "modules/ext/rest";
    public static final String JTA_USER_TRANSACTION_CLASS = "javax/transaction/UserTransaction.class";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String TOMCAT_SERVER_TYPE = "tomcat";
    public static final String GFV3_SERVER_TYPE = "gfv3";
    public static final String GFV2_SERVER_TYPE = "J2EE";
    public static final int PROJECT_TYPE_DESKTOP = 0;
    public static final int PROJECT_TYPE_WEB = 1;
    public static final int PROJECT_TYPE_NB_MODULE = 2;
    private AntProjectHelper helper;
    protected RestServicesModel restServicesModel;
    protected RestApplicationModel restApplicationModel;
    private List<PropertyChangeListener> modelListeners = new ArrayList<PropertyChangeListener>();
    protected final Project project;

    public RestSupport(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
    }

    public abstract void upgrade();

    public abstract void ensureRestDevelopmentReady() throws IOException;

    public abstract void removeRestDevelopmentReadiness() throws IOException;

    public abstract boolean isReady();

    public abstract FileObject getPersistenceXml();

    public abstract Datasource getDatasource(String var1);

    public FileObject findSourceRoot() {
        return RestSupport.findSourceRoot(this.getProject());
    }

    public static FileObject findSourceRoot(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        return null;
    }

    private static ClassPath getClassPath(Project project, String string) {
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>(sourceGroupArray.length);
        for (SourceGroup sourceGroup : sourceGroupArray) {
            String string2 = sourceGroup.getName();
            if (string2 != null && string2.contains("test")) continue;
            FileObject fileObject = sourceGroup.getRootFolder();
            ClassPath classPath = classPathProvider.findClassPath(fileObject, string);
            arrayList.add(classPath);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])arrayList.toArray(new ClassPath[arrayList.size()]));
    }

    public void addModelListener(PropertyChangeListener propertyChangeListener) {
        this.modelListeners.add(propertyChangeListener);
        if (this.restServicesModel != null) {
            this.restServicesModel.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeModelListener(PropertyChangeListener propertyChangeListener) {
        this.modelListeners.remove(propertyChangeListener);
        if (this.restServicesModel != null) {
            this.restServicesModel.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public RestServicesModel getRestServicesModel() {
        ClassPathProvider classPathProvider;
        FileObject fileObject = this.findSourceRoot();
        if (this.restServicesModel == null && fileObject != null && (classPathProvider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class)) != null) {
            ClassPath classPath = classPathProvider.findClassPath(fileObject, "classpath/compile");
            ClassPath classPath2 = classPathProvider.findClassPath(fileObject, "classpath/boot");
            ClassPath classPath3 = classPathProvider.findClassPath(fileObject, "classpath/source");
            if (classPath != null && classPath2 != null) {
                MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)classPath2, (ClassPath)RestSupport.extendWithJsr311Api(classPath), (ClassPath)classPath3, null);
                this.restServicesModel = RestServicesMetadataModelFactory.createMetadataModel(metadataUnit, this.project);
                for (PropertyChangeListener propertyChangeListener : this.modelListeners) {
                    this.restServicesModel.addPropertyChangeListener(propertyChangeListener);
                }
            }
        }
        return this.restServicesModel;
    }

    public RestApplicationModel getRestApplicationsModel() {
        FileObject fileObject = this.findSourceRoot();
        if (this.restApplicationModel == null && fileObject != null) {
            ClassPathProvider classPathProvider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/boot"), (ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/compile"), (ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/source"), null);
            this.restApplicationModel = RestServicesMetadataModelFactory.createApplicationMetadataModel(metadataUnit, this.project);
        }
        return this.restApplicationModel;
    }

    protected void refreshRestServicesMetadataModel() {
        if (this.restServicesModel != null) {
            for (PropertyChangeListener propertyChangeListener : this.modelListeners) {
                this.restServicesModel.removePropertyChangeListener(propertyChangeListener);
            }
            this.restServicesModel = null;
        }
        try {
            RestServicesModel restServicesModel = this.getRestServicesModel();
            if (restServicesModel != null) {
                restServicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                        restServicesMetadata.getRoot().sizeRestServiceDescription();
                        return null;
                    }
                });
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    public static ClassPath extendWithJsr311Api(ClassPath classPath) {
        File[] fileArray;
        File file = InstalledFileLocator.getDefault().locate(JERSEY_API_LOCATION, null, false);
        if (file != null && file.isDirectory() && (fileArray = file.listFiles(new JerseyFilter(JSR311_JAR_PATTERN))) != null && fileArray.length > 0) {
            return RestSupport.extendClassPath(classPath, fileArray[0]);
        }
        return classPath;
    }

    public static ClassPath extendClassPath(ClassPath classPath, File file) {
        if (file == null) {
            return classPath;
        }
        try {
            PathResourceImplementation pathResourceImplementation = RestSupport.getPathResource(file);
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            arrayList.add(pathResourceImplementation);
            for (FileObject fileObject : classPath.getRoots()) {
                arrayList.add(ClassPathSupport.createResource((URL)fileObject.getURL()));
            }
            return ClassPathSupport.createClassPath(arrayList);
        }
        catch (Exception exception) {
            return classPath;
        }
    }

    private static PathResourceImplementation getPathResource(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else {
            uRL = file.toURI().toURL();
            String string = uRL.toExternalForm();
            if (!string.endsWith("/")) {
                uRL = new URL(string + "/");
            }
        }
        return ClassPathSupport.createResource((URL)uRL);
    }

    public abstract void extendBuildScripts() throws IOException;

    public FileObject generateTestClient(File file) throws IOException {
        if (!file.isDirectory()) {
            FileUtil.createFolder((File)file);
        }
        String[] stringArray = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] stringArray2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed"};
        FileObject fileObject = RestSupport.copyFile(file, TEST_RESBEANS_HTML, stringArray, true);
        RestSupport.copyFile(file, TEST_RESBEANS_JS, stringArray2, false);
        RestSupport.copyFile(file, TEST_RESBEANS_CSS);
        RestSupport.copyFile(file, TEST_RESBEANS_CSS2);
        RestSupport.copyFile(file, "expand.gif");
        RestSupport.copyFile(file, "collapse.gif");
        RestSupport.copyFile(file, "item.gif");
        RestSupport.copyFile(file, "cc.gif");
        RestSupport.copyFile(file, "og.gif");
        RestSupport.copyFile(file, "cg.gif");
        RestSupport.copyFile(file, "app.gif");
        File file2 = new File(file, "images");
        file2.mkdir();
        RestSupport.copyFile(file, "images/background_border_bottom.gif");
        RestSupport.copyFile(file, "images/pbsel.png");
        RestSupport.copyFile(file, "images/bg_gradient.gif");
        RestSupport.copyFile(file, "images/pname.png");
        RestSupport.copyFile(file, "images/level1_deselect.jpg");
        RestSupport.copyFile(file, "images/level1_selected-1lvl.jpg");
        RestSupport.copyFile(file, "images/primary-enabled.gif");
        RestSupport.copyFile(file, "images/masthead.png");
        RestSupport.copyFile(file, "images/masthead_link_enabled.gif");
        RestSupport.copyFile(file, "images/masthead_link_roll.gif");
        RestSupport.copyFile(file, "images/primary-roll.gif");
        RestSupport.copyFile(file, "images/pbdis.png");
        RestSupport.copyFile(file, "images/secondary-enabled.gif");
        RestSupport.copyFile(file, "images/pbena.png");
        RestSupport.copyFile(file, "images/tbsel.png");
        RestSupport.copyFile(file, "images/pbmou.png");
        RestSupport.copyFile(file, "images/tbuns.png");
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject copyFile(File file, String string, String[] stringArray, boolean bl) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string);
        } else if (!bl) {
            return fileObject2;
        }
        FileLock fileLock = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            int n;
            fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            InputStream inputStream = RestSupport.class.getResourceAsStream("resources/" + string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = "\n";
            if (File.separatorChar == '\\') {
                string3 = "\r\n";
            }
            String[] stringArray2 = null;
            if (stringArray != null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = NbBundle.getMessage(RestSupport.class, (String)stringArray[n]);
                }
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    string2 = string2.replaceAll(stringArray[n], stringArray2[n]);
                }
                bufferedWriter.write(string2);
                bufferedWriter.write(string3);
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, String string) throws IOException {
        String string2 = "resources/" + string;
        File file2 = new File(file, string);
        if (!file2.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = RestSupport.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file2);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected void addSwdpLibrary(String[] stringArray, boolean bl, String string) throws IOException {
        FileObject fileObject = this.findSourceRoot();
        if (fileObject != null) {
            Library library;
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            if (classPath.findResource(string) == null) {
                library = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY);
                if (library == null) {
                    return;
                }
                this.addSwdpLibrary(stringArray, library);
            }
            if (bl) {
                library = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
                if (library == null) {
                    return;
                }
                this.addSwdpLibrary(stringArray, library);
            }
        }
    }

    protected void addSwdpLibrary(String[] stringArray, Library library) throws IOException {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            throw new IOException("Project has no Java sources");
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        for (String string : stringArray) {
            try {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.getLogger(this.getClass().getName()).info(string + " not supported.");
            }
        }
    }

    public void removeSwdpLibrary(String[] stringArray) throws IOException {
        Library library = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (library == null) {
            return;
        }
        Library library2 = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY);
        if (library2 == null) {
            // empty if block
        }
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        for (String string : stringArray) {
            try {
                ProjectClassPathModifier.removeLibraries((Library[])new Library[]{library2, library}, (FileObject)fileObject, (String)string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.getLogger(this.getClass().getName()).info(string + " not supported.");
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    public boolean hasSwdpLibrary() {
        return !RestSupport.needsSwdpLibrary(this.getProject());
    }

    private static boolean needsSwdpLibrary(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray.length < 1) {
            return false;
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        FileObject fileObject2 = classPath.findResource(REST_SERVLET_ADAPTOR_CLASS);
        return fileObject2 == null;
    }

    public abstract boolean isRestSupportOn();

    public void setProjectProperty(String string, String string2) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        editableProperties.setProperty(string, string2);
        this.helper.putProperties("nbproject/project.properties", editableProperties);
        try {
            ProjectManager.getDefault().saveProject(this.getProject());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    public String getProjectProperty(String string) {
        if (this.getAntProjectHelper() == null) {
            return null;
        }
        return this.helper.getStandardPropertyEvaluator().getProperty(string);
    }

    public void removeProjectProperties(String[] stringArray) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        for (String string : stringArray) {
            editableProperties.remove((Object)string);
        }
        this.helper.putProperties("nbproject/project.properties", editableProperties);
        try {
            ProjectManager.getDefault().saveProject(this.getProject());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    protected boolean ignorePlatformRestLibrary() {
        String string = this.getProjectProperty(IGNORE_PLATFORM_RESTLIB);
        Boolean bl = string != null ? Boolean.valueOf(string) : true;
        return bl != Boolean.FALSE;
    }

    public AntProjectHelper getAntProjectHelper() {
        JAXWSSupport jAXWSSupport;
        JAXWSSupportProvider jAXWSSupportProvider;
        if (this.helper == null && (jAXWSSupportProvider = (JAXWSSupportProvider)this.project.getLookup().lookup(JAXWSSupportProvider.class)) != null && (jAXWSSupport = jAXWSSupportProvider.findJAXWSSupport(this.project.getProjectDirectory())) != null) {
            this.helper = jAXWSSupport.getAntProjectHelper();
        }
        return this.helper;
    }

    public boolean hasJTASupport() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length < 1) {
            return false;
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        FileObject fileObject2 = classPath.findResource(JTA_USER_TRANSACTION_CLASS);
        return fileObject2 != null;
    }

    public boolean hasSpringSupport() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length < 1) {
            return false;
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        FileObject fileObject2 = classPath.findResource("org/springframework/transaction/annotation/Transactional.class");
        return fileObject2 != null;
    }

    public String getServerType() {
        return this.getProjectProperty(J2EE_SERVER_TYPE);
    }

    public boolean isServerTomcat() {
        String string = this.getServerType();
        if (string != null) {
            return string.toLowerCase().contains(TOMCAT_SERVER_TYPE);
        }
        return false;
    }

    public boolean isServerGFV3() {
        if (this.getServerType() == null) {
            return false;
        }
        return this.getServerType().startsWith(GFV3_SERVER_TYPE);
    }

    public boolean isServerGFV2() {
        return GFV2_SERVER_TYPE.equals(this.getServerType());
    }

    public String getApplicationPath() throws IOException {
        return "resources";
    }

    public abstract int getProjectType();

    protected static class JerseyFilter
    implements FileFilter {
        private Pattern pattern;

        JerseyFilter(String string) {
            this.pattern = Pattern.compile(string);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

