/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.hierarchy.HierarchyTopComponent;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class ShowIncludeHierarchyAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        CsmFile file = ContextUtils.findFile(activatedNodes);
        if (file != null) {
            HierarchyTopComponent view = HierarchyTopComponent.findInstance();
            if (!view.isOpened()) {
                view.open();
            }
            view.setFile(file, false);
            view.requestActive();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            CsmReference ref;
            if (ContextUtils.USE_REFERENCE_RESOLVER && (ref = ContextUtils.findReference(activatedNodes[0])) != null && ref.getClosestTopLevelObject() != null) {
                return CsmKindUtilities.isInclude((CsmObject)ref.getClosestTopLevelObject());
            }
            return ContextUtils.findFile(activatedNodes[0]) != null;
        }
        return false;
    }

    protected int mode() {
        return 8;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ShowIncludeAction");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

