/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends JCTree.Visitor {
    private final boolean sourceOutput;
    Writer out;
    public int width = 4;
    int lmargin = 0;
    Name enclClassName;
    Map<JCTree, String> docComments = null;
    String lineSep = System.getProperty("line.separator");
    int prec;

    public Pretty(Writer out, boolean sourceOutput) {
        this.out = out;
        this.sourceOutput = sourceOutput;
    }

    void align() throws IOException {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.write(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write("(");
        }
    }

    void close(int contextPrec, int ownPrec) throws IOException {
        if (ownPrec < contextPrec) {
            this.out.write(")");
        }
    }

    public void print(Object s) throws IOException {
        String text = s.toString();
        this.out.write(this.sourceOutput ? Convert.escapeUnicode(text) : text);
    }

    public void println() throws IOException {
        this.out.write(this.lineSep);
    }

    public void printExpr(JCTree tree, int prec) throws IOException {
        int prevPrec = this.prec;
        try {
            block5: {
                try {
                    this.prec = prec;
                    if (tree == null) {
                        this.print("/*missing*/");
                        break block5;
                    }
                    tree.accept(this);
                }
                catch (UncheckedIOException ex) {
                    IOException e = new IOException(ex.getMessage());
                    e.initCause(ex);
                    throw e;
                }
            }
            Object var7_4 = null;
            this.prec = prevPrec;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.prec = prevPrec;
            throw throwable;
        }
    }

    public void printExpr(JCTree tree) throws IOException {
        this.printExpr(tree, 0);
    }

    public void printStat(JCTree tree) throws IOException {
        this.printExpr(tree, -1);
    }

    public <T extends JCTree> void printExprs(List<T> trees, String sep) throws IOException {
        if (trees.nonEmpty()) {
            this.printExpr((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    public <T extends JCTree> void printExprs(List<T> trees) throws IOException {
        this.printExprs(trees, ", ");
    }

    public void printStats(List<? extends JCTree> trees) throws IOException {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.align();
            this.printStat((JCTree)l.head);
            this.println();
            l = l.tail;
        }
    }

    public void printFlags(long flags) throws IOException {
        if ((flags & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(flags));
        if ((flags & 0xFFFL) != 0L) {
            this.print(" ");
        }
        if ((flags & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printAnnotations(List<JCTree.JCAnnotation> trees) throws IOException {
        List<JCTree.JCAnnotation> l = trees;
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            this.println();
            this.align();
            l = l.tail;
        }
    }

    public void printDocComment(JCTree tree) throws IOException {
        String dc;
        if (this.docComments != null && (dc = this.docComments.get(tree)) != null) {
            this.print("/**");
            this.println();
            int pos = 0;
            int endpos = Pretty.lineEndPos(dc, pos);
            while (pos < dc.length()) {
                this.align();
                this.print(" *");
                if (pos < dc.length() && dc.charAt(pos) > ' ') {
                    this.print(" ");
                }
                this.print(dc.substring(pos, endpos));
                this.println();
                pos = endpos + 1;
                endpos = Pretty.lineEndPos(dc, pos);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String s, int start) {
        int pos = s.indexOf(10, start);
        if (pos < 0) {
            pos = s.length();
        }
        return pos;
    }

    public void printTypeParameters(List<JCTree.JCTypeParameter> trees) throws IOException {
        if (trees.nonEmpty()) {
            this.print("<");
            this.printExprs(trees);
            this.print(">");
        }
    }

    public void printBlock(List<? extends JCTree> stats) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(stats);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumBody(List<JCTree> stats) throws IOException {
        this.print("{");
        this.println();
        this.indent();
        boolean first = true;
        List<JCTree> l = stats;
        while (l.nonEmpty()) {
            if (this.isEnumerator((JCTree)l.head)) {
                if (!first) {
                    this.print(",");
                    this.println();
                }
                this.align();
                this.printStat((JCTree)l.head);
                first = false;
            }
            l = l.tail;
        }
        this.print(";");
        this.println();
        l = stats;
        while (l.nonEmpty()) {
            if (!this.isEnumerator((JCTree)l.head)) {
                this.align();
                this.printStat((JCTree)l.head);
                this.println();
            }
            l = l.tail;
        }
        this.undent();
        this.align();
        this.print("}");
    }

    boolean isEnumerator(JCTree t) {
        return t.getTag() == 5 && (((JCTree.JCVariableDecl)t).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(JCTree.JCCompilationUnit tree, JCTree.JCClassDecl cdef) throws IOException {
        this.docComments = tree.docComments;
        this.printDocComment(tree);
        if (tree.pid != null) {
            this.print("package ");
            this.printExpr(tree.pid);
            this.print(";");
            this.println();
        }
        boolean firstImport = true;
        List<JCTree> l = tree.defs;
        while (l.nonEmpty() && (cdef == null || ((JCTree)l.head).getTag() == 2)) {
            if (((JCTree)l.head).getTag() == 2) {
                JCTree.JCImport imp = (JCTree.JCImport)l.head;
                Name name = TreeInfo.name(imp.qualid);
                if (name == name.table.names.asterisk || cdef == null || this.isUsed(TreeInfo.symbol(imp.qualid), cdef)) {
                    if (firstImport) {
                        firstImport = false;
                        this.println();
                    }
                    this.printStat(imp);
                }
            } else {
                this.printStat((JCTree)l.head);
            }
            l = l.tail;
        }
        if (cdef != null) {
            this.printStat(cdef);
            this.println();
        }
    }

    boolean isUsed(final Symbol t, JCTree cdef) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && !this.result) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (tree.sym == t) {
                    this.result = true;
                }
            }
        }
        UsedVisitor v = new UsedVisitor();
        v.scan(cdef);
        return v.result;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        try {
            this.printUnit(tree, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        try {
            this.print("import ");
            if (tree.staticImport) {
                this.print("static ");
            }
            this.printExpr(tree.qualid);
            this.print(";");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        try {
            this.println();
            this.align();
            this.printDocComment(tree);
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags & 0xFFFFFFFFFFFFFDFFL);
            Name enclClassNamePrev = this.enclClassName;
            this.enclClassName = tree.name;
            if ((tree.mods.flags & 0x200L) != 0L) {
                this.print("interface " + tree.name);
                this.printTypeParameters(tree.typarams);
                if (tree.implementing.nonEmpty()) {
                    this.print(" extends ");
                    this.printExprs(tree.implementing);
                }
            } else {
                if ((tree.mods.flags & 0x4000L) != 0L) {
                    this.print("enum " + tree.name);
                } else {
                    this.print("class " + tree.name);
                }
                this.printTypeParameters(tree.typarams);
                if (tree.extending != null) {
                    this.print(" extends ");
                    this.printExpr(tree.extending);
                }
                if (tree.implementing.nonEmpty()) {
                    this.print(" implements ");
                    this.printExprs(tree.implementing);
                }
            }
            this.print(" ");
            if ((tree.mods.flags & 0x4000L) != 0L) {
                this.printEnumBody(tree.defs);
            } else {
                this.printBlock(tree.defs);
            }
            this.enclClassName = enclClassNamePrev;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        try {
            if (tree.name == tree.name.table.names.init && this.enclClassName == null && this.sourceOutput) {
                return;
            }
            this.println();
            this.align();
            this.printDocComment(tree);
            this.printExpr(tree.mods);
            this.printTypeParameters(tree.typarams);
            if (tree.name == tree.name.table.names.init) {
                this.print(this.enclClassName != null ? this.enclClassName : tree.name);
            } else {
                this.printExpr(tree.restype);
                this.print(" " + tree.name);
            }
            this.print("(");
            this.printExprs(tree.params);
            this.print(")");
            if (tree.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(tree.thrown);
            }
            if (tree.defaultValue != null) {
                this.print(" default ");
                this.printExpr(tree.defaultValue);
            }
            if (tree.body != null) {
                this.print(" ");
                this.printStat(tree.body);
            } else {
                this.print(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        try {
            if (this.docComments != null && this.docComments.get(tree) != null) {
                this.println();
                this.align();
            }
            this.printDocComment(tree);
            if ((tree.mods.flags & 0x4000L) != 0L) {
                this.print("/*public static final*/ ");
                this.print(tree.name);
                if (tree.init != null) {
                    if (this.sourceOutput && tree.init.getTag() == 27) {
                        this.print(" /*enum*/ ");
                        JCTree.JCNewClass init = (JCTree.JCNewClass)tree.init;
                        if (init.args != null && init.args.nonEmpty()) {
                            this.print("(");
                            this.print(init.args);
                            this.print(")");
                        }
                        if (init.def != null && init.def.defs != null) {
                            this.print(" ");
                            this.printBlock(init.def.defs);
                        }
                        return;
                    }
                    this.print(" /* = ");
                    this.printExpr(tree.init);
                    this.print(" */");
                }
            } else {
                this.printExpr(tree.mods);
                if ((tree.mods.flags & 0x400000000L) != 0L) {
                    this.printExpr(((JCTree.JCArrayTypeTree)tree.vartype).elemtype);
                    this.print("... " + tree.name);
                } else {
                    this.printExpr(tree.vartype);
                    this.print(" " + tree.name);
                }
                if (tree.init != null) {
                    this.print(" = ");
                    this.printExpr(tree.init);
                }
                if (this.prec == -1) {
                    this.print(";");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
        try {
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        try {
            this.printFlags(tree.flags);
            this.printBlock(tree.stats);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        try {
            this.print("do ");
            this.printStat(tree.body);
            this.align();
            this.print(" while ");
            if (tree.cond.getTag() == 29) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        try {
            this.print("while ");
            if (tree.cond.getTag() == 29) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        try {
            this.print("for (");
            if (tree.init.nonEmpty()) {
                if (((JCTree.JCStatement)tree.init.head).getTag() == 5) {
                    this.printExpr((JCTree)tree.init.head);
                    List l = tree.init.tail;
                    while (l.nonEmpty()) {
                        JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)l.head;
                        this.print(", " + vdef.name + " = ");
                        this.printExpr(vdef.init);
                        l = l.tail;
                    }
                } else {
                    this.printExprs(tree.init);
                }
            }
            this.print("; ");
            if (tree.cond != null) {
                this.printExpr(tree.cond);
            }
            this.print("; ");
            this.printExprs(tree.step);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        try {
            this.print("for (");
            this.printExpr(tree.var);
            this.print(" : ");
            this.printExpr(tree.expr);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        try {
            this.print(tree.label + ": ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        try {
            this.print("switch ");
            if (tree.selector.getTag() == 29) {
                this.printExpr(tree.selector);
            } else {
                this.print("(");
                this.printExpr(tree.selector);
                this.print(")");
            }
            this.print(" {");
            this.println();
            this.printStats(tree.cases);
            this.align();
            this.print("}");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        try {
            if (tree.pat == null) {
                this.print("default");
            } else {
                this.print("case ");
                this.printExpr(tree.pat);
            }
            this.print(": ");
            this.println();
            this.indent();
            this.printStats(tree.stats);
            this.undent();
            this.align();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        try {
            this.print("synchronized ");
            if (tree.lock.getTag() == 29) {
                this.printExpr(tree.lock);
            } else {
                this.print("(");
                this.printExpr(tree.lock);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        try {
            this.print("try ");
            if (tree.resources.nonEmpty()) {
                this.print("(");
                boolean first = true;
                for (JCTree var : tree.resources) {
                    if (!first) {
                        this.println();
                        this.indent();
                    }
                    this.printStat(var);
                    first = false;
                }
                this.print(") ");
            }
            this.printStat(tree.body);
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                this.printStat((JCTree)l.head);
                l = l.tail;
            }
            if (tree.finalizer != null) {
                this.print(" finally ");
                this.printStat(tree.finalizer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        try {
            this.print(" catch (");
            this.printExpr(tree.param);
            this.print(") ");
            this.printStat(tree.body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        try {
            this.open(this.prec, 3);
            this.printExpr(tree.cond, 3);
            this.print(" ? ");
            this.printExpr(tree.truepart, 3);
            this.print(" : ");
            this.printExpr(tree.falsepart, 3);
            this.close(this.prec, 3);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        try {
            this.print("if ");
            if (tree.cond.getTag() == 29) {
                this.printExpr(tree.cond);
            } else {
                this.print("(");
                this.printExpr(tree.cond);
                this.print(")");
            }
            this.print(" ");
            this.printStat(tree.thenpart);
            if (tree.elsepart != null) {
                this.print(" else ");
                this.printStat(tree.elsepart);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        try {
            this.printExpr(tree.expr);
            if (this.prec == -1) {
                this.print(";");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        try {
            this.print("break");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        try {
            this.print("continue");
            if (tree.label != null) {
                this.print(" " + tree.label);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        try {
            this.print("return");
            if (tree.expr != null) {
                this.print(" ");
                this.printExpr(tree.expr);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        try {
            this.print("throw ");
            this.printExpr(tree.expr);
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        try {
            this.print("assert ");
            this.printExpr(tree.cond);
            if (tree.detail != null) {
                this.print(" : ");
                this.printExpr(tree.detail);
            }
            this.print(";");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        try {
            if (!tree.typeargs.isEmpty()) {
                if (tree.meth.getTag() == 34) {
                    JCTree.JCFieldAccess left = (JCTree.JCFieldAccess)tree.meth;
                    this.printExpr(left.selected);
                    this.print(".<");
                    this.printExprs(tree.typeargs);
                    this.print(">" + left.name);
                } else {
                    this.print("<");
                    this.printExprs(tree.typeargs);
                    this.print(">");
                    this.printExpr(tree.meth);
                }
            } else {
                this.printExpr(tree.meth);
            }
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        try {
            if (tree.encl != null) {
                this.printExpr(tree.encl);
                this.print(".");
            }
            this.print("new ");
            if (!tree.typeargs.isEmpty()) {
                this.print("<");
                this.printExprs(tree.typeargs);
                this.print(">");
            }
            this.printExpr(tree.clazz);
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
            if (tree.def != null) {
                Name enclClassNamePrev = this.enclClassName;
                Name name = tree.def.name != null ? tree.def.name : (this.enclClassName = tree.type != null && tree.type.tsym.name != tree.type.tsym.name.table.names.empty ? tree.type.tsym.name : null);
                if ((tree.def.mods.flags & 0x4000L) != 0L) {
                    this.print("/*enum*/");
                }
                this.printBlock(tree.def.defs);
                this.enclClassName = enclClassNamePrev;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        try {
            if (tree.elemtype != null) {
                this.print("new ");
                JCTree.JCExpression elem = tree.elemtype;
                if (elem.getTag() == 38) {
                    this.printBaseElementType((JCTree.JCArrayTypeTree)elem);
                } else {
                    this.printExpr(elem);
                }
                List<JCTree.JCExpression> l = tree.dims;
                while (l.nonEmpty()) {
                    this.print("[");
                    this.printExpr((JCTree)l.head);
                    this.print("]");
                    l = l.tail;
                }
                if (elem instanceof JCTree.JCArrayTypeTree) {
                    this.printBrackets((JCTree.JCArrayTypeTree)elem);
                }
            }
            if (tree.elems != null) {
                if (tree.elemtype != null) {
                    this.print("[]");
                }
                this.print("{");
                this.printExprs(tree.elems);
                this.print("}");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        try {
            this.print("(");
            this.printExpr(tree.expr);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        try {
            this.open(this.prec, 1);
            this.printExpr(tree.lhs, 2);
            this.print(" = ");
            this.printExpr(tree.rhs, 1);
            this.close(this.prec, 1);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String operatorName(int tag) {
        switch (tag) {
            case 46: {
                return "+";
            }
            case 47: {
                return "-";
            }
            case 48: {
                return "!";
            }
            case 49: {
                return "~";
            }
            case 50: {
                return "++";
            }
            case 51: {
                return "--";
            }
            case 52: {
                return "++";
            }
            case 53: {
                return "--";
            }
            case 54: {
                return "<*nullchk*>";
            }
            case 55: {
                return "||";
            }
            case 56: {
                return "&&";
            }
            case 60: {
                return "==";
            }
            case 61: {
                return "!=";
            }
            case 62: {
                return "<";
            }
            case 63: {
                return ">";
            }
            case 64: {
                return "<=";
            }
            case 65: {
                return ">=";
            }
            case 57: {
                return "|";
            }
            case 58: {
                return "^";
            }
            case 59: {
                return "&";
            }
            case 66: {
                return "<<";
            }
            case 67: {
                return ">>";
            }
            case 68: {
                return ">>>";
            }
            case 69: {
                return "+";
            }
            case 70: {
                return "-";
            }
            case 71: {
                return "*";
            }
            case 72: {
                return "/";
            }
            case 73: {
                return "%";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        try {
            this.open(this.prec, 2);
            this.printExpr(tree.lhs, 3);
            this.print(" " + this.operatorName(tree.getTag() - 17) + "= ");
            this.printExpr(tree.rhs, 2);
            this.close(this.prec, 2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        try {
            int ownprec = TreeInfo.opPrec(tree.getTag());
            String opname = this.operatorName(tree.getTag());
            this.open(this.prec, ownprec);
            if (tree.getTag() <= 51) {
                this.print(opname);
                this.printExpr(tree.arg, ownprec);
            } else {
                this.printExpr(tree.arg, ownprec);
                this.print(opname);
            }
            this.close(this.prec, ownprec);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        try {
            int ownprec = TreeInfo.opPrec(tree.getTag());
            String opname = this.operatorName(tree.getTag());
            this.open(this.prec, ownprec);
            this.printExpr(tree.lhs, ownprec);
            this.print(" " + opname + " ");
            this.printExpr(tree.rhs, ownprec + 1);
            this.close(this.prec, ownprec);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        try {
            this.open(this.prec, 14);
            this.print("(");
            this.printExpr(tree.clazz);
            this.print(")");
            this.printExpr(tree.expr, 14);
            this.close(this.prec, 14);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        try {
            this.open(this.prec, 10);
            this.printExpr(tree.expr, 10);
            this.print(" instanceof ");
            this.printExpr(tree.clazz, 11);
            this.close(this.prec, 10);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        try {
            this.printExpr(tree.indexed, 15);
            this.print("[");
            this.printExpr(tree.index);
            this.print("]");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        try {
            this.printExpr(tree.selected, 15);
            this.print("." + tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        try {
            this.print(tree.name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        try {
            switch (tree.typetag) {
                case 4: {
                    this.print(tree.value.toString());
                    break;
                }
                case 5: {
                    this.print(tree.value + "L");
                    break;
                }
                case 6: {
                    this.print(tree.value + "F");
                    break;
                }
                case 7: {
                    this.print(tree.value.toString());
                    break;
                }
                case 2: {
                    this.print("'" + Convert.quote(String.valueOf((char)((Number)tree.value).intValue())) + "'");
                    break;
                }
                case 8: {
                    this.print(((Number)tree.value).intValue() == 1 ? "true" : "false");
                    break;
                }
                case 17: {
                    this.print("null");
                    break;
                }
                default: {
                    this.print("\"" + Convert.quote(tree.value.toString()) + "\"");
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        try {
            switch (tree.typetag) {
                case 1: {
                    this.print("byte");
                    break;
                }
                case 2: {
                    this.print("char");
                    break;
                }
                case 3: {
                    this.print("short");
                    break;
                }
                case 4: {
                    this.print("int");
                    break;
                }
                case 5: {
                    this.print("long");
                    break;
                }
                case 6: {
                    this.print("float");
                    break;
                }
                case 7: {
                    this.print("double");
                    break;
                }
                case 8: {
                    this.print("boolean");
                    break;
                }
                case 9: {
                    this.print("void");
                    break;
                }
                default: {
                    this.print("error");
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        try {
            this.printBaseElementType(tree);
            this.printBrackets(tree);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void printBaseElementType(JCTree tree) throws IOException {
        this.printExpr(TreeInfo.innermostType(tree));
    }

    private void printBrackets(JCTree.JCArrayTypeTree tree) throws IOException {
        while (true) {
            JCTree.JCExpression elem = tree.elemtype;
            this.print("[]");
            if (elem.getTag() != 38) break;
            tree = (JCTree.JCArrayTypeTree)elem;
        }
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        try {
            this.printExpr(tree.clazz);
            this.print("<");
            this.printExprs(tree.arguments);
            this.print(">");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeDisjunction(JCTree.JCTypeDisjunction tree) {
        try {
            this.printExprs(tree.alternatives, " | ");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        try {
            this.print(tree.name);
            if (tree.bounds.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.bounds, " & ");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        try {
            this.print(tree.kind);
            if (tree.kind.kind != BoundKind.UNBOUND) {
                this.printExpr(tree.inner);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
        try {
            this.print(String.valueOf((Object)tree.kind));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        try {
            this.print("(ERROR)");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        try {
            this.print("(let " + tree.defs + " in " + tree.expr + ")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers mods) {
        try {
            this.printAnnotations(mods.annotations);
            this.printFlags(mods.flags);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        try {
            this.print("@");
            this.printExpr(tree.annotationType);
            this.print("(");
            this.printExprs(tree.args);
            this.print(")");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void visitTree(JCTree tree) {
        try {
            this.print("(UNKNOWN: " + tree + ")");
            this.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException e) {
            super(e.getMessage(), e);
        }
    }
}

