/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code {
    public final boolean debugCode;
    public final boolean needStackMap;
    final Types types;
    final Symtab syms;
    public int max_stack = 0;
    public int max_locals = 0;
    public byte[] code = new byte[64];
    public int cp = 0;
    ListBuffer<char[]> catchInfo = new ListBuffer();
    List<char[]> lineInfo = List.nil();
    public CRTable crt;
    public boolean fatcode;
    private boolean alive = true;
    State state;
    private boolean fixedPc = false;
    public int nextreg = 0;
    Chain pendingJumps = null;
    int pendingStatPos = -1;
    boolean pendingStackMap = false;
    StackMapFormat stackMap;
    boolean varDebugInfo;
    boolean lineDebugInfo;
    Position.LineMap lineMap;
    final Pool pool;
    final Symbol.MethodSymbol meth;
    StackMapFrame[] stackMapBuffer = null;
    ClassWriter.StackMapTableFrame[] stackMapTableBuffer = null;
    int stackMapBufferSize = 0;
    int lastStackMapPC = -1;
    StackMapFrame lastFrame = null;
    StackMapFrame frameBeforeLast = null;
    static Type jsrReturnValue = new Type(4, null);
    LocalVar[] lvar;
    LocalVar[] varBuffer;
    int varBufferSize;

    public boolean checkLimits(JCDiagnostic.DiagnosticPosition pos, Log log) {
        if (this.cp > 65535) {
            log.error(pos, "limit.code", new Object[0]);
            return true;
        }
        if (this.max_locals > 65535) {
            log.error(pos, "limit.locals", new Object[0]);
            return true;
        }
        if (this.max_stack > 65535) {
            log.error(pos, "limit.stack", new Object[0]);
            return true;
        }
        return false;
    }

    public Code(Symbol.MethodSymbol meth, boolean fatcode, Position.LineMap lineMap, boolean varDebugInfo, StackMapFormat stackMap, boolean debugCode, CRTable crt, Symtab syms, Types types, Pool pool) {
        this.meth = meth;
        this.fatcode = fatcode;
        this.lineMap = lineMap;
        this.lineDebugInfo = lineMap != null;
        this.varDebugInfo = varDebugInfo;
        this.crt = crt;
        this.syms = syms;
        this.types = types;
        this.debugCode = debugCode;
        this.stackMap = stackMap;
        switch (stackMap) {
            case CLDC: 
            case JSR202: {
                this.needStackMap = true;
                break;
            }
            default: {
                this.needStackMap = false;
            }
        }
        this.state = new State();
        this.lvar = new LocalVar[20];
        this.pool = pool;
    }

    public static int typecode(Type type) {
        switch (type.tag) {
            case 1: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                return 4;
            }
        }
        throw new AssertionError((Object)("typecode " + type.tag));
    }

    public static int truncate(int tc) {
        switch (tc) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return tc;
    }

    public static int width(int typecode) {
        switch (typecode) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return type == null ? 1 : Code.width(Code.typecode(type));
    }

    public static int width(List<Type> types) {
        int w = 0;
        if (types != null) {
            List<Type> l = types;
            while (l.nonEmpty()) {
                w += Code.width((Type)l.head);
                l = l.tail;
            }
        }
        return w;
    }

    public static int arraycode(Type type) {
        switch (type.tag) {
            case 1: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 3: {
                return 9;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 1;
            }
        }
        throw new AssertionError((Object)("arraycode " + type));
    }

    public int curPc() {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.pendingStatPos != -1) {
            this.markStatBegin();
        }
        this.fixedPc = true;
        return this.cp;
    }

    private void emit1(int od) {
        if (!this.alive) {
            return;
        }
        if (this.cp == this.code.length) {
            byte[] newcode = new byte[this.cp * 2];
            System.arraycopy(this.code, 0, newcode, 0, this.cp);
            this.code = newcode;
        }
        this.code[this.cp++] = (byte)od;
    }

    private void emit2(int od) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 2 > this.code.length) {
            this.emit1(od >> 8);
            this.emit1(od);
        } else {
            this.code[this.cp++] = (byte)(od >> 8);
            this.code[this.cp++] = (byte)od;
        }
    }

    public void emit4(int od) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 4 > this.code.length) {
            this.emit1(od >> 24);
            this.emit1(od >> 16);
            this.emit1(od >> 8);
            this.emit1(od);
        } else {
            this.code[this.cp++] = (byte)(od >> 24);
            this.code[this.cp++] = (byte)(od >> 16);
            this.code[this.cp++] = (byte)(od >> 8);
            this.code[this.cp++] = (byte)od;
        }
    }

    private void emitop(int op) {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.alive) {
            if (this.pendingStatPos != -1) {
                this.markStatBegin();
            }
            if (this.pendingStackMap) {
                this.pendingStackMap = false;
                this.emitStackMap();
            }
            if (this.debugCode) {
                System.err.println("emit@" + this.cp + " stack=" + this.state.stacksize + ": " + Code.mnem(op));
            }
            this.emit1(op);
        }
    }

    void postop() {
        Assert.check(this.alive || this.state.stacksize == 0);
    }

    public void emitMultianewarray(int ndims, int type, Type arrayType) {
        this.emitop(197);
        if (!this.alive) {
            return;
        }
        this.emit2(type);
        this.emit1(ndims);
        this.state.pop(ndims);
        this.state.push(arrayType);
    }

    public void emitNewarray(int elemcode, Type arrayType) {
        this.emitop(188);
        if (!this.alive) {
            return;
        }
        this.emit1(elemcode);
        this.state.pop(1);
        this.state.push(arrayType);
    }

    public void emitAnewarray(int od, Type arrayType) {
        this.emitop(189);
        if (!this.alive) {
            return;
        }
        this.emit2(od);
        this.state.pop(1);
        this.state.push(arrayType);
    }

    public void emitInvokeinterface(int meth, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(185);
        if (!this.alive) {
            return;
        }
        this.emit2(meth);
        this.emit1(argsize + 1);
        this.emit1(0);
        this.state.pop(argsize + 1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokespecial(int meth, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(183);
        if (!this.alive) {
            return;
        }
        this.emit2(meth);
        Symbol sym = (Symbol)this.pool.pool[meth];
        this.state.pop(argsize);
        if (sym.isConstructor()) {
            this.state.markInitialized((UninitializedType)this.state.peek());
        }
        this.state.pop(1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokestatic(int meth, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(184);
        if (!this.alive) {
            return;
        }
        this.emit2(meth);
        this.state.pop(argsize);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokevirtual(int meth, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(182);
        if (!this.alive) {
            return;
        }
        this.emit2(meth);
        this.state.pop(argsize + 1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokedynamic(int desc, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(186);
        if (!this.alive) {
            return;
        }
        this.emit2(desc);
        this.emit2(0);
        this.state.pop(argsize);
        this.state.push(mtype.getReturnType());
    }

    public void emitop0(int op) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 50: {
                this.state.pop(1);
                Type a = this.state.stack[this.state.stacksize - 1];
                this.state.pop(1);
                this.state.push(this.types.erasure(this.types.elemtype(a)));
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            case 1: {
                this.state.push(this.syms.botType);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.state.push(this.syms.intType);
                break;
            }
            case 9: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.state.push(this.syms.longType);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 14: 
            case 15: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 42: {
                this.state.push(this.lvar[0].sym.type);
                break;
            }
            case 43: {
                this.state.push(this.lvar[1].sym.type);
                break;
            }
            case 44: {
                this.state.push(this.lvar[2].sym.type);
                break;
            }
            case 45: {
                this.state.push(this.lvar[3].sym.type);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 47: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 48: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 49: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 121: 
            case 123: 
            case 125: {
                this.state.pop(1);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 191: {
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: {
                this.state.pop(2);
                break;
            }
            case 173: 
            case 175: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(2);
                this.markDead();
                break;
            }
            case 89: {
                this.state.push(this.state.stack[this.state.stacksize - 1]);
                break;
            }
            case 177: {
                Assert.check(this.state.nlocks == 0);
                this.markDead();
                break;
            }
            case 190: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.state.pop(1);
                break;
            }
            case 83: {
                this.state.pop(3);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.state.pop(2);
                break;
            }
            case 148: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 136: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 133: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 134: {
                this.state.pop(1);
                this.state.push(this.syms.floatType);
                break;
            }
            case 135: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 137: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 138: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 139: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 140: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 141: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 142: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 143: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 144: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 170: 
            case 171: {
                this.state.pop(1);
                break;
            }
            case 90: {
                Type val1 = this.state.pop1();
                Type val2 = this.state.pop1();
                this.state.push(val1);
                this.state.push(val2);
                this.state.push(val1);
                break;
            }
            case 84: {
                this.state.pop(3);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.state.pop(1);
                break;
            }
            case 79: 
            case 81: 
            case 85: 
            case 86: {
                this.state.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.state.pop(4);
                break;
            }
            case 92: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value = this.state.pop2();
                this.state.push(value);
                this.state.push(value);
                break;
            }
            case 93: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value1 = this.state.pop2();
                Type value2 = this.state.pop1();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 94: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    if (this.state.stack[this.state.stacksize - 1] != null) {
                        Type value3 = this.state.pop1();
                        Type value4 = this.state.pop1();
                        this.state.push(value2);
                        this.state.push(value1);
                        this.state.push(value4);
                        this.state.push(value3);
                        this.state.push(value2);
                        this.state.push(value1);
                        break;
                    }
                    Type value3 = this.state.pop2();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value1 = this.state.pop2();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value2 = this.state.pop2();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 91: {
                Type value1 = this.state.pop1();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value2 = this.state.pop2();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 149: 
            case 150: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 151: 
            case 152: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 95: {
                Type value1 = this.state.pop1();
                Type value2 = this.state.pop1();
                this.state.push(value1);
                this.state.push(value2);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.state.pop(2);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            case 196: {
                return;
            }
            case 194: 
            case 195: {
                this.state.pop(1);
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    public void emitop1(int op, int od) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit1(od);
        switch (op) {
            case 16: {
                this.state.push(this.syms.intType);
                break;
            }
            case 18: {
                this.state.push(this.typeForPool(this.pool.pool[od]));
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    private Type typeForPool(Object o) {
        if (o instanceof Integer) {
            return this.syms.intType;
        }
        if (o instanceof Float) {
            return this.syms.floatType;
        }
        if (o instanceof String) {
            return this.syms.stringType;
        }
        if (o instanceof Long) {
            return this.syms.longType;
        }
        if (o instanceof Double) {
            return this.syms.doubleType;
        }
        if (o instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (o instanceof Type.ArrayType) {
            return this.syms.classType;
        }
        throw new AssertionError(o);
    }

    public void emitop1w(int op, int od) {
        if (od > 255) {
            this.emitop(196);
            this.emitop(op);
            this.emit2(od);
        } else {
            this.emitop(op);
            this.emit1(od);
        }
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 21: {
                this.state.push(this.syms.intType);
                break;
            }
            case 22: {
                this.state.push(this.syms.longType);
                break;
            }
            case 23: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 24: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 25: {
                this.state.push(this.lvar[od].sym.type);
                break;
            }
            case 55: 
            case 57: {
                this.state.pop(2);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.state.pop(1);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    public void emitop1w(int op, int od1, int od2) {
        if (od1 > 255 || od2 < -128 || od2 > 127) {
            this.emitop(196);
            this.emitop(op);
            this.emit2(od1);
            this.emit2(od2);
        } else {
            this.emitop(op);
            this.emit1(od1);
            this.emit1(od2);
        }
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 132: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public void emitop2(int op, int od) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit2(od);
        switch (op) {
            case 178: {
                this.state.push(((Symbol)this.pool.pool[od]).erasure(this.types));
                break;
            }
            case 179: {
                this.state.pop(((Symbol)this.pool.pool[od]).erasure(this.types));
                break;
            }
            case 187: {
                this.state.push(UninitializedType.uninitializedObject(((Symbol)this.pool.pool[od]).erasure(this.types), this.cp - 3));
                break;
            }
            case 17: {
                this.state.push(this.syms.intType);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.state.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.state.pop(2);
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 181: {
                this.state.pop(((Symbol)this.pool.pool[od]).erasure(this.types));
                this.state.pop(1);
                break;
            }
            case 180: {
                this.state.pop(1);
                this.state.push(((Symbol)this.pool.pool[od]).erasure(this.types));
                break;
            }
            case 192: {
                this.state.pop(1);
                Object o = this.pool.pool[od];
                Type t = o instanceof Symbol ? ((Symbol)o).erasure(this.types) : this.types.erasure((Type)o);
                this.state.push(t);
                break;
            }
            case 20: {
                this.state.push(this.typeForPool(this.pool.pool[od]));
                break;
            }
            case 193: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 19: {
                this.state.push(this.typeForPool(this.pool.pool[od]));
                break;
            }
            case 168: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public void emitop4(int op, int od) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit4(od);
        switch (op) {
            case 200: {
                this.markDead();
                break;
            }
            case 201: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public void align(int incr) {
        if (this.alive) {
            while (this.cp % incr != 0) {
                this.emitop0(0);
            }
        }
    }

    private void put1(int pc, int op) {
        this.code[pc] = (byte)op;
    }

    private void put2(int pc, int od) {
        this.put1(pc, od >> 8);
        this.put1(pc + 1, od);
    }

    public void put4(int pc, int od) {
        this.put1(pc, od >> 24);
        this.put1(pc + 1, od >> 16);
        this.put1(pc + 2, od >> 8);
        this.put1(pc + 3, od);
    }

    private int get1(int pc) {
        return this.code[pc] & 0xFF;
    }

    private int get2(int pc) {
        return this.get1(pc) << 8 | this.get1(pc + 1);
    }

    public int get4(int pc) {
        return this.get1(pc) << 24 | this.get1(pc + 1) << 16 | this.get1(pc + 2) << 8 | this.get1(pc + 3);
    }

    public boolean isAlive() {
        return this.alive || this.pendingJumps != null;
    }

    public void markDead() {
        this.alive = false;
    }

    public int entryPoint() {
        int pc = this.curPc();
        this.alive = true;
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public int entryPoint(State state) {
        int pc = this.curPc();
        this.alive = true;
        this.state = state.dup();
        Assert.check(state.stacksize <= this.max_stack);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public int entryPoint(State state, Type pushed) {
        int pc = this.curPc();
        this.alive = true;
        this.state = state.dup();
        Assert.check(state.stacksize <= this.max_stack);
        this.state.push(pushed);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public void emitStackMap() {
        int pc = this.curPc();
        if (!this.needStackMap) {
            return;
        }
        switch (this.stackMap) {
            case CLDC: {
                this.emitCLDCStackMap(pc, this.getLocalsSize());
                break;
            }
            case JSR202: {
                this.emitStackMapFrame(pc, this.getLocalsSize());
                break;
            }
            default: {
                throw new AssertionError((Object)"Should have chosen a stackmap format");
            }
        }
        if (this.debugCode) {
            this.state.dump(pc);
        }
    }

    private int getLocalsSize() {
        int nextLocal = 0;
        for (int i = this.max_locals - 1; i >= 0; --i) {
            if (!this.state.defined.isMember(i) || this.lvar[i] == null) continue;
            nextLocal = i + Code.width(this.lvar[i].sym.erasure(this.types));
            break;
        }
        return nextLocal;
    }

    void emitCLDCStackMap(int pc, int localsSize) {
        int i;
        if (this.lastStackMapPC == pc) {
            this.stackMapBuffer[--this.stackMapBufferSize] = null;
        }
        this.lastStackMapPC = pc;
        if (this.stackMapBuffer == null) {
            this.stackMapBuffer = new StackMapFrame[20];
        } else if (this.stackMapBuffer.length == this.stackMapBufferSize) {
            StackMapFrame[] newStackMapBuffer = new StackMapFrame[this.stackMapBufferSize << 1];
            System.arraycopy(this.stackMapBuffer, 0, newStackMapBuffer, 0, this.stackMapBufferSize);
            this.stackMapBuffer = newStackMapBuffer;
        }
        StackMapFrame stackMapFrame = new StackMapFrame();
        this.stackMapBuffer[this.stackMapBufferSize++] = stackMapFrame;
        StackMapFrame frame = stackMapFrame;
        frame.pc = pc;
        frame.locals = new Type[localsSize];
        for (i = 0; i < localsSize; ++i) {
            if (!this.state.defined.isMember(i) || this.lvar[i] == null) continue;
            Type vtype = this.lvar[i].sym.type;
            if (!(vtype instanceof UninitializedType)) {
                vtype = this.types.erasure(vtype);
            }
            frame.locals[i] = vtype;
        }
        frame.stack = new Type[this.state.stacksize];
        for (i = 0; i < this.state.stacksize; ++i) {
            frame.stack[i] = this.state.stack[i];
        }
    }

    void emitStackMapFrame(int pc, int localsSize) {
        int i;
        if (this.lastFrame == null) {
            this.lastFrame = this.getInitialFrame();
        } else if (this.lastFrame.pc == pc) {
            this.stackMapTableBuffer[--this.stackMapBufferSize] = null;
            this.lastFrame = this.frameBeforeLast;
            this.frameBeforeLast = null;
        }
        StackMapFrame frame = new StackMapFrame();
        frame.pc = pc;
        int localCount = 0;
        Type[] locals = new Type[localsSize];
        int i2 = 0;
        while (i2 < localsSize) {
            if (this.state.defined.isMember(i2) && this.lvar[i2] != null) {
                Type vtype = this.lvar[i2].sym.type;
                if (!(vtype instanceof UninitializedType)) {
                    vtype = this.types.erasure(vtype);
                }
                locals[i2] = vtype;
                if (Code.width(vtype) > 1) {
                    ++i2;
                }
            }
            ++i2;
            ++localCount;
        }
        frame.locals = new Type[localCount];
        i2 = 0;
        int j = 0;
        while (i2 < localsSize) {
            Assert.check(j < localCount);
            frame.locals[j] = locals[i2];
            if (Code.width(locals[i2]) > 1) {
                ++i2;
            }
            ++i2;
            ++j;
        }
        int stackCount = 0;
        for (i = 0; i < this.state.stacksize; ++i) {
            if (this.state.stack[i] == null) continue;
            ++stackCount;
        }
        frame.stack = new Type[stackCount];
        stackCount = 0;
        for (i = 0; i < this.state.stacksize; ++i) {
            if (this.state.stack[i] == null) continue;
            frame.stack[stackCount++] = this.types.erasure(this.state.stack[i]);
        }
        if (this.stackMapTableBuffer == null) {
            this.stackMapTableBuffer = new ClassWriter.StackMapTableFrame[20];
        } else if (this.stackMapTableBuffer.length == this.stackMapBufferSize) {
            ClassWriter.StackMapTableFrame[] newStackMapTableBuffer = new ClassWriter.StackMapTableFrame[this.stackMapBufferSize << 1];
            System.arraycopy(this.stackMapTableBuffer, 0, newStackMapTableBuffer, 0, this.stackMapBufferSize);
            this.stackMapTableBuffer = newStackMapTableBuffer;
        }
        this.stackMapTableBuffer[this.stackMapBufferSize++] = ClassWriter.StackMapTableFrame.getInstance(frame, this.lastFrame.pc, this.lastFrame.locals, this.types);
        this.frameBeforeLast = this.lastFrame;
        this.lastFrame = frame;
    }

    StackMapFrame getInitialFrame() {
        StackMapFrame frame = new StackMapFrame();
        List<Type> arg_types = ((Type.MethodType)this.meth.externalType((Types)this.types)).argtypes;
        int len = arg_types.length();
        int count = 0;
        if (!this.meth.isStatic()) {
            Type thisType = this.meth.owner.type;
            frame.locals = new Type[len + 1];
            frame.locals[count++] = this.meth.isConstructor() && thisType != this.syms.objectType ? UninitializedType.uninitializedThis(thisType) : this.types.erasure(thisType);
        } else {
            frame.locals = new Type[len];
        }
        for (Type arg_type : arg_types) {
            frame.locals[count++] = this.types.erasure(arg_type);
        }
        frame.pc = -1;
        frame.stack = null;
        return frame;
    }

    public static int negate(int opcode) {
        if (opcode == 198) {
            return 199;
        }
        if (opcode == 199) {
            return 198;
        }
        return (opcode + 1 ^ 1) - 1;
    }

    public int emitJump(int opcode) {
        if (this.fatcode) {
            if (opcode == 167 || opcode == 168) {
                this.emitop4(opcode + 200 - 167, 0);
            } else {
                this.emitop2(Code.negate(opcode), 8);
                this.emitop4(200, 0);
                this.alive = true;
                this.pendingStackMap = this.needStackMap;
            }
            return this.cp - 5;
        }
        this.emitop2(opcode, 0);
        return this.cp - 3;
    }

    public Chain branch(int opcode) {
        Chain result = null;
        if (opcode == 167) {
            result = this.pendingJumps;
            this.pendingJumps = null;
        }
        if (opcode != 168 && this.isAlive()) {
            result = new Chain(this.emitJump(opcode), result, this.state.dup());
            this.fixedPc = this.fatcode;
            if (opcode == 167) {
                this.alive = false;
            }
        }
        return result;
    }

    public void resolve(Chain chain, int target) {
        boolean changed = false;
        State newState = this.state;
        while (chain != null) {
            Assert.check(this.state != chain.state && (target > chain.pc || this.state.stacksize == 0));
            if (target >= this.cp) {
                target = this.cp;
            } else if (this.get1(target) == 167) {
                target = this.fatcode ? (target += this.get4(target + 1)) : (target += this.get2(target + 1));
            }
            if (this.get1(chain.pc) == 167 && chain.pc + 3 == target && target == this.cp && !this.fixedPc) {
                this.cp -= 3;
                target -= 3;
                if (chain.next == null) {
                    this.alive = true;
                    break;
                }
            } else {
                if (this.fatcode) {
                    this.put4(chain.pc + 1, target - chain.pc);
                } else if (target - chain.pc < Short.MIN_VALUE || target - chain.pc > Short.MAX_VALUE) {
                    this.fatcode = true;
                } else {
                    this.put2(chain.pc + 1, target - chain.pc);
                }
                Assert.check(!this.alive || chain.state.stacksize == newState.stacksize && chain.state.nlocks == newState.nlocks);
            }
            this.fixedPc = true;
            if (this.cp == target) {
                changed = true;
                if (this.debugCode) {
                    System.err.println("resolving chain state=" + chain.state);
                }
                if (this.alive) {
                    newState = chain.state.join(newState);
                } else {
                    newState = chain.state;
                    this.alive = true;
                }
            }
            chain = chain.next;
        }
        Assert.check(!changed || this.state != newState);
        if (this.state != newState) {
            this.setDefined(newState.defined);
            this.state = newState;
            this.pendingStackMap = this.needStackMap;
        }
    }

    public void resolve(Chain chain) {
        Assert.check(!this.alive || chain == null || this.state.stacksize == chain.state.stacksize && this.state.nlocks == chain.state.nlocks);
        this.pendingJumps = Code.mergeChains(chain, this.pendingJumps);
    }

    public void resolvePending() {
        Chain x = this.pendingJumps;
        this.pendingJumps = null;
        this.resolve(x, this.cp);
    }

    public static Chain mergeChains(Chain chain1, Chain chain2) {
        if (chain2 == null) {
            return chain1;
        }
        if (chain1 == null) {
            return chain2;
        }
        Assert.check(chain1.state.stacksize == chain2.state.stacksize && chain1.state.nlocks == chain2.state.nlocks);
        if (chain1.pc < chain2.pc) {
            return new Chain(chain2.pc, Code.mergeChains(chain1, chain2.next), chain2.state);
        }
        return new Chain(chain1.pc, Code.mergeChains(chain1.next, chain2), chain1.state);
    }

    public void addCatch(char startPc, char endPc, char handlerPc, char catchType) {
        this.catchInfo.append(new char[]{startPc, endPc, handlerPc, catchType});
    }

    public void addLineNumber(char startPc, char lineNumber) {
        if (this.lineDebugInfo) {
            if (this.lineInfo.nonEmpty() && ((char[])this.lineInfo.head)[0] == startPc) {
                this.lineInfo = this.lineInfo.tail;
            }
            if (this.lineInfo.isEmpty() || ((char[])this.lineInfo.head)[1] != lineNumber) {
                this.lineInfo = this.lineInfo.prepend(new char[]{startPc, lineNumber});
            }
        }
    }

    public void statBegin(int pos) {
        if (pos != -1) {
            this.pendingStatPos = pos;
        }
    }

    public void markStatBegin() {
        if (this.alive && this.lineDebugInfo) {
            int line = this.lineMap.getLineNumber(this.pendingStatPos);
            char cp1 = (char)this.cp;
            char line1 = (char)line;
            if (cp1 == this.cp && line1 == line) {
                this.addLineNumber(cp1, line1);
            }
        }
        this.pendingStatPos = -1;
    }

    private void addLocalVar(Symbol.VarSymbol v) {
        int adr = v.adr;
        if (adr + 1 >= this.lvar.length) {
            int newlength = this.lvar.length << 1;
            if (newlength <= adr) {
                newlength = adr + 10;
            }
            LocalVar[] new_lvar = new LocalVar[newlength];
            System.arraycopy(this.lvar, 0, new_lvar, 0, this.lvar.length);
            this.lvar = new_lvar;
        }
        Assert.checkNull(this.lvar[adr]);
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        this.lvar[adr] = new LocalVar(v);
        this.state.defined.excl(adr);
    }

    public void setDefined(Bits newDefined) {
        if (this.alive && newDefined != this.state.defined) {
            Bits diff = this.state.defined.dup().xorSet(newDefined);
            int adr = diff.nextBit(0);
            while (adr >= 0) {
                if (adr >= this.nextreg) {
                    this.state.defined.excl(adr);
                } else if (this.state.defined.isMember(adr)) {
                    this.setUndefined(adr);
                } else {
                    this.setDefined(adr);
                }
                adr = diff.nextBit(adr + 1);
            }
        }
    }

    public void setDefined(int adr) {
        LocalVar v = this.lvar[adr];
        if (v == null) {
            this.state.defined.excl(adr);
        } else {
            this.state.defined.incl(adr);
            if (this.cp < 65535 && v.start_pc == '\uffff') {
                v.start_pc = (char)this.cp;
            }
        }
    }

    public void setUndefined(int adr) {
        this.state.defined.excl(adr);
        if (adr < this.lvar.length && this.lvar[adr] != null && this.lvar[adr].start_pc != '\uffff') {
            LocalVar v = this.lvar[adr];
            char length = (char)(this.curPc() - v.start_pc);
            if (length > '\u0000' && length < '\uffff') {
                this.lvar[adr] = v.dup();
                v.length = length;
                this.putVar(v);
            } else {
                v.start_pc = (char)65535;
            }
        }
    }

    private void endScope(int adr) {
        LocalVar v = this.lvar[adr];
        if (v != null) {
            char length;
            this.lvar[adr] = null;
            if (v.start_pc != '\uffff' && (length = (char)(this.curPc() - v.start_pc)) < '\uffff') {
                v.length = length;
                this.putVar(v);
            }
        }
        this.state.defined.excl(adr);
    }

    void putVar(LocalVar var) {
        if (!this.varDebugInfo) {
            return;
        }
        if ((var.sym.flags() & 0x1000L) != 0L) {
            return;
        }
        if (this.varBuffer == null) {
            this.varBuffer = new LocalVar[20];
        } else if (this.varBufferSize >= this.varBuffer.length) {
            LocalVar[] newVarBuffer = new LocalVar[this.varBufferSize * 2];
            System.arraycopy(this.varBuffer, 0, newVarBuffer, 0, this.varBuffer.length);
            this.varBuffer = newVarBuffer;
        }
        this.varBuffer[this.varBufferSize++] = var;
    }

    private int newLocal(int typecode) {
        int reg = this.nextreg;
        int w = Code.width(typecode);
        this.nextreg = reg + w;
        if (this.nextreg > this.max_locals) {
            this.max_locals = this.nextreg;
        }
        return reg;
    }

    private int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public int newLocal(Symbol.VarSymbol v) {
        int reg = v.adr = this.newLocal(v.erasure(this.types));
        this.addLocalVar(v);
        return reg;
    }

    public void newRegSegment() {
        this.nextreg = this.max_locals;
    }

    public void endScopes(int first) {
        int prevNextReg = this.nextreg;
        for (int i = this.nextreg = first; i < prevNextReg; ++i) {
            this.endScope(i);
        }
    }

    public static String mnem(int opcode) {
        return Mneumonics.mnem[opcode];
    }

    private static class Mneumonics {
        private static final String[] mnem = new String[203];

        private Mneumonics() {
        }

        static {
            Mneumonics.mnem[0] = "nop";
            Mneumonics.mnem[1] = "aconst_null";
            Mneumonics.mnem[2] = "iconst_m1";
            Mneumonics.mnem[3] = "iconst_0";
            Mneumonics.mnem[4] = "iconst_1";
            Mneumonics.mnem[5] = "iconst_2";
            Mneumonics.mnem[6] = "iconst_3";
            Mneumonics.mnem[7] = "iconst_4";
            Mneumonics.mnem[8] = "iconst_5";
            Mneumonics.mnem[9] = "lconst_0";
            Mneumonics.mnem[10] = "lconst_1";
            Mneumonics.mnem[11] = "fconst_0";
            Mneumonics.mnem[12] = "fconst_1";
            Mneumonics.mnem[13] = "fconst_2";
            Mneumonics.mnem[14] = "dconst_0";
            Mneumonics.mnem[15] = "dconst_1";
            Mneumonics.mnem[16] = "bipush";
            Mneumonics.mnem[17] = "sipush";
            Mneumonics.mnem[18] = "ldc1";
            Mneumonics.mnem[19] = "ldc2";
            Mneumonics.mnem[20] = "ldc2w";
            Mneumonics.mnem[21] = "iload";
            Mneumonics.mnem[22] = "lload";
            Mneumonics.mnem[23] = "fload";
            Mneumonics.mnem[24] = "dload";
            Mneumonics.mnem[25] = "aload";
            Mneumonics.mnem[26] = "iload_0";
            Mneumonics.mnem[30] = "lload_0";
            Mneumonics.mnem[34] = "fload_0";
            Mneumonics.mnem[38] = "dload_0";
            Mneumonics.mnem[42] = "aload_0";
            Mneumonics.mnem[27] = "iload_1";
            Mneumonics.mnem[31] = "lload_1";
            Mneumonics.mnem[35] = "fload_1";
            Mneumonics.mnem[39] = "dload_1";
            Mneumonics.mnem[43] = "aload_1";
            Mneumonics.mnem[28] = "iload_2";
            Mneumonics.mnem[32] = "lload_2";
            Mneumonics.mnem[36] = "fload_2";
            Mneumonics.mnem[40] = "dload_2";
            Mneumonics.mnem[44] = "aload_2";
            Mneumonics.mnem[29] = "iload_3";
            Mneumonics.mnem[33] = "lload_3";
            Mneumonics.mnem[37] = "fload_3";
            Mneumonics.mnem[41] = "dload_3";
            Mneumonics.mnem[45] = "aload_3";
            Mneumonics.mnem[46] = "iaload";
            Mneumonics.mnem[47] = "laload";
            Mneumonics.mnem[48] = "faload";
            Mneumonics.mnem[49] = "daload";
            Mneumonics.mnem[50] = "aaload";
            Mneumonics.mnem[51] = "baload";
            Mneumonics.mnem[52] = "caload";
            Mneumonics.mnem[53] = "saload";
            Mneumonics.mnem[54] = "istore";
            Mneumonics.mnem[55] = "lstore";
            Mneumonics.mnem[56] = "fstore";
            Mneumonics.mnem[57] = "dstore";
            Mneumonics.mnem[58] = "astore";
            Mneumonics.mnem[59] = "istore_0";
            Mneumonics.mnem[63] = "lstore_0";
            Mneumonics.mnem[67] = "fstore_0";
            Mneumonics.mnem[71] = "dstore_0";
            Mneumonics.mnem[75] = "astore_0";
            Mneumonics.mnem[60] = "istore_1";
            Mneumonics.mnem[64] = "lstore_1";
            Mneumonics.mnem[68] = "fstore_1";
            Mneumonics.mnem[72] = "dstore_1";
            Mneumonics.mnem[76] = "astore_1";
            Mneumonics.mnem[61] = "istore_2";
            Mneumonics.mnem[65] = "lstore_2";
            Mneumonics.mnem[69] = "fstore_2";
            Mneumonics.mnem[73] = "dstore_2";
            Mneumonics.mnem[77] = "astore_2";
            Mneumonics.mnem[62] = "istore_3";
            Mneumonics.mnem[66] = "lstore_3";
            Mneumonics.mnem[70] = "fstore_3";
            Mneumonics.mnem[74] = "dstore_3";
            Mneumonics.mnem[78] = "astore_3";
            Mneumonics.mnem[79] = "iastore";
            Mneumonics.mnem[80] = "lastore";
            Mneumonics.mnem[81] = "fastore";
            Mneumonics.mnem[82] = "dastore";
            Mneumonics.mnem[83] = "aastore";
            Mneumonics.mnem[84] = "bastore";
            Mneumonics.mnem[85] = "castore";
            Mneumonics.mnem[86] = "sastore";
            Mneumonics.mnem[87] = "pop";
            Mneumonics.mnem[88] = "pop2";
            Mneumonics.mnem[89] = "dup";
            Mneumonics.mnem[90] = "dup_x1";
            Mneumonics.mnem[91] = "dup_x2";
            Mneumonics.mnem[92] = "dup2";
            Mneumonics.mnem[93] = "dup2_x1";
            Mneumonics.mnem[94] = "dup2_x2";
            Mneumonics.mnem[95] = "swap";
            Mneumonics.mnem[96] = "iadd";
            Mneumonics.mnem[97] = "ladd";
            Mneumonics.mnem[98] = "fadd";
            Mneumonics.mnem[99] = "dadd";
            Mneumonics.mnem[100] = "isub";
            Mneumonics.mnem[101] = "lsub";
            Mneumonics.mnem[102] = "fsub";
            Mneumonics.mnem[103] = "dsub";
            Mneumonics.mnem[104] = "imul";
            Mneumonics.mnem[105] = "lmul";
            Mneumonics.mnem[106] = "fmul";
            Mneumonics.mnem[107] = "dmul";
            Mneumonics.mnem[108] = "idiv";
            Mneumonics.mnem[109] = "ldiv";
            Mneumonics.mnem[110] = "fdiv";
            Mneumonics.mnem[111] = "ddiv";
            Mneumonics.mnem[112] = "imod";
            Mneumonics.mnem[113] = "lmod";
            Mneumonics.mnem[114] = "fmod";
            Mneumonics.mnem[115] = "dmod";
            Mneumonics.mnem[116] = "ineg";
            Mneumonics.mnem[117] = "lneg";
            Mneumonics.mnem[118] = "fneg";
            Mneumonics.mnem[119] = "dneg";
            Mneumonics.mnem[120] = "ishl";
            Mneumonics.mnem[121] = "lshl";
            Mneumonics.mnem[122] = "ishr";
            Mneumonics.mnem[123] = "lshr";
            Mneumonics.mnem[124] = "iushr";
            Mneumonics.mnem[125] = "lushr";
            Mneumonics.mnem[126] = "iand";
            Mneumonics.mnem[127] = "land";
            Mneumonics.mnem[128] = "ior";
            Mneumonics.mnem[129] = "lor";
            Mneumonics.mnem[130] = "ixor";
            Mneumonics.mnem[131] = "lxor";
            Mneumonics.mnem[132] = "iinc";
            Mneumonics.mnem[133] = "i2l";
            Mneumonics.mnem[134] = "i2f";
            Mneumonics.mnem[135] = "i2d";
            Mneumonics.mnem[136] = "l2i";
            Mneumonics.mnem[137] = "l2f";
            Mneumonics.mnem[138] = "l2d";
            Mneumonics.mnem[139] = "f2i";
            Mneumonics.mnem[140] = "f2l";
            Mneumonics.mnem[141] = "f2d";
            Mneumonics.mnem[142] = "d2i";
            Mneumonics.mnem[143] = "d2l";
            Mneumonics.mnem[144] = "d2f";
            Mneumonics.mnem[145] = "int2byte";
            Mneumonics.mnem[146] = "int2char";
            Mneumonics.mnem[147] = "int2short";
            Mneumonics.mnem[148] = "lcmp";
            Mneumonics.mnem[149] = "fcmpl";
            Mneumonics.mnem[150] = "fcmpg";
            Mneumonics.mnem[151] = "dcmpl";
            Mneumonics.mnem[152] = "dcmpg";
            Mneumonics.mnem[153] = "ifeq";
            Mneumonics.mnem[154] = "ifne";
            Mneumonics.mnem[155] = "iflt";
            Mneumonics.mnem[156] = "ifge";
            Mneumonics.mnem[157] = "ifgt";
            Mneumonics.mnem[158] = "ifle";
            Mneumonics.mnem[159] = "if_icmpeq";
            Mneumonics.mnem[160] = "if_icmpne";
            Mneumonics.mnem[161] = "if_icmplt";
            Mneumonics.mnem[162] = "if_icmpge";
            Mneumonics.mnem[163] = "if_icmpgt";
            Mneumonics.mnem[164] = "if_icmple";
            Mneumonics.mnem[165] = "if_acmpeq";
            Mneumonics.mnem[166] = "if_acmpne";
            Mneumonics.mnem[167] = "goto_";
            Mneumonics.mnem[168] = "jsr";
            Mneumonics.mnem[169] = "ret";
            Mneumonics.mnem[170] = "tableswitch";
            Mneumonics.mnem[171] = "lookupswitch";
            Mneumonics.mnem[172] = "ireturn";
            Mneumonics.mnem[173] = "lreturn";
            Mneumonics.mnem[174] = "freturn";
            Mneumonics.mnem[175] = "dreturn";
            Mneumonics.mnem[176] = "areturn";
            Mneumonics.mnem[177] = "return_";
            Mneumonics.mnem[178] = "getstatic";
            Mneumonics.mnem[179] = "putstatic";
            Mneumonics.mnem[180] = "getfield";
            Mneumonics.mnem[181] = "putfield";
            Mneumonics.mnem[182] = "invokevirtual";
            Mneumonics.mnem[183] = "invokespecial";
            Mneumonics.mnem[184] = "invokestatic";
            Mneumonics.mnem[185] = "invokeinterface";
            Mneumonics.mnem[186] = "invokedynamic";
            Mneumonics.mnem[187] = "new_";
            Mneumonics.mnem[188] = "newarray";
            Mneumonics.mnem[189] = "anewarray";
            Mneumonics.mnem[190] = "arraylength";
            Mneumonics.mnem[191] = "athrow";
            Mneumonics.mnem[192] = "checkcast";
            Mneumonics.mnem[193] = "instanceof_";
            Mneumonics.mnem[194] = "monitorenter";
            Mneumonics.mnem[195] = "monitorexit";
            Mneumonics.mnem[196] = "wide";
            Mneumonics.mnem[197] = "multianewarray";
            Mneumonics.mnem[198] = "if_acmp_null";
            Mneumonics.mnem[199] = "if_acmp_nonnull";
            Mneumonics.mnem[200] = "goto_w";
            Mneumonics.mnem[201] = "jsr_w";
            Mneumonics.mnem[202] = "breakpoint";
        }
    }

    static class LocalVar {
        final Symbol.VarSymbol sym;
        final char reg;
        char start_pc = (char)65535;
        char length = (char)65535;

        LocalVar(Symbol.VarSymbol v) {
            this.sym = v;
            this.reg = (char)v.adr;
        }

        public LocalVar dup() {
            return new LocalVar(this.sym);
        }

        public String toString() {
            return "" + this.sym + " in register " + this.reg + " starts at pc=" + this.start_pc + " length=" + this.length;
        }
    }

    class State
    implements Cloneable {
        Bits defined = new Bits();
        Type[] stack = new Type[16];
        int stacksize;
        int[] locks;
        int nlocks;

        State() {
        }

        State dup() {
            try {
                State state = (State)super.clone();
                state.defined = this.defined.dup();
                state.stack = (Type[])this.stack.clone();
                if (this.locks != null) {
                    state.locks = (int[])this.locks.clone();
                }
                if (Code.this.debugCode) {
                    System.err.println("duping state " + this);
                    this.dump();
                }
                return state;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        void lock(int register) {
            if (this.locks == null) {
                this.locks = new int[20];
            } else if (this.locks.length == this.nlocks) {
                int[] newLocks = new int[this.locks.length << 1];
                System.arraycopy(this.locks, 0, newLocks, 0, this.locks.length);
                this.locks = newLocks;
            }
            this.locks[this.nlocks] = register;
            ++this.nlocks;
        }

        void unlock(int register) {
            --this.nlocks;
            Assert.check(this.locks[this.nlocks] == register);
            this.locks[this.nlocks] = -1;
        }

        void push(Type t) {
            if (Code.this.debugCode) {
                System.err.println("   pushing " + t);
            }
            switch (t.tag) {
                case 9: {
                    return;
                }
                case 1: 
                case 2: 
                case 3: 
                case 8: {
                    t = Code.this.syms.intType;
                    break;
                }
            }
            if (this.stacksize + 2 >= this.stack.length) {
                Type[] newstack = new Type[2 * this.stack.length];
                System.arraycopy(this.stack, 0, newstack, 0, this.stack.length);
                this.stack = newstack;
            }
            this.stack[this.stacksize++] = t;
            switch (Code.width(t)) {
                case 1: {
                    break;
                }
                case 2: {
                    this.stack[this.stacksize++] = null;
                    break;
                }
                default: {
                    throw new AssertionError(t);
                }
            }
            if (this.stacksize > Code.this.max_stack) {
                Code.this.max_stack = this.stacksize;
            }
        }

        Type pop1() {
            if (Code.this.debugCode) {
                System.err.println("   popping 1");
            }
            --this.stacksize;
            Type result = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(result != null && Code.width(result) == 1);
            return result;
        }

        Type peek() {
            return this.stack[this.stacksize - 1];
        }

        Type pop2() {
            if (Code.this.debugCode) {
                System.err.println("   popping 2");
            }
            this.stacksize -= 2;
            Type result = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(this.stack[this.stacksize + 1] == null && result != null && Code.width(result) == 2);
            return result;
        }

        void pop(int n) {
            if (Code.this.debugCode) {
                System.err.println("   popping " + n);
            }
            while (n > 0) {
                this.stack[--this.stacksize] = null;
                --n;
            }
        }

        void pop(Type t) {
            this.pop(Code.width(t));
        }

        void forceStackTop(Type t) {
            if (!Code.this.alive) {
                return;
            }
            switch (t.tag) {
                case 10: 
                case 11: {
                    int width = Code.width(t);
                    Type old = this.stack[this.stacksize - width];
                    Assert.check(Code.this.types.isSubtype(Code.this.types.erasure(old), Code.this.types.erasure(t)));
                    this.stack[this.stacksize - width] = t;
                    break;
                }
            }
        }

        void markInitialized(UninitializedType old) {
            int i;
            Type newtype = old.initializedType();
            for (i = 0; i < this.stacksize; ++i) {
                if (this.stack[i] != old) continue;
                this.stack[i] = newtype;
            }
            for (i = 0; i < Code.this.lvar.length; ++i) {
                LocalVar lv = Code.this.lvar[i];
                if (lv == null || lv.sym.type != old) continue;
                Symbol.VarSymbol sym = lv.sym;
                sym = sym.clone(sym.owner);
                sym.type = newtype;
                LocalVar newlv = Code.this.lvar[i] = new LocalVar(sym);
                newlv.start_pc = lv.start_pc;
            }
        }

        State join(State other) {
            int w;
            this.defined = this.defined.andSet(other.defined);
            Assert.check(this.stacksize == other.stacksize && this.nlocks == other.nlocks);
            for (int i = 0; i < this.stacksize; i += w) {
                Type t = this.stack[i];
                Type tother = other.stack[i];
                Type result = t == tother ? t : (Code.this.types.isSubtype(t, tother) ? tother : (Code.this.types.isSubtype(tother, t) ? t : this.error()));
                w = Code.width(result);
                this.stack[i] = result;
                if (w != 2) continue;
                Assert.checkNull(this.stack[i + 1]);
            }
            return this;
        }

        Type error() {
            throw new AssertionError((Object)"inconsistent stack types at join point");
        }

        void dump() {
            this.dump(-1);
        }

        void dump(int pc) {
            int i;
            System.err.print("stackMap for " + Code.this.meth.owner + "." + Code.this.meth);
            if (pc == -1) {
                System.out.println();
            } else {
                System.out.println(" at " + pc);
            }
            System.err.println(" stack (from bottom):");
            for (int i2 = 0; i2 < this.stacksize; ++i2) {
                System.err.println("  " + i2 + ": " + this.stack[i2]);
            }
            int lastLocal = 0;
            for (i = Code.this.max_locals - 1; i >= 0; --i) {
                if (!this.defined.isMember(i)) continue;
                lastLocal = i;
                break;
            }
            if (lastLocal >= 0) {
                System.err.println(" locals:");
            }
            for (i = 0; i <= lastLocal; ++i) {
                System.err.print("  " + i + ": ");
                if (this.defined.isMember(i)) {
                    LocalVar var = Code.this.lvar[i];
                    if (var == null) {
                        System.err.println("(none)");
                        continue;
                    }
                    if (var.sym == null) {
                        System.err.println("UNKNOWN!");
                        continue;
                    }
                    System.err.println("" + var.sym + " of type " + var.sym.erasure(Code.this.types));
                    continue;
                }
                System.err.println("undefined");
            }
            if (this.nlocks != 0) {
                System.err.print(" locks:");
                for (i = 0; i < this.nlocks; ++i) {
                    System.err.print(" " + this.locks[i]);
                }
                System.err.println();
            }
        }
    }

    public static class Chain {
        public final int pc;
        State state;
        public final Chain next;

        public Chain(int pc, Chain next, State state) {
            this.pc = pc;
            this.next = next;
            this.state = state;
        }
    }

    static class StackMapFrame {
        int pc;
        Type[] locals;
        Type[] stack;

        StackMapFrame() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StackMapFormat {
        NONE,
        CLDC{

            Name getAttributeName(Names names) {
                return names.StackMap;
            }
        }
        ,
        JSR202{

            Name getAttributeName(Names names) {
                return names.StackMapTable;
            }
        };


        Name getAttributeName(Names names) {
            return names.empty;
        }
    }
}

