/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;

public abstract class SourceFileFilter
extends FileFilterFactory.FileAndFileObjectFilter {
    @Override
    public boolean accept(File f) {
        if (f != null) {
            String suffix;
            if (f.isDirectory()) {
                return true;
            }
            int index = f.getName().lastIndexOf(46);
            if (index >= 0 ? this.amongSuffixes(suffix = f.getName().substring(index + 1), this.getSuffixes()) : this.amongSuffixes(f.getName(), this.getSuffixes())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(FileObject f) {
        if (f != null) {
            if (f.isFolder()) {
                return true;
            }
            String suffix = f.getExt();
            if (this.amongSuffixes(suffix, this.getSuffixes())) {
                return true;
            }
        }
        return false;
    }

    public abstract String[] getSuffixes();

    public String getSuffixesAsString() {
        String[] suffixes = this.getSuffixes();
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < suffixes.length; ++i) {
            if (0 < i) {
                ret.append(' ');
            }
            ret.append('.').append(suffixes[i]);
        }
        return ret.toString();
    }

    private boolean amongSuffixes(String suffix, String[] suffixes) {
        for (int i = 0; i < suffixes.length; ++i) {
            if (!SourceFileFilter.areFilenamesEqual(suffixes[i], suffix)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getDescription();
    }

    protected static boolean areFilenamesEqual(String firstFile, String secondFile) {
        return CndFileUtils.isSystemCaseSensitive() ? firstFile.equals(secondFile) : firstFile.equalsIgnoreCase(secondFile);
    }
}

