/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.spi.utils.CndFileExistSensitiveCache;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class CndFileUtils {
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static final FileChangeListener FSL;
    private static final FileSystem fileFileSystem;
    private static final boolean isWindows;
    private static L1Cache l1Cache;
    private static final Lock maRefLock;
    private static final Map<FileSystem, Reference<ConcurrentMap<String, Flags>>> maps;
    private static final boolean TRACE_EXTERNAL_CHANGES;
    private static volatile Collection<? extends CndFileExistSensitiveCache> listeners;

    private CndFileUtils() {
    }

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static boolean areFilenamesEqual(String firstFile, String secondFile) {
        return CndFileUtils.isSystemCaseSensitive() ? firstFile.equals(secondFile) : firstFile.equalsIgnoreCase(secondFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFileExistenceCache() {
        try {
            maRefLock.lock();
            for (Reference<ConcurrentMap<String, Flags>> reference : maps.values()) {
                reference.clear();
            }
            maps.clear();
        }
        finally {
            maRefLock.unlock();
        }
        for (CndFileExistSensitiveCache cndFileExistSensitiveCache : CndFileUtils.getCaches()) {
            cndFileExistSensitiveCache.invalidateAll();
        }
    }

    public static File normalizeFile(File file) {
        CndUtils.assertAbsoluteFileInConsole(file, "Is it OK to normalize not absolute file? [" + file + "] during this session it is [" + file.getAbsolutePath() + "] but will be different if start IDE from another folder");
        String path = file.getPath();
        String normPath = CndFileUtils.normalizeAbsolutePath(file.getAbsolutePath());
        return path.equals(normPath) ? file : new File(normPath);
    }

    public static File toFile(FileObject fileObject) {
        return CndFileSystemProvider.toFile(fileObject);
    }

    public static FileObject toFileObject(File file) {
        return CndFileSystemProvider.toFileObject(file);
    }

    public static FileObject toFileObject(FileSystem fs, CharSequence absolutePath) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            return CndFileUtils.toFileObject(absolutePath);
        }
        return fs.findResource(((Object)absolutePath).toString());
    }

    public static FileObject toFileObject(CharSequence absoluteLocalPath) {
        return CndFileSystemProvider.toFileObject(absoluteLocalPath);
    }

    public static String getCanonicalPath(CharSequence path) throws IOException {
        return new File(((Object)path).toString()).getCanonicalPath();
    }

    public static FileObject getCanonicalFileObject(FileObject fo) throws IOException {
        Parameters.notNull((CharSequence)"FileObject", (Object)fo);
        return CndFileSystemProvider.getCanonicalFileObject(fo);
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        return CndFileSystemProvider.getCanonicalPath(fo);
    }

    public static boolean isValidLocalFile(String absolutePath) {
        if (CndPathUtilitities.isPathAbsolute(absolutePath)) {
            return new File(absolutePath).exists();
        }
        return false;
    }

    public static boolean isValidLocalFile(String base, String name) {
        if (CndPathUtilitities.isPathAbsolute(base)) {
            return new File(base, name).exists();
        }
        return false;
    }

    public static boolean isValidLocalFile(File base, String name) {
        if (CndPathUtilitities.isPathAbsolute(base.getPath())) {
            return new File(base, name).exists();
        }
        return false;
    }

    public static File createLocalFile(String absolutePath) {
        Parameters.notNull((CharSequence)"null path", (Object)absolutePath);
        CndUtils.assertAbsolutePathInConsole(absolutePath);
        return new File(absolutePath);
    }

    public static File createLocalFile(File base, String path) {
        Parameters.notNull((CharSequence)"null base file", (Object)base);
        CndUtils.assertAbsoluteFileInConsole(base);
        Parameters.notNull((CharSequence)"null path", (Object)path);
        return new File(base, path);
    }

    public static File createLocalFile(String base, String path) {
        Parameters.notNull((CharSequence)"null base file", (Object)base);
        CndUtils.assertAbsolutePathInConsole(base);
        Parameters.notNull((CharSequence)"null path", (Object)path);
        return new File(base, path);
    }

    public static File createLocalFile(URI uri) {
        File file = new File(uri);
        CndUtils.assertAbsoluteFileInConsole(file);
        return file;
    }

    public static String normalizePath(FileObject fo) {
        try {
            return CndFileUtils.normalizeAbsolutePath(fo.getFileSystem(), fo.getPath());
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return fo.getPath();
        }
    }

    public static String normalizeAbsolutePath(FileSystem fs, String path) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            return CndFileUtils.normalizeAbsolutePath(path);
        }
        FileObject fo = fs.findResource(path);
        return fo == null ? CndFileUtils.normalizeAbsolutePath(path) : fo.getPath();
    }

    public static String normalizeAbsolutePath(String path) {
        CndUtils.assertAbsolutePathInConsole(path, "path for normalization must be absolute");
        if (path.startsWith("/") && Utilities.isWindows()) {
            return PathUtilities.normalizeUnixPath((String)path);
        }
        boolean caseSensitive = CndFileUtils.isSystemCaseSensitive();
        if (!caseSensitive && Utilities.isWindows()) {
            path = path.toString().replace('\\', '/');
        }
        String normalized = !caseSensitive || path.endsWith("/.") || path.endsWith("\\.") || path.contains("..") || path.contains("./") || path.contains(".\\") ? FileUtil.normalizeFile((File)new File(path)).getAbsolutePath() : path;
        return normalized;
    }

    public static boolean exists(File file) {
        return CndFileUtils.getFlags(CndFileUtils.getLocalFileSystem(), file.getAbsolutePath(), true).exist;
    }

    public static boolean isExistingFile(String filePath) {
        return CndFileUtils.isExistingFile(CndFileUtils.getLocalFileSystem(), filePath);
    }

    public static boolean isExistingFile(FileSystem fs, String filePath) {
        Flags flags = CndFileUtils.getFlags(fs, filePath, true);
        return flags.exist && !flags.directory;
    }

    public static boolean isExistingDirectory(FileSystem fs, String filePath) {
        Flags flags = CndFileUtils.getFlags(fs, filePath, false);
        return flags.exist && flags.directory;
    }

    public static FileObject urlToFileObject(CharSequence url) {
        return CndFileSystemProvider.urlToFileObject(url);
    }

    public static CharSequence fileObjectToUrl(FileObject fileObject) {
        return CndFileSystemProvider.fileObjectToUrl(fileObject);
    }

    private static Flags getFlags(FileSystem fs, String absolutePath, boolean indexParentFolder) {
        assert (fs != null);
        assert (absolutePath != null);
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole(!absolutePath.contains("var/cache/remote-files"), "trying to get access to " + absolutePath);
        }
        if (isWindows && CndFileUtils.isLocalFileSystem(fs)) {
            absolutePath = absolutePath.replace('/', '\\');
        }
        absolutePath = CndFileUtils.changeStringCaseIfNeeded(fs, absolutePath);
        ConcurrentMap<String, Flags> files = CndFileUtils.getFilesMap(fs);
        Flags exists = (Flags)files.get(absolutePath);
        if (exists == null) {
            String parent = CndPathUtilitities.getDirName(absolutePath);
            if (parent != null) {
                Flags parentDirFlags = (Flags)files.get(parent);
                if (parentDirFlags == null || parentDirFlags == Flags.DIRECTORY) {
                    if (parentDirFlags == null) {
                        parentDirFlags = Flags.get(fs, parent);
                        files.putIfAbsent(parent, parentDirFlags);
                    }
                    if (parentDirFlags == Flags.NOT_FOUND || parentDirFlags == Flags.FILE) {
                        exists = Flags.NOT_FOUND;
                    } else if (indexParentFolder) {
                        assert (parentDirFlags == Flags.DIRECTORY) : "must be DIRECTORY but was " + parentDirFlags;
                        CndFileUtils.index(fs, parent, files);
                        exists = (Flags)files.get(absolutePath);
                    }
                } else {
                    exists = parentDirFlags == Flags.NOT_FOUND ? Flags.NOT_FOUND : (Flags)files.get(absolutePath);
                }
            }
            if (exists == null) {
                exists = Flags.get(fs, absolutePath);
                files.putIfAbsent(absolutePath, exists);
            }
            if (exists == Flags.DIRECTORY) {
                CndFileUtils.index(fs, absolutePath, files);
            }
        }
        return exists;
    }

    public static boolean isLocalFileSystem(FileSystem fs) {
        return fs == CndFileUtils.getLocalFileSystem();
    }

    private static void index(FileSystem fs, String path, ConcurrentMap<String, Flags> files) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            File file = new File(path);
            if (CndFileSystemProvider.canRead(path).booleanValue()) {
                CndFileSystemProvider.FileInfo[] listFiles = CndFileUtils.listFilesImpl(file);
                for (int i = 0; i < listFiles.length; ++i) {
                    CndFileSystemProvider.FileInfo curFile = listFiles[i];
                    String absPath = CndFileUtils.changeStringCaseIfNeeded(fs, curFile.absolutePath);
                    if (isWindows) {
                        absPath = absPath.replace('/', '\\');
                    }
                    if (curFile.directory) {
                        files.putIfAbsent(absPath, Flags.DIRECTORY);
                        continue;
                    }
                    files.put(absPath, Flags.FILE);
                }
            }
        } else {
            FileObject file = fs.findResource(path);
            if (file != null && file.isFolder() && file.canRead()) {
                for (FileObject child : file.getChildren()) {
                    String absPath = child.getPath();
                    if (child.isFolder()) {
                        files.putIfAbsent(absPath, Flags.DIRECTORY);
                        continue;
                    }
                    files.put(absPath, Flags.FILE);
                }
            }
        }
        assert (CndFileUtils.changeStringCaseIfNeeded(fs, path).equals(path));
        files.put(path, Flags.INDEXED_DIRECTORY);
    }

    private static String changeStringCaseIfNeeded(FileSystem fs, String path) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            if (CndFileUtils.isSystemCaseSensitive()) {
                return path;
            }
            return path.toString().toLowerCase();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, Flags> getFilesMap(FileSystem fs) {
        ConcurrentHashMap<String, Flags> map;
        L1Cache aCache = l1Cache;
        if (aCache != null && (map = aCache.get(fs)) != null) {
            return map;
        }
        try {
            maRefLock.lock();
            Reference<ConcurrentMap<String, Flags>> mapRef = maps.get(fs);
            if (mapRef == null || (map = mapRef.get()) == null) {
                map = new ConcurrentHashMap();
                mapRef = new SoftReference(map);
                maps.put(fs, mapRef);
                l1Cache = new L1Cache(fs, mapRef);
            }
        }
        finally {
            maRefLock.unlock();
        }
        return map;
    }

    private static CndFileSystemProvider.FileInfo[] listFilesImpl(File file) {
        CndFileSystemProvider.FileInfo[] info = CndFileSystemProvider.getChildInfo(file.getAbsolutePath());
        if (info == null) {
            File[] children = file.listFiles();
            if (children != null) {
                info = new CndFileSystemProvider.FileInfo[children.length];
                for (int i = 0; i < children.length; ++i) {
                    info[i] = new CndFileSystemProvider.FileInfo(children[i].getAbsolutePath(), children[i].isDirectory());
                }
            } else {
                info = new CndFileSystemProvider.FileInfo[]{};
            }
        }
        return info;
    }

    public static FileSystem getLocalFileSystem() {
        return fileFileSystem;
    }

    public static char getFileSeparatorChar(FileSystem fs) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            return File.separatorChar;
        }
        return '/';
    }

    public static List<String> toPathList(Collection<FSPath> paths) {
        if (paths != null && paths.size() > 0) {
            ArrayList<String> result = new ArrayList<String>(paths.size());
            for (FSPath fSPath : paths) {
                result.add(fSPath.getPath());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<FSPath> toFSPathList(FileSystem fileSystem, Collection<String> paths) {
        if (paths != null && paths.size() > 0) {
            ArrayList<FSPath> result = new ArrayList<FSPath>(paths.size());
            for (String path : paths) {
                result.add(new FSPath(fileSystem, path));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static Collection<? extends CndFileExistSensitiveCache> getCaches() {
        if (listeners == null) {
            listeners = Lookup.getDefault().lookupAll(CndFileExistSensitiveCache.class);
        }
        return listeners;
    }

    static {
        boolean caseSenstive;
        FSL = new FSListener();
        FileSystem afileFileSystem = null;
        File tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
        FileObject tmpDirFo = FileUtil.toFileObject((File)(tmpDirFile = FileUtil.normalizeFile((File)tmpDirFile)));
        if (tmpDirFo != null) {
            try {
                afileFileSystem = tmpDirFo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (afileFileSystem == null) {
            afileFileSystem = InvalidFileObjectSupport.getDummyFileSystem();
            Exceptions.printStackTrace((Throwable)new Exception("Cannot get local file system"));
        }
        fileFileSystem = afileFileSystem;
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
            FileUtil.addFileChangeListener((FileChangeListener)FSL);
        }
        catch (IOException ex) {
            caseSenstive = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
        isWindows = Utilities.isWindows();
        maRefLock = new ReentrantLock();
        maps = new WeakHashMap<FileSystem, Reference<ConcurrentMap<String, Flags>>>();
        TRACE_EXTERNAL_CHANGES = Boolean.getBoolean("cnd.modelimpl.trace.external.changes");
    }

    private static final class FSListener
    implements FileChangeListener {
        private FSListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            File parent = this.clearCachesAboutFile((FileEvent)fe);
            if (parent != null) {
                String ext = fe.getExt();
                String oldName = ext.length() == 0 ? fe.getName() : fe.getName() + "." + ext;
                this.clearCachesAboutFile(new File(parent, oldName), false);
            }
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private File clearCachesAboutFile(FileEvent fe) {
            return this.clearCachesAboutFile(CndFileUtils.toFile(fe.getFile()), true);
        }

        private File clearCachesAboutFile(File f, boolean withParent) {
            this.cleanCachesImpl(f.getAbsolutePath());
            if (withParent) {
                File parent = f.getParentFile();
                if (parent != null) {
                    this.cleanCachesImpl(parent.getAbsolutePath());
                }
                return parent;
            }
            return null;
        }

        private void cleanCachesImpl(String file) {
            if (TRACE_EXTERNAL_CHANGES) {
                System.err.println("clean cache for " + file);
            }
            CndFileUtils.getFilesMap(CndFileUtils.getLocalFileSystem()).remove(file);
            for (CndFileExistSensitiveCache cache : CndFileUtils.getCaches()) {
                cache.invalidateFile(file);
            }
        }
    }

    private static final class Flags {
        private final boolean exist;
        private final boolean directory;
        private static final Flags FILE = new Flags(true, false);
        private static final Flags DIRECTORY = new Flags(true, true);
        private static final Flags INDEXED_DIRECTORY = new Flags(true, true);
        private static final Flags NOT_FOUND = new Flags(false, true);

        private Flags(boolean exist, boolean directory) {
            this.exist = exist;
            this.directory = directory;
        }

        private static Flags get(FileSystem fs, String absPath) {
            FileObject fo;
            if (CndFileUtils.isLocalFileSystem(fs)) {
                absPath = FileUtil.normalizePath((String)absPath);
                fo = CndFileSystemProvider.toFileObject(absPath);
            } else {
                fo = fs.findResource(absPath);
            }
            return Flags.get(fo);
        }

        private static Flags get(FileObject fo) {
            if (fo != null && fo.isValid()) {
                if (fo.isFolder()) {
                    return DIRECTORY;
                }
                return FILE;
            }
            return NOT_FOUND;
        }

        public String toString() {
            if (this == NOT_FOUND) {
                return "NOT_FOUND";
            }
            if (this == INDEXED_DIRECTORY) {
                return "INDEXED_DIRECTORY";
            }
            if (this == DIRECTORY) {
                return "DIRECTORY";
            }
            if (this == FILE) {
                return "FILE";
            }
            return "UNKNOWN";
        }
    }

    private static final class L1Cache {
        private FileSystem fs;
        private Reference<ConcurrentMap<String, Flags>> mapRef;

        private L1Cache(FileSystem fs, Reference<ConcurrentMap<String, Flags>> mapRef) {
            this.fs = fs;
            this.mapRef = mapRef;
        }

        private ConcurrentMap<String, Flags> get(FileSystem fs) {
            if (this.fs == fs) {
                return this.mapRef.get();
            }
            return null;
        }
    }
}

