/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class CndPathUtilitities {
    private static boolean isWindows = Utilities.isWindows();
    public static final boolean IfdefDiagnostics = Boolean.getBoolean("ifdef.debug.diagnostics");

    private CndPathUtilitities() {
    }

    static void testSetWindows(boolean isWin) {
        isWindows = isWin;
    }

    public static String getDirName(String path) {
        int sep;
        if (path.length() > 0 && (path.charAt(path.length() - 1) == '\\' || path.charAt(path.length() - 1) == '/')) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sep = path.lastIndexOf(47)) == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public static String getBaseName(String path) {
        int sep;
        if (path.length() > 0 && (path.charAt(path.length() - 1) == '\\' || path.charAt(path.length() - 1) == '/')) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sep = path.lastIndexOf(47)) == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static String getRelativePath(String base, String path) {
        String pstring;
        String bstring;
        if (path.equals(base = CndPathUtilitities.trimDotDot(base))) {
            return path;
        }
        if (path.startsWith(base + '/')) {
            return path.substring(base.length() + 1);
        }
        if (path.startsWith(base + '\\')) {
            return path.substring(base.length() + 1);
        }
        if (!CndPathUtilitities.isPathAbsolute(path)) {
            return path;
        }
        String[] bnames = CndPathUtilitities.getPathNameArray(base);
        String[] pnames = CndPathUtilitities.getPathNameArray(path);
        int match = 0;
        for (int i = 0; i < bnames.length && i < pnames.length && (bstring = bnames[i]).equals(pstring = pnames[i]); ++i) {
            ++match;
        }
        if (match > 0 && match == pnames.length && bnames.length > pnames.length) {
            StringBuilder s = new StringBuilder();
            for (int cnt = 0; cnt < bnames.length - match - 1; ++cnt) {
                s.append("..").append(File.separator);
            }
            s.append("..");
            return s.toString();
        }
        if (match > 0) {
            StringBuilder s = new StringBuilder();
            for (int cnt = bnames.length - match; cnt > 0; --cnt) {
                s.append("..").append(File.separator);
            }
            for (int i = match; i < pnames.length; ++i) {
                if (s.length() > 0 && s.charAt(s.length() - 1) != File.separatorChar) {
                    s.append(File.separator);
                }
                s.append(pnames[i]);
            }
            return s.toString();
        }
        return path;
    }

    public static String toAbsolutePath(FileObject base, String path) {
        String newPath = path;
        if (newPath == null || newPath.length() == 0) {
            newPath = ".";
        }
        if (CndPathUtilitities.isPathAbsolute(newPath)) {
            return newPath;
        }
        FileObject fo = base.getFileObject(newPath);
        if (fo != null && fo.isValid()) {
            try {
                return CndFileUtils.getCanonicalPath(fo);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                return fo.getPath();
            }
        }
        return base.getPath() + '/' + path;
    }

    public static String toAbsolutePath(String base, String path) {
        File newPathFile;
        String newPath = path;
        if (newPath == null || newPath.length() == 0) {
            newPath = ".";
        }
        if (!CndPathUtilitities.isPathAbsolute(newPath) && (newPathFile = new File(newPath = base + File.separator + path)).exists()) {
            try {
                newPath = newPathFile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return newPath;
    }

    public static String toRelativePath(FileObject base, FileObject path) {
        return CndPathUtilitities.toRelativePath(base.getPath(), path.getPath());
    }

    public static String toRelativePath(FileObject base, String path) {
        return CndPathUtilitities.toRelativePath(base.getPath(), path);
    }

    public static String toRelativePath(String base, FileObject path) {
        return CndPathUtilitities.toRelativePath(base, path.getPath());
    }

    public static String toRelativePath(String base, String path) {
        String relPath = path;
        if (relPath == null || relPath.length() == 0) {
            relPath = ".";
        }
        if (CndPathUtilitities.isPathAbsolute(relPath)) {
            relPath = relPath.equals(base) ? "." : (CndPathUtilitities.isPathAbsolute(base) ? CndPathUtilitities.getRelativePath(base, relPath) : path);
        }
        return relPath;
    }

    public static String toAbsoluteOrRelativePath(FileObject base, FileObject path) {
        return CndPathUtilitities.toAbsoluteOrRelativePath(base, path.getPath());
    }

    public static String toAbsoluteOrRelativePath(FileObject base, String path) {
        return CndPathUtilitities.toAbsoluteOrRelativePath(base.getPath(), path);
    }

    public static String toAbsoluteOrRelativePath(String base, String path) {
        String dotSlash;
        String resRel = CndPathUtilitities.toRelativePath(base, path);
        String res = CndPathUtilitities.isPathAbsolute(resRel) || resRel.startsWith("..") ? path : (resRel.startsWith(dotSlash = "." + File.separatorChar) ? resRel.substring(2) : resRel);
        return res;
    }

    static String[] getPathNameArray(String path) {
        int pos = 0;
        if (0 < path.length() && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
            pos = 1;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (CndPathUtilitities.isPathAbsolute(path)) {
            while (pos >= 0) {
                int next = path.indexOf(47, pos);
                if (next < 0) {
                    next = path.indexOf(92, pos);
                }
                if (next > 0) {
                    l.add(path.substring(pos, next));
                    pos = next + 1;
                    continue;
                }
                l.add(path.substring(pos));
                pos = -1;
            }
        }
        return l.toArray(new String[l.size()]);
    }

    public static String expandPath(String filename) {
        int si;
        int max = filename.length();
        StringBuilder dp = new StringBuilder(256);
        for (si = 0; si < max && Character.isSpaceChar(filename.charAt(si)); ++si) {
        }
        if (si < max && filename.charAt(si) == '~' && si++ < max && (si == max || filename.charAt(si) == '/')) {
            dp.append(System.getProperty("user.home"));
        }
        while (si < max) {
            int endIndex;
            char c;
            if ((c = filename.charAt(si++)) == '\\' && si < max) {
                if (filename.charAt(si) == '$') {
                    dp.append('\\');
                    dp.append('$');
                    ++si;
                    continue;
                }
                dp.append(c);
                continue;
            }
            if (c == '$' && si < max && filename.charAt(si) == '(') {
                endIndex = filename.indexOf(41, si);
                dp.append('$');
                if (endIndex > -1) {
                    dp.append(filename.substring(si, endIndex));
                    si = endIndex;
                    continue;
                }
                dp.append(filename.substring(si));
                si = max;
                continue;
            }
            if (c == '$' && si < max) {
                boolean braces;
                boolean bl = braces = filename.charAt(si) == '{';
                if (braces) {
                    // empty if block
                }
                int beginIndex = ++si;
                while (si < max) {
                    char c2 = filename.charAt(si);
                    if (braces && c2 == '}' || !Character.isLetterOrDigit(c2) && c2 != '_') break;
                    ++si;
                }
                endIndex = si;
                if (si < max && braces) {
                    ++si;
                }
                if (endIndex > beginIndex) {
                    String value = System.getenv(filename.substring(beginIndex, endIndex));
                    if (value != null) {
                        dp.append(value);
                        continue;
                    }
                    dp.append('$');
                    if (braces) {
                        dp.append('{');
                    }
                    dp.append(filename.substring(beginIndex, endIndex));
                    if (!braces) continue;
                    dp.append('}');
                    continue;
                }
                dp.append('$');
                if (!braces) continue;
                dp.append("{}");
                continue;
            }
            dp.append(c);
        }
        return dp.toString();
    }

    public static String trimSlashes(String dir) {
        int trim = 0;
        for (int i = dir.length(); i > 0 && (dir.charAt(i - 1) == '/' || dir.charAt(i - 1) == '\\'); --i) {
            ++trim;
        }
        if (trim > 0) {
            return dir.substring(0, dir.length() - trim);
        }
        return dir;
    }

    public static String trimpath(String dir) {
        return CndPathUtilitities.trimSlashes(dir.trim());
    }

    @Deprecated
    public static String normalize(String path) {
        return CndPathUtilitities.normalizeSlashes(path);
    }

    public static String normalizeSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String naturalizeSlashes(String path) {
        if (Utilities.isUnix()) {
            return path.replaceAll("\\\\", "/");
        }
        if (Utilities.isWindows()) {
            return path.replaceAll("/", "\\\\");
        }
        return path;
    }

    public static String quoteIfNecessary(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.charAt(0) == '\"' || s.charAt(n - 1) == '\"') {
            return s;
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t' && c != '*' && c != '[' && c != ']' && c != '(' && c != ')') continue;
            return '\"' + s + '\"';
        }
        return s;
    }

    public static boolean isPathAbsolute(CharSequence path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return CharSequenceUtils.indexOf(path, ':') == 1 && isWindows;
    }

    public static boolean isIgnoredFolder(File file) {
        if (file.isDirectory()) {
            String name = file.getName();
            return name.equals("SCCS") || name.equals("CVS") || name.equals(".hg") || name.equals("SunWS_cache") || name.equals(".svn");
        }
        return false;
    }

    public static boolean sameString(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean sameStringArray(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int x = 0; x < a.length; ++x) {
            if (CndPathUtilitities.sameString(a[x], b[x])) continue;
            return false;
        }
        return true;
    }

    public static String escapeOddCharacters(String s) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')' || c == ';') {
                ret.append('\\');
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String replaceOddCharacters(String s, char replaceChar) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')') {
                ret.append(replaceChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapeQuotes(String s) {
        if (s.indexOf(34) < 0) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    public static boolean hasMakeSpecialCharacters(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '-' || string.charAt(i) == '.' || string.charAt(i) == '/' || string.charAt(i) == '$' || string.charAt(i) == '{' || string.charAt(i) == '}' || string.charAt(i) == ':' || string.charAt(i) == '\\') continue;
            return true;
        }
        return false;
    }

    public static String trimDotDot(String path) {
        Stack<String> stack = new Stack<String>();
        String absPrefix = null;
        if (CndPathUtilitities.isPathAbsolute(path)) {
            if (path.charAt(0) == '/') {
                absPrefix = "/";
                path = path.substring(1);
            } else if (path.charAt(1) == ':') {
                absPrefix = path.substring(0, 3);
                path = path.substring(3);
            }
        }
        int down = 0;
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("..")) {
                if (down > 0) {
                    stack.pop();
                    --down;
                    continue;
                }
                stack.push(token);
                continue;
            }
            stack.push(token);
            ++down;
        }
        StringBuilder retpath = new StringBuilder();
        if (absPrefix != null) {
            retpath.append(absPrefix);
        }
        for (int i = 0; i < stack.size(); ++i) {
            retpath.append((String)stack.elementAt(i));
            if (i >= stack.size() - 1) continue;
            retpath.append('/');
        }
        return retpath.toString();
    }

    public static String createUniqueFileName(String folder, String name, String ext) {
        if (folder == null || folder.length() == 0 || !CndPathUtilitities.isPathAbsolute(folder) || name == null || name.length() == 0) {
            assert (false);
            return null;
        }
        String newName = name;
        int i = 0;
        while (true) {
            if (i > 0) {
                newName = name + "_" + i;
            }
            String newPath = folder + "/" + newName;
            if (ext != null && ext.length() > 0) {
                newPath = newPath + "." + ext;
            }
            if (!new File(newPath).exists()) break;
            ++i;
        }
        return newName;
    }

    public static String expandMacro(String string, String macro, String value) {
        int i = string.indexOf(macro);
        if (i == 0) {
            string = value + string.substring(macro.length());
        } else if (i > 0) {
            string = string.substring(0, i) + value + string.substring(i + macro.length());
        }
        return string;
    }
}

