/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.CustomZoomAction;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.NBImageIcon;
import org.netbeans.modules.image.ZoomInAction;
import org.netbeans.modules.image.ZoomOutAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ImageViewer
extends CloneableTopComponent {
    static final long serialVersionUID = 6960127954234034486L;
    private ImageDataObject storedObject;
    private NBImageIcon storedImage;
    private JPanel panel;
    private double scale = 1.0;
    private boolean showGrid = false;
    private final double changeFactor = Math.sqrt(2.0);
    private final Color gridColor = Color.black;
    private PropertyChangeListener nameChangeL;
    private final Collection toolbarButtons = new ArrayList(11);
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImageViewer() {
    }

    public ImageViewer(ImageDataObject obj) {
        this.initialize(obj);
    }

    public int getPersistenceType() {
        return 1;
    }

    protected void reloadIcon() {
        this.resizePanel();
        this.panel.repaint();
    }

    private void initialize(ImageDataObject obj) {
        Component view;
        TopComponent.NodeName.connect((TopComponent)this, (Node)obj.getNodeDelegate());
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)obj.getPrimaryFile()));
        this.storedObject = obj;
        this.setCloseOperation(0);
        String errMsg = this.loadImage(this.storedObject);
        JToolBar toolbar = this.createToolBar();
        if (this.storedImage != null) {
            view = this.createImageView();
        } else {
            view = this.createMessagePanel(errMsg);
            this.setToolbarButtonsEnabled(false);
        }
        this.setLayout(new BorderLayout());
        this.add(view, "Center");
        this.add(toolbar, "North");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_ImageViewer"));
        this.nameChangeL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                    ImageViewer.this.updateNameInEDT();
                }
            }
        };
        obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)obj)));
        this.setFocusable(true);
    }

    private void updateNameInEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateName();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ImageViewer.this.updateName();
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Component createImageView() {
        this.panel = new JPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ImageViewer.this.storedImage.getImage(), 0, 0, (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth()), (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight()), 0, 0, ImageViewer.this.storedImage.getIconWidth(), ImageViewer.this.storedImage.getIconHeight(), this);
                if (ImageViewer.this.showGrid) {
                    int x = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth());
                    int y = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight());
                    double gridDistance = ImageViewer.this.getScale();
                    if (gridDistance < 2.0) {
                        return;
                    }
                    g.setColor(ImageViewer.this.gridColor);
                    double actualDistance = gridDistance;
                    int i = (int)actualDistance;
                    while (i < x) {
                        g.drawLine(i, 0, i, y - 1);
                        i = (int)(actualDistance += gridDistance);
                    }
                    actualDistance = gridDistance;
                    int j = (int)actualDistance;
                    while (j < y) {
                        g.drawLine(0, j, x - 1, j);
                        j = (int)(actualDistance += gridDistance);
                    }
                }
            }
        };
        this.panel.putClientProperty("print.printable", Boolean.TRUE);
        this.panel.putClientProperty("print.name", this.getToolTipText());
        this.storedImage.setImageObserver(this.panel);
        this.panel.setPreferredSize(new Dimension(this.storedImage.getIconWidth(), this.storedImage.getIconHeight()));
        return new JScrollPane(this.panel);
    }

    private Component createMessagePanel(String msg) {
        JPanel msgPanel = new JPanel(new GridBagLayout());
        msgPanel.add((Component)new JLabel(msg), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 10, 10));
        return msgPanel;
    }

    void updateView(ImageDataObject imageObj) {
        boolean isValid;
        boolean wasValid = this.storedImage != null;
        String errMsg = this.loadImage(imageObj);
        boolean bl = isValid = this.storedImage != null;
        if (wasValid && isValid) {
            this.reloadIcon();
            return;
        }
        Component view = this.storedImage != null ? this.createImageView() : this.createMessagePanel(errMsg);
        this.remove(0);
        this.add(view, "Center", 0);
        if (wasValid != isValid) {
            this.setToolbarButtonsEnabled(isValid);
        }
    }

    private void setToolbarButtonsEnabled(boolean enabled) {
        if (!$assertionsDisabled && this.toolbarButtons == null) {
            throw new AssertionError();
        }
        Iterator it = this.toolbarButtons.iterator();
        while (it.hasNext()) {
            ((JButton)it.next()).setEnabled(enabled);
        }
    }

    private String loadImage(ImageDataObject imageObj) {
        String errMsg;
        try {
            this.storedImage = NBImageIcon.load(imageObj);
            errMsg = this.storedImage != null ? null : NbBundle.getMessage((Class)ImageViewer.class, (String)"MSG_CouldNotLoad");
        }
        catch (IOException ex) {
            this.storedImage = null;
            errMsg = NbBundle.getMessage((Class)ImageViewer.class, (String)"MSG_ErrorWhileLoading");
        }
        if (!$assertionsDisabled && this.storedImage == null == (errMsg == null)) {
            throw new AssertionError();
        }
        return errMsg;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setFloatable(false);
        toolBar.setName(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSN_Toolbar"));
        toolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_Toolbar"));
        JButton outButton = new JButton((Action)SystemAction.get((Class)ZoomOutAction.class));
        outButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomOut"));
        outButton.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Out_BTN_Mnem").charAt(0));
        outButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_Out_BTN"));
        outButton.setText("");
        toolBar.add(outButton);
        this.toolbarButtons.add(outButton);
        JButton inButton = new JButton((Action)SystemAction.get((Class)ZoomInAction.class));
        inButton.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomIn"));
        inButton.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_In_BTN_Mnem").charAt(0));
        inButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACSD_In_BTN"));
        inButton.setText("");
        toolBar.add(inButton);
        this.toolbarButtons.add(inButton);
        toolBar.addSeparator(new Dimension(11, 0));
        JButton button = this.getZoomButton(1, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton(1, 3);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(1, 5);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(1, 7);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton(3, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(5, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        button = this.getZoomButton(7, 1);
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getZoomButton();
        toolBar.add(button);
        this.toolbarButtons.add(button);
        toolBar.addSeparator(new Dimension(11, 0));
        button = this.getGridButton();
        toolBar.add(button);
        this.toolbarButtons.add(button);
        Iterator it = this.toolbarButtons.iterator();
        while (it.hasNext()) {
            ((JButton)it.next()).setFocusable(false);
        }
        return toolBar;
    }

    private void updateName() {
        String name = this.storedObject.getNodeDelegate().getDisplayName();
        this.setName(name);
        FileObject fo = this.storedObject.getPrimaryFile();
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)fo));
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            return;
        }
        Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
        this.dockIfNeeded(realWorkspace);
        boolean modeVisible = false;
        TopComponent[] tcArray = this.editorMode(realWorkspace).getTopComponents();
        for (int i = 0; i < tcArray.length; ++i) {
            if (!tcArray[i].isOpened(realWorkspace)) continue;
            modeVisible = true;
            break;
        }
        if (!modeVisible) {
            this.openOtherEditors(realWorkspace);
        }
        super.open(workspace);
        this.openOnOtherWorkspaces(realWorkspace);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        Mode tcMode = null;
        block0: for (int i = 0; i < workspaces.length; ++i) {
            if (workspaces[i].equals(workspace)) continue;
            curEditorMode = workspaces[i].findMode("editor");
            tcMode = workspaces[i].findMode((TopComponent)this);
            if (this.isOpened(workspaces[i]) || curEditorMode == null || tcMode != null && !tcMode.equals(curEditorMode)) continue;
            TopComponent[] tcArray = curEditorMode.getTopComponents();
            for (int j = 0; j < tcArray.length; ++j) {
                if (!tcArray[j].isOpened(workspaces[i])) continue;
                this.pureOpen((TopComponent)this, workspaces[i]);
                continue block0;
            }
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> topComps = new HashSet<TopComponent>(15);
        Workspace[] wsArray = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        TopComponent[] tcArray = null;
        for (int i = 0; i < wsArray.length; ++i) {
            curEditorMode = wsArray[i].findMode("editor");
            if (curEditorMode == null) continue;
            tcArray = curEditorMode.getTopComponents();
            for (int j = 0; j < tcArray.length; ++j) {
                if (!tcArray[j].isOpened(wsArray[i])) continue;
                topComps.add(tcArray[j]);
            }
        }
        Iterator iter = topComps.iterator();
        while (iter.hasNext()) {
            this.pureOpen((TopComponent)iter.next(), workspace);
        }
    }

    private void pureOpen(TopComponent tc, Workspace workspace) {
        if (tc instanceof ImageViewer) {
            ((ImageViewer)tc).dockIfNeeded(workspace);
            ((ImageViewer)tc).superOpen(workspace);
        } else {
            tc.open(workspace);
        }
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode ourMode = workspace.findMode((TopComponent)this);
        if (ourMode == null) {
            this.editorMode(workspace).dockInto((TopComponent)this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode ourMode = workspace.findMode((TopComponent)this);
        if (ourMode == null) {
            ourMode = workspace.createMode("editor", this.getName(), CloneableEditorSupport.class.getResource("/org/openide/resources/editorMode.gif"));
        }
        return ourMode;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean discard() {
        return this.storedObject == null;
    }

    protected boolean closeLast() {
        ((ImageOpenSupport)this.storedObject.getCookie(ImageOpenSupport.class)).lastClosed();
        return true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.storedObject);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.storedObject = (ImageDataObject)((Object)in.readObject());
        ((ImageOpenSupport)this.storedObject.getCookie(ImageOpenSupport.class)).prepareViewer();
        this.initialize(this.storedObject);
    }

    protected CloneableTopComponent createClonedObject() {
        return new ImageViewer(this.storedObject);
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] oldValue = super.getSystemActions();
        SystemAction fsa = null;
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = ((Object)((Object)this)).getClass().getClassLoader();
            }
            Class c = Class.forName("org.openide.actions.FileSystemAction", true, l).asSubclass(SystemAction.class);
            fsa = (SystemAction)SystemAction.findObject(c, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SystemAction.linkActions((SystemAction[])new SystemAction[]{SystemAction.get((Class)ZoomInAction.class), SystemAction.get((Class)ZoomOutAction.class), SystemAction.get((Class)CustomZoomAction.class), fsa, null}, (SystemAction[])oldValue);
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/image/imageObject.png");
    }

    public void zoomIn() {
        this.scaleIn();
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void zoomOut() {
        double oldScale = this.scale;
        this.scaleOut();
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private void resizePanel() {
        this.panel.setPreferredSize(new Dimension((int)(this.getScale() * (double)this.storedImage.getIconWidth()), (int)(this.getScale() * (double)this.storedImage.getIconHeight())));
        this.panel.revalidate();
    }

    private boolean isNewSizeOK() {
        return this.getScale() * (double)this.storedImage.getIconWidth() > 1.0 && this.getScale() * (double)this.storedImage.getIconWidth() > 1.0;
    }

    public void customZoom(int fx, int fy) {
        double oldScale = this.scale;
        this.scale = (double)fx / (double)fy;
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private double getScale() {
        return this.scale;
    }

    private void scaleOut() {
        this.scale /= this.changeFactor;
    }

    private void scaleIn() {
        double oldComputedScale = this.getScale();
        this.scale = this.changeFactor * this.scale;
        double newComputedScale = this.getScale();
        if (newComputedScale == oldComputedScale) {
            this.scale = newComputedScale + 1.0;
        }
    }

    private JButton getZoomButton(final int xf, final int yf) {
        JButton button = new JButton("" + xf + ":" + yf);
        if (xf < yf) {
            button.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomOut") + " " + xf + " : " + yf);
        } else {
            button.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ZoomIn") + " " + xf + " : " + yf);
        }
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Zoom_BTN"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.customZoom(xf, yf);
            }
        });
        return button;
    }

    private JButton getZoomButton() {
        JButton button = new JButton(NbBundle.getBundle((Class)CustomZoomAction.class).getString("LBL_XtoY"));
        button.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_CustomZoom"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Zoom_BTN"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomZoomAction sa = (CustomZoomAction)SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction));
                sa.performAction();
            }
        });
        return button;
    }

    private JButton getGridButton() {
        JButton button = new JButton(" # ");
        button.setToolTipText(NbBundle.getBundle((Class)ImageViewer.class).getString("LBL_ShowHideGrid"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Grid_BTN"));
        button.setMnemonic(NbBundle.getBundle((Class)ImageViewer.class).getString("ACS_Grid_BTN_Mnem").charAt(0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.showGrid = !ImageViewer.this.showGrid;
                ImageViewer.this.panel.repaint(0, 0, ImageViewer.this.panel.getWidth(), ImageViewer.this.panel.getHeight());
            }
        });
        return button;
    }

    static {
        $assertionsDisabled = !ImageViewer.class.desiredAssertionStatus();
    }
}

